/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.site;

import ai.starlake.config.Settings;
import ai.starlake.job.site.SiteCmd$;
import ai.starlake.job.site.SiteConfig;
import ai.starlake.lineage.AclDependencies;
import ai.starlake.lineage.AclDependenciesConfig;
import ai.starlake.lineage.AclDependenciesConfig$;
import ai.starlake.lineage.AutoTaskDependencies;
import ai.starlake.lineage.AutoTaskDependenciesConfig;
import ai.starlake.lineage.AutoTaskDependenciesConfig$;
import ai.starlake.lineage.TableDependencies;
import ai.starlake.lineage.TableDependenciesConfig;
import ai.starlake.lineage.TableDependenciesConfig$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.model.AutoJobDesc;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Schema;
import ai.starlake.sql.SQLUtils$;
import ai.starlake.utils.Utils$;
import better.files.File;
import better.files.File$;
import com.manticore.jsqlformatter.JSQLFormatter;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.fusesource.scalate.TemplateEngine;
import org.fusesource.scalate.TemplateEngine$;
import org.fusesource.scalate.TemplateSource;
import org.fusesource.scalate.TemplateSource$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\n\u0015\u0001uA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!AA\b\u0001BC\u0002\u0013\rQ\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015I\u0006\u0001\"\u0003[\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!!\u0007\u0001\t\u0013\tY\u0002C\u0004\u00020\u0001!I!!\r\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004BCA=\u0001!\u0015\r\u0011\"\u0001\u0002|!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0002\f'&$X\rS1oI2,'O\u0003\u0002\u0016-\u0005!1/\u001b;f\u0015\t9\u0002$A\u0002k_\nT!!\u0007\u000e\u0002\u0011M$\u0018M\u001d7bW\u0016T\u0011aG\u0001\u0003C&\u001c\u0001aE\u0002\u0001=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013-\u001b\u00051#BA\u0014)\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI#&\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0013aA2p[&\u0011QF\n\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\t\u0001\u0014'D\u0001\u0015\u0013\t\u0011DC\u0001\u0006TSR,7i\u001c8gS\u001e\fQb]2iK6\f\u0007*\u00198eY\u0016\u0014\bCA\u001b;\u001b\u00051$BA\u001c9\u0003!A\u0017M\u001c3mKJ\u001c(BA\u001d\u0019\u0003\u0019\u00198\r[3nC&\u00111H\u000e\u0002\u000e'\u000eDW-\\1IC:$G.\u001a:\u0002\u0011M,G\u000f^5oON,\u0012A\u0010\t\u0003\u007f\u0005k\u0011\u0001\u0011\u0006\u0003]aI!A\u0011!\u0003\u0011M+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\rqJg.\u001b;?)\r1\u0015J\u0013\u000b\u0003\u000f\"\u0003\"\u0001\r\u0001\t\u000bq*\u00019\u0001 \t\u000b9*\u0001\u0019A\u0018\t\u000bM*\u0001\u0019\u0001\u001b\u0002\u0007I,h\u000eF\u0001N!\rq\u0015kU\u0007\u0002\u001f*\u0011\u0001\u000bI\u0001\u0005kRLG.\u0003\u0002S\u001f\n\u0019AK]=\u0011\u0005}!\u0016BA+!\u0005\u0011)f.\u001b;\u0002\u0019\t,\u0018\u000e\u001c3E_6\f\u0017N\\:\u0015\u0005MC\u0006\"\u0002\u0018\b\u0001\u0004y\u0013a\u00032vS2$Gi\\7bS:$RaU.fUJDQ\u0001\u0018\u0005A\u0002u\u000b!\u0002Z8nC&t\u0007+\u0019;i!\tq6-D\u0001`\u0015\t\u0001\u0017-A\u0003gS2,7OC\u0001c\u0003\u0019\u0011W\r\u001e;fe&\u0011Am\u0018\u0002\u0005\r&dW\rC\u0003g\u0011\u0001\u0007q-A\u0006e_6\f\u0017N\\%oI\u0016D\bCA\u0010i\u0013\tI\u0007EA\u0002J]RDQa\u001b\u0005A\u00021\fa\u0001Z8nC&t\u0007CA7q\u001b\u0005q'BA89\u0003\u0015iw\u000eZ3m\u0013\t\thN\u0001\u0004E_6\f\u0017N\u001c\u0005\u0006]!\u0001\raL\u0001\u000bEVLG\u000e\u001a+bE2,G#B*vmjd\b\"B6\n\u0001\u0004a\u0007\"B\u001d\n\u0001\u00049\bCA7y\u0013\tIhN\u0001\u0004TG\",W.\u0019\u0005\u0006w&\u0001\r!X\u0001\ni\u0006\u0014G.\u001a$jY\u0016DQAL\u0005A\u0002=\n\u0011BY;jY\u0012TuNY:\u0015\u0005M{\b\"\u0002\u0018\u000b\u0001\u0004y\u0013\u0001\u00032vS2$'j\u001c2\u0015\u0013M\u000b)!!\u0003\u0002\u000e\u0005]\u0001BBA\u0004\u0017\u0001\u0007Q,A\u0004k_\n\u0004\u0016\r\u001e5\t\r\u0005-1\u00021\u0001h\u0003!QwNY%oI\u0016D\bbBA\b\u0017\u0001\u0007\u0011\u0011C\u0001\bU>\u0014G)Z:d!\ri\u00171C\u0005\u0004\u0003+q'aC!vi>TuN\u0019#fg\u000eDQAL\u0006A\u0002=\n\u0011BY;jY\u0012$\u0016m]6\u0015\u0013M\u000bi\"a\b\u0002*\u00055\u0002bBA\b\u0019\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003Ca\u0001\u0019AA\u0012\u0003!!\u0018m]6EKN\u001c\u0007cA7\u0002&%\u0019\u0011q\u00058\u0003\u0019\u0005+Ho\u001c+bg.$Um]2\t\r\u0005-B\u00021\u0001^\u0003!!\u0018m]6GS2,\u0007\"\u0002\u0018\r\u0001\u0004y\u0013!\u00042vS2$G+\u00192mKN3v\tF\u0003T\u0003g\t9\u0004\u0003\u0004\u000265\u0001\r!X\u0001\u0011e\u0016d\u0017\r^5p]N\u001cfk\u0012$jY\u0016Dq!!\u000f\u000e\u0001\u0004\tY$\u0001\u0004uC\ndWm\u001d\t\u0007\u0003{\ti%a\u0015\u000f\t\u0005}\u0012\u0011\n\b\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013bAA&A\u00059\u0001/Y2lC\u001e,\u0017\u0002BA(\u0003#\u0012A\u0001T5ti*\u0019\u00111\n\u0011\u0011\t\u0005U\u0013Q\f\b\u0005\u0003/\nI\u0006E\u0002\u0002B\u0001J1!a\u0017!\u0003\u0019\u0001&/\u001a3fM&!\u0011qLA1\u0005\u0019\u0019FO]5oO*\u0019\u00111\f\u0011\u0002\u0019\t,\u0018\u000e\u001c3UCN\\7KV$\u0015\u000bM\u000b9'a\u001b\t\r\u0005%d\u00021\u0001^\u0003)yW\u000f\u001e9vi\u001aKG.\u001a\u0005\b\u0003[r\u0001\u0019AA\u001e\u0003\u0015!\u0018m]6t\u0003-\u0011W/\u001b7e\u0003\u000ec5KV$\u0015\u000bM\u000b\u0019(a\u001e\t\r\u0005Ut\u00021\u0001^\u0003)\t7\r\\*W\u000f\u001aKG.\u001a\u0005\b\u0003sy\u0001\u0019AA\u001e\u0003%\u00198\u000f]#oO&tW-\u0006\u0002\u0002~A!\u0011qPAG\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015aB:dC2\fG/\u001a\u0006\u0005\u0003\u000f\u000bI)\u0001\u0006gkN,7o\\;sG\u0016T!!a#\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0010\u0006\u0005%A\u0004+f[Bd\u0017\r^3F]\u001eLg.Z\u0001\u0015CB\u0004H.\u001f+bE2,7k\u0015)B]\u0012\u001c\u0016M^3\u0015\u0013M\u000b)*a&\u0002\u001a\u0006u\u0005\"B6\u0012\u0001\u0004a\u0007BBA5#\u0001\u0007Q\f\u0003\u0004\u0002\u001cF\u0001\ra^\u0001\u0006i\u0006\u0014G.\u001a\u0005\u0006]E\u0001\raL\u0001\u0014CB\u0004H.\u001f+bg.\u001c6\u000bU!oIN\u000bg/\u001a\u000b\n'\u0006\r\u0016QUAT\u0003SCq!a\u0004\u0013\u0001\u0004\t\t\u0002C\u0004\u0002\"I\u0001\r!a\t\t\r\u0005%$\u00031\u0001^\u0011\u0015q#\u00031\u00010\u0001")
public class SiteHandler
implements StrictLogging {
    private TemplateEngine sspEngine;
    private final SiteConfig config;
    private final SchemaHandler schemaHandler;
    private final Settings settings;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Settings settings() {
        return this.settings;
    }

    public Try<BoxedUnit> run() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean x$1 = $this.config.outputPath().createDirectoryIfNotExists$default$1();
            Seq x$2 = $this.config.outputPath().createDirectoryIfNotExists$default$2(x$1);
            Seq x$3 = $this.config.outputPath().createDirectoryIfNotExists$default$3(x$1);
            $this.config.outputPath().createDirectoryIfNotExists(x$1, x$2, x$3);
            this.buildDomains($this.config);
            this.buildJobs($this.config);
        });
    }

    public void buildDomains(SiteConfig config) {
        IntRef domainIndex = IntRef.create((int)1);
        File domainPaths = config.outputPath().$div("1000.load");
        domainPaths.delete(true, domainPaths.delete$default$2());
        boolean x$12 = domainPaths.createDirectoryIfNotExists$default$1();
        Seq x$22 = domainPaths.createDirectoryIfNotExists$default$2(x$12);
        Seq x$3 = domainPaths.createDirectoryIfNotExists$default$3(x$12);
        domainPaths.createDirectoryIfNotExists(x$12, x$22, x$3);
        String category = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(209).append("\n         |{\n         |  \"label\": \"Load\",\n         |  \"link\": {\n         |    \"type\": \"generated-index\",\n         |    \"description\": \"").append(this.schemaHandler.domains(this.schemaHandler.domains$default$1(), this.schemaHandler.domains$default$2(), this.schemaHandler.domains$default$3(), this.schemaHandler.domains$default$4()).size()).append(" domain(s) with ").append(((SeqLike)this.schemaHandler.domains(this.schemaHandler.domains$default$1(), this.schemaHandler.domains$default$2(), this.schemaHandler.domains$default$3(), this.schemaHandler.domains$default$4()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.tables(), List$.MODULE$.canBuildFrom())).size()).append(" table(s)\"\n         |\n         |  }\n         |}\n         |").toString())).stripMargin();
        File qual$1 = domainPaths.$div("_category_.json");
        String x$4 = category;
        Seq x$5 = qual$1.writeText$default$2(x$4);
        Charset x$6 = qual$1.writeText$default$3(x$4);
        qual$1.writeText(x$4, x$5, x$6);
        ((List)this.schemaHandler.domains(this.schemaHandler.domains$default$1(), this.schemaHandler.domains$default$2(), this.schemaHandler.domains$default$3(), this.schemaHandler.domains$default$4()).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.finalName(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)domain -> {
            SiteHandler.$anonfun$buildDomains$3(this, domainPaths, domainIndex, config, domain);
            return BoxedUnit.UNIT;
        });
    }

    private void buildDomain(File domainPath, int domainIndex, Domain domain, SiteConfig config) {
        String normalizedDomainName = Utils$.MODULE$.keepAlphaNum(domain.finalName());
        String formattedDomainIndex = new StringOps(Predef$.MODULE$.augmentString("%04d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)domainIndex)}));
        File domainFolder = File$.MODULE$.apply(domainPath, new StringBuilder(1).append(formattedDomainIndex).append(".").append(normalizedDomainName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$1 = domainFolder.createDirectoryIfNotExists$default$1();
        Seq x$2 = domainFolder.createDirectoryIfNotExists$default$2(x$1);
        Seq x$32 = domainFolder.createDirectoryIfNotExists$default$3(x$1);
        domainFolder.createDirectoryIfNotExists(x$1, x$2, x$32);
        String category = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(169).append("\n         |{\n         |  \"label\": \"").append(domain.finalName()).append("\",\n         |  \"link\": {\n         |    \"type\": \"generated-index\",\n         |    \"description\": \"").append(domain.comment().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.replaceAll("\"", "'")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Description not provided")).append("\"\n         |  }\n         |}\n         |").toString())).stripMargin();
        File qual$1 = File$.MODULE$.apply(domainFolder, "_category_.json", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        String x$42 = category;
        Seq x$5 = qual$1.writeText$default$2(x$42);
        Charset x$6 = qual$1.writeText$default$3(x$42);
        qual$1.writeText(x$42, x$5, x$6);
        IntRef tableIndex = IntRef.create((int)1);
        ((List)domain.tables().sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.finalName(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)table -> {
            SiteHandler.$anonfun$buildDomain$4(this, tableIndex, domainFolder, domain, config, table);
            return BoxedUnit.UNIT;
        });
    }

    private void buildTable(Domain domain, Schema schema, File tableFile, SiteConfig config) {
        this.applyTableSSPAndSave(domain, tableFile, schema, config);
    }

    public void buildJobs(SiteConfig config) {
        IntRef jobIndex = IntRef.create((int)1);
        File jobPaths = config.outputPath().$div("1100.transform");
        jobPaths.delete(true, jobPaths.delete$default$2());
        boolean x$1 = jobPaths.createDirectoryIfNotExists$default$1();
        Seq x$2 = jobPaths.createDirectoryIfNotExists$default$2(x$1);
        Seq x$3 = jobPaths.createDirectoryIfNotExists$default$3(x$1);
        jobPaths.createDirectoryIfNotExists(x$1, x$2, x$3);
        String category = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(214).append("\n         |{\n         |  \"label\": \"Transform\",\n         |  \"link\": {\n         |    \"type\": \"generated-index\",\n         |    \"description\": \"").append(this.schemaHandler.jobs(this.schemaHandler.jobs$default$1()).size()).append(" domain(s) with ").append(((SeqLike)this.schemaHandler.jobs(this.schemaHandler.jobs$default$1()).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.tasks(), List$.MODULE$.canBuildFrom())).size()).append(" table(s)\"\n         |\n         |  }\n         |}\n         |").toString())).stripMargin();
        File qual$1 = jobPaths.$div("_category_.json");
        String x$4 = category;
        Seq x$52 = qual$1.writeText$default$2(x$4);
        Charset x$62 = qual$1.writeText$default$3(x$4);
        qual$1.writeText(x$4, x$52, x$62);
        ((List)this.schemaHandler.jobs(this.schemaHandler.jobs$default$1()).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)job -> {
            SiteHandler.$anonfun$buildJobs$3(this, jobPaths, jobIndex, config, job);
            return BoxedUnit.UNIT;
        });
    }

    private void buildJob(File jobPath, int jobIndex, AutoJobDesc jobDesc, SiteConfig config) {
        String normalizedJobName = Utils$.MODULE$.keepAlphaNum(jobDesc.name());
        String formattedJobIndex = new StringOps(Predef$.MODULE$.augmentString("%04d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)jobIndex)}));
        File jobFolder = File$.MODULE$.apply(jobPath, new StringBuilder(1).append(formattedJobIndex).append(".").append(normalizedJobName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$1 = jobFolder.createDirectoryIfNotExists$default$1();
        Seq x$2 = jobFolder.createDirectoryIfNotExists$default$2(x$1);
        Seq x$3 = jobFolder.createDirectoryIfNotExists$default$3(x$1);
        jobFolder.createDirectoryIfNotExists(x$1, x$2, x$3);
        String category = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(169).append("\n         |{\n         |  \"label\": \"").append(jobDesc.name()).append("\",\n         |  \"link\": {\n         |    \"type\": \"generated-index\",\n         |    \"description\": \"").append(jobDesc.comment().getOrElse((Function0 & Serializable & scala.Serializable)() -> "Description not provided")).append("\"\n         |  }\n         |}\n         |").toString())).stripMargin();
        File qual$1 = File$.MODULE$.apply(jobFolder, "_category_.json", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        String x$4 = category;
        Seq x$5 = qual$1.writeText$default$2(x$4);
        Charset x$6 = qual$1.writeText$default$3(x$4);
        qual$1.writeText(x$4, x$5, x$6);
        IntRef taskIndex = IntRef.create((int)1);
        jobDesc.tasks().foreach((Function1 & Serializable & scala.Serializable)task -> {
            SiteHandler.$anonfun$buildJob$2(this, taskIndex, jobFolder, jobDesc, config, task);
            return BoxedUnit.UNIT;
        });
    }

    private void buildTask(AutoJobDesc jobDesc, AutoTaskDesc taskDesc, File taskFile, SiteConfig config) {
        this.applyTaskSSPAndSave(jobDesc, taskDesc, taskFile, config);
    }

    private void buildTableSVG(File relationsSVGFile, List<String> tables) {
        TableDependenciesConfig config = new TableDependenciesConfig(false, true, (Option<File>)new Some((Object)relationsSVGFile), (Option<Seq<String>>)new Some(tables), false, true, TableDependenciesConfig$.MODULE$.$lessinit$greater$default$7(), TableDependenciesConfig$.MODULE$.$lessinit$greater$default$8(), TableDependenciesConfig$.MODULE$.$lessinit$greater$default$9());
        TableDependencies service = new TableDependencies(this.schemaHandler);
        service.relationsAsDotFile(config);
    }

    private void buildTaskSVG(File outputFile, List<String> tasks) {
        Some x$1 = new Some((Object)outputFile);
        Some x$2 = new Some(tasks);
        boolean x$3 = true;
        boolean x$4 = true;
        boolean x$5 = AutoTaskDependenciesConfig$.MODULE$.apply$default$3();
        Seq<String> x$6 = AutoTaskDependenciesConfig$.MODULE$.apply$default$4();
        boolean x$7 = AutoTaskDependenciesConfig$.MODULE$.apply$default$6();
        boolean x$8 = AutoTaskDependenciesConfig$.MODULE$.apply$default$8();
        boolean x$9 = AutoTaskDependenciesConfig$.MODULE$.apply$default$9();
        boolean x$10 = AutoTaskDependenciesConfig$.MODULE$.apply$default$10();
        boolean x$11 = AutoTaskDependenciesConfig$.MODULE$.apply$default$11();
        AutoTaskDependenciesConfig config = new AutoTaskDependenciesConfig((Option<File>)x$1, (Option<Seq<String>>)x$2, x$5, x$6, x$3, x$7, x$4, x$8, x$9, x$10, x$11);
        AutoTaskDependencies service = new AutoTaskDependencies(this.settings(), this.schemaHandler, this.settings().storageHandler(this.settings().storageHandler$default$1()));
        service.jobAsDot(config);
    }

    private void buildACLSVG(File aclSVGFile, List<String> tables) {
        Some x$1 = new Some((Object)aclSVGFile);
        List<String> x$2 = tables;
        boolean x$3 = false;
        boolean x$4 = true;
        boolean x$5 = true;
        List<String> x$6 = AclDependenciesConfig$.MODULE$.$lessinit$greater$default$1();
        boolean x$7 = AclDependenciesConfig$.MODULE$.$lessinit$greater$default$6();
        boolean x$8 = AclDependenciesConfig$.MODULE$.$lessinit$greater$default$7();
        AclDependenciesConfig config = new AclDependenciesConfig(x$6, x$2, (Option<File>)x$1, x$3, x$4, x$7, x$8, x$5);
        AclDependencies service = new AclDependencies(this.schemaHandler);
        service.aclsAsDotFile(config);
    }

    private TemplateEngine sspEngine$lzycompute() {
        SiteHandler siteHandler = this;
        synchronized (siteHandler) {
            if (!this.bitmap$0) {
                this.sspEngine = new TemplateEngine(TemplateEngine$.MODULE$.$lessinit$greater$default$1(), TemplateEngine$.MODULE$.$lessinit$greater$default$2());
                this.bitmap$0 = true;
            }
        }
        return this.sspEngine;
    }

    public TemplateEngine sspEngine() {
        if (!this.bitmap$0) {
            return this.sspEngine$lzycompute();
        }
        return this.sspEngine;
    }

    public void applyTableSSPAndSave(Domain domain, File outputFile, Schema table, SiteConfig config) {
        String sspOutput;
        File relationsSVGFile = File$.MODULE$.apply(outputFile.parent(), new StringBuilder(14).append(table.finalName()).append("-relations.svg").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.buildTableSVG(relationsSVGFile, (List<String>)new .colon.colon((Object)new StringBuilder(1).append(domain.finalName()).append(".").append(table.finalName()).toString(), (List)Nil$.MODULE$));
        BoxedUnit relationsSVG = BoxedUnit.UNIT;
        File aclSVGFile = File$.MODULE$.apply(outputFile.parent(), new StringBuilder(8).append(table.finalName()).append("-acl.svg").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.buildACLSVG(aclSVGFile, (List<String>)new .colon.colon((Object)new StringBuilder(1).append(domain.finalName()).append(".").append(table.finalName()).toString(), (List)Nil$.MODULE$));
        BoxedUnit aclSVG = BoxedUnit.UNIT;
        Map paramMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaHandler"), (Object)this.schemaHandler), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationsSVG"), (Object)relationsSVGFile.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aclSVG"), (Object)aclSVGFile.name())}));
        Tuple2<String, String> tuple2 = config.templateContent(SiteCmd$.MODULE$.TABLE_TEMPLATE());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sspResource = (String)tuple2._1();
        String templateContent = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sspResource, (Object)templateContent);
        String sspResource2 = (String)tuple22._1();
        String templateContent2 = (String)tuple22._2();
        String x$1 = sspOutput = this.sspEngine().layout((TemplateSource)TemplateSource$.MODULE$.fromText(sspResource2, templateContent2), paramMap);
        Seq x$2 = outputFile.writeText$default$2(x$1);
        Charset x$3 = outputFile.writeText$default$3(x$1);
        outputFile.writeText(x$1, x$2, x$3);
    }

    public void applyTaskSSPAndSave(AutoJobDesc jobDesc, AutoTaskDesc taskDesc, File outputFile, SiteConfig config) {
        String sspOutput;
        File relationsSVGFile = File$.MODULE$.apply(outputFile.parent(), new StringBuilder(14).append(taskDesc.name()).append("-relations.svg").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.buildTaskSVG(relationsSVGFile, (List<String>)new .colon.colon((Object)taskDesc.name(), (List)Nil$.MODULE$));
        File aclSVGFile = File$.MODULE$.apply(outputFile.parent(), new StringBuilder(8).append(taskDesc.name()).append("-acl.svg").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.buildACLSVG(aclSVGFile, (List<String>)new .colon.colon((Object)new StringBuilder(1).append(jobDesc.name()).append(".").append(taskDesc.name()).toString(), (List)Nil$.MODULE$));
        BoxedUnit aclSVG = BoxedUnit.UNIT;
        String sql = (String)taskDesc.sql().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String formattedSql = SQLUtils$.MODULE$.format(sql, JSQLFormatter.OutputFormat.PLAIN);
        Map paramMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"task"), (Object)taskDesc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaHandler"), (Object)this.schemaHandler), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationsSVG"), (Object)relationsSVGFile.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aclSVG"), (Object)aclSVGFile.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sql"), (Object)formattedSql), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"python"), taskDesc.python().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))}));
        Tuple2<String, String> tuple2 = config.templateContent(SiteCmd$.MODULE$.TASK_TEMPLATE());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sspResource = (String)tuple2._1();
        String templateContent = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sspResource, (Object)templateContent);
        String sspResource2 = (String)tuple22._1();
        String templateContent2 = (String)tuple22._2();
        String x$1 = sspOutput = this.sspEngine().layout((TemplateSource)TemplateSource$.MODULE$.fromText(sspResource2, templateContent2), paramMap);
        Seq x$2 = outputFile.writeText$default$2(x$1);
        Charset x$3 = outputFile.writeText$default$3(x$1);
        outputFile.writeText(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$buildDomains$3(SiteHandler $this, File domainPaths$1, IntRef domainIndex$1, SiteConfig config$1, Domain domain) {
        $this.buildDomain(domainPaths$1, domainIndex$1.elem, domain, config$1);
        ++domainIndex$1.elem;
    }

    public static final /* synthetic */ void $anonfun$buildDomain$4(SiteHandler $this, IntRef tableIndex$1, File domainFolder$1, Domain domain$1, SiteConfig config$2, Schema table) {
        String formattedIndex = new StringOps(Predef$.MODULE$.augmentString("%04d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tableIndex$1.elem)}));
        ++tableIndex$1.elem;
        File tableFolder = File$.MODULE$.apply(domainFolder$1, new StringBuilder(5).append(formattedIndex).append(".").append(table.finalName()).append(".mdx").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        $this.buildTable(domain$1, table, tableFolder, config$2);
    }

    public static final /* synthetic */ void $anonfun$buildJobs$3(SiteHandler $this, File jobPaths$1, IntRef jobIndex$1, SiteConfig config$3, AutoJobDesc job) {
        $this.buildJob(jobPaths$1, jobIndex$1.elem, job, config$3);
        ++jobIndex$1.elem;
    }

    public static final /* synthetic */ void $anonfun$buildJob$2(SiteHandler $this, IntRef taskIndex$1, File jobFolder$1, AutoJobDesc jobDesc$1, SiteConfig config$4, AutoTaskDesc task) {
        String formattedIndex = new StringOps(Predef$.MODULE$.augmentString("%04d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)taskIndex$1.elem)}));
        ++taskIndex$1.elem;
        File tableFolder = File$.MODULE$.apply(jobFolder$1, new StringBuilder(5).append(formattedIndex).append(".").append(task.name()).append(".mdx").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        $this.buildTask(jobDesc$1, task, tableFolder, config$4);
    }

    public SiteHandler(SiteConfig config, SchemaHandler schemaHandler, Settings settings) {
        this.config = config;
        this.schemaHandler = schemaHandler;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
    }
}

