/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.transform;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.extract.ExtractJDBCSchemaCmd$;
import ai.starlake.extract.ExtractSchemaConfig;
import ai.starlake.extract.ExtractSchemaConfig$;
import ai.starlake.extract.JdbcDbUtils$;
import ai.starlake.job.metrics.ExpectationJob;
import ai.starlake.job.metrics.JdbcExpectationAssertionHandler;
import ai.starlake.job.transform.AutoTask;
import ai.starlake.job.transform.JdbcAutoTask$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AccessControlEntry$;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.WriteStrategy;
import ai.starlake.schema.model.WriteStrategyType;
import ai.starlake.schema.model.WriteStrategyType$SCD2$;
import ai.starlake.utils.Formatter;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.JdbcJobResult;
import ai.starlake.utils.JdbcJobResult$;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.SparkUtils$;
import ai.starlake.utils.Utils$;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001B\u0014)\u0001EB\u0011B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e%\t\u0013%\u0003!\u0011!Q\u0001\n)\u0013\u0006\"C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+X\u0011%A\u0006A!A!\u0002\u00139\u0014\fC\u0005[\u0001\t\u0005\t\u0015!\u0003\\=\"Iq\f\u0001B\u0001B\u0003%1\f\u0019\u0005\nC\u0002\u0011\t\u0011)A\u00057\nD\u0001b\u0019\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\nI\u0002\u0011\t\u0011)A\u0005K\"D\u0011\"\u001b\u0001\u0003\u0002\u0003\u0006YA\u001b9\t\u0011E\u0004!\u0011!Q\u0001\fID\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006Y!\u001f\u0005\u0006y\u0002!\t! \u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\f\u0001\t\u0003\ti\u0006C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\u000b\u00037\u0003\u0001R1A\u0005R\u0005u\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u00037\u0004A\u0011BAo\u0011)\t9\u000f\u0001EC\u0002\u0013\u0005\u0011\u0011\u001e\u0005\b\u0003W\u0004A\u0011BAw\u0011\u001d\t)\u0010\u0001C\u0005\u0003oDqAa\u0010\u0001\t\u0003\u0011\t\u0005C\u0007\u0003X\u0001\u0001\n1!A\u0001\n\u0013\u0011IF\u0015\u0005\u000e\u00057\u0002\u0001\u0013aA\u0001\u0002\u0013%!Q\f9\t\u001b\t}\u0003\u0001%A\u0002\u0002\u0003%IA!\u0019Z\u00115\u0011\u0019\u0007\u0001I\u0001\u0004\u0003\u0005I\u0011BAC=\"i!Q\r\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002\u0006\u0002<qAa\u001a)\u0011\u0003\u0011IG\u0002\u0004(Q!\u0005!1\u000e\u0005\u0007y\n\"\tAa\"\t\u000f\t%%\u0005\"\u0001\u0003\f\"I!\u0011\u0014\u0012\u0012\u0002\u0013\u0005!1\u0014\u0005\n\u0005c\u0013\u0013\u0013!C\u0001\u0005g\u0013AB\u00133cG\u0006+Ho\u001c+bg.T!!\u000b\u0016\u0002\u0013Q\u0014\u0018M\\:g_Jl'BA\u0016-\u0003\rQwN\u0019\u0006\u0003[9\n\u0001b\u001d;be2\f7.\u001a\u0006\u0002_\u0005\u0011\u0011-[\u0002\u0001'\t\u0001!\u0007\u0005\u00024i5\t\u0001&\u0003\u00026Q\tA\u0011)\u001e;p)\u0006\u001c8.A\u0003baBLE\rE\u00029wuj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y*eBA D!\t\u0001\u0015(D\u0001B\u0015\t\u0011\u0005'\u0001\u0004=e>|GOP\u0005\u0003\tf\na\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011A)O\u0005\u0003mQ\n\u0001\u0002^1tW\u0012+7o\u0019\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bQ!\\8eK2T!a\u0014\u0017\u0002\rM\u001c\u0007.Z7b\u0013\t\tFJ\u0001\u0007BkR|G+Y:l\t\u0016\u001c8-\u0003\u0002Ji\u0005\t2m\\7nC:$\u0007+\u0019:b[\u0016$XM]:\u0011\ty*V(P\u0005\u0003-\u001e\u00131!T1q\u0013\t\u0019F'A\u0006j]R,'/Y2uSZ,\u0017B\u0001-5\u0003!!(/\u001e8dCR,\u0007C\u0001\u001d]\u0013\ti\u0016HA\u0004C_>dW-\u00198\n\u0005i#\u0014\u0001\u0002;fgRL!a\u0018\u001b\u0002\u00191|w-\u0012=fGV$\u0018n\u001c8\n\u0005\u0005$\u0014aC1dG\u0016\u001c8\u000fV8lK:\faB]3tk2$\b+Y4f'&TX\r\u0005\u00029M&\u0011q-\u000f\u0002\u0004\u0013:$\u0018B\u000135\u0003!\u0019X\r\u001e;j]\u001e\u001c\bCA6o\u001b\u0005a'BA7-\u0003\u0019\u0019wN\u001c4jO&\u0011q\u000e\u001c\u0002\t'\u0016$H/\u001b8hg&\u0011\u0011\u000eN\u0001\u000fgR|'/Y4f\u0011\u0006tG\r\\3s!\t\u0019h/D\u0001u\u0015\t)h*\u0001\u0005iC:$G.\u001a:t\u0013\t9HO\u0001\bTi>\u0014\u0018mZ3IC:$G.\u001a:\u0002\u001bM\u001c\u0007.Z7b\u0011\u0006tG\r\\3s!\t\u0019(0\u0003\u0002|i\ni1k\u00195f[\u0006D\u0015M\u001c3mKJ\fa\u0001P5oSRtDc\u0005@\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]AcB@\u0002\u0002\u0005\r\u0011Q\u0001\t\u0003g\u0001AQ![\u0007A\u0004)DQ!]\u0007A\u0004IDQ\u0001_\u0007A\u0004eDQAN\u0007A\u0002]BQ!S\u0007A\u0002)CQaU\u0007A\u0002QCQ\u0001W\u0007A\u0002]BQAW\u0007A\u0002mCQaX\u0007A\u0002mCQ!Y\u0007A\u0002mCqaY\u0007\u0011\u0002\u0003\u0007q\u0007C\u0004e\u001bA\u0005\t\u0019A3\u0002\u001d\u0015DHO]1di*#'mY!dYR\u0011\u0011Q\u0004\t\u0006\u0003?\tI#\u0010\b\u0005\u0003C\t)CD\u0002A\u0003GI\u0011AO\u0005\u0004\u0003OI\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003W\tiC\u0001\u0003MSN$(bAA\u0014s\u0005a\u0011\r\u001d9ms*#'mY!dYR1\u00111GA#\u00033\u0002b!!\u000e\u0002<\u0005}RBAA\u001c\u0015\r\tI$O\u0001\u0005kRLG.\u0003\u0003\u0002>\u0005]\"a\u0001+ssB\u0019\u0001(!\u0011\n\u0007\u0005\r\u0013H\u0001\u0003V]&$\bbBA$\u001f\u0001\u0007\u0011\u0011J\u0001\u000bG>tg.Z2uS>t\u0007\u0003BA&\u0003+j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0004gFd'BAA*\u0003\u0011Q\u0017M^1\n\t\u0005]\u0013Q\n\u0002\u000b\u0007>tg.Z2uS>t\u0007BBA.\u001f\u0001\u00071,\u0001\u0006g_J\u001cW-\u00119qYf$b!a\r\u0002`\u0005=\u0004bBA1!\u0001\u0007\u00111M\u0001\u000fU\u0012\u00147mQ8o]\u0016\u001cG/[8o!\u0011\t)'a\u001b\u000f\u0007-\f9'C\u0002\u0002j1\f\u0001bU3ui&twm]\u0005\u0005\u0003/\niGC\u0002\u0002j1Da!a\u0017\u0011\u0001\u0004Y\u0016a\u0001:v]R\u0011\u0011Q\u000f\t\u0007\u0003k\tY$a\u001e\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! -\u0003\u0015)H/\u001b7t\u0013\u0011\t\t)a\u001f\u0003\u0013){'MU3tk2$\u0018a\u0003;bE2,W\t_5tiN,\u0012aW\u0001\u0011GJ,\u0017\r^3Bk\u0012LG\u000fV1cY\u0016$\u0012aW\u0001\u000fC\u0012$7k\u0011#3\u0007>dW/\u001c8t)\u0019\ty$a$\u0002\u0012\"9\u0011q\t\u000bA\u0002\u0005%\u0003bBAJ)\u0001\u0007\u0011QS\u0001\u000bK:<\u0017N\\3OC6,\u0007cA&\u0002\u0018&\u0019\u0011\u0011\u0014'\u0003\r\u0015sw-\u001b8f\u00039\u0019\u0018N\\6D_:tWm\u0019;j_:,\"!a\u0019\u0002\u000fI,hN\u0013#C\u0007R!\u00111UAV!\u0019\t)$a\u000f\u0002&B!\u0011\u0011PAT\u0013\u0011\tI+a\u001f\u0003\u001b)#'m\u0019&pEJ+7/\u001e7u\u0011\u001d\tiK\u0006a\u0001\u0003_\u000b!\u0001\u001a4\u0011\taZ\u0014\u0011\u0017\t\u0005\u0003g\u000b)N\u0004\u0003\u00026\u0006Eg\u0002BA\\\u0003\u001btA!!/\u0002H:!\u00111XAa\u001d\r\u0001\u0015QX\u0005\u0003\u0003\u007f\u000b1a\u001c:h\u0013\u0011\t\u0019-!2\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ty,\u0003\u0003\u0002J\u0006-\u0017!B:qCJ\\'\u0002BAb\u0003\u000bLA!a\u0014\u0002P*!\u0011\u0011ZAf\u0013\u0011\t9#a5\u000b\t\u0005=\u0013qZ\u0005\u0005\u0003/\fINA\u0005ECR\fgI]1nK*!\u0011qEAj\u00039\u0011XO\\%oi\u0016\u0014\u0018m\u0019;jm\u0016$b!!*\u0002`\u0006\r\bbBAq/\u0001\u0007\u0011\u0011J\u0001\u0005G>tg\u000e\u0003\u0004\u0002f^\u0001\r!P\u0001\b[\u0006LgnU9m\u000351W\u000f\u001c7UC\ndWMT1nKV\tQ(A\u0007sk:\u0004&/Z!di&|gn\u001d\u000b\u0007\u0003\u007f\ty/!=\t\u000f\u0005\u0005\u0018\u00041\u0001\u0002J!9\u00111_\rA\u0002\u0005u\u0011A\u00039sK\u0006\u001bG/[8og\u00069!/\u001e8Tc2\u001cH\u0003CA \u0003s\fY0a@\t\u000f\u0005\u0005(\u00041\u0001\u0002J!9\u0011Q \u000eA\u0002\u0005u\u0011\u0001B:rYNDaA!\u0001\u001b\u0001\u0004i\u0014a\u0001;za\"*!D!\u0002\u0003\u0012A)\u0001Ha\u0002\u0003\f%\u0019!\u0011B\u001d\u0003\rQD'o\\<t!\u0011\tyB!\u0004\n\t\t=\u0011Q\u0006\u0002\n\u000bb\u001cW\r\u001d;j_:\fdAH\u001f\u0003\u0014\tu\u0012'C\u0012\u0003\u0016\tm!1\u0007B\u000f+\u0011\tIOa\u0006\u0005\u000f\te\u0001G1\u0001\u0003$\t\tA+\u0003\u0003\u0003\u001e\t}\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0003\"e\na\u0001\u001e5s_^\u001c\u0018\u0003\u0002B\u0013\u0005W\u00012\u0001\u000fB\u0014\u0013\r\u0011I#\u000f\u0002\b\u001d>$\b.\u001b8h!\u0011\u0011iCa\f\u000f\u0007a\n)#\u0003\u0003\u00032\u00055\"!\u0003+ie><\u0018M\u00197fc%\u0019#Q\u0007B\u001c\u0005s\u0011\tCD\u00029\u0005oI1A!\t:c\u0015\u0011\u0003(\u000fB\u001e\u0005\u0015\u00198-\u00197bc\r1#1B\u0001\u0016kB$\u0017\r^3KI\n\u001cG+\u00192mKN\u001b\u0007.Z7b)\u0019\tyDa\u0011\u0003T!9!QI\u000eA\u0002\t\u001d\u0013AD5oG>l\u0017N\\4TG\",W.\u0019\t\u0005\u0005\u0013\u0012y%\u0004\u0002\u0003L)!!QJAj\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0011\tFa\u0013\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0004\u0003Vm\u0001\r!P\u0001\ni\u0006\u0014G.\u001a(b[\u0016\fab];qKJ$C/Y:l\t\u0016\u001c8-F\u0001K\u00039\u0019X\u000f]3sIM,G\u000f^5oON,\u0012A[\u0001\u0012gV\u0004XM\u001d\u0013j]R,'/Y2uSZ,W#A\u001c\u0002\u001dM,\b/\u001a:%iJ,hnY1uK\u0006Q1/\u001e9fe\u0012\"Xm\u001d;\u0002\u0019)#'mY!vi>$\u0016m]6\u0011\u0005M\u00123#\u0002\u0012\u0003n\tM\u0004c\u0001\u001d\u0003p%\u0019!\u0011O\u001d\u0003\r\u0005s\u0017PU3g!\u0011\u0011)Ha!\u000e\u0005\t]$\u0002\u0002B=\u0005w\nAb]2bY\u0006dwnZ4j]\u001eTAA! \u0003\u0000\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0003\u0002\u0006\u00191m\\7\n\t\t\u0015%q\u000f\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0015\u0005\t%\u0014!D3yK\u000e,H/Z+qI\u0006$X\r\u0006\u0004\u0003\u000e\nM%Q\u0013\u000b\u0005\u0005\u001f\u0013\t\nE\u0003\u00026\u0005m2\fC\u0003jI\u0001\u000f!\u000e\u0003\u0004\u0002P\u0011\u0002\r!\u0010\u0005\u0007\u0005/#\u0003\u0019A\u001f\u0002\u001d\r|gN\\3di&|gNT1nK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIa*\"A!(+\u0007]\u0012yj\u000b\u0002\u0003\"B!!1\u0015BW\u001b\t\u0011)K\u0003\u0003\u0003(\n%\u0016!C;oG\",7m[3e\u0015\r\u0011Y+O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BX\u0005K\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!Q\u0017\u0016\u0004K\n}\u0005")
public class JdbcAutoTask
extends AutoTask {
    private Settings.Connection sinkConnection;
    private String fullTableName;
    private final Option<String> accessToken;
    private final StorageHandler storageHandler;
    private final SchemaHandler schemaHandler;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$9() {
        return JdbcAutoTask$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<String> $lessinit$greater$default$8() {
        return JdbcAutoTask$.MODULE$.$lessinit$greater$default$8();
    }

    public static Try<Object> executeUpdate(String string, String string2, Settings settings) {
        return JdbcAutoTask$.MODULE$.executeUpdate(string, string2, settings);
    }

    private /* synthetic */ AutoTaskDesc super$taskDesc() {
        return super.taskDesc();
    }

    private /* synthetic */ Settings super$settings() {
        return super.settings();
    }

    private /* synthetic */ Option super$interactive() {
        return super.interactive();
    }

    private /* synthetic */ boolean super$truncate() {
        return super.truncate();
    }

    private /* synthetic */ boolean super$test() {
        return super.test();
    }

    public List<String> extractJdbcAcl() {
        return (List)super.taskDesc().acl().flatMap((Function1 & Serializable & scala.Serializable)ace -> ace.asJdbcSql(this.fullTableName()), List$.MODULE$.canBuildFrom());
    }

    public Try<BoxedUnit> applyJdbcAcl(Connection connection, boolean forceApply) {
        return AccessControlEntry$.MODULE$.applyJdbcAcl(connection, (Seq<String>)this.extractJdbcAcl(), forceApply, super.settings());
    }

    public Try<BoxedUnit> applyJdbcAcl(Settings.Connection jdbcConnection, boolean forceApply) {
        return AccessControlEntry$.MODULE$.applyJdbcAcl(jdbcConnection, (Seq<String>)this.extractJdbcAcl(), forceApply, super.settings());
    }

    @Override
    public Try<JobResult> run() {
        return this.runJDBC((Option<Dataset<Row>>)None$.MODULE$);
    }

    @Override
    public boolean tableExists() {
        boolean exists = BoxesRunTime.unboxToBoolean(JdbcDbUtils$.MODULE$.withJDBCConnection(JdbcDbUtils$.MODULE$.readOnlyConnection(this.sinkConnection()).options(), (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JdbcAutoTask.$anonfun$tableExists$1(this, conn)), super.settings()));
        if (!exists && super.taskDesc()._auditTableName().isDefined()) {
            return this.createAuditTable();
        }
        return exists;
    }

    @Override
    public boolean createAuditTable() {
        return BoxesRunTime.unboxToBoolean(JdbcDbUtils$.MODULE$.withJDBCConnection(this.sinkConnection().options(), (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JdbcAutoTask.$anonfun$createAuditTable$1(this, conn)), super.settings()));
    }

    public void addSCD2Columns(Connection connection, Engine engineName) {
        Option<WriteStrategy> option = super.taskDesc().writeStrategy();
        if (option instanceof Some) {
            Some some = (Some)option;
            WriteStrategy strategyOptions = (WriteStrategy)some.value();
            WriteStrategyType writeStrategyType = strategyOptions.getEffectiveType();
            WriteStrategyType$SCD2$ writeStrategyType$SCD2$ = WriteStrategyType$SCD2$.MODULE$;
            if (!(writeStrategyType != null ? !((Object)writeStrategyType).equals(writeStrategyType$SCD2$) : writeStrategyType$SCD2$ != null)) {
                String startTsCol = (String)strategyOptions.startTs().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$settings().appConfig().scd2StartTimestamp());
                String endTsCol = (String)strategyOptions.endTs().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$settings().appConfig().scd2EndTimestamp());
                .colon.colon scd2Columns = new .colon.colon((Object)startTsCol, (List)new .colon.colon((Object)endTsCol, (List)Nil$.MODULE$));
                List alterTableSqls = (List)scd2Columns.map((Function1 & Serializable & scala.Serializable)column -> {
                    String string = engineName.toString().toLowerCase();
                    String string2 = "redshift";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return new StringBuilder(34).append("ALTER TABLE ").append(this.fullTableName()).append(" ADD COLUMN ").append((String)column).append(" TIMESTAMP").toString();
                    }
                    return new StringBuilder(53).append("ALTER TABLE ").append(this.fullTableName()).append(" ADD COLUMN IF NOT EXISTS ").append((String)column).append(" TIMESTAMP NULL").toString();
                }, List$.MODULE$.canBuildFrom());
                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runSqls(connection, (List<String>)alterTableSqls, "addSCE2Columns"));
                return;
            }
        }
    }

    private Settings.Connection sinkConnection$lzycompute() {
        JdbcAutoTask jdbcAutoTask = this;
        synchronized (jdbcAutoTask) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sinkConnection = super.interactive().isDefined() ? JdbcDbUtils$.MODULE$.readOnlyConnection((Settings.Connection)super.settings().appConfig().connections().apply((Object)this.sinkConnectionRef())) : (Settings.Connection)super.settings().appConfig().connections().apply((Object)this.sinkConnectionRef());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sinkConnection;
    }

    @Override
    public Settings.Connection sinkConnection() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sinkConnection$lzycompute();
        }
        return this.sinkConnection;
    }

    public Try<JdbcJobResult> runJDBC(Option<Dataset<Row>> df) {
        Timestamp start = Timestamp.from(Instant.now());
        Object object = super.interactive().isEmpty() && super.settings().appConfig().createSchemaIfNotExists() ? JdbcDbUtils$.MODULE$.withJDBCConnection(this.sinkConnection().options(), (Function1 & Serializable & scala.Serializable)conn -> {
            JdbcDbUtils$.MODULE$.createSchema(conn, this.fullDomainName());
            return BoxedUnit.UNIT;
        }, super.settings()) : BoxedUnit.UNIT;
        Try res = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            if (this.super$interactive().isEmpty() && df.isEmpty() && BoxesRunTime.unboxToBoolean((Object)this.super$taskDesc().parseSQL().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) {
                string = this.buildAllSQLQueries((Option<String>)None$.MODULE$, this.buildAllSQLQueries$default$2());
            } else {
                String sql = this.super$taskDesc().getSql();
                string = Utils$.MODULE$.parseJinja(sql, this.allVars(), this.super$settings());
            }
            String mainSql = string;
            Map sinkOptions = this.sinkConnection().isDuckDb() ? this.sinkConnection().options().updated((Object)"enable_external_access", (Object)"false") : this.sinkConnection().options();
            Option option = this.super$interactive();
            if (option instanceof Some) {
                return (JdbcJobResult)JdbcDbUtils$.MODULE$.withJDBCConnection((Map<String, String>)sinkOptions, (Function1 & Serializable & scala.Serializable)conn -> this.runInteractive((Connection)conn, mainSql), this.super$settings());
            }
            if (None$.MODULE$.equals(option)) {
                Try<JobResult> try_;
                String parsedPreActions = Utils$.MODULE$.parseJinja((String)this.jdbcSinkEngine().preActions().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.super$taskDesc().domain())}))), this.super$settings());
                Option option2 = df;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    Dataset loadedDF = (Dataset)some.value();
                    JdbcDbUtils$.MODULE$.withJDBCConnection((Map<String, String>)sinkOptions, (Function1 & Serializable & scala.Serializable)conn -> {
                        JdbcAutoTask.$anonfun$runJDBC$6(this, parsedPreActions, conn);
                        return BoxedUnit.UNIT;
                    }, this.super$settings());
                    Path tablePath = new Path(new StringBuilder(1).append(this.super$settings().appConfig().datasets()).append("/").append(this.fullTableName()).toString());
                    Object object = this.super$settings().storageHandler(this.super$settings().storageHandler$default$1()).exists(tablePath) ? BoxesRunTime.boxToBoolean((boolean)this.super$settings().storageHandler(this.super$settings().storageHandler$default$1()).delete(tablePath)) : BoxedUnit.UNIT;
                    if (this.sinkConnection().isDuckDb()) {
                        loadedDF.write().format("parquet").mode(SaveMode.Overwrite).save(tablePath.toString());
                        JdbcDbUtils$.MODULE$.withJDBCConnection((Map<String, String>)this.sinkConnection().options().updated((Object)"enable_external_access", (Object)"true"), (Function1 & Serializable & scala.Serializable)conn -> {
                            String sql = new StringBuilder(39).append("INSERT INTO ").append(this.fullTableName()).append(" SELECT * FROM '").append(tablePath).append("/*.parquet'").toString();
                            return JdbcDbUtils$.MODULE$.executeUpdate(sql, (Connection)conn);
                        }, this.super$settings());
                        BoxesRunTime.boxToBoolean((boolean)this.super$settings().storageHandler(this.super$settings().storageHandler$default$1()).delete(tablePath));
                    } else {
                        loadedDF.write().format((String)this.sinkConnection().sparkDatasource().getOrElse((Function0 & Serializable & scala.Serializable)() -> "jdbc")).option("dbtable", this.fullTableName()).mode(SaveMode.Append).options(this.sinkConnection().options()).save();
                    }
                } else if (None$.MODULE$.equals(option2)) {
                    JdbcDbUtils$.MODULE$.withJDBCConnection((Map<String, String>)sinkOptions, (Function1 & Serializable & scala.Serializable)conn -> {
                        JdbcAutoTask.$anonfun$runJDBC$10(this, parsedPreActions, mainSql, conn);
                        return BoxedUnit.UNIT;
                    }, this.super$settings());
                } else {
                    throw new MatchError((Object)option2);
                }
                JdbcDbUtils$.MODULE$.withJDBCConnection((Map<String, String>)sinkOptions, (Function1 & Serializable & scala.Serializable)conn -> {
                    JdbcAutoTask.$anonfun$runJDBC$12(this, conn);
                    return BoxedUnit.UNIT;
                }, this.super$settings());
                Try<JobResult> try_2 = this.super$settings().appConfig().expectations().active() ? new ExpectationJob((Option<String>)Option$.MODULE$.apply((Object)this.applicationId()), this.super$taskDesc().database(), this.super$taskDesc().domain(), this.super$taskDesc().table(), this.super$taskDesc().expectations(), $this.storageHandler, $this.schemaHandler, new JdbcExpectationAssertionHandler((Map<String, String>)sinkOptions), this.super$settings()).run() : BoxedUnit.UNIT;
                if (this.super$settings().appConfig().autoExportSchema()) {
                    boolean isTableInAuditDomain;
                    String string2 = this.super$taskDesc().domain();
                    String string3 = this.super$settings().appConfig().audit().getDomain(this.super$settings());
                    boolean bl = !(string2 != null ? !string2.equals(string3) : string3 != null) ? true : (isTableInAuditDomain = false);
                    if (isTableInAuditDomain) {
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Table {}.{} is in audit domain, skipping schema extraction", new Object[]{this.super$taskDesc().domain(), this.super$taskDesc().table()});
                            try_ = BoxedUnit.UNIT;
                        } else {
                            try_ = BoxedUnit.UNIT;
                        }
                    } else {
                        boolean x$2 = true;
                        Some x$3 = new Some((Object)DatasetArea$.MODULE$.external(this.super$settings()).toString());
                        String string4 = new StringBuilder(1).append(this.super$taskDesc().domain()).append(".").append(this.super$taskDesc().table()).toString();
                        List x$4 = Nil$.MODULE$.$colon$colon((Object)string4);
                        Some x$5 = new Some((Object)this.sinkConnectionRef());
                        Option<String> x$6 = $this.accessToken;
                        String x$7 = ExtractSchemaConfig$.MODULE$.apply$default$1();
                        Option<Object> x$8 = ExtractSchemaConfig$.MODULE$.apply$default$4();
                        ExtractSchemaConfig config = new ExtractSchemaConfig(x$7, (Seq<String>)x$4, (Option<String>)x$3, x$8, x$2, (Option<String>)x$5, x$6);
                        try_ = ExtractJDBCSchemaCmd$.MODULE$.run(config, $this.schemaHandler, this.super$settings());
                    }
                } else {
                    try_ = BoxedUnit.UNIT;
                }
                return new JdbcJobResult((List<String>)Nil$.MODULE$, JdbcJobResult$.MODULE$.apply$default$2());
            }
            throw new MatchError((Object)option);
        });
        Timestamp end = Timestamp.from(Instant.now());
        Try try_ = res;
        if (try_ instanceof Success) {
            if (super.logExecution()) {
                this.logAuditSuccess(start, end, -1L, super.test());
            }
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logAuditFailure(start, end, e, super.test());
        } else {
            throw new MatchError((Object)try_);
        }
        return res;
    }

    private JdbcJobResult runInteractive(Connection conn, String mainSql) {
        JdbcJobResult jdbcJobResult;
        try (Statement stmt = conn.createStatement();){
            try {
                ResultSet rs = stmt.executeQuery(mainSql);
                ListBuffer result = new ListBuffer();
                ListBuffer headerAsSeq = new ListBuffer();
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    headerAsSeq.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{rs.getMetaData().getColumnName(i)}));
                }
                for (int rowCount = 0; rs.next() && rowCount < super.settings().appConfig().maxInteractiveRecords(); ++rowCount) {
                    ListBuffer rowAsSeq = new ListBuffer();
                    for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                        rowAsSeq.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)Option$.MODULE$.apply(rs.getObject(i)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")}));
                    }
                    result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{rowAsSeq.toList()}));
                }
                jdbcJobResult = new JdbcJobResult((List<String>)headerAsSeq.toList(), (List<List<String>>)result.toList());
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(32).append("Error running interactive query ").append(mainSql).toString(), (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw e;
            }
        }
        return jdbcJobResult;
    }

    private String fullTableName$lzycompute() {
        JdbcAutoTask jdbcAutoTask = this;
        synchronized (jdbcAutoTask) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.fullTableName = new StringBuilder(1).append(this.fullDomainName()).append(".").append(super.taskDesc().table()).toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.fullTableName;
    }

    @Override
    public String fullTableName() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.fullTableName$lzycompute();
        }
        return this.fullTableName;
    }

    private void runPreActions(Connection conn, List<String> preActions) {
        this.runSqls(conn, preActions, "PreActions");
    }

    private void runSqls(Connection conn, List<String> sqls, String typ) throws Exception {
        if (sqls.nonEmpty()) {
            sqls.foreach((Function1 & Serializable & scala.Serializable)req -> {
                JdbcAutoTask.$anonfun$runSqls$1(conn, req);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void updateJdbcTableSchema(StructType incomingSchema, String tableName) {
        WriteStrategyType writeStrategyType = this.strategy().getEffectiveType();
        WriteStrategyType$SCD2$ writeStrategyType$SCD2$ = WriteStrategyType$SCD2$.MODULE$;
        boolean isSCD2 = !(writeStrategyType != null ? !((Object)writeStrategyType).equals(writeStrategyType$SCD2$) : writeStrategyType$SCD2$ != null);
        StructType incomingSchemaWithSCD2 = isSCD2 ? incomingSchema.add(new StructField((String)this.strategy().startTs().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$settings().appConfig().scd2StartTimestamp()), (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4())).add(new StructField((String)this.strategy().endTs().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$settings().appConfig().scd2EndTimestamp()), (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4())) : incomingSchema;
        Map<String, String> sinkConnectionRefOptions = this.sinkConnection().options();
        String jdbcUrl = (String)sinkConnectionRefOptions.apply((Object)"url");
        boolean targetTableExists = this.tableExists();
        JdbcDbUtils$.MODULE$.withJDBCConnection(sinkConnectionRefOptions, (Function1 & Serializable & scala.Serializable)conn -> {
            JdbcAutoTask.$anonfun$updateJdbcTableSchema$3(this, targetTableExists, sinkConnectionRefOptions, tableName, incomingSchemaWithSCD2, incomingSchema, jdbcUrl, conn);
            return BoxedUnit.UNIT;
        }, super.settings());
    }

    public static final /* synthetic */ boolean $anonfun$tableExists$1(JdbcAutoTask $this, Connection conn) {
        String url = (String)$this.sinkConnection().options().apply((Object)"url");
        boolean exists = JdbcDbUtils$.MODULE$.tableExists(conn, url, $this.fullTableName());
        return exists;
    }

    public static final /* synthetic */ boolean $anonfun$createAuditTable$1(JdbcAutoTask $this, Connection conn) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Table {} not found in {}", new Object[]{$this.super$taskDesc().table(), $this.super$taskDesc().domain()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String entry = (String)$this.super$taskDesc()._auditTableName().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(49).append("audit table for output ").append($this.super$taskDesc().table()).append(" is not defined in engine ").append($this.jdbcSinkEngineName()).toString());
        });
        String scriptTemplate = ((Settings.JdbcEngine.TableDdl)$this.jdbcSinkEngine().tables().apply((Object)entry)).createSql();
        JdbcDbUtils$.MODULE$.createSchema(conn, $this.fullDomainName());
        String script = Formatter$.MODULE$.RichFormatter(scriptTemplate).richFormat((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)$this.fullTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writeFormat"), (Object)$this.super$settings().appConfig().defaultWriteFormat())}))), (Map<String, Object>)Predef$.MODULE$.Map().empty(), $this.super$settings());
        JdbcDbUtils$.MODULE$.createSchema(conn, $this.fullDomainName());
        Try<Object> try_ = JdbcDbUtils$.MODULE$.executeUpdate(script, conn);
        if (try_ instanceof Success) {
            return true;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error(new StringBuilder(21).append("Error creating table ").append($this.fullTableName()).toString(), e);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw e;
        }
        throw new MatchError(try_);
    }

    public static final /* synthetic */ void $anonfun$runJDBC$6(JdbcAutoTask $this, String parsedPreActions$1, Connection conn) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SaveMode saveMode;
            BoxedUnit boxedUnit;
            conn.setAutoCommit(false);
            $this.runPreActions(conn, Formatter$.MODULE$.RichFormatter(parsedPreActions$1).splitSql(";"));
            $this.runSqls(conn, $this.preSql(), "Pre");
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Writing dataframe to {}", new Object[]{$this.fullTableName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            SaveMode saveMode2 = saveMode = $this.strategy().toWriteMode().toSaveMode();
            SaveMode saveMode3 = SaveMode.Overwrite;
            if (!(saveMode2 == null ? saveMode3 != null : !saveMode2.equals(saveMode3)) || $this.super$truncate()) {
                String jdbcUrl = (String)$this.sinkConnection().options().apply((Object)"url");
                JdbcDbUtils$.MODULE$.truncateTable(conn, $this.fullTableName());
                return;
            }
        });
        if (try_ instanceof Success) {
            conn.commit();
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            conn.rollback();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$runJDBC$10(JdbcAutoTask $this, String parsedPreActions$1, String mainSql$1, Connection conn) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            conn.setAutoCommit(false);
            $this.runPreActions(conn, Formatter$.MODULE$.RichFormatter(parsedPreActions$1).splitSql(";"));
            $this.runSqls(conn, $this.preSql(), "Pre");
            Formatter.RichFormatter qual$1 = Formatter$.MODULE$.RichFormatter(mainSql$1);
            String x$1 = qual$1.splitSql$default$1();
            List<String> finalSqls = qual$1.splitSql(x$1);
            $this.runSqls(conn, finalSqls, "Main");
        });
        if (try_ instanceof Success) {
            conn.commit();
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            conn.rollback();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$runJDBC$12(JdbcAutoTask $this, Connection conn) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Try<BoxedUnit> try_ = !$this.super$test() ? $this.applyJdbcAcl(conn, true) : BoxedUnit.UNIT;
            $this.runSqls(conn, $this.postSql(), "Post");
            $this.addSCD2Columns(conn, $this.sinkConnection().getJdbcEngineName());
        });
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            conn.rollback();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$runSqls$1(Connection conn$4, String req) {
        Try<Object> try_ = JdbcDbUtils$.MODULE$.executeUpdate(req, conn$4);
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError(try_);
    }

    public static final /* synthetic */ void $anonfun$updateJdbcTableSchema$3(JdbcAutoTask $this, boolean targetTableExists$1, Map sinkConnectionRefOptions$1, String tableName$1, StructType incomingSchemaWithSCD2$1, StructType incomingSchema$1, String jdbcUrl$1, Connection conn) {
        BoxedUnit boxedUnit;
        if (targetTableExists$1) {
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            Option<StructType> existingSchema = SparkUtils$.MODULE$.getSchemaOption(conn, (Map<String, String>)sinkConnectionRefOptions$1, tableName$1);
            StructType addedSchema = SparkUtils$.MODULE$.added(incomingSchemaWithSCD2$1, (StructType)existingSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> incomingSchema$1));
            StructType deletedSchema = SparkUtils$.MODULE$.dropped(incomingSchemaWithSCD2$1, (StructType)existingSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> incomingSchema$1));
            Seq<String> alterTableDropColumns = SparkUtils$.MODULE$.alterTableDropColumnsString(deletedSchema, tableName$1);
            if (alterTableDropColumns.nonEmpty()) {
                BoxedUnit boxedUnit4;
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info("alter table {} with {} columns to drop", new Object[]{tableName$1, BoxesRunTime.boxToInteger((int)alterTableDropColumns.size())});
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug("alter table {}", new Object[]{alterTableDropColumns.mkString("\n")});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            Seq<String> alterTableAddColumns = SparkUtils$.MODULE$.alterTableAddColumnsString(addedSchema, tableName$1, (Map<String, String>)Predef$.MODULE$.Map().empty());
            if (alterTableAddColumns.nonEmpty()) {
                BoxedUnit boxedUnit5;
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info("alter table {} with {} columns to add", new Object[]{tableName$1, BoxesRunTime.boxToInteger((int)alterTableAddColumns.size())});
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug("alter table {}", new Object[]{alterTableAddColumns.mkString("\n")});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            alterTableDropColumns.foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JdbcDbUtils$.MODULE$.executeAlterTable(x$3, conn)));
            alterTableAddColumns.foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JdbcDbUtils$.MODULE$.executeAlterTable(x$4, conn)));
            return;
        }
        JdbcOptionsInWrite optionsWrite = new JdbcOptionsInWrite(jdbcUrl$1, tableName$1, sinkConnectionRefOptions$1);
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Table {} not found, creating it with schema {}", new Object[]{tableName$1, incomingSchemaWithSCD2$1});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SparkUtils$.MODULE$.createTable(conn, tableName$1, incomingSchemaWithSCD2$1, false, optionsWrite, $this.attDdl(), $this.super$settings());
    }

    public JdbcAutoTask(Option<String> appId, AutoTaskDesc taskDesc, Map<String, String> commandParameters, Option<String> interactive, boolean truncate, boolean test, boolean logExecution, Option<String> accessToken, int resultPageSize, Settings settings, StorageHandler storageHandler, SchemaHandler schemaHandler) {
        this.accessToken = accessToken;
        this.storageHandler = storageHandler;
        this.schemaHandler = schemaHandler;
        super(appId, taskDesc, commandParameters, interactive, test, logExecution, truncate, resultPageSize, settings, storageHandler, schemaHandler);
    }
}

