/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.migration;

import ai.starlake.migration.PostMigrationAction;
import ai.starlake.schema.handlers.StorageHandler;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import org.apache.hadoop.fs.Path;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u000153AAB\u0004\u0001\u001d!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011!\u0011\u0004A!A!\u0002\u0017\u0019\u0004\"B\u001e\u0001\t\u0003a\u0004\"\u0002\"\u0001\t\u0003\u001a%\u0001\u0004*f]\u0006lWMR8mI\u0016\u0014(B\u0001\u0005\n\u0003%i\u0017n\u001a:bi&|gN\u0003\u0002\u000b\u0017\u0005A1\u000f^1sY\u0006\\WMC\u0001\r\u0003\t\t\u0017n\u0001\u0001\u0014\u0007\u0001yQ\u0003\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-]i\u0011aB\u0005\u00031\u001d\u00111\u0003U8ti6KwM]1uS>t\u0017i\u0019;j_:\faAZ8mI\u0016\u0014\bCA\u000e%\u001b\u0005a\"BA\u000f\u001f\u0003\t17O\u0003\u0002 A\u00051\u0001.\u00193p_BT!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO&\u0011Q\u0005\b\u0002\u0005!\u0006$\b.A\u0004oK^t\u0015-\\3\u0011\u0005!zcBA\u0015.!\tQ\u0013#D\u0001,\u0015\taS\"\u0001\u0004=e>|GOP\u0005\u0003]E\ta\u0001\u0015:fI\u00164\u0017B\u0001\u00192\u0005\u0019\u0019FO]5oO*\u0011a&E\u0001\u000fgR|'/Y4f\u0011\u0006tG\r\\3s!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0005iC:$G.\u001a:t\u0015\tA\u0014\"\u0001\u0004tG\",W.Y\u0005\u0003uU\u0012ab\u0015;pe\u0006<W\rS1oI2,'/\u0001\u0004=S:LGO\u0010\u000b\u0004{\u0001\u000bEC\u0001 @!\t1\u0002\u0001C\u00033\t\u0001\u000f1\u0007C\u0003\u001a\t\u0001\u0007!\u0004C\u0003'\t\u0001\u0007q%A\u0004qe>\u001cWm]:\u0015\u0003\u0011\u00032!\u0012%K\u001b\u00051%BA$\u0012\u0003\u0011)H/\u001b7\n\u0005%3%a\u0001+ssB\u0011\u0001cS\u0005\u0003\u0019F\u0011A!\u00168ji\u0002")
public class RenameFolder
implements PostMigrationAction {
    private final Path folder;
    private final String newName;
    private final StorageHandler storageHandler;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Try<BoxedUnit> process() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Renaming {} as {}", new Object[]{this.folder, this.newName});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Path targetPath = new Path(this.folder.getParent(), this.newName);
        if (this.storageHandler.exists(this.folder)) {
            BoxedUnit boxedUnit2;
            if (this.storageHandler.move(this.folder, targetPath)) {
                return new Success((Object)BoxedUnit.UNIT);
            }
            String errorMessage = new StringBuilder(17).append("Could not rename ").append(this.folder).toString();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(errorMessage);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return new Failure((Throwable)new RuntimeException(errorMessage));
        }
        if (!this.storageHandler.exists(targetPath)) {
            BoxedUnit boxedUnit3;
            String errorMessage = new StringBuilder(80).append(this.folder).append(" and its target ").append(targetPath).append(" don't exists. Problem may have occurs during migration process.").toString();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(errorMessage);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            return new Failure((Throwable)new RuntimeException(errorMessage));
        }
        return new Success((Object)BoxedUnit.UNIT);
    }

    public RenameFolder(Path folder, String newName, StorageHandler storageHandler) {
        this.folder = folder;
        this.newName = newName;
        this.storageHandler = storageHandler;
        StrictLogging.$init$((StrictLogging)this);
    }
}

