/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema;

import ai.starlake.config.Settings;
import ai.starlake.job.Cmd;
import ai.starlake.schema.ProjectCompare$;
import ai.starlake.schema.ProjectCompareConfig;
import ai.starlake.schema.ProjectCompareConfig$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.utils.CliConfig;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.JobResult$;
import ai.starlake.utils.Utils;
import ai.starlake.utils.Utils$;
import ai.starlake.workflow.IngestionWorkflow;
import better.files.File;
import better.files.File$;
import java.io.Serializable;
import org.fusesource.scalate.TemplateEngine;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scopt.OParser;
import scopt.OParser$;
import scopt.OParserBuilder;
import scopt.OParserSetup;
import scopt.Read$;

public final class ProjectCompareCmd$
implements Cmd<ProjectCompareConfig> {
    public static ProjectCompareCmd$ MODULE$;
    private final String command;
    private final OParser<BoxedUnit, ProjectCompareConfig> parser;
    private final String shell;
    private final TemplateEngine engine;
    private final OParserSetup setup;

    static {
        new ProjectCompareCmd$();
    }

    @Override
    public final Try<JobResult> run(Seq<String> args, SchemaHandler schemaHandler, Settings settings) {
        return Cmd.run$(this, args, schemaHandler, settings);
    }

    @Override
    public IngestionWorkflow workflow(SchemaHandler schemaHandler, Settings settings) {
        return Cmd.workflow$(this, schemaHandler, settings);
    }

    @Override
    public String usage() {
        return CliConfig.usage$(this);
    }

    @Override
    public String markdown(int pageIndex) {
        return CliConfig.markdown$(this, pageIndex);
    }

    @Override
    public String shell() {
        return this.shell;
    }

    @Override
    public void ai$starlake$job$Cmd$_setter_$shell_$eq(String x$1) {
        this.shell = x$1;
    }

    @Override
    public TemplateEngine engine() {
        return this.engine;
    }

    @Override
    public OParserSetup setup() {
        return this.setup;
    }

    @Override
    public void ai$starlake$utils$CliConfig$_setter_$engine_$eq(TemplateEngine x$1) {
        this.engine = x$1;
    }

    @Override
    public void ai$starlake$utils$CliConfig$_setter_$setup_$eq(OParserSetup x$1) {
        this.setup = x$1;
    }

    @Override
    public String command() {
        return this.command;
    }

    @Override
    public OParser<BoxedUnit, ProjectCompareConfig> parser() {
        return this.parser;
    }

    private void checkOnlyOneOf(String errorMessage, Seq<String> args) {
        if (args.count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ProjectCompareCmd$.$anonfun$checkOnlyOneOf$1(x$1))) != 1) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private String getCommitFromTag(String tag, String gitWorkTree) {
        Try<Utils.CommandOutput> commitOfTagOutput;
        String string;
        String string2 = tag;
        String string3 = "latest";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String[] latestTagCommand = (String[])((Object[])new String[]{"git", "-C", gitWorkTree, "describe", "--abbrev", "0"});
            Utils.CommandOutput latestTag = (Utils.CommandOutput)Utils$.MODULE$.runCommand((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])latestTagCommand), Utils$.MODULE$.runCommand$default$2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("latest tag not found!");
            });
            string = BoxedUnit.UNIT;
        } else {
            string = tag;
        }
        String tagName = string;
        String[] commitOfTagCommand = (String[])((Object[])new String[]{"git", "-C", gitWorkTree, "rev-list", "-n", "1", new StringBuilder(5).append("tags/").append((Object)tagName).toString()});
        Try<Utils.CommandOutput> try_ = commitOfTagOutput = Utils$.MODULE$.runCommand((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])commitOfTagCommand), Utils$.MODULE$.runCommand$default$2());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Utils.CommandOutput cmdOutput = (Utils.CommandOutput)success.value();
            return cmdOutput.output();
        }
        throw new IllegalArgumentException("Invalid tag");
    }

    private String getPathFromCommit(String commit, String gitWorkTree) {
        String x$1 = File$.MODULE$.newTemporaryDirectory$default$1();
        Option x$2 = File$.MODULE$.newTemporaryDirectory$default$2();
        Seq x$3 = File$.MODULE$.newTemporaryDirectory$default$3(x$1, x$2);
        String path = File$.MODULE$.newTemporaryDirectory(x$1, x$2, x$3).pathAsString();
        String[] checkoutCommand = (String[])((Object[])new String[]{"git", "-C", gitWorkTree, "--work-tree", path, "checkout", commit, "--", "."});
        Try<Utils.CommandOutput> checkoutOutput = Utils$.MODULE$.runCommand((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])checkoutCommand), Utils$.MODULE$.runCommand$default$2());
        Try<Utils.CommandOutput> try_ = checkoutOutput;
        if (try_ instanceof Success) {
            return path;
        }
        throw new IllegalArgumentException("Invalid commit");
    }

    private String getPathFromCommitOrTag(String gitWorkTree, String path, String commit, String tag) {
        if (path.isEmpty()) {
            String commitFromTag = commit.isEmpty() ? this.getCommitFromTag(tag, gitWorkTree) : commit;
            return this.getPathFromCommit(commitFromTag, gitWorkTree);
        }
        return path;
    }

    @Override
    public Option<ProjectCompareConfig> parse(Seq<String> args) {
        Option config2 = OParser$.MODULE$.parse(this.parser(), args, (Object)new ProjectCompareConfig(ProjectCompareConfig$.MODULE$.apply$default$1(), ProjectCompareConfig$.MODULE$.apply$default$2(), ProjectCompareConfig$.MODULE$.apply$default$3(), ProjectCompareConfig$.MODULE$.apply$default$4(), ProjectCompareConfig$.MODULE$.apply$default$5(), ProjectCompareConfig$.MODULE$.apply$default$6(), ProjectCompareConfig$.MODULE$.apply$default$7(), ProjectCompareConfig$.MODULE$.apply$default$8(), ProjectCompareConfig$.MODULE$.apply$default$9()), this.setup());
        config2.foreach((Function1 & Serializable & scala.Serializable)config -> {
            ProjectCompareCmd$.$anonfun$parse$1(config);
            return BoxedUnit.UNIT;
        });
        return config2;
    }

    private void cleanTempPath(String path) {
        File qual$1 = File$.MODULE$.apply(path, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$1 = qual$1.delete$default$1();
        Seq x$2 = qual$1.delete$default$2();
        qual$1.delete(x$1, x$2);
    }

    @Override
    public Try<JobResult> run(ProjectCompareConfig config, SchemaHandler schemaHandler, Settings settings) {
        Try result;
        block1: {
            String path1 = this.getPathFromCommitOrTag(config.gitWorkTree(), config.path1(), config.commit1(), config.tag1());
            String path2 = this.getPathFromCommitOrTag(config.gitWorkTree(), config.path2(), config.commit2(), config.tag2());
            ProjectCompareConfig configWithPaths = config.copy(path1, path2, config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9());
            result = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ProjectCompare$.MODULE$.compare(configWithPaths, settings)).map((Function1 & Serializable & scala.Serializable)x$2 -> JobResult$.MODULE$.empty());
            if (config.path1().isEmpty()) {
                this.cleanTempPath(path1);
            }
            if (!config.path2().isEmpty()) break block1;
            this.cleanTempPath(path2);
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$checkOnlyOneOf$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$parse$1(ProjectCompareConfig config) {
        if ((config.path1().isEmpty() || config.path2().isEmpty()) && config.gitWorkTree().isEmpty()) {
            throw new IllegalArgumentException("gitWorkTree is required");
        }
        MODULE$.checkOnlyOneOf("Only one of path1 or commit1 or tag1 is required", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{config.path1(), config.commit1(), config.tag1()}));
        MODULE$.checkOnlyOneOf("Only one of path2 or commit2 or tag2 is required", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{config.path2(), config.commit2(), config.tag2()}));
    }

    private ProjectCompareCmd$() {
        MODULE$ = this;
        CliConfig.$init$(this);
        Cmd.$init$(this);
        this.command = "compare";
        OParserBuilder builder = OParser$.MODULE$.builder();
        this.parser = OParser$.MODULE$.sequence(builder.programName(new StringBuilder(1).append(this.shell()).append(" ").append(this.command()).toString()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.shell(), this.command(), "[options]"})), builder.note(""), builder.opt("path1", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9())).optional().text("old version starlake project path"), builder.opt("path2", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            String x$1 = x;
            String x$2 = c.copy$default$1();
            String x$3 = c.copy$default$3();
            String x$4 = c.copy$default$4();
            String x$5 = c.copy$default$5();
            String x$6 = c.copy$default$6();
            String x$7 = c.copy$default$7();
            Option<String> x$8 = c.copy$default$8();
            Option<String> x$9 = c.copy$default$9();
            return c.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
        }).optional().text("new version starlake project path"), builder.opt("gitWorkTree", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            String x$10 = x;
            String x$11 = c.copy$default$1();
            String x$12 = c.copy$default$2();
            String x$13 = c.copy$default$4();
            String x$14 = c.copy$default$5();
            String x$15 = c.copy$default$6();
            String x$16 = c.copy$default$7();
            Option<String> x$17 = c.copy$default$8();
            Option<String> x$18 = c.copy$default$9();
            return c.copy(x$11, x$12, x$10, x$13, x$14, x$15, x$16, x$17, x$18);
        }).optional().text("local path to git project (only if path1 or path2 if empty)"), builder.opt("commit1", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            String x$19 = x;
            String x$20 = c.copy$default$1();
            String x$21 = c.copy$default$2();
            String x$22 = c.copy$default$3();
            String x$23 = c.copy$default$5();
            String x$24 = c.copy$default$6();
            String x$25 = c.copy$default$7();
            Option<String> x$26 = c.copy$default$8();
            Option<String> x$27 = c.copy$default$9();
            return c.copy(x$20, x$21, x$22, x$19, x$23, x$24, x$25, x$26, x$27);
        }).optional().text("old project commit id (SHA) - if path1 is empty"), builder.opt("commit2", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            String x$28 = x;
            String x$29 = c.copy$default$1();
            String x$30 = c.copy$default$2();
            String x$31 = c.copy$default$3();
            String x$32 = c.copy$default$4();
            String x$33 = c.copy$default$6();
            String x$34 = c.copy$default$7();
            Option<String> x$35 = c.copy$default$8();
            Option<String> x$36 = c.copy$default$9();
            return c.copy(x$29, x$30, x$31, x$32, x$28, x$33, x$34, x$35, x$36);
        }).optional().text("new project commit id (SHA) - if path2 is empty"), builder.opt("tag1", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            String x$37 = x;
            String x$38 = c.copy$default$1();
            String x$39 = c.copy$default$2();
            String x$40 = c.copy$default$3();
            String x$41 = c.copy$default$4();
            String x$42 = c.copy$default$5();
            String x$43 = c.copy$default$7();
            Option<String> x$44 = c.copy$default$8();
            Option<String> x$45 = c.copy$default$9();
            return c.copy(x$38, x$39, x$40, x$41, x$42, x$37, x$43, x$44, x$45);
        }).optional().text("old project git tag (latest for most recent tag) - if path1 and commit1 are empty"), builder.opt("tag2", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            String x$46 = x;
            String x$47 = c.copy$default$1();
            String x$48 = c.copy$default$2();
            String x$49 = c.copy$default$3();
            String x$50 = c.copy$default$4();
            String x$51 = c.copy$default$5();
            String x$52 = c.copy$default$6();
            Option<String> x$53 = c.copy$default$8();
            Option<String> x$54 = c.copy$default$9();
            return c.copy(x$47, x$48, x$49, x$50, x$51, x$52, x$46, x$53, x$54);
        }).optional().text("new project git tag (latest for most recent tag) - if path2 and commit1 are empty"), builder.opt("template", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            Some x$55 = new Some(x);
            String x$56 = c.copy$default$1();
            String x$57 = c.copy$default$2();
            String x$58 = c.copy$default$3();
            String x$59 = c.copy$default$4();
            String x$60 = c.copy$default$5();
            String x$61 = c.copy$default$6();
            String x$62 = c.copy$default$7();
            Option<String> x$63 = c.copy$default$9();
            return c.copy(x$56, x$57, x$58, x$59, x$60, x$61, x$62, (Option<String>)x$55, x$63);
        }).optional().text("SSP / Mustache Template path"), builder.opt("output", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            Some x$64 = new Some(x);
            String x$65 = c.copy$default$1();
            String x$66 = c.copy$default$2();
            String x$67 = c.copy$default$3();
            String x$68 = c.copy$default$4();
            String x$69 = c.copy$default$5();
            String x$70 = c.copy$default$6();
            String x$71 = c.copy$default$7();
            Option<String> x$72 = c.copy$default$8();
            return c.copy(x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, (Option<String>)x$64);
        }).optional().text("Output path")}));
    }
}

