/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.handlers;

import ai.starlake.config.Settings;
import ai.starlake.schema.handlers.FileInfo;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.utils.conversion.Conversions$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\ruc\u0001B\u001a5\u0001uB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t)\u0002\u0011\t\u0011)A\u0006+\")1\f\u0001C\u00019\")\u0011\r\u0001C\u0005E\")\u0001\u000e\u0001C\u0005S\")1\u000e\u0001C\u0005Y\")a\u000e\u0001C!_\"A\u0001\u000f\u0001EC\u0002\u0013\u0005\u0011\u000fC\u0004~\u0001\t\u0007I\u0011\u0001@\t\u000f\u0005=\u0001\u0001)A\u0005\u007f\"9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0001bBA\u0013\u0001\u0011%\u0011q\u0005\u0005\u000b\u0003W\u0001\u0001R1A\u0005\n\u00055\u0002bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003\u0007\u0002A\u0011AA\u0019\u0011%\t)\u0005\u0001b\u0001\n\u0013\t9\u0005\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA%\u0011\u001d\ty\u0005\u0001C\u0001\u0003/Bq!a\u0019\u0001\t\u0013\t)\u0007C\u0004\u0002|\u0001!\t!! \t\u0013\u0005M\u0005!%A\u0005\u0002\u0005U\u0005bBAV\u0001\u0011\u0005\u0011Q\u0016\u0005\n\u0003;\u0004\u0011\u0013!C\u0001\u0003?Dq!a9\u0001\t\u0003\n)\u000fC\u0004\u0002|\u0002!\t!!@\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012!9!1\u0005\u0001\u0005\u0002\t\u0015\u0002b\u0002B\u001e\u0001\u0011\u0005!Q\b\u0005\b\u0005\u000f\u0002A\u0011\u0001B%\u0011%\u0011)\tAI\u0001\n\u0003\u00119\tC\u0004\u0003\f\u0002!\tE!$\t\u000f\t]\u0005\u0001\"\u0001\u0003\u001a\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006b\u0002BT\u0001\u0011\u0005!\u0011\u0016\u0005\b\u0005[\u0003A\u0011\u0001BX\u0011\u001d\u00119\f\u0001C\u0001\u0005sCqAa0\u0001\t\u0003\u0011\t\rC\u0004\u0003H\u0002!\tA!3\t\u000f\t5\u0007\u0001\"\u0001\u0003P\"9!\u0011\u001c\u0001\u0005\u0002\tm\u0007b\u0002Bp\u0001\u0011\u0005!\u0011\u001d\u0005\b\u00077\u0001A\u0011AB\u000f\u0011\u001d\u0019I\u0003\u0001C\u0001\u0007WAqaa\f\u0001\t\u0003\u0019\t\u0004C\u0004\u00044\u0001!\ta!\u000e\t\u000f\r\u001d\u0003\u0001\"\u0011\u0004J!91q\n\u0001\u0005B\rEsaBB+i!\u00051q\u000b\u0004\u0007gQB\ta!\u0017\t\rm\u000bD\u0011AB.\u0005IAEMZ:Ti>\u0014\u0018mZ3IC:$G.\u001a:\u000b\u0005U2\u0014\u0001\u00035b]\u0012dWM]:\u000b\u0005]B\u0014AB:dQ\u0016l\u0017M\u0003\u0002:u\u0005A1\u000f^1sY\u0006\\WMC\u0001<\u0003\t\t\u0017n\u0001\u0001\u0014\u0007\u0001qD\t\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005I\u0001\u0004B]f\u0014VM\u001a\t\u0003\u000b\u001ak\u0011\u0001N\u0005\u0003\u000fR\u0012ab\u0015;pe\u0006<W\rS1oI2,'/\u0001\u0006gS2,7+_:uK6\u0004\"AS)\u000f\u0005-{\u0005C\u0001'A\u001b\u0005i%B\u0001(=\u0003\u0019a$o\\8u}%\u0011\u0001\u000bQ\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q\u0001\u0006A1/\u001a;uS:<7\u000f\u0005\u0002W36\tqK\u0003\u0002Yq\u000511m\u001c8gS\u001eL!AW,\u0003\u0011M+G\u000f^5oON\fa\u0001P5oSRtDCA/a)\tqv\f\u0005\u0002F\u0001!)Ak\u0001a\u0002+\")\u0001j\u0001a\u0001\u0013\u0006\u0001Bn\\1e\u000f\u000e\u0003V\t\u001f;sC\u000e{gN\u001a\u000b\u0003G\u001a\u0004BA\u00133J\u0013&\u0011Qm\u0015\u0002\u0004\u001b\u0006\u0004\b\"B4\u0005\u0001\u0004\u0019\u0017!E2p]:,7\r^5p]>\u0003H/[8og\u0006\u0011Bn\\1e\u0003j,(/Z#yiJ\f7i\u001c8g)\t\u0019'\u000eC\u0003h\u000b\u0001\u00071-A\bm_\u0006$7kM#yiJ\f7i\u001c8g)\t\u0019W\u000eC\u0003h\r\u0001\u00071-A\u0007m_\u0006$W\t\u001f;sC\u000e{gN\u001a\u000b\u0002G\u0006!1m\u001c8g+\u0005\u0011\bCA:|\u001b\u0005!(B\u00019v\u0015\t1x/\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003qf\fa!\u00199bG\",'\"\u0001>\u0002\u0007=\u0014x-\u0003\u0002}i\ni1i\u001c8gS\u001e,(/\u0019;j_:\f1bR\"T+JL'+Z4FqV\tq\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u00115\fGo\u00195j]\u001eT1!!\u0003A\u0003\u0011)H/\u001b7\n\t\u00055\u00111\u0001\u0002\u0006%\u0016<W\r_\u0001\r\u000f\u000e\u001bVK]5SK\u001e,\u0005\u0010I\u0001!Kb$(/Y2TG\",W.Z!oI\n+8m[3u\u0003:$g)\u001b7f!\u0006$\b\u000e\u0006\u0003\u0002\u0016\u0005\u0005\u0002cB \u0002\u0018%\u000bY\"S\u0005\u0004\u00033\u0001%A\u0002+va2,7\u0007\u0005\u0003@\u0003;I\u0015bAA\u0010\u0001\n1q\n\u001d;j_:Da!a\t\f\u0001\u0004I\u0015aA;sS\u0006!bn\u001c:nC2L'0\u001a3GS2,7+_:uK6$2!SA\u0015\u0011\u0015AE\u00021\u0001J\u0003m!WMZ1vYRtuN]7bY&TX\r\u001a$jY\u0016\u001c\u0016p\u001d;f[V\t\u0011*A\fm_\u000e\\\u0017iY9vSNLG/[8o!>dG\u000eV5nKV\u0011\u00111\u0007\t\u0005\u0003k\ty$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003!!WO]1uS>t'bAA\u001f\u0001\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u0005\u0013q\u0007\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003MawnY6SK\u001a\u0014Xm\u001d5Q_2dG+[7f\u0003%!WMZ1vYR45+\u0006\u0002\u0002JA!\u00111JA)\u001b\t\tiEC\u0002\u0002PU\f!AZ:\n\t\u0005M\u0013Q\n\u0002\u000b\r&dWmU=ti\u0016l\u0017A\u00033fM\u0006,H\u000e\u001e$TAQ!\u0011\u0011JA-\u0011\u001d\tYF\u0005a\u0001\u0003;\n\u0011\"\u001b8qkR\u0004\u0016\r\u001e5\u0011\t\u0005-\u0013qL\u0005\u0005\u0003C\niE\u0001\u0003QCRD\u0017aD4fi>+H\u000f];u'R\u0014X-Y7\u0015\t\u0005\u001d\u0014q\u000f\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003\tIwN\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\u0011\t)(a\u001b\u0003\u0019=+H\u000f];u'R\u0014X-Y7\t\u000f\u0005e4\u00031\u0001\u0002^\u0005!\u0001/\u0019;i\u0003\u0011\u0011X-\u00193\u0015\u000b%\u000by(!!\t\u000f\u0005eD\u00031\u0001\u0002^!I\u00111\u0011\u000b\u0011\u0002\u0003\u0007\u0011QQ\u0001\bG\"\f'o]3u!\u0011\t9)a$\u000e\u0005\u0005%%\u0002BAB\u0003\u0017SA!!$\u0002p\u0005\u0019a.[8\n\t\u0005E\u0015\u0011\u0012\u0002\b\u0007\"\f'o]3u\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uII*\"!a&+\t\u0005\u0015\u0015\u0011T\u0016\u0003\u00037\u0003B!!(\u0002(6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0015!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0006}%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q!/Z1e\u0003:$W\t_3dkR,W\u0003BAX\u0003o#b!!-\u0002Z\u0006mG\u0003BAZ\u0003\u0013\u0004B!!.\u000282\u0001AaBA]-\t\u0007\u00111\u0018\u0002\u0002)F!\u0011QXAb!\ry\u0014qX\u0005\u0004\u0003\u0003\u0004%a\u0002(pi\"Lgn\u001a\t\u0004\u007f\u0005\u0015\u0017bAAd\u0001\n\u0019\u0011I\\=\t\u000f\u0005-g\u00031\u0001\u0002N\u00061\u0011m\u0019;j_:\u0004raPAh\u0003'\f\u0019,C\u0002\u0002R\u0002\u0013\u0011BR;oGRLwN\\\u0019\u0011\t\u0005%\u0014Q[\u0005\u0005\u0003/\fYGA\tJ]B,Ho\u0015;sK\u0006l'+Z1eKJDq!!\u001f\u0017\u0001\u0004\ti\u0006C\u0005\u0002\u0004Z\u0001\n\u00111\u0001\u0002\u0006\u0006A\"/Z1e\u0003:$W\t_3dkR,G\u0005Z3gCVdG\u000f\n\u001a\u0016\t\u0005U\u0015\u0011\u001d\u0003\b\u0003s;\"\u0019AA^\u0003A\u0011X-\u00193B]\u0012,\u00050Z2vi\u0016L5+\u0006\u0003\u0002h\u00065H\u0003BAu\u0003s$B!a;\u0002pB!\u0011QWAw\t\u001d\tI\f\u0007b\u0001\u0003wCq!a3\u0019\u0001\u0004\t\t\u0010E\u0004@\u0003\u001f\f\u00190a;\u0011\t\u0005%\u0014Q_\u0005\u0005\u0003o\fYGA\u0006J]B,Ho\u0015;sK\u0006l\u0007bBA=1\u0001\u0007\u0011QL\u0001\u0006oJLG/\u001a\u000b\u0007\u0003\u007f\u0014IA!\u0004\u0015\t\t\u0005!q\u0001\t\u0004\u007f\t\r\u0011b\u0001B\u0003\u0001\n!QK\\5u\u0011%\t\u0019)\u0007I\u0001\u0002\b\t)\t\u0003\u0004\u0003\fe\u0001\r!S\u0001\u0005I\u0006$\u0018\rC\u0004\u0002ze\u0001\r!!\u0018\u0002\u0017]\u0014\u0018\u000e^3CS:\f'/\u001f\u000b\u0007\u0005\u0003\u0011\u0019B!\t\t\u000f\t-!\u00041\u0001\u0003\u0016A)qHa\u0006\u0003\u001c%\u0019!\u0011\u0004!\u0003\u000b\u0005\u0013(/Y=\u0011\u0007}\u0012i\"C\u0002\u0003 \u0001\u0013AAQ=uK\"9\u0011\u0011\u0010\u000eA\u0002\u0005u\u0013a\u00047jgR$\u0015N]3di>\u0014\u0018.Z:\u0015\t\t\u001d\"\u0011\b\t\u0007\u0005S\u0011\u0019$!\u0018\u000f\t\t-\"q\u0006\b\u0004\u0019\n5\u0012\"A!\n\u0007\tE\u0002)A\u0004qC\u000e\\\u0017mZ3\n\t\tU\"q\u0007\u0002\u0005\u0019&\u001cHOC\u0002\u00032\u0001Cq!!\u001f\u001c\u0001\u0004\ti&\u0001\u0003ti\u0006$H\u0003\u0002B \u0005\u000b\u00022!\u0012B!\u0013\r\u0011\u0019\u0005\u000e\u0002\t\r&dW-\u00138g_\"9\u0011\u0011\u0010\u000fA\u0002\u0005u\u0013\u0001\u00027jgR$bBa\u0013\u0003N\t=#1\u000bB2\u0005[\u0012\t\t\u0005\u0004\u0003*\tM\"q\b\u0005\b\u0003sj\u0002\u0019AA/\u0011!\u0011\t&\bI\u0001\u0002\u0004I\u0015!C3yi\u0016t7/[8o\u0011%\u0011)&\bI\u0001\u0002\u0004\u00119&A\u0003tS:\u001cW\r\u0005\u0003\u0003Z\t}SB\u0001B.\u0015\u0011\u0011i&a\u001c\u0002\tQLW.Z\u0005\u0005\u0005C\u0012YFA\u0007M_\u000e\fG\u000eR1uKRKW.\u001a\u0005\b\u0005Kj\u0002\u0019\u0001B4\u0003%\u0011XmY;sg&4X\rE\u0002@\u0005SJ1Aa\u001bA\u0005\u001d\u0011un\u001c7fC:D\u0011Ba\u001c\u001e!\u0003\u0005\rA!\u001d\u0002\u000f\u0015D8\r\\;eKB)q(!\b\u0003tA!!Q\u000fB?\u001b\t\u00119H\u0003\u0003\u0003z\tm\u0014!\u0002:fO\u0016D(\u0002BA\u0005\u0003_JAAa \u0003x\t9\u0001+\u0019;uKJt\u0007\"\u0003BB;A\u0005\t\u0019\u0001B4\u0003)\u0019xN\u001d;Cs:\u000bW.Z\u0001\u000fY&\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011II\u000b\u0003\u0003h\u0005e\u0015\u0001B2paf$bAa\u001a\u0003\u0010\nM\u0005b\u0002BI?\u0001\u0007\u0011QL\u0001\u0004gJ\u001c\u0007b\u0002BK?\u0001\u0007\u0011QL\u0001\u0004IN$\u0018\u0001B7pm\u0016$bAa\u001a\u0003\u001c\nu\u0005b\u0002BIA\u0001\u0007\u0011Q\f\u0005\b\u0005?\u0003\u0003\u0019AA/\u0003\u0011!Wm\u001d;\u0002\r\u0011,G.\u001a;f)\u0011\u00119G!*\t\u000f\u0005e\u0014\u00051\u0001\u0002^\u00051Qn\u001b3jeN$BAa\u001a\u0003,\"9\u0011\u0011\u0010\u0012A\u0002\u0005u\u0013!D2paf4%o\\7M_\u000e\fG\u000e\u0006\u0004\u0003\u0002\tE&Q\u0017\u0005\b\u0005g\u001b\u0003\u0019AA/\u0003\u0019\u0019x.\u001e:dK\"9!qT\u0012A\u0002\u0005u\u0013aC2paf$v\u000eT8dC2$bA!\u0001\u0003<\nu\u0006b\u0002BZI\u0001\u0007\u0011Q\f\u0005\b\u0005?#\u0003\u0019AA/\u00035iwN^3Ge>lGj\\2bYR1!\u0011\u0001Bb\u0005\u000bDqAa-&\u0001\u0004\ti\u0006C\u0004\u0003 \u0016\u0002\r!!\u0018\u0002\r\u0015D\u0018n\u001d;t)\u0011\u00119Ga3\t\u000f\u0005ed\u00051\u0001\u0002^\u0005I!\r\\8dWNK'0\u001a\u000b\u0005\u0005#\u00149\u000eE\u0002@\u0005'L1A!6A\u0005\u0011auN\\4\t\u000f\u0005et\u00051\u0001\u0002^\u0005i1\u000f]1dK\u000e{gn];nK\u0012$BA!5\u0003^\"9\u0011\u0011\u0010\u0015A\u0002\u0005u\u0013\u0001\u00047bgRlu\u000eZ5gS\u0016$G\u0003\u0002Br\u00073\u0001BA!:\u0004\u00149!!q]B\u0007\u001d\u0011\u0011Ioa\u0002\u000f\t\t-8\u0011\u0001\b\u0005\u0005[\u0014YP\u0004\u0003\u0003p\n]h\u0002\u0002By\u0005kt1\u0001\u0014Bz\u0013\u0005Q\u0018B\u0001=z\u0013\r\u0011Ip^\u0001\u0006gB\f'o[\u0005\u0005\u0005{\u0014y0A\u0002tc2T1A!?x\u0013\u0011\u0019\u0019a!\u0002\u0002\u0013\u0015DXmY;uS>t'\u0002\u0002B\u007f\u0005\u007fLAa!\u0003\u0004\f\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0005\u0007\u0007\u0019)!\u0003\u0003\u0004\u0010\rE\u0011\u0001\u0005$jY\u0016\u001cFO]3b[N{WO]2f\u0015\u0011\u0019Iaa\u0003\n\t\rU1q\u0003\u0002\n)&lWm\u001d;b[BTAaa\u0004\u0004\u0012!9\u0011\u0011P\u0015A\u0002\u0005u\u0013A\u0002;pk\u000eD'\u0010\u0006\u0003\u0004 \r\u001d\u0002CBB\u0011\u0007G\u0011\t!\u0004\u0002\u0002\b%!1QEA\u0004\u0005\r!&/\u001f\u0005\b\u0003sR\u0003\u0019AA/\u0003\u0015!x.^2i)\u0011\u0019yb!\f\t\u000f\u0005e4\u00061\u0001\u0002^\u0005Iq-\u001a;TG\",W.\u001a\u000b\u0002\u0013\u0006I1m\u001c9z\u001b\u0016\u0014x-\u001a\u000b\u000b\u0005O\u001a9da\u000f\u0004@\r\r\u0003bBB\u001d[\u0001\u0007\u00111D\u0001\u0007Q\u0016\fG-\u001a:\t\u000f\ruR\u00061\u0001\u0002^\u000511O]2ESJDqa!\u0011.\u0001\u0004\ti&A\u0004egR4\u0015\u000e\\3\t\u000f\r\u0015S\u00061\u0001\u0003h\u0005aA-\u001a7fi\u0016\u001cv.\u001e:dK\u0006!q\u000e]3o)\u0011\u0019Ye!\u0014\u0011\u000b}\ni\"a=\t\u000f\u0005ed\u00061\u0001\u0002^\u00051q.\u001e;qkR$B!a\u001a\u0004T!9\u0011\u0011P\u0018A\u0002\u0005u\u0013A\u0005%eMN\u001cFo\u001c:bO\u0016D\u0015M\u001c3mKJ\u0004\"!R\u0019\u0014\u0005ErDCAB,\u0001")
public class HdfsStorageHandler
implements StorageHandler {
    private Configuration conf;
    private String defaultNormalizedFileSystem;
    private String fileSystem;
    private final Settings settings;
    private final Regex GCSUriRegEx;
    private final FileSystem defaultFS;
    private final boolean starApiIsActive;
    private Map<String, String> extraConf;
    private final Logger logger;
    private volatile byte bitmap$0;

    @Override
    public void pathSecurityCheck(Path path) {
        StorageHandler.pathSecurityCheck$(this, path);
    }

    @Override
    public Option<Path> moveSparkPartFile(Path sparkFolder, String extension) {
        return StorageHandler.moveSparkPartFile$(this, sparkFolder, extension);
    }

    @Override
    public Charset write$default$3(String data, Path path) {
        return StorageHandler.write$default$3$(this, data, path);
    }

    @Override
    public String list$default$2() {
        return StorageHandler.list$default$2$(this);
    }

    @Override
    public LocalDateTime list$default$3() {
        return StorageHandler.list$default$3$(this);
    }

    @Override
    public Option<Pattern> list$default$5() {
        return StorageHandler.list$default$5$(this);
    }

    @Override
    public boolean starApiIsActive() {
        return this.starApiIsActive;
    }

    private Map<String, String> extraConf$lzycompute() {
        HdfsStorageHandler hdfsStorageHandler = this;
        synchronized (hdfsStorageHandler) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.extraConf = StorageHandler.extraConf$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.extraConf;
    }

    @Override
    public Map<String, String> extraConf() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.extraConf$lzycompute();
        }
        return this.extraConf;
    }

    @Override
    public void ai$starlake$schema$handlers$StorageHandler$_setter_$starApiIsActive_$eq(boolean x$1) {
        this.starApiIsActive = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Map<String, String> loadGCPExtraConf(Map<String, String> connectionOptions) {
        Map map;
        String authType;
        String string;
        String bucket = (String)connectionOptions.getOrElse((Object)"gcsBucket", (Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("bucket attribute is required for Google Storage");
        });
        int index = bucket.indexOf("://");
        String bucketName = index > 0 ? bucket.substring(index + 3) : bucket;
        Option option = connectionOptions.get((Object)"temporaryGcsBucket");
        if (option instanceof Some) {
            Some some = (Some)option;
            String tempBucket = (String)some.value();
            int index2 = tempBucket.indexOf("://");
            string = index2 > 0 ? tempBucket.substring(index2 + 3) : tempBucket;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(146).append("temporaryGcsBucket is not set, using ").append(bucket).append(" as temporary bucket. ").append("Please set temporaryGcsBucket to a different bucket if you want to use a different one.").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            string = bucketName;
        } else {
            throw new MatchError((Object)option);
        }
        String tempBucketName = string;
        String string2 = authType = (String)connectionOptions.getOrElse((Object)"authType", (Function0 & Serializable & scala.Serializable)() -> "APPLICATION_DEFAULT");
        if ("APPLICATION_DEFAULT".equals(string2)) {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"google.cloud.auth.type"), (Object)"APPLICATION_DEFAULT")}));
        } else if ("SERVICE_ACCOUNT_JSON_KEYFILE".equals(string2)) {
            String jsonKeyfile = (String)connectionOptions.getOrElse((Object)"jsonKeyfile", (Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception("jsonKeyfile attribute is required for SERVICE_ACCOUNT_JSON_KEYFILE");
            });
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"google.cloud.auth.type"), (Object)"SERVICE_ACCOUNT_JSON_KEYFILE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"google.cloud.auth.service.account.enable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"google.cloud.auth.service.account.json.keyfile"), (Object)jsonKeyfile)}));
        } else if ("USER_CREDENTIALS".equals(string2)) {
            String clientId = (String)connectionOptions.getOrElse((Object)"clientId", (Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception("clientId attribute is required for USER_CREDENTIALS");
            });
            String clientSecret = (String)connectionOptions.getOrElse((Object)"clientSecret", (Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception("clientSecret attribute is required for USER_CREDENTIALS");
            });
            String refreshToken = (String)connectionOptions.getOrElse((Object)"refreshToken", (Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception("refreshToken attribute is required for USER_CREDENTIALS");
            });
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"google.cloud.auth.type"), (Object)"USER_CREDENTIALS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"google.cloud.auth.service.account.enable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"google.cloud.auth.client.id"), (Object)clientId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"google.cloud.auth.client.secret"), (Object)clientSecret), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"google.cloud.auth.refresh.token"), (Object)refreshToken)}));
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        Map authConf = map;
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.defaultFS"), (Object)bucket), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"temporaryGcsBucket"), (Object)tempBucketName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.AbstractFileSystem.gs.impl"), (Object)"com.google.cloud.hadoop.fs.gcs.GoogleHadoopFS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.gs.impl"), (Object)"com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem")}))).$plus$plus((GenTraversableOnce)authConf);
    }

    private Map<String, String> loadAzureExtraConf(Map<String, String> connectionOptions) {
        String azureStorageContainer = (String)connectionOptions.getOrElse((Object)"azureStorageContainer", (Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("azureStorageContainer attribute is required for Azure Storage");
        });
        String azureStorageAccount = (String)connectionOptions.getOrElse((Object)"azureStorageAccount", (Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("azureStorageAccount attribute is required for Azure Storage");
        });
        String azureStorageKey = (String)connectionOptions.getOrElse((Object)"azureStorageKey", (Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("azureStorageKey attribute is required for Azure Storage");
        });
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.defaultFS"), (Object)azureStorageContainer), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(49).append("fs.azure.account.auth.type.").append(azureStorageAccount).append(".blob.core.windows.net").toString()), (Object)"SharedKey"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(43).append("fs.azure.account.key.").append(azureStorageAccount).append(".blob.core.windows.net").toString()), (Object)azureStorageKey)}));
    }

    private Map<String, String> loadS3ExtraConf(Map<String, String> connectionOptions) {
        throw new Exception("S3 credentials Not yet released");
    }

    @Override
    public Map<String, String> loadExtraConf() {
        if (this.settings.appConfig().fileSystem().startsWith("file:")) {
            return Predef$.MODULE$.Map().empty();
        }
        Map options = (Map)this.settings.appConfig().connections().get((Object)this.settings.appConfig().connectionRef()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.options()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        if (options.contains((Object)"gcsBucket")) {
            return this.loadGCPExtraConf((Map<String, String>)options);
        }
        if (options.contains((Object)"s3Bucket")) {
            return this.loadS3ExtraConf((Map<String, String>)options);
        }
        if (options.contains((Object)"azureStorageContainer")) {
            return this.loadAzureExtraConf((Map<String, String>)options);
        }
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * WARNING - void declaration
     */
    private Configuration conf$lzycompute() {
        HdfsStorageHandler hdfsStorageHandler = this;
        synchronized (hdfsStorageHandler) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                Configuration conf = new Configuration();
                this.extraConf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    HdfsStorageHandler.$anonfun$conf$1(conf, x0$1);
                    return BoxedUnit.UNIT;
                });
                package$.MODULE$.env().get((Object)"SL_STORAGE_CONF").foreach((Function1 & Serializable & scala.Serializable)value -> {
                    HdfsStorageHandler.$anonfun$conf$2(conf, value);
                    return BoxedUnit.UNIT;
                });
                this.settings.appConfig().hadoop().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    HdfsStorageHandler.$anonfun$conf$5(conf, x0$3);
                    return BoxedUnit.UNIT;
                });
                this.conf = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.conf;
    }

    public Configuration conf() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.conf$lzycompute();
        }
        return this.conf;
    }

    public Regex GCSUriRegEx() {
        return this.GCSUriRegEx;
    }

    private Tuple3<String, Option<String>, String> extracSchemeAndBucketAndFilePath(String uri) {
        Option option;
        String string = uri;
        Option option2 = this.GCSUriRegEx().unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(3) == 0) {
            String string2 = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String filePath = (String)((LinearSeqOptimized)option2.get()).apply(2);
            if ("file".equals(string2)) {
                return new Tuple3((Object)"file", (Object)None$.MODULE$, (Object)new StringBuilder(1).append("/").append(filePath).toString());
            }
        }
        if (!(option = this.GCSUriRegEx().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
            String scheme = (String)((LinearSeqOptimized)option.get()).apply(0);
            String bucketName = (String)((LinearSeqOptimized)option.get()).apply(1);
            String filePath = (String)((LinearSeqOptimized)option.get()).apply(2);
            return new Tuple3((Object)scheme, (Object)new Some((Object)bucketName), (Object)filePath);
        }
        return new Tuple3((Object)this.defaultFS().getScheme(), (Object)None$.MODULE$, (Object)uri);
    }

    private String normalizedFileSystem(String fileSystem) {
        if (fileSystem.endsWith(":")) {
            return new StringBuilder(3).append(fileSystem).append("///").toString();
        }
        if (!fileSystem.endsWith("://") && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(fileSystem)).last()) == '/') {
            return (String)new StringOps(Predef$.MODULE$.augmentString(fileSystem)).dropRight(1);
        }
        if (fileSystem.endsWith("://")) {
            return new StringBuilder(2).append(fileSystem).append("/.").toString();
        }
        return fileSystem;
    }

    private String defaultNormalizedFileSystem$lzycompute() {
        HdfsStorageHandler hdfsStorageHandler = this;
        synchronized (hdfsStorageHandler) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.defaultNormalizedFileSystem = this.normalizedFileSystem(this.fileSystem);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.fileSystem = null;
        return this.defaultNormalizedFileSystem;
    }

    private String defaultNormalizedFileSystem() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.defaultNormalizedFileSystem$lzycompute();
        }
        return this.defaultNormalizedFileSystem;
    }

    @Override
    public FiniteDuration lockAcquisitionPollTime() {
        return this.settings.appConfig().lock().pollTime();
    }

    @Override
    public FiniteDuration lockRefreshPollTime() {
        return this.settings.appConfig().lock().refreshTime();
    }

    private FileSystem defaultFS() {
        return this.defaultFS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public FileSystem fs(Path inputPath) {
        FileSystem fileSystem;
        block5: {
            Path path = new StringOps(Predef$.MODULE$.augmentString(inputPath.toString())).contains((Object)BoxesRunTime.boxToCharacter((char)':')) ? inputPath : new Path(this.settings.appConfig().fileSystem(), inputPath.toString());
            Tuple3<String, Option<String>, String> tuple3 = this.extracSchemeAndBucketAndFilePath(path.toString());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String scheme = (String)tuple3._1();
            Option bucketOpt = (Option)tuple3._2();
            Tuple2 tuple2 = new Tuple2((Object)scheme, (Object)bucketOpt);
            String scheme2 = (String)tuple2._1();
            Option bucketOpt2 = (Option)tuple2._2();
            String string = scheme2;
            if ("gs".equals(string) ? true : ("s3".equals(string) ? true : ("s3a".equals(string) ? true : "s3n".equals(string)))) {
                Option option = bucketOpt2;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String bucket = (String)some.value();
                    this.conf().set("fs.defaultFS", this.normalizedFileSystem(new StringBuilder(3).append(scheme2).append("://").append(bucket).toString()));
                    fileSystem = FileSystem.get((Configuration)this.conf());
                    break block5;
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new RuntimeException("Using gs/s3 scheme must be with a bucket name. gs://bucketName");
                    }
                    throw new MatchError((Object)option);
                }
            }
            fileSystem = this.defaultFS();
        }
        FileSystem fs = fileSystem;
        fs.setWriteChecksum(false);
        return fs;
    }

    private OutputStream getOutputStream(Path path) {
        FileSystem currentFS = this.fs(path);
        currentFS.delete(path, false);
        FSDataOutputStream outputStream = currentFS.create(path);
        return outputStream;
    }

    @Override
    public String read(Path path, Charset charset) {
        this.pathSecurityCheck(path);
        return (String)this.readAndExecute(path, charset, (Function1 & Serializable & scala.Serializable)is -> org.apache.commons.io.IOUtils.toString((Reader)is));
    }

    @Override
    public Charset read$default$2() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public <T> T readAndExecute(Path path, Charset charset, Function1<InputStreamReader, T> action) {
        return this.readAndExecuteIS(path, (Function1 & Serializable & scala.Serializable)is -> {
            FileSystem currentFS = this.fs(path);
            CompressionCodecFactory factory = new CompressionCodecFactory(currentFS.getConf());
            InputStream decompressedIS = (InputStream)Option$.MODULE$.apply((Object)factory.getCodec(path)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.createInputStream(is)).getOrElse((Function0 & Serializable & scala.Serializable)() -> is);
            return action.apply((Object)new InputStreamReader(decompressedIS, charset));
        });
    }

    @Override
    public <T> Charset readAndExecute$default$2() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public <T> T readAndExecuteIS(Path path, Function1<InputStream, T> action) {
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        return (T)Using$.MODULE$.resource((Object)currentFS.open(path), action, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Override
    public void write(String data, Path path, Charset charset) {
        this.pathSecurityCheck(path);
        FSDataOutputStream os = (FSDataOutputStream)this.getOutputStream(path);
        os.write(data.getBytes(charset));
        os.close();
    }

    @Override
    public void writeBinary(byte[] data, Path path) {
        this.pathSecurityCheck(path);
        OutputStream os = this.getOutputStream(path);
        os.write(data, 0, data.length);
        os.close();
    }

    @Override
    public List<Path> listDirectories(Path path) {
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])currentFS.listStatus(path))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDirectory())))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).toList();
    }

    @Override
    public FileInfo stat(Path path) {
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        FileStatus fileStatus = currentFS.getFileStatus(path);
        return new FileInfo(path, fileStatus.getLen(), Instant.ofEpochMilli(fileStatus.getModificationTime()));
    }

    @Override
    public List<FileInfo> list(Path path, String extension, LocalDateTime since, boolean recursive, Option<Pattern> exclude, boolean sortByName) {
        BoxedUnit boxedUnit;
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("list({}, {}, {})", new Object[]{path, extension, since});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (this.exists(path)) {
                BoxedUnit boxedUnit;
                RemoteIterator iterator = currentFS.listFiles(path, recursive);
                List files = Conversions$.MODULE$.convertToScalaIterator(iterator).filter((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$list$2(this, exclude, since, extension, status))).toList();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Found {} files", new Object[]{BoxesRunTime.boxToInteger((int)files.size())});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                List sorted = sortByName ? (List)files.sortBy((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getPath().getName(), (Ordering)Ordering.String$.MODULE$) : (List)files.sortBy((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)BoxesRunTime.boxToLong((long)r.getModificationTime()), (Object)r.getPath().getName()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.String$.MODULE$));
                return (List)sorted.map((Function1 & Serializable & scala.Serializable)status -> new FileInfo(status.getPath(), status.getLen(), Instant.ofEpochMilli(status.getModificationTime())), List$.MODULE$.canBuildFrom());
            }
            return Nil$.MODULE$;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List list = (List)success.value();
            return list;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(16).append("Ignoring folder ").append(path).toString(), e);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return Nil$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public boolean list$default$6() {
        return false;
    }

    @Override
    public boolean copy(Path src, Path dst) {
        this.pathSecurityCheck(src);
        this.pathSecurityCheck(dst);
        return FileUtil.copy((FileSystem)this.fs(src), (Path)src, (FileSystem)this.fs(dst), (Path)dst, (boolean)false, (Configuration)this.conf());
    }

    @Override
    public boolean move(Path src, Path dest) {
        this.pathSecurityCheck(src);
        FileSystem currentFS = this.fs(src);
        this.delete(dest);
        this.mkdirs(dest.getParent());
        return currentFS.rename(src, dest);
    }

    @Override
    public boolean delete(Path path) {
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        return currentFS.delete(path, true);
    }

    @Override
    public boolean mkdirs(Path path) {
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        return currentFS.mkdirs(path);
    }

    @Override
    public void copyFromLocal(Path source, Path dest) {
        this.pathSecurityCheck(source);
        this.pathSecurityCheck(dest);
        FileSystem currentFS = this.fs(source);
        currentFS.copyFromLocalFile(source, dest);
    }

    @Override
    public void copyToLocal(Path source, Path dest) {
        this.pathSecurityCheck(source);
        this.pathSecurityCheck(dest);
        FileSystem currentFS = this.fs(source);
        currentFS.copyToLocalFile(source, dest);
    }

    @Override
    public void moveFromLocal(Path source, Path dest) {
        this.pathSecurityCheck(source);
        this.pathSecurityCheck(dest);
        FileSystem currentFS = this.fs(source);
        String string = currentFS.getScheme();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            currentFS.moveFromLocalFile(source, dest);
            return;
        }
        this.move(source, dest);
    }

    @Override
    public boolean exists(Path path) {
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        return currentFS.exists(path);
    }

    @Override
    public long blockSize(Path path) {
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        return currentFS.getDefaultBlockSize(path);
    }

    @Override
    public long spaceConsumed(Path path) {
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        return currentFS.getContentSummary(path).getSpaceConsumed();
    }

    @Override
    public long lastModified(Path path) {
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        return currentFS.getFileStatus(path).getModificationTime();
    }

    @Override
    public Try<BoxedUnit> touchz(Path path) {
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> currentFS.create(path, false).close());
    }

    @Override
    public Try<BoxedUnit> touch(Path path) {
        this.pathSecurityCheck(path);
        FileSystem currentFS = this.fs(path);
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> currentFS.setTimes(path, System.currentTimeMillis(), -1L));
    }

    @Override
    public String getScheme() {
        return this.defaultFS().getScheme();
    }

    @Override
    public boolean copyMerge(Option<String> header2, Path srcDir, Path dstFile, boolean deleteSource) {
        FileSystem currentFS = this.fs(dstFile);
        if (currentFS.exists(dstFile)) {
            throw new IOException(new StringBuilder(22).append("Target ").append(dstFile).append(" already exists").toString());
        }
        if (currentFS.getFileStatus(srcDir).isDirectory()) {
            Object object;
            Path[] parts = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])currentFS.listStatus(srcDir))).filter((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)status.isFile())))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).nonEmpty() || header2.nonEmpty()) {
                header2.foreach((Function1 & Serializable & scala.Serializable)header -> {
                    HdfsStorageHandler.$anonfun$copyMerge$3(this, outputStream, header);
                    return BoxedUnit.UNIT;
                });
                try (FSDataOutputStream outputStream = currentFS.create(dstFile);){
                    object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).filter((Function1 & Serializable & scala.Serializable)part -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$copyMerge$4(part))))).sortBy((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getName(), (Ordering)Ordering.String$.MODULE$))).collect((PartialFunction)new scala.Serializable(this, currentFS, outputStream, deleteSource){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ HdfsStorageHandler $outer;
                        private final FileSystem currentFS$4;
                        private final FSDataOutputStream outputStream$1;
                        private final boolean deleteSource$1;

                        public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            try (FSDataInputStream inputStream = this.currentFS$4.open(A1);){
                                IOUtils.copyBytes((InputStream)inputStream, (OutputStream)this.outputStream$1, (Configuration)this.$outer.conf(), (boolean)false);
                                object = this.deleteSource$1 ? BoxesRunTime.boxToBoolean((boolean)this.$outer.delete(A1)) : BoxedUnit.UNIT;
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Path x1) {
                            Path path = x1;
                            return true;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.currentFS$4 = currentFS$4;
                            this.outputStream$1 = outputStream$1;
                            this.deleteSource$1 = deleteSource$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.AnyVal()));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            return true;
        }
        return false;
    }

    @Override
    public Option<InputStream> open(Path path) {
        this.pathSecurityCheck(path);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.fs(path).open(path));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            FSDataInputStream is = (FSDataInputStream)success.value();
            return new Some((Object)is);
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable f = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(f.getMessage());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public OutputStream output(Path path) {
        return this.getOutputStream(path);
    }

    public static final /* synthetic */ void $anonfun$conf$1(Configuration conf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            conf$1.set(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$conf$4(Configuration conf$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            conf$1.set(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$conf$2(Configuration conf$1, String value) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(value)).split(','))).map((Function1 & Serializable & scala.Serializable)x -> {
            String[] t = new StringOps(Predef$.MODULE$.augmentString(x)).split('=');
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t[0].trim()), (Object)t[1].trim());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            HdfsStorageHandler.$anonfun$conf$4(conf$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$conf$5(Configuration conf$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            conf$1.set(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$list$3(LocatedFileStatus status$1, Pattern x$6) {
        return x$6.matcher(status$1.getPath().getName()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$list$2(HdfsStorageHandler $this, Option exclude$1, LocalDateTime since$1, String extension$1, LocatedFileStatus status) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("found file={}", new Object[]{status});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        LocalDateTime time = LocalDateTime.ofInstant(Instant.ofEpochMilli(status.getModificationTime()), ZoneId.systemDefault());
        boolean excludeFile = exclude$1.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$list$3(status, x$6)));
        return !excludeFile && time.isAfter(since$1) && status.getPath().getName().endsWith(extension$1);
    }

    public static final /* synthetic */ void $anonfun$copyMerge$3(HdfsStorageHandler $this, FSDataOutputStream outputStream$1, String header) {
        String headerWithNL = header.endsWith("\n") ? header : new StringBuilder(1).append(header).append("\n").toString();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(headerWithNL.getBytes());){
            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream$1, (Configuration)$this.conf(), (boolean)false);
        }
    }

    public static final /* synthetic */ boolean $anonfun$copyMerge$4(Path part) {
        return part.getName().startsWith("part-");
    }

    public HdfsStorageHandler(String fileSystem, Settings settings) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        this.fileSystem = fileSystem;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        StorageHandler.$init$(this);
        this.GCSUriRegEx = new StringOps(Predef$.MODULE$.augmentString("(.*)://(.*?)/(.*)")).r();
        this.conf().set("fs.defaultFS", this.defaultNormalizedFileSystem());
        this.defaultFS = FileSystem.get((Configuration)this.conf());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(10).append("defaultFS=").append(this.defaultFS()).toString());
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(27).append("defaultFS.getHomeDirectory=").append(this.defaultFS().getHomeDirectory()).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(17).append("defaultFS.getUri=").append(this.defaultFS().getUri()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

