/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.handlers;

import ai.starlake.config.Settings;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AllSinks;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Attribute$;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Domain$;
import ai.starlake.schema.model.ExpectationItem;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Format$DSV$;
import ai.starlake.schema.model.Format$JSON_FLAT$;
import ai.starlake.schema.model.Format$POSITION$;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.Metadata$;
import ai.starlake.schema.model.MetricType;
import ai.starlake.schema.model.Position;
import ai.starlake.schema.model.PrimitiveType$;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Schema$;
import ai.starlake.schema.model.TransformInput;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.WriteStrategy;
import ai.starlake.utils.YamlSerde$;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class InferSchemaHandler$ {
    public static InferSchemaHandler$ MODULE$;
    private final Pattern datePattern;
    private final Regex identifierRegex;

    static {
        new InferSchemaHandler$();
    }

    public Pattern datePattern() {
        return this.datePattern;
    }

    public boolean parseIsoInstant(String str) {
        boolean bl;
        try {
            ZonedDateTime.parse(str, DateTimeFormatter.ISO_DATE_TIME);
            bl = true;
        }
        catch (DateTimeParseException e) {
            bl = false;
        }
        return bl;
    }

    public Regex identifierRegex() {
        return this.identifierRegex;
    }

    public List<Attribute> createAttributes(List<Row> lines, StructType schema, Format format, boolean forcePattern) {
        return this.createAttribute$1(lines, (DataType)schema, new StructField("_ROOT_", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), "", forcePattern, format).attributes();
    }

    public boolean createAttributes$default$4() {
        return true;
    }

    public Metadata createMetaData(Format format, Option<Object> array, Option<Object> withHeader, Option<String> separator, Option<Map<String, String>> options) {
        Some x$1 = new Some((Object)format);
        None$ x$2 = None$.MODULE$;
        None$ x$3 = None$.MODULE$;
        None$ x$4 = array.contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? array : None$.MODULE$;
        Option<Object> x$5 = withHeader;
        Option<String> x$6 = separator;
        Option<Map<String, String>> x$7 = options;
        Option<String> x$8 = Metadata$.MODULE$.apply$default$7();
        Option<String> x$9 = Metadata$.MODULE$.apply$default$8();
        Option<AllSinks> x$10 = Metadata$.MODULE$.apply$default$9();
        Option<String> x$11 = Metadata$.MODULE$.apply$default$10();
        Option<String> x$12 = Metadata$.MODULE$.apply$default$11();
        Option<String> x$13 = Metadata$.MODULE$.apply$default$12();
        Option<String> x$14 = Metadata$.MODULE$.apply$default$14();
        Option<Object> x$15 = Metadata$.MODULE$.apply$default$15();
        Option<String> x$16 = Metadata$.MODULE$.apply$default$16();
        Option<Freshness> x$17 = Metadata$.MODULE$.apply$default$17();
        Option<String> x$18 = Metadata$.MODULE$.apply$default$18();
        boolean x$19 = Metadata$.MODULE$.apply$default$19();
        Option<String> x$20 = Metadata$.MODULE$.apply$default$20();
        Option<WriteStrategy> x$21 = Metadata$.MODULE$.apply$default$21();
        return new Metadata((Option<Format>)x$1, (Option<String>)x$2, (Option<Object>)x$3, (Option<Object>)x$4, x$5, x$6, x$8, x$9, x$10, x$11, x$12, x$13, x$7, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
    }

    public Option<Object> createMetaData$default$2() {
        return None$.MODULE$;
    }

    public Option<Object> createMetaData$default$3() {
        return None$.MODULE$;
    }

    public Option<String> createMetaData$default$4() {
        return None$.MODULE$;
    }

    public Option<Map<String, String>> createMetaData$default$5() {
        return None$.MODULE$;
    }

    public Schema createSchema(String name, Pattern pattern, Option<String> comment, List<Attribute> attributes, Option<Metadata> metadata, Option<String> sample) {
        String x$1 = name;
        Pattern x$2 = pattern;
        List<Attribute> x$3 = attributes;
        Option<Metadata> x$4 = metadata;
        Option<String> x$5 = comment;
        Option<String> x$6 = sample;
        List<String> x$7 = Schema$.MODULE$.apply$default$6();
        List<String> x$8 = Schema$.MODULE$.apply$default$7();
        Set<String> x$9 = Schema$.MODULE$.apply$default$8();
        List<RowLevelSecurity> x$10 = Schema$.MODULE$.apply$default$9();
        List<ExpectationItem> x$11 = Schema$.MODULE$.apply$default$10();
        List<String> x$12 = Schema$.MODULE$.apply$default$11();
        List<AccessControlEntry> x$13 = Schema$.MODULE$.apply$default$12();
        Option<String> x$14 = Schema$.MODULE$.apply$default$13();
        Option<String> x$15 = Schema$.MODULE$.apply$default$15();
        Option<String> x$16 = Schema$.MODULE$.apply$default$16();
        return new Schema(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$6, x$15, x$16);
    }

    public Domain createDomain(String name, Option<Metadata> metadata, List<Schema> schemas) {
        return new Domain(name, metadata, schemas, Domain$.MODULE$.apply$default$4(), Domain$.MODULE$.apply$default$5(), Domain$.MODULE$.apply$default$6(), Domain$.MODULE$.apply$default$7());
    }

    public Option<Metadata> createDomain$default$2() {
        return None$.MODULE$;
    }

    public List<Schema> createDomain$default$3() {
        return Nil$.MODULE$;
    }

    public Try<Path> generateYaml(Domain domain, String saveDir, boolean clean, Settings settings) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Schema table;
            Path tablePath;
            StorageHandler storageHandler = settings.storageHandler(settings.storageHandler$default$1());
            Path domainFolder = new Path(saveDir, domain.name());
            storageHandler.mkdirs(domainFolder);
            Path configPath = new Path(domainFolder, "_config.sl.yml");
            if (!storageHandler.exists(configPath)) {
                Nil$ x$1 = Nil$.MODULE$;
                String x$2 = domain.copy$default$1();
                Option<Metadata> x$3 = domain.copy$default$2();
                Option<String> x$4 = domain.copy$default$4();
                Set<String> x$5 = domain.copy$default$5();
                Option<String> x$6 = domain.copy$default$6();
                Option<String> x$7 = domain.copy$default$7();
                YamlSerde$.MODULE$.serializeToPath(configPath, domain.copy(x$2, x$3, (List<Schema>)x$1, x$4, x$5, x$6, x$7), storageHandler);
            }
            if (storageHandler.exists(tablePath = new Path(domainFolder, new StringBuilder(7).append((table = (Schema)domain.tables().head()).name()).append(".sl.yml").toString())) && !clean) {
                throw new Exception(new StringBuilder(47).append("Could not write table ").append(((Schema)domain.tables().head()).name()).append(" already defined in file ").append(tablePath).toString());
            }
            YamlSerde$.MODULE$.serializeToPath(tablePath, table, storageHandler);
            return tablePath;
        });
    }

    public static final /* synthetic */ boolean $anonfun$createAttributes$9(String v) {
        return MODULE$.datePattern().matcher(v).matches();
    }

    public static final /* synthetic */ boolean $anonfun$createAttributes$12(String v) {
        return MODULE$.datePattern().matcher(v).matches();
    }

    private final Attribute createAttribute$1(List currentLines, DataType currentSchema, StructField container, String fieldPath, boolean forcePattern, Format format$1) {
        Attribute result;
        Attribute attribute;
        DataType dataType = currentSchema;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Seq schemaWithIndex = (Seq)structType.zipWithIndex(Seq$.MODULE$.canBuildFrom());
            List attributes = ((TraversableOnce)schemaWithIndex.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    List structLines = (List)((List)currentLines.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x$1)), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Object object = x0$2;
                        if (object instanceof Row) {
                            Row row = (Row)object;
                            return row.get(index);
                        }
                        throw new RuntimeException(new StringBuilder(68).append("Encountered ").append(object.getClass().getName()).append(" for field path ").append(fieldPath).append(" but expected a Row instead for a Struct").toString());
                    }, List$.MODULE$.canBuildFrom());
                    return this.createAttribute$1(structLines, structType.apply(index).dataType(), field, new StringBuilder(1).append(fieldPath).append(".").append(field.name()).toString(), forcePattern, format$1);
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).toList();
            String x$1 = container.name();
            String x$22 = structType.typeName();
            None$ x$32 = !container.nullable() ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)) : None$.MODULE$;
            Some x$4 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
            List x$52 = attributes;
            None$ x$6 = None$.MODULE$;
            Option<TransformInput> x$72 = Attribute$.MODULE$.apply$default$5();
            Option<String> x$82 = Attribute$.MODULE$.apply$default$6();
            Option<String> x$9 = Attribute$.MODULE$.apply$default$7();
            Option<MetricType> x$10 = Attribute$.MODULE$.apply$default$8();
            Option<Position> x$11 = Attribute$.MODULE$.apply$default$10();
            Option<String> x$12 = Attribute$.MODULE$.apply$default$11();
            Set<String> x$13 = Attribute$.MODULE$.apply$default$12();
            Option<Trim> x$14 = Attribute$.MODULE$.apply$default$13();
            Option<String> x$15 = Attribute$.MODULE$.apply$default$14();
            Option<String> x$16 = Attribute$.MODULE$.apply$default$15();
            Option<Object> x$17 = Attribute$.MODULE$.apply$default$16();
            Option<String> x$18 = Attribute$.MODULE$.apply$default$17();
            attribute = new Attribute(x$1, x$22, (Option<Object>)x$4, (Option<Object>)x$32, x$72, x$82, x$9, x$10, (List<Attribute>)x$52, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, (Option<String>)x$6);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType dataType2 = arrayType.elementType();
            if (dataType2 instanceof ArrayType) {
                throw new RuntimeException(new StringBuilder(62).append("Starlake doesn't support array of array. Rejecting field path ").append(fieldPath).toString());
            }
            List arrayLines = (List)((List)currentLines.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x$2)), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Object object = x0$3;
                if (object instanceof GenSeq) {
                    GenSeq genSeq = (GenSeq)object;
                    return genSeq;
                }
                throw new RuntimeException(new StringBuilder(70).append("Expecting an array to be contained into a Seq for field path ").append(fieldPath).append(" and not ").append(object.getClass().getName()).toString());
            }, List$.MODULE$.canBuildFrom());
            Attribute stAttributes = this.createAttribute$1(arrayLines, arrayType.elementType(), container, new StringBuilder(2).append(fieldPath).append("[]").toString(), forcePattern, format$1);
            Some x$19 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
            None$ x$20 = !container.nullable() ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)) : None$.MODULE$;
            None$ x$21 = None$.MODULE$;
            String x$22 = stAttributes.copy$default$1();
            String x$23 = stAttributes.copy$default$2();
            Option<TransformInput> x$24 = stAttributes.copy$default$5();
            Option<String> x$25 = stAttributes.copy$default$6();
            Option<String> x$26 = stAttributes.copy$default$7();
            Option<MetricType> x$27 = stAttributes.copy$default$8();
            List<Attribute> x$28 = stAttributes.copy$default$9();
            Option<Position> x$29 = stAttributes.copy$default$10();
            Option<String> x$30 = stAttributes.copy$default$11();
            Set<String> x$31 = stAttributes.copy$default$12();
            Option<Trim> x$32 = stAttributes.copy$default$13();
            Option<String> x$33 = stAttributes.copy$default$14();
            Option<String> x$34 = stAttributes.copy$default$15();
            Option<Object> x$35 = stAttributes.copy$default$16();
            Option<String> x$36 = stAttributes.copy$default$17();
            attribute = stAttributes.copy(x$22, x$23, (Option<Object>)x$19, (Option<Object>)x$20, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, (Option<String>)x$21);
        } else {
            List timestamps;
            List timestampCandidates;
            String string = currentSchema.typeName();
            String string2 = "string".equals(string) ? ((timestampCandidates = (List)currentLines.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x$3).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString())), List$.MODULE$.canBuildFrom())).isEmpty() ? "string" : (timestampCandidates.forall((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)InferSchemaHandler$.MODULE$.parseIsoInstant(v))) ? "iso_date_time" : (timestampCandidates.forall((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)InferSchemaHandler$.$anonfun$createAttributes$9(v))) ? "date" : "string"))) : ("timestamp".equals(string) && ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Format[]{Format$DSV$.MODULE$, Format$POSITION$.MODULE$, Format$JSON_FLAT$.MODULE$}))).contains((Object)format$1) ? ((timestamps = (List)currentLines.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x$5).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString())), List$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)InferSchemaHandler$.$anonfun$createAttributes$12(v))) ? "date" : (timestamps.forall((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)InferSchemaHandler$.MODULE$.parseIsoInstant(v))) ? "iso_date_time" : "timestamp")) : PrimitiveType$.MODULE$.from(currentSchema).value());
            String cellType = string2;
            String x$37 = container.name();
            String x$38 = cellType;
            Some x$39 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
            None$ x$40 = !container.nullable() ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)) : None$.MODULE$;
            Option x$41 = ((TraversableLike)currentLines.map((Function1 & Serializable & scala.Serializable)x$7 -> Option$.MODULE$.apply(x$7), List$.MODULE$.canBuildFrom())).headOption().flatten(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toString());
            Option<TransformInput> x$42 = Attribute$.MODULE$.apply$default$5();
            Option<String> x$43 = Attribute$.MODULE$.apply$default$6();
            Option<String> x$44 = Attribute$.MODULE$.apply$default$7();
            Option<MetricType> x$45 = Attribute$.MODULE$.apply$default$8();
            List<Attribute> x$46 = Attribute$.MODULE$.apply$default$9();
            Option<Position> x$47 = Attribute$.MODULE$.apply$default$10();
            Option<String> x$48 = Attribute$.MODULE$.apply$default$11();
            Set<String> x$49 = Attribute$.MODULE$.apply$default$12();
            Option<Trim> x$50 = Attribute$.MODULE$.apply$default$13();
            Option<String> x$51 = Attribute$.MODULE$.apply$default$14();
            Option<String> x$52 = Attribute$.MODULE$.apply$default$15();
            Option<Object> x$53 = Attribute$.MODULE$.apply$default$16();
            Option<String> x$54 = Attribute$.MODULE$.apply$default$17();
            attribute = result = new Attribute(x$37, x$38, (Option<Object>)x$39, (Option<Object>)x$40, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, (Option<String>)x$41);
        }
        if (!forcePattern || this.identifierRegex().pattern().matcher(result.name()).matches()) {
            return result;
        }
        throw new RuntimeException(new StringBuilder(115).append("Invalid field name ->").append(result.name()).append("<-. Only letters, digits and '_' are allowed. Other characters including spaces are forbidden.").toString());
    }

    private static final boolean createAttribute$default$5$1() {
        return true;
    }

    private InferSchemaHandler$() {
        MODULE$ = this;
        this.datePattern = new StringOps(Predef$.MODULE$.augmentString("[0-9]{4}-[0-9]{2}-[0-9]{2}")).r().pattern();
        this.identifierRegex = new StringOps(Predef$.MODULE$.augmentString("^([a-zA-Z_][a-zA-Z\\d_]*)$")).r();
    }
}

