/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.model;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.schema.handlers.FileInfo;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AnyRefDiff$;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.DomainDiff;
import ai.starlake.schema.model.ListDiff;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.Named;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Schema$;
import ai.starlake.schema.model.Severity$Warning$;
import ai.starlake.schema.model.TableDiff;
import ai.starlake.schema.model.TablesDiff;
import ai.starlake.schema.model.ValidationMessage;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple7;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

public final class Domain$
implements scala.Serializable {
    public static Domain$ MODULE$;

    static {
        new Domain$();
    }

    public Option<Metadata> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    public List<Schema> $lessinit$greater$default$3() {
        return Nil$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Set<String> $lessinit$greater$default$5() {
        return Predef$.MODULE$.Set().empty();
    }

    public Option<String> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public List<Either<List<ValidationMessage>, Object>> checkFilenamesValidity(StorageHandler storage, Settings settings) {
        List<Path> domainRootDirectories;
        boolean x$6;
        LocalDateTime x$5;
        Path x$1 = DatasetArea$.MODULE$.load(settings);
        boolean x$2 = false;
        None$ x$3 = None$.MODULE$;
        String x$4 = storage.list$default$2();
        List<FileInfo> domainRootFiles = storage.list(x$1, x$4, x$5 = storage.list$default$3(), x$2, (Option<Pattern>)x$3, x$6 = storage.list$default$6());
        List diff = (List)domainRootFiles.diff(domainRootDirectories = storage.listDirectories(DatasetArea$.MODULE$.load(settings)));
        .colon.colon extraFileWarnings = diff.nonEmpty() ? new .colon.colon((Object)package$.MODULE$.Left().apply((Object)new .colon.colon((Object)new ValidationMessage(Severity$Warning$.MODULE$, "Domain", new StringBuilder(61).append("Domain root directory should only contain directories. Found ").append(diff.mkString(",")).toString()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$) : new .colon.colon((Object)package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$);
        List allWarnings = (List)domainRootDirectories.flatMap(arg_0 -> Domain$.$anonfun$checkFilenamesValidity$1(storage, (List)extraFileWarnings, arg_0), List$.MODULE$.canBuildFrom());
        return allWarnings;
    }

    public Try<DomainDiff> compare(Domain existing, Domain incoming) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Tuple3<List<Schema>, List<Schema>, List<Schema>> tuple3 = AnyRefDiff$.MODULE$.partitionNamed(existing.tables(), incoming.tables());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            List addedTables = (List)tuple3._1();
            List deletedTables = (List)tuple3._2();
            List existingCommonTables = (List)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)addedTables, (Object)deletedTables, (Object)existingCommonTables);
            List addedTables2 = (List)tuple32._1();
            List deletedTables2 = (List)tuple32._2();
            List existingCommonTables2 = (List)tuple32._3();
            List commonTables = (List)existingCommonTables2.map((Function1 & Serializable & scala.Serializable)table -> new Tuple2(table, incoming.tables().find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)Domain$.$anonfun$compare$3(table, x$13))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception("Should not happen");
            })), List$.MODULE$.canBuildFrom());
            List updatedTablesDiff = (List)commonTables.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Schema existingTable = (Schema)tuple2._1();
                    Schema incomingTable = (Schema)tuple2._2();
                    return Option$.MODULE$.option2Iterable(Schema$.MODULE$.compare(existingTable, incomingTable).toOption());
                }
                throw new MatchError((Object)tuple2);
            }, List$.MODULE$.canBuildFrom());
            ListDiff<Named> metadataDiff = AnyRefDiff$.MODULE$.diffOptionAnyRef("metadata", existing.metadata(), incoming.metadata());
            ListDiff<String> commentDiff = AnyRefDiff$.MODULE$.diffOptionString("comment", existing.comment(), incoming.comment());
            ListDiff<String> tagsDiffs = AnyRefDiff$.MODULE$.diffSetString("tags", existing.tags(), incoming.tags());
            ListDiff<String> renameDiff = AnyRefDiff$.MODULE$.diffOptionString("rename", existing.rename(), incoming.rename());
            ListDiff<String> databaseDiff = AnyRefDiff$.MODULE$.diffOptionString("database", existing.database(), incoming.database());
            return new DomainDiff(existing.name(), new TablesDiff((List<String>)((List)addedTables2.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.name(), List$.MODULE$.canBuildFrom())), (List<String>)((List)deletedTables2.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name(), List$.MODULE$.canBuildFrom())), (List<TableDiff>)updatedTablesDiff), metadataDiff.asOption(), commentDiff.asOption(), tagsDiffs.asOption(), renameDiff.asOption(), databaseDiff.asOption());
        });
    }

    public Tuple2<Path, String> ddlExtract(String datawarehouse, String ddlType, Settings settings) {
        Path path;
        Path rootPath = new Path(new Path(DatasetArea$.MODULE$.extract(settings), "ddl"), datawarehouse);
        Path mustache = new Path(rootPath, new StringBuilder(9).append(ddlType).append(".mustache").toString());
        Path ssp = new Path(rootPath, new StringBuilder(4).append(ddlType).append(".ssp").toString());
        if (settings.storageHandler(settings.storageHandler$default$1()).exists(mustache)) {
            path = mustache;
        } else if (settings.storageHandler(settings.storageHandler$default$1()).exists(ssp)) {
            path = ssp;
        } else {
            throw new Exception(new StringBuilder(41).append("No ").append(ddlType).append(".mustache/ssp found for datawarehouse ").append(datawarehouse).toString());
        }
        Path template = path;
        StorageHandler qual$1 = settings.storageHandler(settings.storageHandler$default$1());
        Path x$1 = template;
        Charset x$2 = qual$1.read$default$2();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)template), (Object)qual$1.read(x$1, x$2));
    }

    public Domain apply(String name, Option<Metadata> metadata, List<Schema> tables, Option<String> comment, Set<String> tags, Option<String> rename, Option<String> database) {
        return new Domain(name, metadata, tables, comment, tags, rename, database);
    }

    public Option<Metadata> apply$default$2() {
        return None$.MODULE$;
    }

    public List<Schema> apply$default$3() {
        return Nil$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Set<String> apply$default$5() {
        return Predef$.MODULE$.Set().empty();
    }

    public Option<String> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$7() {
        return None$.MODULE$;
    }

    public Option<Tuple7<String, Option<Metadata>, List<Schema>, Option<String>, Set<String>, Option<String>, Option<String>>> unapply(Domain x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)x$0.name(), x$0.metadata(), x$0.tables(), x$0.comment(), x$0.tags(), x$0.rename(), x$0.database()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ List $anonfun$checkFilenamesValidity$1(StorageHandler storage$2, List extraFileWarnings$1, Path domainDirectory) {
        String domainName = domainDirectory.getName();
        String expectedDomainYmlName = "_config.sl.yml";
        Path expectedDomainYmlPath = new Path(domainDirectory, expectedDomainYmlName);
        boolean domainYmlExists = storage$2.exists(expectedDomainYmlPath);
        Nil$ domainYmlWarnings = domainYmlExists ? Nil$.MODULE$ : new .colon.colon((Object)package$.MODULE$.Left().apply((Object)new .colon.colon((Object)new ValidationMessage(Severity$Warning$.MODULE$, "Domain", new StringBuilder(57).append("Domain directory for ").append(domainName).append(" does not have a _config.sl.yml file").toString()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$);
        return (List)new .colon.colon((Object)extraFileWarnings$1, (List)new .colon.colon((Object)domainYmlWarnings, (List)Nil$.MODULE$)).flatten((Function1)Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$compare$3(Schema table$4, Schema x$13) {
        String string = x$13.name().toLowerCase();
        String string2 = table$4.name().toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Domain$() {
        MODULE$ = this;
    }
}

