/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.model;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.config.Settings$;
import ai.starlake.schema.handlers.FileInfo;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.EnvDesc;
import ai.starlake.schema.model.Severity$Error$;
import ai.starlake.schema.model.ValidationMessage;
import ai.starlake.utils.YamlSerde$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class EnvDesc$
implements StrictLogging,
scala.Serializable {
    public static EnvDesc$ MODULE$;
    private final Logger logger;

    static {
        new EnvDesc$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public EnvDesc apply(Map<String, String> env) {
        return new EnvDesc(Settings$.MODULE$.latestSchemaVersion(), env);
    }

    public Option<EnvDesc> loadEnv(Path path, StorageHandler storageHandler) {
        BoxedUnit boxedUnit;
        if (storageHandler.exists(path)) {
            Option envDesc2 = Option$.MODULE$.apply((Object)YamlSerde$.MODULE$.deserializeYamlEnvConfig(storageHandler.read(path, storageHandler.read$default$2()), path.toString()));
            return envDesc2.map((Function1 & Serializable & scala.Serializable)envDesc -> {
                if (!envDesc.env().contains((Object)"_updated")) {
                    Map x$1 = envDesc.env().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_updated"), (Object)LocalDateTime.now().toString()));
                    int x$2 = envDesc.copy$default$1();
                    return envDesc.copy(x$2, (Map<String, String>)x$1);
                }
                return envDesc;
            });
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Env file {} not found", new Object[]{path});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return None$.MODULE$;
    }

    public List<ValidationMessage> checkValidity(StorageHandler storageHandler, Settings settings) {
        ObjectRef errors = ObjectRef.create((Object)List$.MODULE$.empty());
        Path defaultEnvPath = DatasetArea$.MODULE$.env(settings);
        Map defaultEnv = (Map)this.loadEnv(defaultEnvPath, storageHandler).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.env()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        Path x$1 = DatasetArea$.MODULE$.metadata(settings);
        String x$2 = ".sl.yml";
        boolean x$3 = false;
        LocalDateTime x$4 = storageHandler.list$default$3();
        Option<Pattern> x$5 = storageHandler.list$default$5();
        boolean x$6 = storageHandler.list$default$6();
        List allSpecificEnvs = (List)((List)storageHandler.list(x$1, x$2, x$4, x$3, x$5, x$6).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)EnvDesc$.$anonfun$checkValidity$3(file)))).flatMap((Function1 & Serializable & scala.Serializable)file -> {
            Path path = file.path();
            Option<EnvDesc> env = MODULE$.loadEnv(path, storageHandler);
            return Option$.MODULE$.option2Iterable(env.map((Function1 & Serializable & scala.Serializable)e -> new Tuple2((Object)path, e.env())));
        }, List$.MODULE$.canBuildFrom());
        int specificEnvVarsCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)allSpecificEnvs.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)EnvDesc$.$anonfun$checkValidity$6(x0$1)), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (defaultEnv.isEmpty() && specificEnvVarsCount > 0) {
            String allSpecificFilenames = ((TraversableOnce)allSpecificEnvs.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    return path.getName();
                }
                throw new MatchError((Object)tuple2);
            }, List$.MODULE$.canBuildFrom())).mkString(", ");
            errors.elem = (List)((List)errors.elem).$colon$plus((Object)new ValidationMessage(Severity$Error$.MODULE$, "Env", new StringBuilder(95).append("Found Env specific ").append(allSpecificFilenames).append(". You cannot have env specific variables without the default env.sl.yml file").toString()), List$.MODULE$.canBuildFrom());
        }
        allSpecificEnvs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            EnvDesc$.$anonfun$checkValidity$8(defaultEnv, errors, x0$3);
            return BoxedUnit.UNIT;
        });
        return (List)errors.elem;
    }

    public EnvDesc apply(int version, Map<String, String> env) {
        return new EnvDesc(version, env);
    }

    public Option<Tuple2<Object, Map<String, String>>> unapply(EnvDesc x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)x$0.version()), x$0.env()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkValidity$3(FileInfo file) {
        String filename = file.path().getName();
        if (!filename.startsWith("env.")) return false;
        String string = filename;
        String string2 = "env.sl.yml";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static final /* synthetic */ int $anonfun$checkValidity$6(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Map vars = (Map)tuple2._2();
            return vars.size();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$checkValidity$8(Map defaultEnv$1, ObjectRef errors$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Path path = (Path)tuple2._1();
            Map vars = (Map)tuple2._2();
            Set envVarsWithNoDefault = (Set)vars.keys().toSet().$minus$minus((GenTraversableOnce)defaultEnv$1.keys().toSet());
            if (envVarsWithNoDefault.nonEmpty()) {
                errors$1.elem = (List)((List)errors$1.elem).$colon$plus((Object)new ValidationMessage(Severity$Error$.MODULE$, "Env", new StringBuilder(50).append("Specific env file ").append(path.getName()).append(" has variables with no default: ").append(envVarsWithNoDefault.mkString(", ")).toString()), List$.MODULE$.canBuildFrom());
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private EnvDesc$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

