/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.serve;

import ai.starlake.config.Settings;
import ai.starlake.serve.CaffeineSettingsManager$;
import ai.starlake.serve.Response;
import ai.starlake.serve.SingleUserRequestHandler;
import ai.starlake.serve.SingleUserServices$;
import ai.starlake.utils.Utils$;
import buildinfo.BuildInfo$;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.servlet.ServletHandler;
import scala.Console$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class SingleUserMainServer$ {
    public static SingleUserMainServer$ MODULE$;
    private final ObjectMapper mapper;
    private boolean autoReload;

    static {
        new SingleUserMainServer$();
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public Try<BoxedUnit> serve(String host, int port) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Server server = new Server(new InetSocketAddress(host, port));
            ServletHandler handler = new ServletHandler();
            server.setHandler((Handler)handler);
            handler.addServletWithMapping(SingleUserRequestHandler.class, "/");
            server.start();
            Predef$.MODULE$.println((Object)new StringBuilder(19).append("Server started at ").append(host).append(":").append(port).toString());
        });
    }

    private boolean autoReload() {
        return this.autoReload;
    }

    private void autoReload_$eq(boolean x$1) {
        this.autoReload = x$1;
    }

    public String run(String root, Option<String> metadata, String[] args, Option<String> env, Option<String> gcpProject, boolean duckDbMode) {
        String string;
        Tuple2<Settings, Object> tuple2 = CaffeineSettingsManager$.MODULE$.getUpdatedSettings("", root, env, duckDbMode);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Settings settings = (Settings)tuple2._1();
        boolean reload = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)settings, (Object)BoxesRunTime.boxToBoolean((boolean)reload));
        Settings settings2 = (Settings)tuple22._1();
        boolean reload2 = tuple22._2$mcZ$sp();
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).head();
        String string2 = "quit";
        Object object2 = (object == null ? string2 != null : !object.equals(string2)) && this.autoReload() ? this.mapper().writeValueAsString((Object)SingleUserServices$.MODULE$.reset(true, settings2)) : BoxedUnit.UNIT;
        String string3 = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).head();
        if ("quit".equals(string3) ? true : "exit".equals(string3)) {
            System.exit(0);
            string = "";
        } else if ("version".equals(string3)) {
            string = this.mapper().writeValueAsString((Object)BuildInfo$.MODULE$.version());
        } else if ("reload".equals(string3)) {
            Object object3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).last();
            String string4 = "unset";
            if (!(object3 != null ? !object3.equals(string4) : string4 != null)) {
                this.autoReload_$eq(false);
                string = this.mapper().writeValueAsString((Object)new Response("{\"serve\":\"Auto reload is unset\"}"));
            } else {
                Object object4 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).last();
                String string5 = "set";
                if (!(object4 != null ? !object4.equals(string5) : string5 != null)) {
                    this.autoReload_$eq(true);
                }
                string = this.mapper().writeValueAsString((Object)SingleUserServices$.MODULE$.reset(reload2, settings2));
            }
        } else if ("heartbeat".equals(string3)) {
            string = this.mapper().writeValueAsString((Object)"OK");
        } else if ("domains".equals(string3)) {
            string = this.mapper().writeValueAsString(SingleUserServices$.MODULE$.domains(reload2, settings2));
        } else if ("table-names".equals(string3)) {
            string = this.mapper().writeValueAsString(SingleUserServices$.MODULE$.objectNames(settings2));
        } else if ("jobs".equals(string3)) {
            string = this.mapper().writeValueAsString(SingleUserServices$.MODULE$.jobs(reload2, settings2));
        } else if ("types".equals(string3)) {
            string = this.mapper().writeValueAsString(SingleUserServices$.MODULE$.types(reload2, settings2));
        } else {
            ByteArrayOutputStream errCapture = new ByteArrayOutputStream();
            string = (String)Console$.MODULE$.withErr((OutputStream)errCapture, (Function0 & Serializable & scala.Serializable)() -> {
                Try<Object> result = SingleUserServices$.MODULE$.core(args, reload2, settings2);
                boolean bl = false;
                Failure failure = null;
                Try<Object> try_ = result;
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (e instanceof IllegalArgumentException) {
                        IllegalArgumentException illegalArgumentException = (IllegalArgumentException)e;
                        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(164).append("\n              |--------------------------------------------------\n              |").append(errCapture.toString().trim()).append("\n              |--------------------------------------------------\n              |").append(illegalArgumentException.getMessage()).toString())).stripMargin();
                    }
                }
                if (bl) {
                    Throwable exception = failure.exception();
                    String errMessage = Utils$.MODULE$.exceptionAsString(exception);
                    return MODULE$.mapper().writeValueAsString((Object)new Response(errMessage));
                }
                if (try_ instanceof Success) {
                    return MODULE$.mapper().writeValueAsString((Object)new Response("Serving"));
                }
                throw new MatchError(try_);
            });
        }
        String response = string;
        return response;
    }

    private SingleUserMainServer$() {
        MODULE$ = this;
        this.mapper = Utils$.MODULE$.newJsonMapper();
        this.autoReload = true;
    }
}

