/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.sql;

import ai.starlake.config.Settings;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.OutputRef;
import ai.starlake.schema.model.RefDesc;
import ai.starlake.schema.model.Schema;
import ai.starlake.transpiler.JSQLColumResolver;
import ai.starlake.transpiler.JSQLTranspiler;
import ai.starlake.transpiler.schema.JdbcMetaData;
import ai.starlake.utils.Utils$;
import com.manticore.jsqlformatter.JSQLFormatter;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import java.util.function.Consumer;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.StatementVisitorAdapter;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.util.TablesNamesFinder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class SQLUtils$
implements StrictLogging {
    public static SQLUtils$ MODULE$;
    private final Regex fromsRegex;
    private final Regex joinRegex;
    private final Logger logger;

    static {
        new SQLUtils$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Regex fromsRegex() {
        return this.fromsRegex;
    }

    public Regex joinRegex() {
        return this.joinRegex;
    }

    public List<String> extractRefsInFromAndJoin(String sql) {
        List froms = (List)((TraversableLike)((List)this.fromsRegex().findAllMatchIn((CharSequence)sql).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.group(1)).toList().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split(","))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)table -> {
            int space = table.replaceAll("\\s", " ").indexOf(32);
            if (space > 0) {
                return table.substring(0, space);
            }
            return table;
        }, List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SQLUtils$.$anonfun$extractRefsInFromAndJoin$5(x$4)));
        List joins = this.joinRegex().findAllMatchIn((CharSequence)sql).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.group(1)).toList();
        return (List)((List)froms.$plus$plus((GenTraversableOnce)joins, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.replaceAll("`", ""), List$.MODULE$.canBuildFrom());
    }

    public List<String> extractRefsInFromCTEs(String sql) {
        Regex cteRegex = new StringOps(Predef$.MODULE$.augmentString("(?i)\\s+WITH\\s+([_\\-a-z0-9`./(]+\\s*[ _,a-z0-9`./(]*)")).r();
        List ctes = cteRegex.findAllMatchIn((CharSequence)sql).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.group(1)).toList();
        return ctes;
    }

    public List<String> extractColumnNames(String sql) {
        ObjectRef result = ObjectRef.create((Object)Nil$.MODULE$);
        SelectVisitorAdapter<Object> selectVisitorAdapter = new SelectVisitorAdapter<Object>(result){
            private final ObjectRef result$1;

            public <T> Object visit(PlainSelect plainSelect, T context) {
                SQLUtils$.ai$starlake$sql$SQLUtils$$extractColumnsFromPlainSelect$1(plainSelect, this.result$1);
                return BoxedUnit.UNIT;
            }

            public <T> Object visit(SetOperationList setOpList, T context) {
                PlainSelect plainSelect = setOpList.getSelect(0).getPlainSelect();
                SQLUtils$.ai$starlake$sql$SQLUtils$$extractColumnsFromPlainSelect$1(plainSelect, this.result$1);
                return BoxedUnit.UNIT;
            }
            {
                this.result$1 = result$1;
            }
        };
        StatementVisitorAdapter<Object> statementVisitor = new StatementVisitorAdapter<Object>((SelectVisitorAdapter)selectVisitorAdapter){
            private final SelectVisitorAdapter selectVisitorAdapter$1;

            public <T> Object visit(Select select, T context) {
                return select.accept((SelectVisitor)this.selectVisitorAdapter$1, null);
            }
            {
                this.selectVisitorAdapter$1 = selectVisitorAdapter$1;
            }
        };
        Statement select = this.jsqlParse(sql);
        select.accept((StatementVisitor)statementVisitor, null);
        return (List)result.elem;
    }

    public List<String> extractTableNames(String sql) {
        Statement select = this.jsqlParse(sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Iterable tableList = (Iterable)Option$.MODULE$.apply((Object)finder.getTables(select)).map((Function1 & Serializable & scala.Serializable)x$9 -> (Set)CollectionConverters$.MODULE$.asScalaSetConverter(x$9).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        return tableList.toList();
    }

    public List<String> extractCTENames(String sql) {
        ObjectRef result = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        StatementVisitorAdapter<Object> statementVisitor = new StatementVisitorAdapter<Object>(result){
            private final ObjectRef result$2;

            public <T> Object visit(Select select, T context) {
                Seq ctes = (Seq)Option$.MODULE$.apply((Object)select.getWithItemsList()).map((Function1 & Serializable & scala.Serializable)x$10 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$10).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                ctes.foreach((Function1 & Serializable & scala.Serializable)withItem -> {
                    String alias = (String)Option$.MODULE$.apply((Object)withItem.getAlias()).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                    if (new StringOps(Predef$.MODULE$.augmentString(alias)).nonEmpty()) {
                        return ((ListBuffer)$this.result$2.elem).$plus$eq((Object)alias);
                    }
                    return BoxedUnit.UNIT;
                });
                return null;
            }
            {
                this.result$2 = result$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$visit$1(java.util.List ), $anonfun$visit$2(), $anonfun$visit$3(ai.starlake.sql.SQLUtils$$anon$3 net.sf.jsqlparser.statement.select.WithItem ), $anonfun$visit$4(net.sf.jsqlparser.expression.Alias ), $anonfun$visit$5()}, serializedLambda);
            }
        };
        Statement select = this.jsqlParse(sql);
        select.accept((StatementVisitor)statementVisitor, null);
        return ((ListBuffer)result.elem).toList();
    }

    public Statement jsqlParse(String sql) {
        Statement statement;
        String parseable = sql.replaceAll("(?i)WHEN NOT MATCHED AND (.*) THEN ", "WHEN NOT MATCHED THEN ").replaceAll("(?i)WHEN MATCHED (.*) THEN ", "WHEN MATCHED THEN ");
        Consumer<CCJSqlParser> features = new Consumer<CCJSqlParser>(){

            public Consumer<CCJSqlParser> andThen(Consumer<? super CCJSqlParser> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(CCJSqlParser t) {
                t.withTimeOut(60000L);
            }
        };
        try {
            statement = CCJSqlParserUtil.parse((String)parseable, (Consumer)features);
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to parse {}", new Object[]{sql});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw exception;
        }
        return statement;
    }

    public String substituteRefInSQLSelect(String sql, RefDesc refs, List<Domain> domains, List<AutoTaskDesc> tasks, Settings.Connection connection, Settings settings) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Source SQL: {}", new Object[]{sql});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        String fromResolved = this.buildSingleSQLQueryForRegex(sql, refs, domains, tasks, this.fromsRegex(), "FROM", connection, settings);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("fromResolved SQL: {}", new Object[]{fromResolved});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String joinAndFromResolved = this.buildSingleSQLQueryForRegex(fromResolved, refs, domains, tasks, this.joinRegex(), "JOIN", connection, settings);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("joinAndFromResolved SQL: {}", new Object[]{joinAndFromResolved});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return joinAndFromResolved;
    }

    public String buildSingleSQLQueryForRegex(String sql, RefDesc refs, List<Domain> domains, List<AutoTaskDesc> tasks, Regex fromOrJoinRegex, String keyword, Settings.Connection connection, Settings settings) {
        List<String> ctes = this.extractCTENames(sql);
        ObjectRef resolvedSQL = ObjectRef.create((Object)"");
        IntRef startIndex = IntRef.create((int)0);
        List fromMatches = fromOrJoinRegex.findAllMatchIn((CharSequence)sql).toList();
        if (fromMatches.isEmpty()) {
            return sql;
        }
        List<String> tablesList = this.extractTableNames(sql);
        fromMatches.foreach((Function1 & Serializable & scala.Serializable)regex -> {
            SQLUtils$.$anonfun$buildSingleSQLQueryForRegex$1(keyword, tablesList, refs, domains, tasks, ctes, connection, settings, resolvedSQL, sql, startIndex, regex);
            return BoxedUnit.UNIT;
        });
        resolvedSQL.elem = new StringBuilder(0).append((String)resolvedSQL.elem).append(sql.substring(startIndex.elem)).toString();
        return (String)resolvedSQL.elem;
    }

    private String resolveTableNameInSql(String tableName, RefDesc refs, List<Domain> domains, List<AutoTaskDesc> tasks, List<String> ctes, Settings.Connection connection, Settings settings) {
        if (new StringOps(Predef$.MODULE$.augmentString(tableName)).contains((Object)BoxesRunTime.boxToCharacter((char)'/'))) {
            return tableName;
        }
        String quoteFreeTName = this.quoteFreeTableName(tableName);
        List tableTuple = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])quoteFreeTName.split("\\."))).toList();
        RefDesc activeEnvRefs = refs;
        Option databaseDomainTableRef = activeEnvRefs.getOutputRef((List<String>)tableTuple).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.toSQLString(connection));
        String resolvedTableName = (String)databaseDomainTableRef.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Success success;
            Tuple3 tuple3;
            Try<Tuple3<String, String, String>> try_ = MODULE$.resolveTableRefInDomainsAndJobs((List<String>)tableTuple, domains, tasks, settings);
            if (try_ instanceof Success && (tuple3 = (Tuple3)(success = (Success)try_).value()) != null) {
                String database = (String)tuple3._1();
                String domain = (String)tuple3._2();
                String table = (String)tuple3._3();
                return new OutputRef(database, domain, table).toSQLString(connection);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                Utils$.MODULE$.logException(MODULE$.logger(), e);
                throw e;
            }
            throw new MatchError(try_);
        });
        return resolvedTableName;
    }

    public String quoteFreeTableName(String tableName2) {
        String quoteFreeTableName = (String)new .colon.colon((Object)"\"", (List)new .colon.colon((Object)"`", (List)new .colon.colon((Object)"'", (List)Nil$.MODULE$))).foldLeft((Object)tableName2, (Function2 & Serializable & scala.Serializable)(tableName, quote) -> tableName.replaceAll((String)quote, ""));
        return quoteFreeTableName;
    }

    private Try<Tuple3<String, String, String>> resolveTableRefInDomainsAndJobs(List<String> tableComponents, List<Domain> domains, List<AutoTaskDesc> tasks, Settings settings) {
        return Try$.MODULE$.apply(() -> SQLUtils$.$anonfun$resolveTableRefInDomainsAndJobs$1(tableComponents, domains, tasks, settings));
    }

    public String temporaryTableName(String tableName) {
        return new StringBuilder(7).append("zztmp_").append(tableName).append("_").append(UUID.randomUUID().toString().replace("-", "")).toString();
    }

    public String stripComments(String sql) {
        String sql1 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sql.split("\n"))).map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.replaceAll("--.*$", ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
        String sql2 = sql1.replaceAll("(?s)/\\*.*?\\*/", "");
        return sql2.trim();
    }

    public List<String> quoteCols(List<String> cols, String quote) {
        return (List)this.unquoteCols(cols, quote).map((Function1 & Serializable & scala.Serializable)col -> new StringBuilder(0).append(quote).append((String)col).append(quote).toString(), List$.MODULE$.canBuildFrom());
    }

    public List<String> unquoteCols(List<String> cols, String quote) {
        return (List)cols.map((Function1 & Serializable & scala.Serializable)col -> {
            if (new StringOps(Predef$.MODULE$.augmentString(quote)).nonEmpty() && col.startsWith(quote) && col.endsWith(quote)) {
                return col.substring(1, col.length() - 1);
            }
            return col;
        }, List$.MODULE$.canBuildFrom());
    }

    public String targetColumnsForSelectSql(List<String> targetTableColumns, String quote) {
        return this.quoteCols(this.unquoteCols(targetTableColumns, quote), quote).mkString(",");
    }

    public String incomingColumnsForSelectSql(String incomingTable, List<String> targetTableColumns, String quote) {
        return ((TraversableOnce)this.unquoteCols(targetTableColumns, quote).map((Function1 & Serializable & scala.Serializable)col -> new StringBuilder(1).append(incomingTable).append(".").append(quote).append((String)col).append(quote).toString(), List$.MODULE$.canBuildFrom())).mkString(",");
    }

    public String setForUpdateSql(String incomingTable, List<String> targetTableColumns, String quote) {
        return ((TraversableOnce)this.unquoteCols(targetTableColumns, quote).map((Function1 & Serializable & scala.Serializable)col -> new StringBuilder(4).append(quote).append((String)col).append(quote).append(" = ").append(incomingTable).append(".").append(quote).append((String)col).append(quote).toString(), List$.MODULE$.canBuildFrom())).mkString("SET ", ",", "");
    }

    public String mergeKeyJoinCondition(String incomingTable, String targetTable, List<String> columns, String quote) {
        return ((TraversableOnce)this.unquoteCols(columns, quote).map((Function1 & Serializable & scala.Serializable)col -> new StringBuilder(5).append(incomingTable).append(".").append(quote).append((String)col).append(quote).append(" = ").append(targetTable).append(".").append(quote).append((String)col).append(quote).toString(), List$.MODULE$.canBuildFrom())).mkString(" AND ");
    }

    public String format(String input, JSQLFormatter.OutputFormat outputFormat) {
        String string;
        String formatted;
        String string2;
        String sql = input.trim();
        String uppercaseSQL = sql.toUpperCase();
        if (uppercaseSQL.startsWith("SELECT") || uppercaseSQL.startsWith("WITH") || uppercaseSQL.startsWith("MERGE")) {
            String preformat = sql.replaceAll("}}", "______\n").replaceAll("\\{\\{", "___\n");
            string2 = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JSQLFormatter.format((String)preformat, (String[])new String[]{new StringBuilder(13).append("outputFormat=").append(outputFormat.name()).toString(), "statementTerminator=NONE"})).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("-- failed to format start\n").append(sql).append("\n-- failed to format end").toString());
        } else {
            string2 = formatted = sql;
        }
        if (formatted.startsWith("-- failed to format start")) {
            string = sql;
        } else {
            String postFormat = formatted.replaceAll("______", "}}").replaceAll("___", "{{");
            JSQLFormatter.OutputFormat outputFormat2 = outputFormat;
            JSQLFormatter.OutputFormat outputFormat3 = JSQLFormatter.OutputFormat.HTML;
            if (!(outputFormat2 != null ? !outputFormat2.equals(outputFormat3) : outputFormat3 != null)) {
                int startIndex = postFormat.indexOf("<body>") + "<body>".length();
                int endIndex = postFormat.indexOf("</body>");
                string = startIndex > 0 && endIndex > 0 ? postFormat.substring(startIndex, endIndex) : postFormat;
            } else {
                string = postFormat;
            }
        }
        String result = string;
        String trimmedResult = result.trim();
        if (!sql.endsWith(";") && trimmedResult.endsWith(";")) {
            return trimmedResult.substring(0, trimmedResult.length() - 1);
        }
        return result;
    }

    public JSQLTranspiler.Dialect transpilerDialect(Settings.Connection conn) {
        Option<String> option = conn._transpileDialect();
        if (option instanceof Some) {
            Some some = (Some)option;
            String dialect = (String)some.value();
            return JSQLTranspiler.Dialect.valueOf((String)dialect);
        }
        if (None$.MODULE$.equals(option)) {
            Object object = conn.isSpark() ? JSQLTranspiler.Dialect.DATABRICKS : BoxedUnit.UNIT;
            if (conn.isBigQuery()) {
                return JSQLTranspiler.Dialect.GOOGLE_BIG_QUERY;
            }
            if (conn.isSnowflake()) {
                return JSQLTranspiler.Dialect.SNOWFLAKE;
            }
            if (conn.isRedshift()) {
                return JSQLTranspiler.Dialect.AMAZON_REDSHIFT;
            }
            if (conn.isDuckDb()) {
                return JSQLTranspiler.Dialect.DUCK_DB;
            }
            if (conn.isPostgreSql()) {
                return JSQLTranspiler.Dialect.ANY;
            }
            if (conn.isMySQLOrMariaDb()) {
                return JSQLTranspiler.Dialect.ANY;
            }
            if (conn.isJdbcUrl()) {
                return JSQLTranspiler.Dialect.ANY;
            }
            return JSQLTranspiler.Dialect.ANY;
        }
        throw new MatchError(option);
    }

    public String resolve(String sql, Settings settings) {
        JdbcMetaData schemaDefinition = settings.schemaHandler(settings.schemaHandler$default$1(), settings.schemaHandler$default$2()).objectDefinitions();
        Try resolved = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new JSQLColumResolver(schemaDefinition).getResolvedStatementText(sql).replaceAll("/\\* Resolved Column\\*/", ""));
        return (String)resolved.getOrElse((Function0 & Serializable & scala.Serializable)() -> sql);
    }

    public String transpile(String sql, Settings.Connection conn, scala.collection.immutable.Map<String, Object> timestamps) {
        BoxedUnit boxedUnit;
        if (timestamps.nonEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Transpiling SQL with timestamps: {}", new Object[]{timestamps});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JSQLTranspiler.transpileQuery((String)sql, (JSQLTranspiler.Dialect)MODULE$.transpilerDialect(conn), (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)timestamps).asJava())));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String transpiled = (String)success.value();
            return transpiled;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to transpile SQL: {}", new Object[]{sql});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Utils$.MODULE$.logException(this.logger(), e);
            return sql;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ boolean $anonfun$extractRefsInFromAndJoin$5(String x$4) {
        return !x$4.contains("(");
    }

    public static final void ai$starlake$sql$SQLUtils$$extractColumnsFromPlainSelect$1(PlainSelect plainSelect, ObjectRef result$1) {
        Seq selectItems = (Seq)Option$.MODULE$.apply((Object)plainSelect.getSelectItems()).map((Function1 & Serializable & scala.Serializable)x$8 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        result$1.elem = ((TraversableOnce)selectItems.map((Function1 & Serializable & scala.Serializable)selectItem -> selectItem.getASTNode().jjtGetLastToken().image, Seq$.MODULE$.canBuildFrom())).toList();
    }

    public static final /* synthetic */ void $anonfun$buildSingleSQLQueryForRegex$5(RefDesc refs$1, List domains$1, List tasks$1, List ctes$1, Settings.Connection connection$1, Settings settings$1, ObjectRef source$1, String tableFound) {
        String resolvedTableName = MODULE$.resolveTableNameInSql(tableFound, refs$1, (List<Domain>)domains$1, (List<AutoTaskDesc>)tasks$1, (List<String>)ctes$1, connection$1, settings$1);
        source$1.elem = ((String)source$1.elem).replaceAll(tableFound, resolvedTableName);
    }

    public static final /* synthetic */ void $anonfun$buildSingleSQLQueryForRegex$1(String keyword$1, List tablesList$1, RefDesc refs$1, List domains$1, List tasks$1, List ctes$1, Settings.Connection connection$1, Settings settings$1, ObjectRef resolvedSQL$1, String sql$1, IntRef startIndex$1, Regex.Match regex) {
        ObjectRef source = ObjectRef.create((Object)((Object)regex.source()).toString().substring(regex.start(), regex.end()));
        String[] tablesFound = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)source.elem).substring(((String)source.elem).toUpperCase().indexOf(keyword$1.toUpperCase()) + keyword$1.length()).split(","))).map((Function1 & Serializable & scala.Serializable)x$12 -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$12.trim().split("\\s"))).head(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)tablesList$1.contains((Object)x$13))))).sortBy((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.length()), (Ordering)Ordering.Int$.MODULE$))).reverse();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tablesFound)).foreach((Function1 & Serializable & scala.Serializable)tableFound -> {
            SQLUtils$.$anonfun$buildSingleSQLQueryForRegex$5(refs$1, domains$1, tasks$1, ctes$1, connection$1, settings$1, source, tableFound);
            return BoxedUnit.UNIT;
        });
        resolvedSQL$1.elem = new StringBuilder(0).append((String)resolvedSQL$1.elem).append(sql$1.substring(startIndex$1.elem, regex.start())).append((String)source.elem).toString();
        startIndex$1.elem = regex.end();
    }

    private static final boolean cteContains$1(String table, List ctes$2) {
        return ctes$2.exists((Function1 & Serializable & scala.Serializable)cte -> BoxesRunTime.boxToBoolean((boolean)cte.equalsIgnoreCase(table)));
    }

    public static final /* synthetic */ boolean $anonfun$resolveTableRefInDomainsAndJobs$4(String table$2, Schema x$18) {
        return x$18.finalName().equalsIgnoreCase(table$2);
    }

    public static final /* synthetic */ boolean $anonfun$resolveTableRefInDomainsAndJobs$2(Option domainComponent$1, String table$2, Domain dom) {
        boolean domainOK = domainComponent$1.forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.equalsIgnoreCase(dom.finalName())));
        return domainOK && dom.tables().exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)SQLUtils$.$anonfun$resolveTableRefInDomainsAndJobs$4(table$2, x$18)));
    }

    public static final /* synthetic */ boolean $anonfun$resolveTableRefInDomainsAndJobs$5(Option domainComponent$1, String table$2, AutoTaskDesc task) {
        boolean domainOK = domainComponent$1.forall((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.equalsIgnoreCase(task.domain())));
        return domainOK && task.table().equalsIgnoreCase(table$2);
    }

    public static final /* synthetic */ String $anonfun$resolveTableRefInDomainsAndJobs$7(Domain x$20) {
        return x$20.finalName();
    }

    public static final /* synthetic */ String $anonfun$resolveTableRefInDomainsAndJobs$8(AutoTaskDesc x$21) {
        return x$21.table();
    }

    public static final /* synthetic */ String $anonfun$resolveTableRefInDomainsAndJobs$9(AutoTaskDesc x$22) {
        return x$22.name();
    }

    public static final /* synthetic */ Tuple2 $anonfun$resolveTableRefInDomainsAndJobs$10(Domain dom) {
        return new Tuple2(dom.database(), (Object)dom.finalName());
    }

    public static final /* synthetic */ Option $anonfun$resolveTableRefInDomainsAndJobs$11(List tasksByTable$1) {
        return tasksByTable$1.headOption().map((Function1 & Serializable & scala.Serializable)task -> new Tuple2(task.database(), (Object)task.domain()));
    }

    public static final /* synthetic */ Tuple2 $anonfun$resolveTableRefInDomainsAndJobs$13() {
        return new Tuple2((Object)None$.MODULE$, (Object)"");
    }

    public static final /* synthetic */ String $anonfun$resolveTableRefInDomainsAndJobs$14() {
        return "";
    }

    public static final /* synthetic */ Option $anonfun$resolveTableRefInDomainsAndJobs$15(Settings settings$3) {
        return settings$3.appConfig().getDefaultDatabase();
    }

    public static final /* synthetic */ String $anonfun$resolveTableRefInDomainsAndJobs$16() {
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple3 $anonfun$resolveTableRefInDomainsAndJobs$1(List tableComponents$1, List domains$3, List tasks$3, Settings settings$3) {
        block21: {
            block22: {
                block20: {
                    var10_4 = false;
                    var11_5 = null;
                    var12_6 = tableComponents$1;
                    if (!(var12_6 instanceof .colon.colon)) break block20;
                    var10_4 = true;
                    var11_5 = (.colon.colon)var12_6;
                    table = (String)var11_5.head();
                    var14_8 = var11_5.tl$access$1();
                    if (!Nil$.MODULE$.equals(var14_8)) break block20;
                    v0 = new Tuple3((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)table);
                    break block21;
                }
                if (!var10_4) break block22;
                domain = (String)var11_5.head();
                var16_10 = var11_5.tl$access$1();
                if (!(var16_10 instanceof .colon.colon)) break block22;
                var17_11 = (.colon.colon)var16_10;
                table = (String)var17_11.head();
                var19_13 = var17_11.tl$access$1();
                if (!Nil$.MODULE$.equals(var19_13)) break block22;
                v0 = new Tuple3((Object)None$.MODULE$, (Object)new Some((Object)domain), (Object)table);
                break block21;
            }
            if (!var10_4) ** GOTO lbl-1000
            database = (String)var11_5.head();
            var21_15 = var11_5.tl$access$1();
            if (!(var21_15 instanceof .colon.colon)) ** GOTO lbl-1000
            var22_16 = (.colon.colon)var21_15;
            domain = (String)var22_16.head();
            var24_18 = var22_16.tl$access$1();
            if (!(var24_18 instanceof .colon.colon)) ** GOTO lbl-1000
            var25_19 = (.colon.colon)var24_18;
            table = (String)var25_19.head();
            var27_21 = var25_19.tl$access$1();
            if (Nil$.MODULE$.equals(var27_21)) {
                v0 = new Tuple3((Object)new Some((Object)database), (Object)new Some((Object)domain), (Object)table);
            } else lbl-1000:
            // 4 sources

            {
                throw new Exception(new StringBuilder(24).append("Invalid table reference ").append(tableComponents$1.mkString(".")).toString());
            }
        }
        var9_22 = v0;
        if (var9_22 == null) {
            throw new MatchError((Object)var9_22);
        }
        database = (Option)var9_22._1();
        domain = (Option)var9_22._2();
        table = (String)var9_22._3();
        var8_26 = new Tuple3((Object)database, (Object)domain, (Object)table);
        database = (Option)var8_26._1();
        domain = (Option)var8_26._2();
        table = (String)var8_26._3();
        var34_30 = new Tuple3((Object)database, (Object)domain, (Object)table);
        if (var34_30 != null) {
            var35_31 = (Option)var34_30._1();
            var36_32 = (Option)var34_30._2();
            table = (String)var34_30._3();
            if (var35_31 instanceof Some) {
                var38_34 = (Some)var35_31;
                db = (String)var38_34.value();
                if (var36_32 instanceof Some) {
                    var40_36 = (Some)var36_32;
                    dom = (String)var40_36.value();
                    return new Tuple3((Object)db, (Object)dom, (Object)table);
                }
            }
        }
        if (var34_30 != null) {
            var42_38 = (Option)var34_30._1();
            domainComponent = (Option)var34_30._2();
            table = (String)var34_30._3();
            if (None$.MODULE$.equals(var42_38)) {
                domainsByFinalName = (List)domains$3.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$resolveTableRefInDomainsAndJobs$2$adapted(scala.Option java.lang.String ai.starlake.schema.model.Domain ), (Lai/starlake/schema/model/Domain;)Ljava/lang/Object;)((Option)domainComponent, (String)table));
                tasksByTable = tasks$3.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$resolveTableRefInDomainsAndJobs$5$adapted(scala.Option java.lang.String ai.starlake.schema.model.AutoTaskDesc ), (Lai/starlake/schema/model/AutoTaskDesc;)Ljava/lang/Object;)((Option)domainComponent, (String)table)).toList();
                nameCountMatch = domainsByFinalName.length() + tasksByTable.length();
                if (nameCountMatch > 1) {
                    domainNames = ((TraversableOnce)domainsByFinalName.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$resolveTableRefInDomainsAndJobs$7(ai.starlake.schema.model.Domain ), (Lai/starlake/schema/model/Domain;)Ljava/lang/String;)(), List$.MODULE$.canBuildFrom())).mkString(",");
                    if (SQLUtils$.MODULE$.logger().underlying().isErrorEnabled()) {
                        SQLUtils$.MODULE$.logger().underlying().error("Table {} is present in domain(s): {}.", new Object[]{table, domainNames});
                        v1 = BoxedUnit.UNIT;
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                    taskNamesByTable = ((TraversableOnce)tasksByTable.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$resolveTableRefInDomainsAndJobs$8(ai.starlake.schema.model.AutoTaskDesc ), (Lai/starlake/schema/model/AutoTaskDesc;)Ljava/lang/String;)(), List$.MODULE$.canBuildFrom())).mkString(",");
                    if (SQLUtils$.MODULE$.logger().underlying().isErrorEnabled()) {
                        SQLUtils$.MODULE$.logger().underlying().error("Table {} is present as a table in tasks(s): {}.", new Object[]{table, taskNamesByTable});
                        v2 = BoxedUnit.UNIT;
                    } else {
                        v2 = BoxedUnit.UNIT;
                    }
                    taskNames = ((TraversableOnce)tasksByTable.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$resolveTableRefInDomainsAndJobs$9(ai.starlake.schema.model.AutoTaskDesc ), (Lai/starlake/schema/model/AutoTaskDesc;)Ljava/lang/String;)(), List$.MODULE$.canBuildFrom())).mkString(",");
                    if (SQLUtils$.MODULE$.logger().underlying().isErrorEnabled()) {
                        SQLUtils$.MODULE$.logger().underlying().error("Table {} is present as a table in tasks(s): {}.", new Object[]{table, taskNames});
                        v3 = BoxedUnit.UNIT;
                    } else {
                        v3 = BoxedUnit.UNIT;
                    }
                    throw new Exception("Table is present in multiple domains and/or tasks");
                }
                if (nameCountMatch == 1) {
                    v4 = (Tuple2)domainsByFinalName.headOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$resolveTableRefInDomainsAndJobs$10(ai.starlake.schema.model.Domain ), (Lai/starlake/schema/model/Domain;)Lscala/Tuple2;)()).orElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$resolveTableRefInDomainsAndJobs$11(scala.collection.immutable.List ), ()Lscala/Option;)((List)tasksByTable)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$resolveTableRefInDomainsAndJobs$13(), ()Lscala/Tuple2;)());
                } else {
                    if (SQLUtils$.MODULE$.logger().underlying().isInfoEnabled()) {
                        SQLUtils$.MODULE$.logger().underlying().info("Table {} not found in any domain or task; This is probably a CTE or a temporary table", new Object[]{table});
                        v5 = BoxedUnit.UNIT;
                    } else {
                        v5 = BoxedUnit.UNIT;
                    }
                    v4 = var49_47 = new Tuple2((Object)None$.MODULE$, domainComponent.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$resolveTableRefInDomainsAndJobs$14(), ()Ljava/lang/String;)()));
                }
                if (var49_47 == null) {
                    throw new MatchError((Object)var49_47);
                }
                database = (Option)var49_47._1();
                domain = (String)var49_47._2();
                var48_50 = new Tuple2((Object)database, (Object)domain);
                database = (Option)var48_50._1();
                domain = (String)var48_50._2();
                databaseName = (String)database.orElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$resolveTableRefInDomainsAndJobs$15(ai.starlake.config.Settings ), ()Lscala/Option;)((Settings)settings$3)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$resolveTableRefInDomainsAndJobs$16(), ()Ljava/lang/String;)());
                return new Tuple3((Object)databaseName, (Object)domain, (Object)table);
            }
        }
        throw new Exception(new StringBuilder(24).append("Invalid table reference ").append(tableComponents$1.mkString(".")).toString());
    }

    private SQLUtils$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.fromsRegex = new StringOps(Predef$.MODULE$.augmentString("(?i)\\s+FROM\\s+([_\\-a-z0-9`./(]+\\s*[ _,a-z0-9`./(]*)")).r();
        this.joinRegex = new StringOps(Predef$.MODULE$.augmentString("(?i)\\s+JOIN\\s+([_\\-a-z0-9`./]+)")).r();
    }

    public static final /* synthetic */ Object $anonfun$resolveTableRefInDomainsAndJobs$2$adapted(Option domainComponent$1, String table$2, Domain dom) {
        return BoxesRunTime.boxToBoolean((boolean)SQLUtils$.$anonfun$resolveTableRefInDomainsAndJobs$2(domainComponent$1, table$2, dom));
    }

    public static final /* synthetic */ Object $anonfun$resolveTableRefInDomainsAndJobs$5$adapted(Option domainComponent$1, String table$2, AutoTaskDesc task) {
        return BoxesRunTime.boxToBoolean((boolean)SQLUtils$.$anonfun$resolveTableRefInDomainsAndJobs$5(domainComponent$1, table$2, task));
    }
}

