/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.tests;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.job.Main;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.ConnectionType$JDBC$;
import ai.starlake.schema.model.DDLField;
import ai.starlake.schema.model.DDLLeaf;
import ai.starlake.schema.model.EnvDesc$;
import ai.starlake.schema.model.Ref;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.TableDesc;
import ai.starlake.tests.StarlakePreTestScript;
import ai.starlake.tests.StarlakeTest;
import ai.starlake.tests.StarlakeTestConfig;
import ai.starlake.tests.StarlakeTestCoverage;
import ai.starlake.tests.StarlakeTestData;
import ai.starlake.tests.StarlakeTestResult;
import ai.starlake.utils.Utils$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.TimeZone;
import org.apache.hadoop.fs.Path;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple7;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.io.Directory;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class StarlakeTestData$
implements scala.Serializable {
    public static StarlakeTestData$ MODULE$;

    static {
        new StarlakeTestData$();
    }

    public boolean $lessinit$greater$default$7() {
        return false;
    }

    public Settings createDuckDbSettings(Settings originalSettings, String dbFilename) {
        Map x$7 = (Map)originalSettings.appConfig().connections().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Settings.Connection v = (Settings.Connection)tuple2._2();
                ConnectionType$JDBC$ x$1 = ConnectionType$JDBC$.MODULE$;
                Some x$2 = new Some((Object)"\"");
                Some x$3 = new Some((Object)".");
                None$ x$4 = None$.MODULE$;
                Map x$5 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)new StringBuilder(12).append("jdbc:duckdb:").append(dbFilename).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driver"), (Object)"org.duckdb.DuckDBDriver")}));
                Option<String> x$6 = v.copy$default$6();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.copy(x$1, (Option<String>)x$4, (Option<String>)x$2, (Option<String>)x$3, (Map<String, String>)x$5, x$6));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        String x$8 = originalSettings.appConfig().copy$default$1();
        String x$9 = originalSettings.appConfig().copy$default$2();
        String x$10 = originalSettings.appConfig().copy$default$3();
        String x$11 = originalSettings.appConfig().copy$default$4();
        String x$12 = originalSettings.appConfig().copy$default$5();
        String x$13 = originalSettings.appConfig().copy$default$6();
        Settings.Metrics x$14 = originalSettings.appConfig().copy$default$7();
        boolean x$15 = originalSettings.appConfig().copy$default$8();
        Settings.Audit x$16 = originalSettings.appConfig().copy$default$9();
        boolean x$17 = originalSettings.appConfig().copy$default$10();
        boolean x$18 = originalSettings.appConfig().copy$default$11();
        Settings.Lock x$19 = originalSettings.appConfig().copy$default$12();
        String x$20 = originalSettings.appConfig().copy$default$13();
        String x$21 = originalSettings.appConfig().copy$default$14();
        String x$22 = originalSettings.appConfig().copy$default$15();
        boolean x$23 = originalSettings.appConfig().copy$default$16();
        String x$24 = originalSettings.appConfig().copy$default$17();
        boolean x$25 = originalSettings.appConfig().copy$default$18();
        boolean x$26 = originalSettings.appConfig().copy$default$19();
        String x$27 = originalSettings.appConfig().copy$default$20();
        String x$28 = originalSettings.appConfig().copy$default$21();
        String x$29 = originalSettings.appConfig().copy$default$22();
        String x$30 = originalSettings.appConfig().copy$default$23();
        boolean x$31 = originalSettings.appConfig().copy$default$24();
        int x$32 = originalSettings.appConfig().copy$default$25();
        String x$33 = originalSettings.appConfig().copy$default$26();
        String x$34 = originalSettings.appConfig().copy$default$27();
        Settings.Area x$35 = originalSettings.appConfig().copy$default$28();
        Map<String, String> x$36 = originalSettings.appConfig().copy$default$29();
        Map<String, Settings.JdbcEngine> x$37 = originalSettings.appConfig().copy$default$31();
        Settings.Privacy x$38 = originalSettings.appConfig().copy$default$32();
        String x$39 = originalSettings.appConfig().copy$default$33();
        Option<Settings.Internal> x$40 = originalSettings.appConfig().copy$default$34();
        Settings.AccessPolicies x$41 = originalSettings.appConfig().copy$default$35();
        Settings.SparkScheduling x$42 = originalSettings.appConfig().copy$default$36();
        Option<String> x$43 = originalSettings.appConfig().copy$default$37();
        Settings.ExpectationsConfig x$44 = originalSettings.appConfig().copy$default$38();
        String x$45 = originalSettings.appConfig().copy$default$39();
        boolean x$46 = originalSettings.appConfig().copy$default$40();
        int x$47 = originalSettings.appConfig().copy$default$41();
        int x$48 = originalSettings.appConfig().copy$default$42();
        Settings.KafkaConfig x$49 = originalSettings.appConfig().copy$default$43();
        Map<String, String> x$50 = originalSettings.appConfig().copy$default$44();
        String x$51 = originalSettings.appConfig().copy$default$45();
        String x$52 = originalSettings.appConfig().copy$default$46();
        String x$53 = originalSettings.appConfig().copy$default$47();
        String x$54 = originalSettings.appConfig().copy$default$48();
        String x$55 = originalSettings.appConfig().copy$default$49();
        boolean x$56 = originalSettings.appConfig().copy$default$50();
        long x$57 = originalSettings.appConfig().copy$default$51();
        String x$58 = originalSettings.appConfig().copy$default$52();
        String x$59 = originalSettings.appConfig().copy$default$53();
        String x$60 = originalSettings.appConfig().copy$default$54();
        Map<String, String> x$61 = originalSettings.appConfig().copy$default$55();
        int x$62 = originalSettings.appConfig().copy$default$56();
        List<Ref> x$63 = originalSettings.appConfig().copy$default$57();
        Option<Settings.DagRef> x$64 = originalSettings.appConfig().copy$default$58();
        boolean x$65 = originalSettings.appConfig().copy$default$59();
        Option<String> x$66 = originalSettings.appConfig().copy$default$60();
        String x$67 = originalSettings.appConfig().copy$default$61();
        boolean x$68 = originalSettings.appConfig().copy$default$62();
        String x$69 = originalSettings.appConfig().copy$default$63();
        boolean x$70 = originalSettings.appConfig().copy$default$64();
        long x$71 = originalSettings.appConfig().copy$default$65();
        long x$72 = originalSettings.appConfig().copy$default$66();
        boolean x$73 = originalSettings.appConfig().copy$default$67();
        Settings.Http x$74 = originalSettings.appConfig().copy$default$68();
        TimeZone x$75 = originalSettings.appConfig().copy$default$69();
        boolean x$76 = originalSettings.appConfig().copy$default$70();
        boolean x$77 = originalSettings.appConfig().copy$default$71();
        String x$78 = originalSettings.appConfig().copy$default$72();
        int x$79 = originalSettings.appConfig().copy$default$73();
        return originalSettings.copy(originalSettings.appConfig().copy(x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, (Map<String, Settings.Connection>)x$7, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79), originalSettings.copy$default$2(), originalSettings.copy$default$3(), originalSettings.copy$default$4(), originalSettings.copy$default$5());
    }

    public File getFile(boolean load, Option<String> domainName, Option<String> tableName, Option<String> testName, String filename, boolean incoming, Settings settings) {
        Path path = load ? DatasetArea$.MODULE$.loadTests(settings) : DatasetArea$.MODULE$.transformTests(settings);
        Tuple3 tuple3 = new Tuple3(domainName, tableName, testName);
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option2 = (Option)tuple3._2();
            Option option3 = (Option)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                String domain = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String table = (String)some2.value();
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        String test = (String)some3.value();
                        String prefix = incoming ? "_incoming." : "";
                        return new File(path.toString(), new StringBuilder(3).append(domain).append("/").append(table).append("/").append(test).append("/").append(prefix).append(filename).toString());
                    }
                }
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option4 = (Option)tuple3._2();
            Option option5 = (Option)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                String domain = (String)some.value();
                if (option4 instanceof Some) {
                    Some some4 = (Some)option4;
                    String table = (String)some4.value();
                    if (None$.MODULE$.equals(option5)) {
                        return new File(path.toString(), new StringBuilder(2).append(domain).append("/").append(table).append("/").append(filename).toString());
                    }
                }
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option6 = (Option)tuple3._2();
            Option option7 = (Option)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                String domain = (String)some.value();
                if (None$.MODULE$.equals(option6) && None$.MODULE$.equals(option7)) {
                    return new File(path.toString(), new StringBuilder(1).append(domain).append("/").append(filename).toString());
                }
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option8 = (Option)tuple3._2();
            Option option9 = (Option)tuple3._3();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option8) && None$.MODULE$.equals(option9)) {
                return new File(path.toString(), filename);
            }
        }
        throw new IllegalArgumentException("Invalid arguments");
    }

    public void createSchema(String domainName, Connection conn) {
        this.execute(conn, new StringBuilder(30).append("CREATE SCHEMA IF NOT EXISTS \"").append(domainName).append("\"").toString());
    }

    public void dropSchema(String domainName, Connection conn) {
        this.execute(conn, new StringBuilder(32).append("DROP SCHEMA IF EXISTS \"").append(domainName).append("\" CASCADE").toString());
    }

    public List<String> describe(Connection connection, String domainAndTableOrQuery) {
        String string;
        Regex selectPattern = new StringOps(Predef$.MODULE$.augmentString("(?i)SELECT\\s")).r();
        Option option = selectPattern.findFirstMatchIn((CharSequence)domainAndTableOrQuery);
        if (option instanceof Some) {
            string = domainAndTableOrQuery;
        } else if (None$.MODULE$.equals(option)) {
            String[] domAndTbl = new StringOps(Predef$.MODULE$.augmentString(domainAndTableOrQuery)).split('.');
            String domain = domAndTbl[0];
            String table = domAndTbl[1];
            string = new StringBuilder(5).append("\"").append(domain).append("\".\"").append(table).append("\"").toString();
        } else {
            throw new MatchError((Object)option);
        }
        String statement = string;
        Tuple2<Statement, ResultSet> tuple2 = this.executeQuery(connection, new StringBuilder(9).append("DESCRIBE ").append(statement).toString());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Statement stmt = (Statement)tuple2._1();
        ResultSet rs = (ResultSet)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)stmt, (Object)rs);
        Statement stmt2 = (Statement)tuple22._1();
        ResultSet rs2 = (ResultSet)tuple22._2();
        ListBuffer columns = new ListBuffer();
        while (rs2.next()) {
            String name = rs2.getString("column_name");
            String type_ = rs2.getString("column_type");
            columns.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name.toLowerCase()}));
        }
        rs2.close();
        stmt2.close();
        return columns.toList();
    }

    private String expectationQuery(String targetDomain, String targetTable, StarlakeTestData assertDatum, boolean missing) {
        String string;
        String sql = (String)assertDatum.expectationAsSql().getOrElse((Function0 & Serializable & scala.Serializable)() -> "*");
        String assertTable = assertDatum.table();
        Regex selectPattern = new StringOps(Predef$.MODULE$.augmentString("(?i)SELECT\\s")).r();
        Option option = selectPattern.findFirstMatchIn((CharSequence)sql);
        if (option instanceof Some) {
            string = missing ? new StringBuilder(27).append(sql).append(" EXCEPT SELECT * FROM \"").append(targetDomain).append("\".\"").append(assertTable).append("\"").toString() : new StringBuilder(27).append("SELECT * FROM \"").append(targetDomain).append("\".\"").append(assertTable).append("\" EXCEPT ").append(sql).toString();
        } else if (None$.MODULE$.equals(option)) {
            String columnNames = sql;
            string = missing ? new StringBuilder(45).append("SELECT ").append(columnNames).append(" FROM \"").append(targetDomain).append("\".\"").append(targetTable).append("\" EXCEPT SELECT * FROM \"").append(targetDomain).append("\".\"").append(assertTable).append("\"").toString() : new StringBuilder(45).append("SELECT * FROM \"").append(targetDomain).append("\".\"").append(assertTable).append("\" EXCEPT SELECT ").append(columnNames).append(" FROM \"").append(targetDomain).append("\".\"").append(targetTable).append("\"").toString();
        } else {
            throw new MatchError((Object)option);
        }
        String selectStatement = string;
        return selectStatement;
    }

    public boolean outputTableDifferences(Connection conn, String targetDomain, String targetTable, StarlakeTestData assertDatum, File outputPath, String selectStatement) {
        boolean bl;
        block3: {
            String diffSql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(88).append("COPY\n                        |(").append(selectStatement).append(")\n                        |TO '").append(outputPath).append("' (HEADER, DELIMITER ',') ").toString())).stripMargin();
            this.execute(conn, diffSql);
            try {
                java.util.List<String> allLines = Files.readAllLines(outputPath.toPath());
                if (allLines.size() <= 1) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        return bl;
    }

    public StarlakeTestResult[] compareResults(Directory testFolder, String targetDomain, String targetTable, String taskName, StarlakeTestData[] assertData, Connection conn, long duration) {
        return (StarlakeTestResult[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])assertData)).map((Function1 & Serializable & scala.Serializable)assertDatum -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String assertTable = assertDatum.table();
                String expectedColumns = (String)assertDatum.expectationAsSql().getOrElse((Function0 & Serializable & scala.Serializable)() -> "*");
                List<String> targetColumns = MODULE$.describe(conn, new StringBuilder(18).append("SELECT ").append(expectedColumns).append(" FROM \"").append(targetDomain).append("\".\"").append(targetTable).append("\"").toString());
                List<String> assertColumns = MODULE$.describe(conn, new StringBuilder(1).append(targetDomain).append(".").append(assertTable).toString());
                List missingColumns = (List)assertColumns.diff(targetColumns);
                List notExpectedColumns = (List)targetColumns.diff(assertColumns);
                boolean success = true;
                if (missingColumns.nonEmpty()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(17).append("Missing columns: ").append(missingColumns.mkString(", ")).toString());
                }
                if (notExpectedColumns.nonEmpty()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(22).append("Not expected columns: ").append(notExpectedColumns.mkString(", ")).toString());
                }
                File notExpectedPath = new File(testFolder.jfile(), new StringBuilder(16).append("not_expected").append(assertDatum.expectationName()).append(".csv").toString());
                File missingPath = new File(testFolder.jfile(), new StringBuilder(11).append("missing").append(assertDatum.expectationName()).append(".csv").toString());
                if (missingColumns.isEmpty() && notExpectedColumns.isEmpty()) {
                    boolean missingSuccess = MODULE$.outputTableDifferences(conn, targetDomain, targetTable, (StarlakeTestData)assertDatum, missingPath, MODULE$.expectationQuery(targetDomain, targetTable, (StarlakeTestData)assertDatum, true));
                    boolean notExpectedSuccess = MODULE$.outputTableDifferences(conn, targetDomain, assertTable, (StarlakeTestData)assertDatum, notExpectedPath, MODULE$.expectationQuery(targetDomain, targetTable, (StarlakeTestData)assertDatum, false));
                    success = notExpectedSuccess && missingSuccess;
                } else {
                    Files.write(notExpectedPath.toPath(), "number of columns does not match. Not expected data could not be computed".getBytes(), new OpenOption[0]);
                    Files.write(missingPath.toPath(), "number of columns does not match. Missing data could not be computed".getBytes(), new OpenOption[0]);
                    success = false;
                }
                String missingData = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(missingPath.toPath())).asScala()).mkString("\n");
                String notExpectedData = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(notExpectedPath.toPath())).asScala()).mkString("\n");
                return new StarlakeTestResult(testFolder.path(), targetDomain, targetTable, taskName, testFolder.name(), assertDatum.expectationName(), (List<String>)missingColumns, (List<String>)notExpectedColumns, missingPath, notExpectedPath, success, (Option<String>)None$.MODULE$, duration);
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                StarlakeTestResult result = (StarlakeTestResult)success.value();
                return result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                return new StarlakeTestResult(testFolder.path(), targetDomain, targetTable, taskName, testFolder.name(), assertDatum.expectationName(), (List<String>)Nil$.MODULE$, (List<String>)Nil$.MODULE$, new File(""), new File(""), false, (Option<String>)new Some((Object)Utils$.MODULE$.exceptionAsString(e)), duration);
            }
            throw new MatchError((Object)try_);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StarlakeTestResult.class)));
    }

    private void execute(Connection conn, String sql) {
        Statement stmt = conn.createStatement();
        Predef$.MODULE$.println((Object)sql);
        stmt.execute(sql);
        stmt.close();
    }

    private Tuple2<Statement, ResultSet> executeQuery(Connection conn, String sql) {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        return new Tuple2((Object)stmt, (Object)rs);
    }

    public Tuple2<List<StarlakeTestResult>, StarlakeTestCoverage> runTransforms(Tuple3<List<StarlakeTestData>, List<Tuple2<String, Tuple2<List<StarlakeTestData>, List<Tuple2<String, Tuple2<List<StarlakeTestData>, List<Tuple2<String, StarlakeTest>>>>>>>>, List<Tuple2<String, String>>> dataAndTests, StarlakeTestConfig config, Settings originalSettings) {
        File rootFolder = (File)config.outputDir().flatMap((Function1 & Serializable & scala.Serializable)dir -> {
            File file = new File((String)dir);
            if (file.exists() || file.mkdirs()) {
                return Option$.MODULE$.apply((Object)file);
            }
            Console$.MODULE$.err().println(new StringBuilder(34).append("Could not create output directory ").append((String)dir).toString());
            return None$.MODULE$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new File(originalSettings.appConfig().root(), "test-reports"));
        Directory testsFolder = new Directory(new File(rootFolder, "transform"));
        return this.run(dataAndTests, (Function3<StarlakeTest, String, Settings, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(test, testName, settings) -> {
            StarlakeTestData$.runner$1(test, testName, settings, config);
            return BoxedUnit.UNIT;
        }, testsFolder, originalSettings);
    }

    public Tuple2<List<StarlakeTestResult>, StarlakeTestCoverage> runLoads(Tuple3<List<StarlakeTestData>, List<Tuple2<String, Tuple2<List<StarlakeTestData>, List<Tuple2<String, Tuple2<List<StarlakeTestData>, List<Tuple2<String, StarlakeTest>>>>>>>>, List<Tuple2<String, String>>> dataAndTests, StarlakeTestConfig config, Settings originalSettings) {
        File rootFolder = (File)config.outputDir().flatMap((Function1 & Serializable & scala.Serializable)dir -> {
            File file = new File((String)dir);
            if (file.exists() || file.mkdirs()) {
                return Option$.MODULE$.apply((Object)file);
            }
            Console$.MODULE$.err().println(new StringBuilder(34).append("Could not create output directory ").append((String)dir).toString());
            return None$.MODULE$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new File(originalSettings.appConfig().root(), "test-reports"));
        Directory testsFolder = new Directory(new File(rootFolder, "load"));
        return this.run(dataAndTests, (Function3<StarlakeTest, String, Settings, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(test, testName, settings) -> {
            StarlakeTestData$.runner$2(test, testName, settings, config);
            return BoxedUnit.UNIT;
        }, testsFolder, originalSettings);
    }

    public Tuple2<List<StarlakeTestResult>, StarlakeTestCoverage> run(Tuple3<List<StarlakeTestData>, List<Tuple2<String, Tuple2<List<StarlakeTestData>, List<Tuple2<String, Tuple2<List<StarlakeTestData>, List<Tuple2<String, StarlakeTest>>>>>>>>, List<Tuple2<String, String>>> dataAndTests, Function3<StarlakeTest, String, Settings, BoxedUnit> runner, Directory testsFolder, Settings originalSettings) {
        Class.forName("org.duckdb.DuckDBDriver");
        testsFolder.deleteRecursively();
        testsFolder.createDirectory(true, false);
        Tuple3<List<StarlakeTestData>, List<Tuple2<String, Tuple2<List<StarlakeTestData>, List<Tuple2<String, Tuple2<List<StarlakeTestData>, List<Tuple2<String, StarlakeTest>>>>>>>>, List<Tuple2<String, String>>> tuple3 = dataAndTests;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        List rootData = (List)tuple3._1();
        List tests = (List)tuple3._2();
        List domainsAndTables = (List)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)rootData, (Object)tests, (Object)domainsAndTables);
        List rootData2 = (List)tuple32._1();
        List tests2 = (List)tuple32._2();
        List domainsAndTables2 = (List)tuple32._3();
        List testResults = (List)tests2.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String domainName = (String)tuple2._1();
                Tuple2 dataAndTables = (Tuple2)tuple2._2();
                Directory domainFolder = new Directory(new File(testsFolder.jfile(), domainName));
                Tuple2 tuple22 = dataAndTables;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                List domainData = (List)tuple22._1();
                List tables = (List)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)domainData, (Object)tables);
                List domainData2 = (List)tuple23._1();
                List tables2 = (List)tuple23._2();
                return (List)tables2.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String tableName = (String)tuple2._1();
                        Tuple2 dataAndTests = (Tuple2)tuple2._2();
                        Directory tableFolder = new Directory(new File(domainFolder.jfile(), tableName));
                        Tuple2 tuple22 = dataAndTests;
                        if (tuple22 == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        List taskData = (List)tuple22._1();
                        List tests = (List)tuple22._2();
                        Tuple2 tuple23 = new Tuple2((Object)taskData, (Object)tests);
                        List taskData2 = (List)tuple23._1();
                        List tests2 = (List)tuple23._2();
                        return (List)tests2.flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> new ArrayOps.ofRef(StarlakeTestData$.$anonfun$run$3(tableFolder, originalSettings, domainName, rootData2, domainData2, taskData2, runner, tableName, x0$3)), List$.MODULE$.canBuildFrom());
                    }
                    throw new MatchError((Object)tuple2);
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        Set testedDomains = ((TraversableOnce)testResults.map((Function1 & Serializable & scala.Serializable)result -> result.domainName(), List$.MODULE$.canBuildFrom())).toSet();
        Set testedTables = ((TraversableOnce)testResults.map((Function1 & Serializable & scala.Serializable)result -> new StringBuilder(1).append(result.domainName()).append(".").append(result.tableName()).toString(), List$.MODULE$.canBuildFrom())).toSet();
        List untestedDomains = (List)((List)domainsAndTables2.filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)StarlakeTestData$.$anonfun$run$15(testedDomains, x0$4)))).map((Function1 & Serializable & scala.Serializable)x$22 -> (String)x$22._1(), List$.MODULE$.canBuildFrom());
        List untestedTables = (List)((TraversableLike)domainsAndTables2.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 != null) {
                String domain = (String)tuple2._1();
                String table = (String)tuple2._2();
                return new StringBuilder(1).append(domain).append(".").append(table).toString();
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)table -> BoxesRunTime.boxToBoolean((boolean)StarlakeTestData$.$anonfun$run$18(testedTables, table)));
        StarlakeTestCoverage coverage = new StarlakeTestCoverage((Set<String>)testedDomains, (Set<String>)testedTables, (List<String>)untestedDomains, (List<String>)untestedTables);
        return new Tuple2((Object)testResults, (Object)coverage);
    }

    public void drop(List<Tuple2<String, List<Tuple2<String, List<Tuple2<String, StarlakeTest>>>>>> tests, Connection conn, Settings settings) {
        tests.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StarlakeTestData$.$anonfun$drop$1(conn, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public List<StarlakeTestData> rootTestData(boolean load, Settings settings) {
        Path path = load ? DatasetArea$.MODULE$.loadTests(settings) : DatasetArea$.MODULE$.transformTests(settings);
        File testDir = new File(path.toString());
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)testDir.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.isFile())))).toList().flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(MODULE$.testDataFromCsvOrJsonFile("", "", (File)f, "", "", settings)), List$.MODULE$.canBuildFrom());
    }

    public List<String> domainNames(boolean load, Settings settings) {
        return (List)this.domainFolders(load, settings).map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.getName(), List$.MODULE$.canBuildFrom());
    }

    public List<File> domainFolders(boolean load, Settings settings) {
        Path path = load ? DatasetArea$.MODULE$.loadTests(settings) : DatasetArea$.MODULE$.transformTests(settings);
        File testDir = new File(path.toString());
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)testDir.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)x$25.isDirectory())))).toList();
    }

    public List<File> taskOrTableFolders(File domainFolder) {
        return (List)Option$.MODULE$.apply((Object)domainFolder.listFiles(x$26 -> x$26.isDirectory())).map((Function1 & Serializable & scala.Serializable)x$27 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$27)).toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public List<String> taskOrTableNames(boolean load, String domainName, Settings settings) {
        Path path = load ? DatasetArea$.MODULE$.loadTests(settings) : DatasetArea$.MODULE$.transformTests(settings);
        File domainFolder = new File(path.toString(), domainName);
        return (List)this.taskOrTableFolders(domainFolder).map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.getName(), List$.MODULE$.canBuildFrom());
    }

    public List<File> testFolders(File taskOrTableFolder) {
        return (List)Option$.MODULE$.apply((Object)taskOrTableFolder.listFiles(x$29 -> x$29.isDirectory())).map((Function1 & Serializable & scala.Serializable)x$30 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$30)).toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public List<File> testFolders(boolean load, String domainName, String taskOrTableName, Settings settings) {
        Path path = load ? DatasetArea$.MODULE$.loadTests(settings) : DatasetArea$.MODULE$.transformTests(settings);
        File domainFolder = new File(path.toString(), domainName);
        File taskOrTableFolder = new File(domainFolder, taskOrTableName);
        return this.testFolders(taskOrTableFolder);
    }

    public List<String> testNames(boolean load, String domainName, String taskOrTableName, Settings settings) {
        return (List)this.testFolders(load, domainName, taskOrTableName, settings).map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.getName(), List$.MODULE$.canBuildFrom());
    }

    public List<StarlakeTestData> domainTestData(File domainFolder, Settings settings) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)domainFolder.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)x$32.isFile())))).toList().flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(MODULE$.testDataFromCsvOrJsonFile("", "", (File)f, domainFolder.getName(), "", settings)), List$.MODULE$.canBuildFrom());
    }

    public List<StarlakeTestData> domainTestData(boolean load, String domainName, Settings settings) {
        Path path = load ? DatasetArea$.MODULE$.loadTests(settings) : DatasetArea$.MODULE$.transformTests(settings);
        File domainFolder = new File(path.toString(), domainName);
        return this.domainTestData(domainFolder, settings);
    }

    public List<StarlakeTestData> taskOrTableTestData(File taskOrTableFolder, String domainName, String tableOrTaskName, Settings settings) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)taskOrTableFolder.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)x$33.isFile())))).toList().flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(MODULE$.testDataFromCsvOrJsonFile("", "", (File)f, domainName, tableOrTaskName, settings)), List$.MODULE$.canBuildFrom());
    }

    public List<StarlakeTestData> taskOrTableTestData(boolean load, String domainName, String taskOrTableName, Settings settings) {
        Path path = load ? DatasetArea$.MODULE$.loadTests(settings) : DatasetArea$.MODULE$.transformTests(settings);
        File domainFolder = new File(path.toString(), domainName);
        File taskOrTableFolder = new File(domainFolder, taskOrTableName);
        return this.taskOrTableTestData(taskOrTableFolder, domainName, taskOrTableName, settings);
    }

    public Tuple3<List<StarlakeTestData>, List<Tuple2<String, Tuple2<List<StarlakeTestData>, List<Tuple2<String, Tuple2<List<StarlakeTestData>, List<Tuple2<String, StarlakeTest>>>>>>>>, List<Tuple2<String, String>>> loadTests(boolean load, String thisDomainName, String thisTaskOrTableName, String onlyThisTest, Settings settings) {
        SchemaHandler schemaHandler = settings.schemaHandler(settings.schemaHandler$default$1(), settings.schemaHandler$default$2());
        List filteredDomainFolders = (List)this.domainFolders(load, settings).filter((Function1 & Serializable & scala.Serializable)domainDir -> BoxesRunTime.boxToBoolean((boolean)StarlakeTestData$.$anonfun$loadTests$1(thisDomainName, domainDir)));
        List allTests = (List)filteredDomainFolders.map((Function1 & Serializable & scala.Serializable)domainFolder -> {
            List filteredTaskOrTableFolders = (List)MODULE$.taskOrTableFolders((File)domainFolder).filter((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)StarlakeTestData$.$anonfun$loadTests$3(thisTaskOrTableName, x$34)));
            List domainTests = (List)filteredTaskOrTableFolders.map((Function1 & Serializable & scala.Serializable)taskOrTableFolder -> {
                List filteredTestFolders = (List)MODULE$.testFolders((File)taskOrTableFolder).filter((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)StarlakeTestData$.$anonfun$loadTests$5(onlyThisTest, x$35)));
                List taskOrTableTests = (List)filteredTestFolders.flatMap((Function1 & Serializable & scala.Serializable)testFolder -> Option$.MODULE$.option2Iterable(MODULE$.loadTest(schemaHandler, (File)testFolder, settings).map((Function1 & Serializable & scala.Serializable)test -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testFolder.getName()), test))), List$.MODULE$.canBuildFrom());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)taskOrTableFolder.getName()), (Object)new Tuple2(MODULE$.taskOrTableTestData((File)taskOrTableFolder, domainFolder.getName(), taskOrTableFolder.getName(), settings), (Object)taskOrTableTests));
            }, List$.MODULE$.canBuildFrom());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)domainFolder.getName()), (Object)new Tuple2(MODULE$.domainTestData((File)domainFolder, settings), (Object)domainTests));
        }, List$.MODULE$.canBuildFrom());
        List domainAndTables = load ? (List)schemaHandler.domains(schemaHandler.domains$default$1(), schemaHandler.domains$default$2(), schemaHandler.domains$default$3(), schemaHandler.domains$default$4()).flatMap((Function1 & Serializable & scala.Serializable)dom -> (List)dom.tables().map((Function1 & Serializable & scala.Serializable)table -> new Tuple2((Object)dom.name(), (Object)table.name()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()) : (List)schemaHandler.tasks(schemaHandler.tasks$default$1()).map((Function1 & Serializable & scala.Serializable)task -> new Tuple2((Object)task.domain(), (Object)task.name()), List$.MODULE$.canBuildFrom());
        return new Tuple3(this.rootTestData(load, settings), (Object)allTests, (Object)domainAndTables);
    }

    public Option<StarlakeTest> loadTest(SchemaHandler schemaHandler, boolean load, String domainName, String taskOrTableName, String testName, Settings settings) {
        Path path = load ? DatasetArea$.MODULE$.loadTests(settings) : DatasetArea$.MODULE$.transformTests(settings);
        File domainFolder = new File(path.toString(), domainName);
        File taskOrTableFolder = new File(domainFolder, taskOrTableName);
        File testFolder = new File(taskOrTableFolder, testName);
        Option<StarlakeTest> test = this.loadTest(schemaHandler, testFolder, settings);
        return test;
    }

    public Option<StarlakeTest> loadTest(SchemaHandler schemaHandler, File testFolder, Settings settings) {
        Option table;
        File taskOrTableFolder = testFolder.getParentFile();
        String taskOrTableFolderName = taskOrTableFolder.getName();
        File domainFolder = taskOrTableFolder.getParentFile();
        String domainName = domainFolder.getName();
        File rootFolder = domainFolder.getParentFile();
        List preTestStatementsFiles = (List)((List)((List)StarlakeTestData$.listFilesInFolder$1(rootFolder).$plus$plus((GenTraversableOnce)StarlakeTestData$.listFilesInFolder$1(domainFolder), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)StarlakeTestData$.listFilesInFolder$1(taskOrTableFolder), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)StarlakeTestData$.listFilesInFolder$1(testFolder), List$.MODULE$.canBuildFrom());
        List preTestStatements = (List)preTestStatementsFiles.flatMap((Function1 & Serializable & scala.Serializable)preTestStatementsFile -> {
            if (preTestStatementsFile.exists()) {
                BufferedSource source = Source$.MODULE$.fromFile(preTestStatementsFile, Codec$.MODULE$.fallbackSystemCodec());
                String sql = source.mkString();
                source.close();
                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)new StarlakePreTestScript(preTestStatementsFile.getPath(), sql)));
            }
            return Nil$.MODULE$;
        }, List$.MODULE$.canBuildFrom());
        List testDataFiles = (List)Option$.MODULE$.apply((Object)testFolder.listFiles(f -> f.isFile() && !f.getName().startsWith("_expected"))).map((Function1 & Serializable & scala.Serializable)x$36 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$36)).toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        StarlakeTestData[] testExpectationsData = this.expectationsTestData(schemaHandler, testFolder, settings);
        Object task = (table = schemaHandler.tableOnly(new StringBuilder(1).append(domainName).append(".").append(taskOrTableFolderName).toString()).toOption().map((Function1 & Serializable & scala.Serializable)x$37 -> x$37.table())).isDefined() ? None$.MODULE$ : schemaHandler.taskOnly(new StringBuilder(1).append(domainName).append(".").append(taskOrTableFolderName).toString(), schemaHandler.taskOnly$default$2()).toOption();
        Tuple2 tuple2 = new Tuple2((Object)table, task);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Schema table2 = (Schema)some.value();
                if (None$.MODULE$.equals(option2)) {
                    List preloadFiles = (List)testDataFiles.filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)StarlakeTestData$.$anonfun$loadTest$7(domainName, taskOrTableFolderName, path)));
                    List preloadTestData = (List)testDataFiles.flatMap((Function1 & Serializable & scala.Serializable)dataPath -> Option$.MODULE$.option2Iterable(MODULE$.testDataFromCsvOrJsonFile(testFolder.getName(), "", (File)dataPath, domainName, taskOrTableFolderName, settings)), List$.MODULE$.canBuildFrom());
                    Tuple2 tuple22 = ((TraversableLike)preloadTestData.filter((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)x$38.incoming()))).partition((Function1 & Serializable & scala.Serializable)incoming -> BoxesRunTime.boxToBoolean((boolean)StarlakeTestData$.$anonfun$loadTest$10(table2, incoming)));
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    List matchingPatternData = (List)tuple22._1();
                    List unmatchingPatternData = (List)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)matchingPatternData, (Object)unmatchingPatternData);
                    List matchingPatternData2 = (List)tuple23._1();
                    List unmatchingPatternData2 = (List)tuple23._2();
                    if (unmatchingPatternData2.nonEmpty()) {
                        String testName = testFolder.getName();
                        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Load Test ").append(domainName).append(".").append(taskOrTableFolderName).append(".").append(testName).append(" has unmatched load files: ").append(((TraversableOnce)unmatchingPatternData2.map((Function1 & Serializable & scala.Serializable)x$40 -> x$40.filename(), List$.MODULE$.canBuildFrom())).mkString(", ")).toString());
                    }
                    List matchingPatternFiles = (List)matchingPatternData2.map((Function1 & Serializable & scala.Serializable)m -> new File(testFolder, new StringBuilder(10).append("_incoming.").append(m.filename()).toString()), List$.MODULE$.canBuildFrom());
                    return new Some((Object)new StarlakeTest(new StringBuilder(1).append(domainName).append(".").append(taskOrTableFolderName).toString(), domainName, taskOrTableFolderName, testExpectationsData, (List<StarlakeTestData>)preloadTestData, (List<File>)matchingPatternFiles, (List<StarlakePreTestScript>)preTestStatements));
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                Some some = (Some)option3;
                AutoTaskDesc task2 = (AutoTaskDesc)some.value();
                List testDataList = (List)testDataFiles.flatMap((Function1 & Serializable & scala.Serializable)dataPath -> Option$.MODULE$.option2Iterable(MODULE$.testDataFromCsvOrJsonFile(testFolder.getName(), "", (File)dataPath, domainName, taskOrTableFolderName, settings)), List$.MODULE$.canBuildFrom());
                return new Some((Object)new StarlakeTest(new StringBuilder(1).append(domainName).append(".").append(taskOrTableFolderName).toString(), task2.domain(), task2.table(), testExpectationsData, (List<StarlakeTestData>)testDataList, (List<File>)Nil$.MODULE$, (List<StarlakePreTestScript>)preTestStatements));
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (option instanceof Some && option4 instanceof Some) {
                Predef$.MODULE$.println((Object)new StringBuilder(75).append("Table / Task ").append(domainName).append(".").append(taskOrTableFolderName).append(" found in tasks load and transform. Please rename one of them").toString());
                return None$.MODULE$;
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option5 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option5)) {
                Predef$.MODULE$.println((Object)new StringBuilder(24).append("Table / Task ").append(domainName).append(".").append(taskOrTableFolderName).append(" not found").toString());
                return None$.MODULE$;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public StarlakeTestData[] expectationsTestData(SchemaHandler schemaHandler, boolean load, String domainName, String taskOrTableName, String testName, Settings settings) {
        Path path = load ? DatasetArea$.MODULE$.loadTests(settings) : DatasetArea$.MODULE$.transformTests(settings);
        File domainFolder = new File(path.toString(), domainName);
        File taskOrTableFolder = new File(domainFolder, taskOrTableName);
        File testFolder = new File(taskOrTableFolder, testName);
        return this.expectationsTestData(schemaHandler, testFolder, settings);
    }

    public StarlakeTestData[] expectationsTestData(SchemaHandler schemaHandler, File testFolder, Settings settings) {
        String domainName = testFolder.getParentFile().getParentFile().getName();
        return (StarlakeTestData[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)testFolder.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))))).flatMap((Function1 & Serializable & scala.Serializable)f -> {
            boolean isExpectationDataFile;
            String filename = f.getName();
            boolean bl = isExpectationDataFile = f.isFile() && filename.startsWith("_expected") && (filename.endsWith(".json") || f.getName().endsWith(".csv"));
            if (isExpectationDataFile) {
                String expectationName = filename.substring("_expected".length(), filename.lastIndexOf(46));
                String expectedCreateTable = MODULE$.loadDataAsCreateTableExpression(schemaHandler, domainName, new StringBuilder(11).append("sl_expected").append(expectationName).toString(), (File)f, settings);
                if (expectationName.isEmpty()) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new StarlakeTestData(domainName, "sl_expected", expectedCreateTable, (Option<String>)new Some((Object)"*"), expectationName, filename, MODULE$.apply$default$7())));
                }
                File expectationSqlFile = new File(testFolder, new StringBuilder(13).append("_expected").append(expectationName).append(".sql").toString());
                if (expectationSqlFile.exists()) {
                    BufferedSource source = Source$.MODULE$.fromFile(expectationSqlFile, Codec$.MODULE$.fallbackSystemCodec());
                    String sql = source.mkString();
                    source.close();
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new StarlakeTestData(domainName, new StringBuilder(11).append("sl_expected").append(expectationName).toString(), expectedCreateTable, (Option<String>)new Some((Object)sql), expectationName, filename, MODULE$.apply$default$7())));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StarlakeTestData.class)));
    }

    /*
     * Unable to fully structure code
     */
    private String loadDataAsCreateTableExpression(SchemaHandler schemaHandler, String domainName, String tableName, File dataFile, Settings settings) {
        table = schemaHandler.tableOnly(new StringBuilder(1).append(domainName).append(".").append(tableName).toString()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$loadDataAsCreateTableExpression$1(ai.starlake.schema.model.TableDesc ), (Lai/starlake/schema/model/TableDesc;)Lai/starlake/schema/model/Schema;)()).toOption();
        var9_7 = false;
        var10_8 = null;
        var11_9 = table;
        if (!(var11_9 instanceof Some)) ** GOTO lbl-1000
        var9_7 = true;
        var10_8 = (Some)var11_9;
        table = (Schema)var10_8.value();
        if (table.isFlat()) {
            fields = table.ddlMapping("duckdb", schemaHandler);
            cols = ((TraversableOnce)fields.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$loadDataAsCreateTableExpression$2(ai.starlake.schema.model.DDLField ), (Lai/starlake/schema/model/DDLField;)Ljava/lang/String;)(), List$.MODULE$.canBuildFrom())).mkString(", ");
            v0 = firstLine = dataFile.getName().endsWith("json") != false ? Files.readAllLines(Paths.get(dataFile.toString(), new String[0]), StandardCharsets.UTF_8).get(0).trim() : "";
            extraArgs = firstLine.startsWith("[") != false ? "(FORMAT JSON, ARRAY true)" : (dataFile.getName().endsWith("csv") != false ? new StringBuilder(24).append("(FORMAT CSV, nullstr '").append(settings.appConfig().testCsvNullString()).append("')").toString() : "");
            v1 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("CREATE OR REPLACE TABLE \"").append(domainName).append("\".\"").append(tableName).append("\" (").append(cols).append(");\n                 |COPY \"").append(domainName).append("\".\"").append(tableName).append("\" FROM '").append(dataFile.toString()).append("' ").append(extraArgs).append(";").toString())).stripMargin();
        } else if (var9_7 && !(table = (Schema)var10_8.value()).isFlat()) {
            v1 = new StringBuilder(58).append("ERROR: Nested tables are not supported in tests => table ").append(domainName).append(".").append(table).toString();
        } else if (None$.MODULE$.equals(var11_9)) {
            source = dataFile.getName().endsWith("csv") != false ? new StringBuilder(41).append("read_csv('").append(dataFile.toString()).append("', header = true, nullstr = '").append(schemaHandler.activeEnvVars(schemaHandler.activeEnvVars$default$1(), schemaHandler.activeEnvVars$default$2(), schemaHandler.activeEnvVars$default$3()).getOrElse((Object)"SL_CSV_NULLSTR", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$loadDataAsCreateTableExpression$3(), ()Ljava/lang/String;)())).append("')").toString() : new StringBuilder(2).append("'").append(dataFile.toString()).append("'").toString();
            v1 = new StringBuilder(44).append("CREATE OR REPLACE TABLE ").append(domainName).append(".").append(tableName).append(" AS SELECT * FROM ").append(source).append(";").toString();
        } else {
            throw new MatchError((Object)var11_9);
        }
        expectedCreateTable = v1;
        return expectedCreateTable;
    }

    private Option<StarlakeTestData> testDataFromCsvOrJsonFile(String testName, String expectationName, File dataPath, String domainName, String taskOrTableName, Settings settings) {
        boolean filterOK;
        String dataName = dataPath.getName();
        if (dataName.startsWith("_incoming.")) {
            return new Some((Object)new StarlakeTestData(domainName, taskOrTableName, "", (Option<String>)None$.MODULE$, expectationName, dataPath.getName().substring("_incoming.".length()), true));
        }
        String[] components = new StringOps(Predef$.MODULE$.augmentString(dataName)).split('.');
        boolean bl = filterOK = components.length == 3;
        if (filterOK) {
            String testDataDomainName = components[0];
            String testDataTableName = components[1];
            String ext = components[2];
            boolean extOK = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"json", "csv"}))).contains((Object)ext);
            if (extOK) {
                SchemaHandler schemaHandler = settings.schemaHandler(settings.schemaHandler$default$1(), settings.schemaHandler$default$2());
                String dataAsCreateTableExpression = this.loadDataAsCreateTableExpression(schemaHandler, testDataDomainName, testDataTableName, dataPath, settings);
                return new Some((Object)new StarlakeTestData(testDataDomainName, testDataTableName, dataAsCreateTableExpression, (Option<String>)None$.MODULE$, expectationName, dataPath.getName(), this.apply$default$7()));
            }
            return None$.MODULE$;
        }
        if (dataName.endsWith(".sql")) {
            BufferedSource source = Source$.MODULE$.fromFile(dataPath, Codec$.MODULE$.fallbackSystemCodec());
            String sql = source.mkString("\n");
            source.close();
            return new Some((Object)new StarlakeTestData(domainName, taskOrTableName, "", (Option<String>)new Some((Object)sql), expectationName, dataPath.getName(), this.apply$default$7()));
        }
        return None$.MODULE$;
    }

    public StarlakeTestData apply(String domain, String table, String createTableExpression, Option<String> expectationAsSql, String expectationName, String filename, boolean incoming) {
        return new StarlakeTestData(domain, table, createTableExpression, expectationAsSql, expectationName, filename, incoming);
    }

    public boolean apply$default$7() {
        return false;
    }

    public Option<Tuple7<String, String, String, Option<String>, String, String, Object>> unapply(StarlakeTestData x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)x$0.domain(), (Object)x$0.table(), (Object)x$0.createTableExpression(), x$0.expectationAsSql(), (Object)x$0.expectationName(), (Object)x$0.filename(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.incoming())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final void runner$1(StarlakeTest test, String testName, Settings settings, StarlakeTestConfig config$1) {
        String[] params = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"transform", "--test", "--name", test.name()})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config$1.toArgs())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        StorageHandler storage = settings.storageHandler(settings.storageHandler$default$1());
        Map testEnvVars = ((MapLike)EnvDesc$.MODULE$.loadEnv(new Path(DatasetArea$.MODULE$.tests(settings), "env.sl.yml"), storage).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.env()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)EnvDesc$.MODULE$.loadEnv(new Path(DatasetArea$.MODULE$.tests(settings), new StringBuilder(21).append("transform/").append(test.domain()).append("/env.sl.yml").toString()), storage).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.env()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)EnvDesc$.MODULE$.loadEnv(new Path(DatasetArea$.MODULE$.tests(settings), new StringBuilder(22).append("transform/").append(test.domain()).append("/").append(test.table()).append("/env.sl.yml").toString()), storage).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.env()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)EnvDesc$.MODULE$.loadEnv(new Path(DatasetArea$.MODULE$.tests(settings), new StringBuilder(23).append("transform/").append(test.domain()).append("/").append(test.table()).append("/").append(testName).append("/env.sl.yml").toString()), storage).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.env()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()));
        SchemaHandler schemaHandler = settings.schemaHandler((Map<String, String>)testEnvVars, true);
        Try<Object> try_ = new Main().run(params, schemaHandler, settings);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw e;
        }
        if (try_ instanceof Success) {
            return;
        }
        throw new MatchError(try_);
    }

    private static final void runner$2(StarlakeTest test, String testName, Settings settings, StarlakeTestConfig config$2) {
        Option tmpDir = test.incomingFiles().headOption().map((Function1 & Serializable & scala.Serializable)incomingFile -> {
            Directory tmpDir = new Directory(new File(incomingFile.getParentFile(), "tmp"));
            tmpDir.deleteRecursively();
            tmpDir.createDirectory(true, tmpDir.createDirectory$default$2());
            return tmpDir.toFile();
        });
        String[] params = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"load", "--test", "--domains", test.domain(), "--tables", test.table()})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--files", ((TraversableOnce)test.incomingFiles().flatMap((Function1 & Serializable & scala.Serializable)incomingFile -> Option$.MODULE$.option2Iterable(tmpDir.map((Function1 & Serializable & scala.Serializable)tmpDir -> {
            File tmpFile = new File(tmpDir.toString(), incomingFile.getName().substring("_incoming.".length()));
            return Files.copy(incomingFile.toPath(), tmpFile.toPath(), new CopyOption[0]).toFile().toString();
        })), List$.MODULE$.canBuildFrom())).mkString(",")})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config$2.toArgs())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        StorageHandler storage = settings.storageHandler(settings.storageHandler$default$1());
        Map testEnvVars = ((MapLike)EnvDesc$.MODULE$.loadEnv(new Path(DatasetArea$.MODULE$.tests(settings), "env.sl.yml"), storage).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.env()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)EnvDesc$.MODULE$.loadEnv(new Path(DatasetArea$.MODULE$.tests(settings), new StringBuilder(16).append("load/").append(test.domain()).append("/env.sl.yml").toString()), storage).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.env()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)EnvDesc$.MODULE$.loadEnv(new Path(DatasetArea$.MODULE$.tests(settings), new StringBuilder(17).append("load/").append(test.domain()).append("/").append(test.table()).append("/env.sl.yml").toString()), storage).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.env()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)EnvDesc$.MODULE$.loadEnv(new Path(DatasetArea$.MODULE$.tests(settings), new StringBuilder(18).append("load/").append(test.domain()).append("/").append(test.table()).append("/").append(testName).append("/env.sl.yml").toString()), storage).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.env()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()));
        SchemaHandler schemaHandler = settings.schemaHandler((Map<String, String>)testEnvVars, true);
        Try<Object> try_ = new Main().run(params, schemaHandler, settings);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            tmpDir.foreach((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.deleteRecursively()));
            throw e;
        }
        if (try_ instanceof Success) {
            tmpDir.foreach((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.deleteRecursively()));
            return;
        }
        throw new MatchError(try_);
    }

    public static final /* synthetic */ void $anonfun$run$5(String domainName$1, List rootData$1, List domainData$1, List taskData$1, StarlakeTest test$1, Connection conn) {
        MODULE$.createSchema(domainName$1, conn);
        rootData$1.foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            x$18.load(conn);
            return BoxedUnit.UNIT;
        });
        domainData$1.foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            x$19.load(conn);
            return BoxedUnit.UNIT;
        });
        taskData$1.foreach((Function1 & Serializable & scala.Serializable)x$20 -> {
            x$20.load(conn);
            return BoxedUnit.UNIT;
        });
        test$1.load(conn);
    }

    public static final /* synthetic */ Object[] $anonfun$run$3(Directory tableFolder$1, Settings originalSettings$3, String domainName$1, List rootData$1, List domainData$1, List taskData$1, Function3 runner$3, String tableName$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Success result;
            String testName = (String)tuple2._1();
            StarlakeTest test = (StarlakeTest)tuple2._2();
            Directory testFolder = new Directory(new File(tableFolder$1.jfile(), testName));
            testFolder.deleteRecursively();
            testFolder.createDirectory(true, testFolder.createDirectory$default$2());
            String dbFilename = new File(testFolder.jfile(), new StringBuilder(3).append(testName).append(".db").toString()).getPath();
            Settings settings = MODULE$.createDuckDbSettings(originalSettings$3, dbFilename);
            Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> DriverManager.getConnection(new StringBuilder(12).append("jdbc:duckdb:").append(dbFilename).toString()), (Function1 & Serializable & scala.Serializable)conn -> {
                StarlakeTestData$.$anonfun$run$5(domainName$1, rootData$1, domainData$1, taskData$1, test, conn);
                return BoxedUnit.UNIT;
            });
            long start = System.currentTimeMillis();
            Success success = result = test.incomingFiles().isEmpty() ? new Success((Object)BoxedUnit.UNIT) : Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> runner$3.apply((Object)test, (Object)testName, (Object)settings));
            if (success instanceof Failure) {
                Failure failure = (Failure)success;
                Throwable e = failure.exception();
                long end = System.currentTimeMillis();
                Predef$.MODULE$.println((Object)new StringBuilder(24).append("Test ").append(domainName$1).append(".").append(tableName$1).append(".").append(testName).append(" failed to run (").append(e.getMessage()).append(")").toString());
                return Predef$.MODULE$.refArrayOps((Object[])new StarlakeTestResult[]{new StarlakeTestResult(testFolder.path(), domainName$1, tableName$1, test.getTaskName(), testName, "", (List<String>)Nil$.MODULE$, (List<String>)Nil$.MODULE$, new File(""), new File(""), false, (Option<String>)new Some((Object)Utils$.MODULE$.exceptionAsString(e)), end - start)});
            }
            if (success instanceof Success) {
                long end = System.currentTimeMillis();
                StarlakeTestResult[] compareResult = (StarlakeTestResult[])Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> DriverManager.getConnection(new StringBuilder(12).append("jdbc:duckdb:").append(dbFilename).toString()), (Function1 & Serializable & scala.Serializable)conn -> MODULE$.compareResults(testFolder, test.domain(), test.table(), test.getTaskName(), test.expectations(), (Connection)conn, end - start));
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compareResult)).forall((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)x$21.success()))) {
                    Predef$.MODULE$.println((Object)new StringBuilder(17).append("Test ").append(domainName$1).append(".").append(tableName$1).append(".").append(testName).append(" succeeded").toString());
                } else {
                    Predef$.MODULE$.println((Object)new StringBuilder(14).append("Test ").append(domainName$1).append(".").append(tableName$1).append(".").append(testName).append(" failed").toString());
                }
                return Predef$.MODULE$.refArrayOps((Object[])compareResult);
            }
            throw new MatchError((Object)success);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$run$15(Set testedDomains$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            String domain = (String)tuple2._1();
            return !testedDomains$1.contains((Object)domain);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$run$18(Set testedTables$1, String table) {
        return !testedTables$1.contains((Object)table);
    }

    public static final /* synthetic */ void $anonfun$drop$3(Connection conn$6, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            StarlakeTest test = (StarlakeTest)tuple2._2();
            test.data().foreach((Function1 & Serializable & scala.Serializable)d -> {
                StarlakeTestData$.MODULE$.dropSchema(d.domain(), conn$6);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$drop$2(Connection conn$6, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            List tests = (List)tuple2._2();
            tests.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                StarlakeTestData$.$anonfun$drop$3(conn$6, x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$drop$1(Connection conn$6, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String domainName = (String)tuple2._1();
            List tables = (List)tuple2._2();
            MODULE$.dropSchema(domainName, conn$6);
            tables.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                StarlakeTestData$.$anonfun$drop$2(conn$6, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$loadTests$1(String thisDomainName$1, File domainDir) {
        if (thisDomainName$1.isEmpty()) return true;
        String string = thisDomainName$1;
        String string2 = domainDir.getName();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = thisDomainName$1;
        String string4 = "*";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$loadTests$3(String thisTaskOrTableName$1, File x$34) {
        if (thisTaskOrTableName$1.isEmpty()) return true;
        String string = thisTaskOrTableName$1;
        String string2 = x$34.getName();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = thisTaskOrTableName$1;
        String string4 = "*";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$loadTests$5(String onlyThisTest$1, File x$35) {
        if (onlyThisTest$1.isEmpty()) return true;
        String string = onlyThisTest$1;
        String string2 = x$35.getName();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = onlyThisTest$1;
        String string4 = "*";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final List listFilesInFolder$1(File folder) {
        if (folder.exists()) {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])folder.listFiles(f -> f.isFile() && !f.getName().startsWith("_") && f.getName().endsWith(".sql")))).toList();
        }
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$loadTest$7(String domainName$3, String taskOrTableFolderName$1, File path) {
        String name = path.getName();
        return name.equals(new StringBuilder(6).append(domainName$3).append(".").append(taskOrTableFolderName$1).append(".json").toString()) || name.equals(new StringBuilder(5).append(domainName$3).append(".").append(taskOrTableFolderName$1).append(".csv").toString());
    }

    public static final /* synthetic */ boolean $anonfun$loadTest$10(Schema table$1, StarlakeTestData incoming) {
        String name = incoming.filename();
        return table$1.pattern().matcher(name).matches();
    }

    public static final /* synthetic */ Schema $anonfun$loadDataAsCreateTableExpression$1(TableDesc x$41) {
        return x$41.table();
    }

    public static final /* synthetic */ String $anonfun$loadDataAsCreateTableExpression$2(DDLField x0$1) {
        DDLField dDLField = x0$1;
        if (dDLField instanceof DDLLeaf) {
            DDLLeaf dDLLeaf = (DDLLeaf)dDLField;
            return new StringBuilder(3).append("\"").append(dDLLeaf.name()).append("\" ").append(dDLLeaf.tpe()).toString();
        }
        throw new MatchError((Object)dDLField);
    }

    public static final /* synthetic */ String $anonfun$loadDataAsCreateTableExpression$3() {
        return "null";
    }

    private StarlakeTestData$() {
        MODULE$ = this;
    }
}

