/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils;

import ai.starlake.config.Settings;
import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import better.files.File;
import better.files.File$;
import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class GcpUtils$ {
    public static GcpUtils$ MODULE$;
    private final String WELL_KNOWN_CREDENTIALS_FILE;
    private final String CLOUDSDK_CONFIG_DIRECTORY;

    static {
        new GcpUtils$();
    }

    private String WELL_KNOWN_CREDENTIALS_FILE() {
        return this.WELL_KNOWN_CREDENTIALS_FILE;
    }

    private String CLOUDSDK_CONFIG_DIRECTORY() {
        return this.CLOUDSDK_CONFIG_DIRECTORY;
    }

    public Option<File> getApplicationDefaultFile() {
        Option credentialsPath = package$.MODULE$.env().get((Object)"GOOGLE_APPLICATION_CREDENTIALS");
        return credentialsPath.map((Function1 & Serializable & scala.Serializable)x$1 -> File$.MODULE$.apply(x$1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<File> applicationDefaultFile = MODULE$.getWellKnownCredentialsFile();
            return applicationDefaultFile;
        });
    }

    public Option<File> getWellKnownCredentialsFile() {
        File file;
        String os = System.getProperty("os.name", "").toLowerCase(Locale.US);
        if (os.indexOf("windows") >= 0) {
            File appDataPath = File$.MODULE$.apply(System.getenv("APPDATA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            file = File$.MODULE$.apply(appDataPath, this.CLOUDSDK_CONFIG_DIRECTORY(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        } else {
            File configPath = File$.MODULE$.apply(System.getProperty("user.home", ""), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".config"}));
            file = File$.MODULE$.apply(configPath, this.CLOUDSDK_CONFIG_DIRECTORY(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        }
        File cloudConfigPath = file;
        File credentialFilePath = File$.MODULE$.apply(cloudConfigPath, this.WELL_KNOWN_CREDENTIALS_FILE(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (credentialFilePath.exists(credentialFilePath.exists$default$1())) {
            return new Some((Object)credentialFilePath);
        }
        return None$.MODULE$;
    }

    public Map<String, Object> adapt_map_to_gcp_log(Map<String, Object> log) {
        Object object = GcpUtils$.adapt_values$1(log);
        if (object instanceof Map) {
            Map map = (Map)object;
            return map;
        }
        throw new RuntimeException(new StringBuilder(36).append("Expected type Map[String, Any], got ").append(object.getClass().getSimpleName()).toString());
    }

    public void sinkToGcpCloudLogging(Map<String, Object> log, String typ, String logName, Settings settings) {
        try (Logging logging = (Logging)((LoggingOptions.Builder)LoggingOptions.getDefaultInstance().toBuilder().setProjectId(BigQueryJobBase$.MODULE$.projectId(settings.appConfig().audit().database()))).build().getService();){
            LogEntry entry = LogEntry.newBuilder((Payload)Payload.JsonPayload.of((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.adapt_map_to_gcp_log(log)).asJava()))).setSeverity(Severity.INFO).addLabel("type", typ).addLabel("app", "starlake").setLogName(logName).setResource(MonitoredResource.newBuilder((String)"global").build()).build();
            logging.write(Collections.singleton(entry), new Logging.WriteOption[0]);
            logging.flush();
        }
    }

    private static final Object adapt_values$1(Object value2) {
        if (value2 != null) {
            Object object = value2;
            if (object instanceof Map) {
                Map map = (Map)object;
                return map.iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)(k != null ? k.toString() : (String)k)), GcpUtils$.adapt_values$1(v));
                    }
                    throw new MatchError((Object)tuple2);
                }).toMap(Predef$.MODULE$.$conforms());
            }
            if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                return iterable.map((Function1 & Serializable & scala.Serializable)value -> GcpUtils$.adapt_values$1(value), Iterable$.MODULE$.canBuildFrom());
            }
            if (object instanceof String ? true : (object instanceof Boolean ? true : object instanceof Number)) {
                return value2;
            }
            if (value2.getClass().isEnum()) {
                return value2;
            }
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                return BoxesRunTime.boxToLong((long)timestamp.getTime());
            }
            return value2.toString();
        }
        return value2;
    }

    private GcpUtils$() {
        MODULE$ = this;
        this.WELL_KNOWN_CREDENTIALS_FILE = "application_default_credentials.json";
        this.CLOUDSDK_CONFIG_DIRECTORY = "gcloud";
    }
}

