/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils;

import ai.starlake.job.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JarUtil$ {
    public static JarUtil$ MODULE$;

    static {
        new JarUtil$();
    }

    public List<String> getResourceFiles(String path) throws IOException {
        ListBuffer filenames;
        block2: {
            block1: {
                filenames = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                File jarFile = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                if (!jarFile.isFile()) break block1;
                JarFile jar = new JarFile(jarFile);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || !name.startsWith(path)) continue;
                    filenames.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
                }
                jar.close();
                break block2;
            }
            URL url = Main.class.getResource(new StringBuilder(1).append("/").append(path).toString());
            if (url == null) break block2;
            File apps = new File(url.toURI());
            String pathWithSlash = path.endsWith("/") ? path : new StringBuilder(1).append(path).append("/").toString();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])apps.listFiles())).foreach((Function1 & Serializable & scala.Serializable)app -> {
                JarUtil$.$anonfun$getResourceFiles$1(pathWithSlash, filenames, app);
                return BoxedUnit.UNIT;
            });
        }
        return filenames.toList();
    }

    public List<String> getResourceFolders(String path) throws IOException {
        ListBuffer filenames;
        block4: {
            block3: {
                int pathLevel = new StringOps(Predef$.MODULE$.augmentString(path)).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JarUtil$.$anonfun$getResourceFolders$1(BoxesRunTime.unboxToChar((Object)x$2))));
                int pathLen = path.length();
                filenames = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                File jarFile = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                if (!jarFile.isFile()) break block3;
                JarFile jar = new JarFile(jarFile);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    int nameLevel = new StringOps(Predef$.MODULE$.augmentString(name)).count((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JarUtil$.$anonfun$getResourceFolders$2(BoxesRunTime.unboxToChar((Object)x$3))));
                    if (nameLevel != pathLevel + 1 || !entry.isDirectory() || !name.startsWith(path)) continue;
                    filenames.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name.substring(pathLen, name.length() - 1)}));
                }
                jar.close();
                break block4;
            }
            URL url = Main.class.getResource(new StringBuilder(1).append("/").append(path).toString());
            if (url == null) break block4;
            try {
                File apps = new File(url.toURI());
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])apps.listFiles())).foreach((Function1 & Serializable & scala.Serializable)app -> {
                    filenames.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{app.getName()}));
                    return BoxedUnit.UNIT;
                });
            }
            catch (URISyntaxException ex) {}
        }
        return filenames.toList();
    }

    private boolean isDirectory(String name) {
        URL resource = this.getContextClassLoader().getResource(new StringBuilder(1).append(name).append("/").toString());
        if (resource.getProtocol().equals("file")) {
            return !name.contains(".");
        }
        return resource != null;
    }

    private InputStream getResourceAsStream(String resourceName) {
        InputStream in = this.getContextClassLoader().getResourceAsStream(resourceName);
        if (in == null) {
            return this.getClass().getResourceAsStream(resourceName);
        }
        return in;
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void main(String[] args) {
        List<String> folders = this.getResourceFolders("bootstrap/samples/templates/");
        folders.foreach((Function1 & Serializable & scala.Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getResourceFiles$1(String pathWithSlash$1, ListBuffer filenames$1, File app) {
        if (app.isDirectory()) {
            MODULE$.getResourceFiles(new StringBuilder(0).append(pathWithSlash$1).append(app.getName()).toString()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                filenames$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$1}));
                return BoxedUnit.UNIT;
            });
            return;
        }
        filenames$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(pathWithSlash$1).append(app.getName()).toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$getResourceFolders$1(char x$2) {
        return x$2 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$getResourceFolders$2(char x$3) {
        return x$3 == '/';
    }

    private JarUtil$() {
        MODULE$ = this;
    }
}

