/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils;

import ai.starlake.config.Settings;
import ai.starlake.extract.JdbcDbUtils$;
import ai.starlake.sql.SQLUtils$;
import com.manticore.jsqlformatter.JSQLFormatter;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SparkUtils$
implements StrictLogging {
    public static SparkUtils$ MODULE$;
    private final Logger logger;

    static {
        new SparkUtils$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public StructType added(StructType incoming, StructType existing) {
        Set incomingFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])incoming.fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        Set existingFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existing.fields())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name().toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        Set newFields = (Set)incomingFields.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SparkUtils$.$anonfun$added$3(existingFields, f)));
        StructField[] fields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])incoming.fields())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)newFields.contains((Object)f.name())));
        return new StructType(fields);
    }

    public StructType dropped(StructType incoming, StructType existing) {
        Set incomingFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])incoming.fields())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name().toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        Set existingFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existing.fields())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        Set deletedFields = (Set)existingFields.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SparkUtils$.$anonfun$dropped$3(incomingFields, f)));
        StructField[] fields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existing.fields())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)deletedFields.contains((Object)f.name())));
        return new StructType(fields);
    }

    public Seq<String> alterTableDropColumnsString(StructType fields, String tableName) {
        Seq dropFields = (Seq)fields.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Seq$.MODULE$.canBuildFrom());
        return (Seq)dropFields.map((Function1 & Serializable & scala.Serializable)dropColumn -> new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append((String)dropColumn).toString(), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> alterTableAddColumnsString(StructType allFields, String tableName, Map<String, String> attributesWithDDLType) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFields.fields())).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> Option$.MODULE$.option2Iterable(MODULE$.alterTableAddColumnString((StructField)x$6, tableName, attributesWithDDLType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toIndexedSeq();
    }

    public Option<String> alterTableAddColumnString(StructField field, String tableName, Map<String, String> attributesWithDDLType) {
        String addField = field.name();
        DataType addFieldType = field.dataType();
        Option addJdbcType = attributesWithDDLType.get((Object)addField).orElse((Function0 & Serializable & scala.Serializable)() -> JdbcDbUtils$.MODULE$.getCommonJDBCType(addFieldType).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.databaseTypeDefinition()));
        String nullable = "";
        return addJdbcType.map((Function1 & Serializable & scala.Serializable)jdbcType -> new StringBuilder(26).append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(addField).append(" ").append((String)jdbcType).append(" ").append(nullable).toString());
    }

    public void updateJdbcTableSchema(Connection conn, Map<String, String> jdbcOptions, String domainAndTableName, StructType sparkSchema, Map<String, String> attributesWithDDLType) {
        String url = (String)jdbcOptions.apply((Object)"url");
        if (this.isFlat(sparkSchema)) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Option<StructType> existingSchema = this.getSchemaOption(conn, jdbcOptions, domainAndTableName);
            StructType addedSchema = this.added(sparkSchema, (StructType)existingSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> sparkSchema));
            StructType deletedSchema = this.dropped(sparkSchema, (StructType)existingSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> sparkSchema));
            Seq<String> alterTableDropColumns = this.alterTableDropColumnsString(deletedSchema, domainAndTableName);
            if (alterTableDropColumns.nonEmpty()) {
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("alter table {} with {} columns to drop", new Object[]{domainAndTableName, BoxesRunTime.boxToInteger((int)alterTableDropColumns.size())});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("alter table {}", new Object[]{alterTableDropColumns.mkString("\n")});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Seq<String> alterTableAddColumns = this.alterTableAddColumnsString(addedSchema, domainAndTableName, attributesWithDDLType);
            if (alterTableAddColumns.nonEmpty()) {
                BoxedUnit boxedUnit4;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("alter table {} with {} columns to add", new Object[]{domainAndTableName, BoxesRunTime.boxToInteger((int)alterTableAddColumns.size())});
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("alter table {}", new Object[]{alterTableAddColumns.mkString("\n")});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            alterTableDropColumns.foreach((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JdbcDbUtils$.MODULE$.executeAlterTable(x$8, conn)));
            alterTableAddColumns.foreach((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JdbcDbUtils$.MODULE$.executeAlterTable(x$9, conn)));
            return;
        }
    }

    public Option<StructType> getSchemaOption(Connection conn, Map<String, String> options, String table) {
        None$ none$;
        JdbcDialect dialect = this.dialect((String)options.apply((Object)"url"));
        boolean preferTimestampNTZ = BoxesRunTime.unboxToBoolean((Object)options.get((Object)JDBCOptions$.MODULE$.JDBC_PREFER_TIMESTAMP_NTZ()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SparkUtils$.$anonfun$getSchemaOption$1(x$10))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            AtomicType atomicType = SQLConf$.MODULE$.get().timestampType();
            TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
            return !(atomicType != null ? !atomicType.equals(timestampNTZType$) : timestampNTZType$ != null);
        }));
        try (PreparedStatement statement = conn.prepareStatement(dialect.getSchemaQuery(table));){
            try {
                ResultSet x$1 = statement.executeQuery();
                JdbcDialect x$2 = dialect;
                boolean x$3 = preferTimestampNTZ;
                boolean x$4 = JdbcUtils$.MODULE$.getSchema$default$3();
                Some some = new Some((Object)JdbcUtils$.MODULE$.getSchema(x$1, x$2, x$4, x$3));
                none$ = some;
            }
            catch (SQLException sQLException) {
                none$ = None$.MODULE$;
            }
        }
        catch (SQLException sQLException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void createSchema(SparkSession session, String domain) {
        this.sql(session, new StringBuilder(28).append("CREATE SCHEMA IF NOT EXISTS ").append(domain).toString());
    }

    public void truncateTable(SparkSession session, String tableName) {
        this.sql(session, new StringBuilder(15).append("TRUNCATE TABLE ").append(tableName).toString());
    }

    public void createTable(Connection conn, String domainAndTableName, StructType schema, boolean caseSensitive, JdbcOptionsInWrite options, Map<String, Map<String, String>> attrDdlMapping, Settings settings) {
        block8: {
            Statement statement = conn.createStatement();
            JdbcDialect jdbcDialect = this.dialect(options.url());
            String strSchema = this.schemaString(schema, caseSensitive, options.url(), attrDdlMapping, 0, settings);
            try {
                BoxedUnit boxedUnit;
                statement.setQueryTimeout(options.queryTimeout());
                String createTableOptions = options.createTableOptions();
                String finalStrSchema = new StringOps(Predef$.MODULE$.augmentString((String)options.parameters().getOrElse((Object)"quoteIdentifiers", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean() ? strSchema : strSchema.replaceAll("\"", "");
                String domainName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(domainAndTableName)).split('.'))).head();
                statement.executeUpdate(new StringBuilder(28).append("CREATE SCHEMA IF NOT EXISTS ").append(domainName).toString());
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Creating table {} with schema {} and options {}", new Object[]{domainAndTableName, finalStrSchema, createTableOptions});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                statement.executeUpdate(new StringBuilder(17).append("CREATE TABLE ").append(domainAndTableName).append(" (").append(finalStrSchema).append(") ").append(createTableOptions).toString());
                if (!new StringOps(Predef$.MODULE$.augmentString(options.tableComment())).nonEmpty()) break block8;
                try {
                    String tableCommentQuery = jdbcDialect.getTableCommentQuery(domainAndTableName, options.tableComment());
                    statement.executeUpdate(tableCommentQuery);
                }
                catch (Exception e) {
                    BoxedUnit boxedUnit2;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Cannot create JDBC table comment. The table comment will be ignored.");
                        boxedUnit2 = BoxedUnit.UNIT;
                        break block8;
                    }
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            }
            finally {
                statement.close();
            }
        }
    }

    public boolean isFlat(StructType fields) {
        boolean deep = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields.fields())).exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SparkUtils$.$anonfun$isFlat$1(x$11)));
        return !deep;
    }

    public JdbcDialect dialect(String url) {
        BoxedUnit boxedUnit;
        String reworkedUrl = url.replace("jdbc:redshift", "jdbc:postgresql").replace("jdbc:as400", "jdbc:db2").replace("mariadb", "mysql");
        JdbcDialect jdbcDialect = JdbcDialects$.MODULE$.get(reworkedUrl);
        String string = jdbcDialect.getClass().getSimpleName();
        String string2 = "NoopDialect$";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("No dialect found for {}, falling back to default one", new Object[]{url});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("JDBC dialect {}", new Object[]{jdbcDialect});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return jdbcDialect;
    }

    private Option<String> getDescription(StructField field) {
        Option comment = !field.getComment().isEmpty() ? field.getComment() : (field.metadata().contains("description") ? Option$.MODULE$.apply((Object)field.metadata().getString("description")) : None$.MODULE$);
        return comment;
    }

    public String schemaString(StructType schema, boolean caseSensitive, String url, Map<String, Map<String, String>> createTableColumnTypes, int level, Settings settings) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("SchemaString of {}", new Object[]{schema});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        createTableColumnTypes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkUtils$.$anonfun$schemaString$1(x0$1);
            return BoxedUnit.UNIT;
        });
        Matcher dialectPattern = Pattern.compile("jdbc:([a-zA-Z]+):.*").matcher(url);
        Predef$.MODULE$.assert(dialectPattern.find());
        String dialectName = dialectPattern.group(1);
        Settings.JdbcEngine jdbcEng = (Settings.JdbcEngine)settings.appConfig().jdbcEngines().apply((Object)dialectName);
        String urlForRedshiftAndDuckDb = url.replace("jdbc:redshift:", "jdbc:postgresql:").replace("jdbc:duckdb:", "jdbc:postgresql:");
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(urlForRedshiftAndDuckDb);
        CaseInsensitiveMap typMap = caseSensitive ? createTableColumnTypes : CaseInsensitiveMap$.MODULE$.apply(createTableColumnTypes);
        String[] columns = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).flatMap(arg_0 -> SparkUtils$.$anonfun$schemaString$2(level, (Map)typMap, dialectName, dialect, jdbcEng, caseSensitive, url, (Map)createTableColumnTypes, settings, arg_0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).mkString(", ");
    }

    public Map<String, Map<String, String>> schemaString$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public Dataset<Row> sql(SparkSession session, String sql) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        String formattedSQL = SQLUtils$.MODULE$.format(sql, JSQLFormatter.OutputFormat.PLAIN);
        String sqlId = UUID.randomUUID().toString();
        try {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Executing statement with id {}:\n {}", new Object[]{sqlId, formattedSQL});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            dataset = session.sql(sql);
        }
        catch (Exception e) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error when executing statement id {}", new Object[]{sqlId});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            e.printStackTrace();
            throw e;
        }
        Dataset result = dataset;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Successfully executed statement id {}", new Object[]{sqlId});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$added$3(Set existingFields$1, String f) {
        return !existingFields$1.contains((Object)f.toLowerCase());
    }

    public static final /* synthetic */ boolean $anonfun$dropped$3(Set incomingFields$1, String f) {
        return !incomingFields$1.contains((Object)f.toLowerCase());
    }

    public static final /* synthetic */ boolean $anonfun$getSchemaOption$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$isFlat$1(StructField x$11) {
        return x$11.dataType() instanceof StructType;
    }

    public static final /* synthetic */ void $anonfun$schemaString$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            Map v = (Map)tuple2._2();
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("Column {} has DDL types {}", new Object[]{k, v});
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Iterable $anonfun$schemaString$2(int level$1, Map typMap$1, String dialectName$1, JdbcDialect dialect$1, Settings.JdbcEngine jdbcEng$1, boolean caseSensitive$1, String url$1, Map createTableColumnTypes$1, Settings settings$1, StructField field) {
        Some some;
        String nullable = !field.nullable() && level$1 == 0 ? "NOT NULL" : "";
        String description = level$1 == 0 ? (String)MODULE$.getDescription(field).map((Function1 & Serializable & scala.Serializable)d -> new StringBuilder(10).append("COMMENT '").append((String)d).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "") : "";
        Option ddlTyp = typMap$1.get((Object)field.name()).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.get((Object)dialectName$1));
        String quotedFieldName = dialect$1.quoteIdentifier(field.name());
        DataType dataType = field.dataType();
        String name = field.name();
        if (BoxesRunTime.unboxToBoolean((Object)jdbcEng$1.supportsJson().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            String string;
            Tuple2 tuple2;
            Tuple2 tuple22;
            DataType dataType2 = dataType;
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                tuple22 = new Tuple2((Object)arrayType.elementType(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                tuple22 = tuple2 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType elementType = (DataType)tuple2._1();
            boolean repeated = tuple2._2$mcZ$sp();
            Tuple2 tuple23 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)repeated));
            DataType elementType2 = (DataType)tuple23._1();
            boolean repeated2 = tuple23._2$mcZ$sp();
            DataType dataType3 = elementType2;
            if (dataType3 instanceof StructType) {
                StructType structType = (StructType)dataType3;
                String fields = MODULE$.schemaString(structType, caseSensitive$1, url$1, (Map<String, Map<String, String>>)createTableColumnTypes$1, level$1 + 1, settings$1);
                string = repeated2 ? new StringBuilder(11).append(name).append(" STRUCT(").append(fields).append(")[]").toString() : new StringBuilder(9).append(name).append(" STRUCT(").append(fields).append(")").toString();
            } else if (dataType3 instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType3;
                string = repeated2 ? new StringBuilder(13).append(name).append(" DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")[]").toString() : new StringBuilder(12).append(name).append(" DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(") ").append(nullable).toString();
            } else {
                String typ = (String)ddlTyp.getOrElse((Function0 & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.getJdbcType(field.dataType(), dialect$1).databaseTypeDefinition());
                string = typ.endsWith("[]") ? new StringBuilder(1).append(quotedFieldName).append(" ").append(typ).toString() : (repeated2 ? new StringBuilder(3).append(quotedFieldName).append(" ").append(typ).append("[]").toString() : new StringBuilder(2).append(quotedFieldName).append(" ").append(typ).append(" ").append(nullable).toString());
            }
            String element = string;
            some = new Some((Object)element);
        } else {
            if (dataType instanceof StructType || dataType instanceof ArrayType) {
                throw new IllegalArgumentException("Array and nested struct types are not supported in the schema for this database");
            }
            String typ = (String)ddlTyp.getOrElse((Function0 & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.getJdbcType(field.dataType(), dialect$1).databaseTypeDefinition());
            some = new Some((Object)new StringBuilder(1).append(quotedFieldName).append(" ").append(typ).toString());
        }
        Some column = some;
        return Option$.MODULE$.option2Iterable((Option)column);
    }

    private SparkUtils$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

