/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils;

import ai.starlake.config.Settings;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Severity$Error$;
import ai.starlake.schema.model.ValidationMessage;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.schema.model.WriteMode$APPEND$;
import ai.starlake.schema.model.WriteMode$OVERWRITE$;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.HadoopModule;
import ai.starlake.utils.JinjaResourceHandler;
import ai.starlake.utils.StorageLevelModule;
import ai.starlake.utils.Utils;
import better.files.File;
import better.files.File$;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.loader.ResourceLocator;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Mirrors;
import scala.reflect.api.Symbols;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessLogger;
import scala.sys.process.ProcessLogger$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class Utils$
implements StrictLogging {
    public static Utils$ MODULE$;
    private Jinjava _jinjava;
    private final Logger logger;

    static {
        new Utils$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("close", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public static Method reflMethod$Method2(Class x$1) {
        CallSite methodCache2 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method2 = methodCache2.find(x$1);
        if (method2 != null) {
            return method2;
        }
        method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("close", methodCache2.parameterTypes()));
        methodCache2.add(x$1, method2);
        return method2;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public <T, V> V withResources(Function0<T> r, Function1<T, V> f) {
        Object object;
        Object resource = r.apply();
        Predef$.MODULE$.require(resource != null, (Function0 & Serializable & scala.Serializable)() -> "resource is null");
        Throwable exception = null;
        try {
            try {
                object = f.apply(resource);
            }
            catch (Throwable e) {
                exception = e;
                throw e;
            }
        }
        finally {
            this.closeAndAddSuppressed(exception, resource);
        }
        return (V)object;
    }

    public <T> T loadInstance(String objectName) {
        JavaUniverse.JavaMirror runtimeMirror = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        Symbols.ModuleSymbolApi module = ((Mirror)runtimeMirror).staticModule(objectName);
        Mirrors.ModuleMirror obj = runtimeMirror.reflectModule(module);
        return (T)obj.instance();
    }

    private void closeAndAddSuppressed(Throwable e, Object resource) {
        if (e != null) {
            e.printStackTrace();
            try {
                Object qual1 = resource;
                try {
                    Utils$.reflMethod$Method1(qual1.getClass()).invoke(qual1, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable suppressed = (Throwable)option.get();
                    e.addSuppressed(suppressed);
                }
                throw throwable;
            }
            return;
        }
        Object qual2 = resource;
        try {
            Utils$.reflMethod$Method2(qual2.getClass()).invoke(qual2, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public <T> Try<T> logFailure(Try<T> attempt, Logger logger) {
        Try<T> try_ = attempt;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            return success;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logException(logger, exception);
            return failure;
        }
        throw new MatchError(try_);
    }

    public <T> boolean throwFailure(Try<T> attempt, Logger logger) {
        Try<T> try_ = attempt;
        if (try_ instanceof Success) {
            return true;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logException(logger, exception);
            throw exception;
        }
        throw new MatchError(try_);
    }

    public void logException(Logger logger, Throwable exception) {
        BoxedUnit boxedUnit;
        if (logger.underlying().isErrorEnabled()) {
            logger.underlying().error(this.exceptionAsString(exception));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String exceptionAsString(Throwable exception) {
        StringWriter sw = new StringWriter();
        exception.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public Tuple2<String, String> getDBDisposition(WriteMode writeMode) {
        Tuple2 tuple2;
        WriteMode writeMode2 = writeMode;
        Tuple2 tuple22 = ((Object)WriteMode$OVERWRITE$.MODULE$).equals(writeMode2) ? new Tuple2((Object)"CREATE_IF_NEEDED", (Object)"WRITE_TRUNCATE") : (tuple2 = ((Object)WriteMode$APPEND$.MODULE$).equals(writeMode2) ? new Tuple2((Object)"CREATE_IF_NEEDED", (Object)"WRITE_APPEND") : new Tuple2((Object)"CREATE_IF_NEEDED", (Object)"WRITE_TRUNCATE"));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String createDisposition = (String)tuple2._1();
        String writeDisposition = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)createDisposition, (Object)writeDisposition);
        String createDisposition2 = (String)tuple23._1();
        String writeDisposition2 = (String)tuple23._2();
        return new Tuple2((Object)createDisposition2, (Object)writeDisposition2);
    }

    public String subst(String value, scala.collection.immutable.Map<String, String> params) {
        List paramsList = params.toList();
        List paramKeys = (List)paramsList.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                return name;
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        List paramValues = (List)paramsList.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String value = (String)tuple2._2();
                return value;
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        List allParams = (List)paramKeys.zip((GenIterable)paramValues, List$.MODULE$.canBuildFrom());
        return (String)allParams.foldLeft((Object)value, (Function2 & Serializable & scala.Serializable)(x0$3, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$3, x1$1);
            if (tuple2 != null) {
                String acc = (String)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String p = (String)tuple22._1();
                    String v = (String)tuple22._2();
                    return new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(6).append("\\b(").append(p).append(")\\b").toString())).r().replaceAllIn((CharSequence)acc, v);
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public scala.collection.immutable.Map<String, Object> toMap(List<Attribute> attributes) {
        return ((TraversableOnce)attributes.map((Function1 & Serializable & scala.Serializable)attribute -> {
            List<Attribute> list = attribute.attributes();
            if (Nil$.MODULE$.equals(list)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attribute.name()), attribute);
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attribute.name()), MODULE$.toMap(list));
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Either<List<ValidationMessage>, Object> duplicates(String target, List<String> values, String errorMessage) {
        ListBuffer errorList = (ListBuffer)ListBuffer$.MODULE$.empty();
        scala.collection.immutable.Map duplicates = (scala.collection.immutable.Map)values.groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$duplicates$3(x0$1)));
        duplicates.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                int size = tuple2._2$mcI$sp();
                return errorList.$plus$eq((Object)new ValidationMessage(Severity$Error$.MODULE$, target, new StringOps(Predef$.MODULE$.augmentString(errorMessage)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToInteger((int)size)}))));
            }
            throw new MatchError((Object)tuple2);
        });
        if (errorList.nonEmpty()) {
            return scala.package$.MODULE$.Left().apply((Object)errorList.toList());
        }
        return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public Either<List<ValidationMessage>, Object> combine(Either<List<ValidationMessage>, Object> errors1, Seq<Either<List<ValidationMessage>, Object>> errors2) {
        Either<List<ValidationMessage>, Object> either = errors1;
        List allErrors = List$.MODULE$.apply(errors2).$colon$colon(either);
        List errors = (List)((GenericTraversableTemplate)allErrors.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Either<List<ValidationMessage>, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Left) {
                    Left left = (Left)A1;
                    List err = (List)left.value();
                    return (B1)err;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Either<List<ValidationMessage>, Object> x1) {
                Either<List<ValidationMessage>, Object> either = x1;
                return either instanceof Left;
            }
        }, List$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        if (errors.isEmpty()) {
            return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        return scala.package$.MODULE$.Left().apply((Object)errors);
    }

    public Set<Tuple2<String, String>> extractTags(Set<String> tags) {
        return (Set)tags.map((Function1 & Serializable & scala.Serializable)tag -> {
            boolean hasValue = tag.indexOf(61) > 0;
            String[] keyValuePAir = hasValue ? new StringOps(Predef$.MODULE$.augmentString(tag)).split('=') : (String[])((Object[])new String[]{tag, ""});
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)keyValuePAir[0]), (Object)keyValuePAir[1]);
        }, Set$.MODULE$.canBuildFrom());
    }

    public boolean isDeltaAvailable() {
        boolean bl;
        try {
            Class.forName("io.delta.tables.DeltaTable");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public boolean isRunningInDatabricks() {
        return scala.sys.package$.MODULE$.env().contains((Object)"DATABRICKS_RUNTIME_VERSION");
    }

    public scala.collection.immutable.Map<String, String> labels(Set<String> tags) {
        return ((TraversableOnce)tags.map((Function1 & Serializable & scala.Serializable)tag -> {
            String[] labelValue = tag.split("=");
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labelValue)).size() == 1) {
                return new Tuple2((Object)labelValue[0], (Object)"");
            }
            return new Tuple2((Object)labelValue[0], (Object)labelValue[1]);
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Jinjava jinjava(Settings settings) {
        block4: {
            Jinjava jinjava;
            if (this._jinjava() != null) break block4;
            ClassLoader curClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                JinjavaConfig config = JinjavaConfig.newBuilder().withFailOnUnknownTokens(false).withNestedInterpretationEnabled(false).build();
                jinjava = new Jinjava(config);
            }
            finally {
                Thread.currentThread().setContextClassLoader(curClassLoader);
            }
            Jinjava res = jinjava;
            res.setResourceLocator((ResourceLocator)new JinjaResourceHandler(settings));
            this._jinjava_$eq(res);
        }
        return this._jinjava();
    }

    private Jinjava _jinjava() {
        return this._jinjava;
    }

    private void _jinjava_$eq(Jinjava x$1) {
        this._jinjava = x$1;
    }

    public void resetJinjaClassLoader() {
        this._jinjava_$eq(null);
    }

    public String parseJinja(String str, scala.collection.immutable.Map<String, Object> params, Settings settings) {
        return (String)this.parseJinja((List<String>)new .colon.colon((Object)str, (List)Nil$.MODULE$), params, settings).head();
    }

    public List<String> parseJinja(List<String> str, scala.collection.immutable.Map<String, Object> params, Settings settings) {
        List result = (List)str.map((Function1 & Serializable & scala.Serializable)sql -> Formatter$.MODULE$.RichFormatter(MODULE$.jinjava(settings).render(sql, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)params).asJava())).richFormat(params, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty(), settings).trim(), List$.MODULE$.canBuildFrom());
        return result;
    }

    public String parseJinjaTpl(String templateContent, scala.collection.immutable.Map<String, Object> params, Settings settings) {
        return this.parseJinja(templateContent, params, settings);
    }

    public ObjectMapper newYamlMapper() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return this.setMapperProperties(mapper);
    }

    public ObjectMapper newJsonMapper() {
        ObjectMapper mapper = new ObjectMapper();
        return this.setMapperProperties(mapper);
    }

    public ObjectMapper setMapperProperties(ObjectMapper mapper) {
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$).registerModule((Module)new HadoopModule()).registerModule((Module)new StorageLevelModule()).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setDefaultSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.AS_EMPTY, (Nulls)Nulls.AS_EMPTY));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public String keepAlphaNum(String domain) {
        return domain.replaceAll("[^\\p{Alnum}]", "_");
    }

    public void dot2Svg(Option<File> outputFile, String str) {
        this.dot2Format(outputFile, str, "svg");
    }

    public void dot2Png(Option<File> outputFile, String str) {
        this.dot2Format(outputFile, str, "png");
    }

    public void save(Option<File> outputFile, String result) {
        Option<File> option = outputFile;
        if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println((Object)result);
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            File outputFile2 = (File)some.value();
            File qual$1 = outputFile2.parent();
            Seq x$1 = qual$1.createDirectories$default$1();
            Seq x$2 = qual$1.createDirectories$default$2();
            qual$1.createDirectories(x$1, x$2);
            String x$3 = result;
            Seq x$4 = outputFile2.overwrite$default$2(x$3);
            Charset x$5 = outputFile2.overwrite$default$3(x$3);
            outputFile2.overwrite(x$3, x$4, x$5);
            return;
        }
        throw new MatchError(option);
    }

    private void dot2Format(Option<File> outputFile, String str, String format) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            File file;
            String x$1 = "graph_";
            String x$2 = ".dot.tmp";
            Option x$3 = File$.MODULE$.newTemporaryFile$default$3();
            Seq x$42 = File$.MODULE$.newTemporaryFile$default$4(x$1, x$2, x$3);
            File dotFile = File$.MODULE$.newTemporaryFile(x$1, x$2, x$3, x$42);
            String x$52 = str;
            Seq x$6 = dotFile.write$default$2(x$52);
            Charset x$7 = dotFile.write$default$3(x$52);
            dotFile.write(x$52, x$6, x$7);
            Option option = outputFile;
            if (option instanceof Some) {
                Some some = (Some)option;
                File outputFile = (File)some.value();
                File qual$1 = outputFile.parent();
                Seq x$8 = qual$1.createDirectories$default$1();
                Seq x$9 = qual$1.createDirectories$default$2();
                qual$1.createDirectories(x$8, x$9);
                file = outputFile;
            } else if (None$.MODULE$.equals(option)) {
                String x$10 = "graph_";
                String x$11 = ".svg.tmp";
                Option x$12 = File$.MODULE$.newTemporaryFile$default$3();
                Seq x$13 = File$.MODULE$.newTemporaryFile$default$4(x$10, x$11, x$12);
                file = File$.MODULE$.newTemporaryFile(x$10, x$11, x$12, x$13);
            } else {
                throw new MatchError((Object)option);
            }
            File svgFile = file;
            StringBuilder stdout = new StringBuilder();
            StringBuilder stderr = new StringBuilder();
            ProcessLogger logger = ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$4 -> {
                stdout.append(x$4);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)x$5 -> {
                stderr.append(x$5);
                return BoxedUnit.UNIT;
            });
            ProcessBuilder p = Process$.MODULE$.apply(new java.lang.StringBuilder(12).append("dot -T").append(format).append(" ").append(dotFile.pathAsString()).append("  -o ").append(svgFile.pathAsString()).toString());
            int exitCode = p.run(logger).exitValue();
            if (exitCode != 0) {
                throw new Exception(new java.lang.StringBuilder(154).append("\n          ").append(stdout.toString()).append("\n          ").append(stderr.toString()).append("\n          Exited with status code ").append(exitCode).append(".\n          --> Please make sure that GraphViz is installed and available in your PATH\n          ").toString());
            }
            dotFile.delete(false, dotFile.delete$default$2());
            Option option2 = outputFile;
            if (None$.MODULE$.equals(option2)) {
                Predef$.MODULE$.println((Object)svgFile.contentAsString(svgFile.contentAsString$default$1()));
                return svgFile.delete(false, svgFile.delete$default$2());
            }
            if (option2 instanceof Some) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option2);
        });
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new java.lang.StringBuilder(81).append("Error while converting dot to ").append(format).append(". Please make sure you installed the GraphViz tool.").toString(), new Object[]{this.exceptionAsString(e)});
                return;
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    public scala.collection.immutable.Map<String, String> redact(scala.collection.immutable.Map<String, String> options) {
        return (scala.collection.immutable.Map)options.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                if (key.toLowerCase().contains("password")) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)"********");
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Try<Utils.CommandOutput> runCommand(Seq<String> cmd, scala.collection.immutable.Map<String, String> extraEnv) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info(cmd.mkString(" "));
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            ByteArrayOutputStream stdoutStream = new ByteArrayOutputStream();
            ByteArrayOutputStream stderrStream = new ByteArrayOutputStream();
            int exitValue = MODULE$.runCommand(cmd, extraEnv, stdoutStream, stderrStream);
            String output = stdoutStream.toString();
            String error = stderrStream.toString();
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info(output);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (exitValue != 0) {
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error(error);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new Utils.CommandOutput(exitValue, output, error);
        });
    }

    public Try<Utils.CommandOutput> runCommand(Seq<String> cmd, scala.collection.immutable.Map<String, String> extraEnv, File outFile, File errFile) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Utils.CommandOutput commandOutput;
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info(cmd.mkString(" "));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            OutputStream stdoutStream = outFile.newOutputStream(outFile.newOutputStream$default$1());
            OutputStream stderrStream = errFile.newOutputStream(errFile.newOutputStream$default$1());
            try {
                try {
                    int exitValue = MODULE$.runCommand(cmd, extraEnv, stdoutStream, stderrStream);
                    commandOutput = new Utils.CommandOutput(exitValue, outFile.name(), errFile.name());
                }
                catch (Exception e) {
                    BoxedUnit boxedUnit2;
                    if (MODULE$.logger().underlying().isErrorEnabled()) {
                        MODULE$.logger().underlying().error("Error while running command", (Throwable)e);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    commandOutput = new Utils.CommandOutput(1, "", MODULE$.exceptionAsString(e));
                }
            }
            finally {
                stdoutStream.close();
                stderrStream.close();
            }
            return commandOutput;
        });
    }

    private int runCommand(Seq<String> cmd, scala.collection.immutable.Map<String, String> extraEnv, OutputStream outStream, OutputStream errStream) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(cmd.mkString(" "));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        PrintWriter stdoutWriter = new PrintWriter(outStream);
        PrintWriter stderrWriter = new PrintWriter(errStream);
        int exitValue = Process$.MODULE$.apply(cmd, (Option)None$.MODULE$, extraEnv.toSeq()).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$1 -> {
            stdoutWriter.println(x$1);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$1 -> {
            stderrWriter.println(x$1);
            return BoxedUnit.UNIT;
        }));
        stdoutWriter.close();
        stderrWriter.close();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new java.lang.StringBuilder(11).append("exitValue: ").append(exitValue).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return exitValue;
    }

    public scala.collection.immutable.Map<String, String> runCommand$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ boolean $anonfun$duplicates$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int size = tuple2._2$mcI$sp();
            return size > 1;
        }
        throw new MatchError((Object)tuple2);
    }

    private Utils$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this._jinjava = null;
    }
}

