/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils;

import ai.starlake.config.Settings;
import ai.starlake.config.Settings$;
import ai.starlake.exceptions.SchemaValidationException;
import ai.starlake.extract.ExtractDesc;
import ai.starlake.extract.JDBCSchemas;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AllSinks;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.AutoJobDesc;
import ai.starlake.schema.model.AutoJobDesc$;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.DagDesc;
import ai.starlake.schema.model.DagGenerationConfig;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.EnvDesc;
import ai.starlake.schema.model.ExpectationItem;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.IamPolicyTags;
import ai.starlake.schema.model.LoadDesc;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.RefDesc;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.TableDesc;
import ai.starlake.schema.model.TaskDesc;
import ai.starlake.schema.model.TransformDesc;
import ai.starlake.schema.model.Type;
import ai.starlake.schema.model.TypesDesc;
import ai.starlake.schema.model.WriteStrategy;
import ai.starlake.utils.ImplicitRichPath$;
import ai.starlake.utils.Utils$;
import ai.starlake.utils.YamlMigrator;
import ai.starlake.utils.YamlMigrator$PreV1$TableConfig$;
import ai.starlake.utils.YamlMigrator$ScalaClass$ExtractConfig$;
import ai.starlake.utils.YamlMigrator$V1$ApplicationConfig$;
import ai.starlake.utils.YamlMigrator$V1$DagConfig$;
import ai.starlake.utils.YamlMigrator$V1$EnvConfig$;
import ai.starlake.utils.YamlMigrator$V1$ExtractConfig$;
import ai.starlake.utils.YamlMigrator$V1$LoadConfig$;
import ai.starlake.utils.YamlMigrator$V1$RefsConfig$;
import ai.starlake.utils.YamlMigrator$V1$TableConfig$;
import ai.starlake.utils.YamlMigrator$V1$TaskConfig$;
import ai.starlake.utils.YamlMigrator$V1$TransformConfig$;
import ai.starlake.utils.YamlMigrator$V1$TypesConfig$;
import ai.starlake.utils.YamlMigratorInterface;
import ai.starlake.utils.YamlUtils;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.networknt.schema.ApplyDefaultsStrategy;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.PathType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationResult;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class YamlSerde$
implements LazyLogging,
YamlUtils {
    public static YamlSerde$ MODULE$;
    private final ObjectMapper mapper;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new YamlSerde$();
    }

    @Override
    public Function1<JsonNode, JsonNode> transformNode(String nodePath, Function1<JsonNode, JsonNode> transform) {
        return YamlUtils.transformNode$(this, nodePath, transform);
    }

    @Override
    public Function1<JsonNode, JsonNode> renameField(String fieldPath, String newName) {
        return YamlUtils.renameField$(this, fieldPath, newName);
    }

    @Override
    public Function1<JsonNode, JsonNode> removeField(String fieldPath) {
        return YamlUtils.removeField$(this, fieldPath);
    }

    @Override
    public Function1<JsonNode, JsonNode> wrapToContainer(String containerName) {
        return YamlUtils.wrapToContainer$(this, containerName);
    }

    private Logger logger$lzycompute() {
        YamlSerde$ yamlSerde$ = this;
        synchronized (yamlSerde$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public <T> String serialize(T entity) {
        return this.mapper().writeValueAsString(entity);
    }

    private <T> Object wrapEntityToDesc(T entity) {
        T t = entity;
        if (t instanceof AutoJobDesc) {
            AutoJobDesc autoJobDesc = (AutoJobDesc)t;
            return new TransformDesc(Settings$.MODULE$.latestSchemaVersion(), autoJobDesc);
        }
        if (t instanceof AutoTaskDesc) {
            AutoTaskDesc autoTaskDesc = (AutoTaskDesc)t;
            return new TaskDesc(Settings$.MODULE$.latestSchemaVersion(), autoTaskDesc);
        }
        if (t instanceof Domain) {
            Domain domain = (Domain)t;
            return new LoadDesc(Settings$.MODULE$.latestSchemaVersion(), domain);
        }
        if (t instanceof Schema) {
            Schema schema = (Schema)t;
            return new TableDesc(Settings$.MODULE$.latestSchemaVersion(), schema);
        }
        if (t instanceof JDBCSchemas) {
            JDBCSchemas jDBCSchemas = (JDBCSchemas)t;
            return new ExtractDesc(Settings$.MODULE$.latestSchemaVersion(), jDBCSchemas);
        }
        if (t instanceof DagGenerationConfig) {
            DagGenerationConfig dagGenerationConfig = (DagGenerationConfig)t;
            return new DagDesc(Settings$.MODULE$.latestSchemaVersion(), dagGenerationConfig);
        }
        return entity;
    }

    public <T> void serializeToPath(Path targetPath, T entity, StorageHandler storage) {
        String x$1 = this.serialize(this.wrapEntityToDesc(entity));
        Path x$2 = targetPath;
        Charset x$3 = storage.write$default$3(x$1, x$2);
        storage.write(x$1, x$2, x$3);
    }

    public IamPolicyTags deserializeIamPolicyTags(String content) {
        JsonNode rootNode = this.mapper().readTree(content);
        return (IamPolicyTags)this.mapper().treeToValue((TreeNode)rootNode, IamPolicyTags.class);
    }

    public Map<String, Object> toMap(AutoJobDesc job, Settings settings) {
        ObjectWriter jobWriter = this.mapper().writer().withAttribute(Settings.class, (Object)settings);
        String jsonContent = jobWriter.writeValueAsString((Object)job);
        return (Map)this.mapper().readValue(jsonContent, Map.class);
    }

    private <T> T forceLocaleIn(Locale locale, Function0<T> func) {
        Object object;
        Locale previousDefault = Locale.getDefault();
        Locale.setDefault(locale);
        try {
            object = func.apply();
        }
        finally {
            Locale.setDefault(previousDefault);
        }
        return (T)object;
    }

    private JsonNode adaptSchemaV7ToStrictV201909(JsonNode node) {
        Tuple2 tuple2 = this.adaptIt$1("", node);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        JsonNode newSchema = (JsonNode)tuple2._2();
        JsonNode newSchema2 = newSchema;
        return newSchema2;
    }

    public JsonNode validateConfigFile(String subPath, String content, String inputFilename, List<YamlMigratorInterface> migrationList, Option<YamlMigratorInterface> postProcess) throws SchemaValidationException {
        JsonNode rawRootNode = this.mapper().readTree(content);
        return this.validateConfigFileFromNode(subPath, rawRootNode, inputFilename, migrationList, postProcess);
    }

    public Option<YamlMigratorInterface> validateConfigFile$default$5() {
        return None$.MODULE$;
    }

    public JsonNode validateConfigFileFromNode(String subPath, JsonNode rawRootNode, String inputFilename, List<YamlMigratorInterface> migrationList, Option<YamlMigratorInterface> postProcess) throws SchemaValidationException {
        JsonNode effectiveRootNode;
        JsonNode jsonNode;
        if (migrationList.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.canMigrate(rawRootNode)))) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Migrating config of {} on-the-fly", new Object[]{inputFilename});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            jsonNode = (JsonNode)migrationList.foldLeft((Object)rawRootNode, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    JsonNode node = (JsonNode)tuple2._1();
                    YamlMigratorInterface migrator = (YamlMigratorInterface)tuple2._2();
                    return migrator.migrate(node);
                }
                throw new MatchError((Object)tuple2);
            });
        } else {
            jsonNode = effectiveRootNode = rawRootNode;
        }
        if (!effectiveRootNode.hasNonNull(subPath)) {
            throw new RuntimeException(new StringBuilder(85).append("No '").append(subPath).append("' attribute found in ").append(inputFilename).append(". Please check your config and define it under '").append(subPath).append("' attribute.").toString());
        }
        ValidationResult validationResult = (ValidationResult)this.forceLocaleIn(Locale.ROOT, (Function0 & Serializable & scala.Serializable)() -> {
            JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909);
            SchemaValidatorsConfig config = new SchemaValidatorsConfig();
            config.setPathType(PathType.JSON_PATH);
            config.setFormatAssertionsEnabled(Predef$.MODULE$.boolean2Boolean(true));
            config.setJavaSemantics(true);
            config.setApplyDefaultsStrategy(new ApplyDefaultsStrategy(true, true, true));
            JsonNode starlakeSchema = MODULE$.adaptSchemaV7ToStrictV201909(MODULE$.mapper().readTree(MODULE$.getClass().getResourceAsStream("/starlake.schema.json")));
            JsonSchema schema = factory.getSchema(starlakeSchema, config);
            return schema.walk(effectiveRootNode, true);
        });
        List validationMessages = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(validationResult.getValidationMessages()).asScala()).toList();
        if (validationMessages.nonEmpty()) {
            String formattedErrors = ((TraversableOnce)((TraversableLike)validationMessages.map((Function1 & Serializable & scala.Serializable)error -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)error.getInstanceLocation().toString()), (Object)error.toString()), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String location = (String)tuple2._1();
                    return location;
                }
                throw new MatchError((Object)tuple2);
            }).mapValues((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)x$3.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    String errorMessage = (String)tuple2._2();
                    return errorMessage;
                }
                throw new MatchError((Object)tuple2);
            }, List$.MODULE$.canBuildFrom())).mkString("\n     - ", "\n     - ", "")).values().toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("");
            throw new SchemaValidationException(new StringBuilder(21).append("Invalid content for ").append(inputFilename).append(":").append(formattedErrors).toString());
        }
        return (JsonNode)postProcess.map((Function1 & Serializable & scala.Serializable)f -> {
            if (f.canMigrate(effectiveRootNode)) {
                return f.migrate(effectiveRootNode);
            }
            throw new RuntimeException(new StringBuilder(58).append("Post process hasn't been applied for ").append(inputFilename).append(" but was expected to.").toString());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> effectiveRootNode);
    }

    public Option<YamlMigratorInterface> validateConfigFileFromNode$default$5() {
        return None$.MODULE$;
    }

    public JDBCSchemas deserializeYamlExtractConfig(String content, String inputFilename, boolean propageDefault) {
        String extractSubPath = "extract";
        JsonNode extractNode = this.validateConfigFile(extractSubPath, content, inputFilename, (List<YamlMigratorInterface>)new .colon.colon((Object)YamlMigrator$V1$ExtractConfig$.MODULE$, (List)Nil$.MODULE$), (Option<YamlMigratorInterface>)new Some((Object)YamlMigrator$ScalaClass$ExtractConfig$.MODULE$)).path(extractSubPath);
        JDBCSchemas jdbcSchemas = (JDBCSchemas)this.mapper().treeToValue((TreeNode)extractNode, JDBCSchemas.class);
        if (propageDefault) {
            return jdbcSchemas.propagateGlobalJdbcSchemas();
        }
        return jdbcSchemas;
    }

    public boolean deserializeYamlExtractConfig$default$3() {
        return true;
    }

    public RefDesc deserializeYamlRefs(String content, String path) {
        String refsSubPath = "refs";
        JsonNode refsNode = this.validateConfigFile(refsSubPath, content, path, (List<YamlMigratorInterface>)new .colon.colon((Object)YamlMigrator$V1$RefsConfig$.MODULE$, (List)Nil$.MODULE$), this.validateConfigFile$default$5());
        return (RefDesc)this.mapper().treeToValue((TreeNode)refsNode, RefDesc.class);
    }

    public JsonNode deserializeYamlApplication(String content, String path) {
        String refsSubPath = "application";
        return this.validateConfigFile(refsSubPath, content, path, (List<YamlMigratorInterface>)new .colon.colon((Object)YamlMigrator$V1$ApplicationConfig$.MODULE$, (List)Nil$.MODULE$), this.validateConfigFile$default$5());
    }

    public List<TableDesc> deserializeYamlTables(String content, String path) {
        return this.deserializeYamlTables(this.mapper().readTree(content), path);
    }

    private List<TableDesc> deserializeYamlTables(JsonNode jsonRootNode, String path) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            .colon.colon colon2;
            String tableListSubPath;
            ObjectNode rootNode = YamlMigrator$PreV1$TableConfig$.MODULE$.canMigrate(jsonRootNode) ? (ObjectNode)YamlMigrator$PreV1$TableConfig$.MODULE$.migrate(jsonRootNode) : (ObjectNode)jsonRootNode;
            if (rootNode.has(tableListSubPath = "tables")) {
                JsonNode jsonNode = rootNode.path(tableListSubPath);
                if (!(jsonNode instanceof ArrayNode)) throw new RuntimeException(new StringBuilder(37).append("Expecting array for tables but found ").append(jsonNode.getNodeType().name()).toString());
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                colon2 = (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)arrayNode).asScala()).map(MODULE$.wrapToContainer("table"), Iterable$.MODULE$.canBuildFrom());
            } else {
                colon2 = new .colon.colon((Object)rootNode, (List)Nil$.MODULE$);
            }
            .colon.colon tablesNode = colon2;
            return ((TraversableOnce)tablesNode.map((Function1 & Serializable & scala.Serializable)rawTableNode -> {
                boolean bl;
                JsonNode tableNode = MODULE$.validateConfigFileFromNode("table", (JsonNode)rawTableNode, path, (List<YamlMigratorInterface>)new .colon.colon((Object)YamlMigrator$V1$TableConfig$.MODULE$, (List)Nil$.MODULE$), MODULE$.validateConfigFileFromNode$default$5());
                JsonNode metadata = tableNode.path("metadata");
                if (!metadata.isMissingNode()) {
                    String string = metadata.path("format").asText().toLowerCase();
                    String string2 = "array_json";
                    bl = !(string != null ? !string.equals(string2) : string2 != null);
                } else {
                    bl = false;
                }
                boolean isJsonArray = bl;
                TableDesc ref = (TableDesc)MODULE$.mapper().treeToValue((TreeNode)tableNode, TableDesc.class);
                if (isJsonArray) {
                    Option x$22 = ref.table().metadata().map((Function1 & Serializable & scala.Serializable)m -> {
                        Some x$1 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        Option<Format> x$2 = m.copy$default$1();
                        Option<String> x$3 = m.copy$default$2();
                        Option<Object> x$4 = m.copy$default$3();
                        Option<Object> x$5 = m.copy$default$5();
                        Option<String> x$6 = m.copy$default$6();
                        Option<String> x$7 = m.copy$default$7();
                        Option<String> x$8 = m.copy$default$8();
                        Option<AllSinks> x$9 = m.copy$default$9();
                        Option<String> x$10 = m.copy$default$10();
                        Option<String> x$11 = m.copy$default$11();
                        Option<String> x$12 = m.copy$default$12();
                        Option<Map<String, String>> x$13 = m.copy$default$13();
                        Option<String> x$14 = m.copy$default$14();
                        Option<Object> x$15 = m.copy$default$15();
                        Option<String> x$16 = m.copy$default$16();
                        Option<Freshness> x$17 = m.copy$default$17();
                        Option<String> x$18 = m.copy$default$18();
                        boolean x$19 = m.copy$default$19();
                        Option<String> x$20 = m.copy$default$20();
                        Option<WriteStrategy> x$21 = m.copy$default$21();
                        return m.copy(x$2, x$3, x$4, (Option<Object>)x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
                    });
                    String x$23 = ref.table().copy$default$1();
                    Pattern x$24 = ref.table().copy$default$2();
                    List<Attribute> x$25 = ref.table().copy$default$3();
                    Option<String> x$26 = ref.table().copy$default$5();
                    List<String> x$27 = ref.table().copy$default$6();
                    List<String> x$28 = ref.table().copy$default$7();
                    Set<String> x$29 = ref.table().copy$default$8();
                    List<RowLevelSecurity> x$30 = ref.table().copy$default$9();
                    List<ExpectationItem> x$31 = ref.table().copy$default$10();
                    List<String> x$32 = ref.table().copy$default$11();
                    List<AccessControlEntry> x$33 = ref.table().copy$default$12();
                    Option<String> x$34 = ref.table().copy$default$13();
                    Option<String> x$35 = ref.table().copy$default$14();
                    Option<String> x$36 = ref.table().copy$default$15();
                    Option<String> x$37 = ref.table().copy$default$16();
                    Schema x$38 = ref.table().copy(x$23, x$24, x$25, (Option<Metadata>)x$22, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37);
                    int x$39 = ref.copy$default$1();
                    return ref.copy(x$39, x$38);
                }
                return ref;
            }, Iterable$.MODULE$.canBuildFrom())).toList();
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List value = (List)success.value();
            return value;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            exception.printStackTrace();
            throw new Exception(new StringBuilder(23).append("Invalid Schema file: ").append(path).append("(").append(exception.getMessage()).append(")").toString(), exception);
        }
        throw new MatchError((Object)try_);
    }

    public Try<Domain> deserializeYamlLoadConfig(String content, String path, boolean isForExtract) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Nil$ nil$;
            String loadSubPath = "load";
            Path filePath = new Path(path);
            JsonNode rawRootNode = MODULE$.mapper().readTree(content);
            if (!rawRootNode.has("version") && rawRootNode.path("load").has("tables") || rawRootNode.has("tables")) {
                JsonNode tablesNode = rawRootNode.has("tables") ? rawRootNode.path("tables") : rawRootNode.path("load").path("tables");
                JsonNode tables = isForExtract ? new YamlMigrator.V1.TableForExtractConfig(ImplicitRichPath$.MODULE$.RichPath(filePath).fileNameWithoutSlExt()).migrate((JsonNode)MODULE$.wrapToContainer("tables").apply((Object)tablesNode)) : tablesNode;
                nil$ = (List)MODULE$.deserializeYamlTables((JsonNode)MODULE$.wrapToContainer("tables").apply((Object)tables), path).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.table(), List$.MODULE$.canBuildFrom());
            } else {
                nil$ = Nil$.MODULE$;
            }
            Nil$ attachedTables = nil$;
            JsonNode domainNode = MODULE$.validateConfigFileFromNode(loadSubPath, rawRootNode, path, (List<YamlMigratorInterface>)new .colon.colon((Object)YamlMigrator$V1$LoadConfig$.MODULE$, (List)Nil$.MODULE$), MODULE$.validateConfigFileFromNode$default$5());
            LoadDesc loadDesc = (LoadDesc)MODULE$.mapper().treeToValue((TreeNode)domainNode, LoadDesc.class);
            Nil$ x$1 = attachedTables;
            String x$2 = loadDesc.load().copy$default$1();
            Option<Metadata> x$3 = loadDesc.load().copy$default$2();
            Option<String> x$42 = loadDesc.load().copy$default$4();
            Set<String> x$5 = loadDesc.load().copy$default$5();
            Option<String> x$6 = loadDesc.load().copy$default$6();
            Option<String> x$7 = loadDesc.load().copy$default$7();
            return loadDesc.load().copy(x$2, x$3, (List<Schema>)x$1, x$42, x$5, x$6, x$7);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Domain value = (Domain)success.value();
            return new Success((Object)value);
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(23).append("Invalid domain file: ").append(path).append("(").append(exception.getMessage()).append(")").toString(), exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new Failure(exception);
        }
        throw new MatchError((Object)try_);
    }

    public List<Type> deserializeYamlTypes(String content, String path) {
        String refsSubPath = "types";
        JsonNode refsNode = this.validateConfigFile(refsSubPath, content, path, (List<YamlMigratorInterface>)new .colon.colon((Object)YamlMigrator$V1$TypesConfig$.MODULE$, (List)Nil$.MODULE$), this.validateConfigFile$default$5());
        return ((TypesDesc)this.mapper().treeToValue((TreeNode)refsNode, TypesDesc.class)).types();
    }

    public Try<DagGenerationConfig> deserializeYamlDagConfig(String content, String path) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String dagSubPath = "dag";
            JsonNode dagNode = MODULE$.validateConfigFile(dagSubPath, content, path, (List<YamlMigratorInterface>)new .colon.colon((Object)YamlMigrator$V1$DagConfig$.MODULE$, (List)Nil$.MODULE$), MODULE$.validateConfigFile$default$5());
            return (DagDesc)MODULE$.mapper().treeToValue((TreeNode)dagNode, DagDesc.class);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DagDesc value = (DagDesc)success.value();
            return new Success((Object)value.dag());
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Invalid dag file: {}({})", new Object[]{path, exception.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new Failure(exception);
        }
        throw new MatchError((Object)try_);
    }

    public EnvDesc deserializeYamlEnvConfig(String content, String path) {
        String envSubPath = "env";
        if (content.indexOf("env:") == -1) {
            return new EnvDesc(Settings$.MODULE$.latestSchemaVersion(), (Map<String, String>)Predef$.MODULE$.Map().empty());
        }
        JsonNode dagNode = this.validateConfigFile(envSubPath, content, path, (List<YamlMigratorInterface>)new .colon.colon((Object)YamlMigrator$V1$EnvConfig$.MODULE$, (List)Nil$.MODULE$), this.validateConfigFile$default$5());
        return (EnvDesc)this.mapper().treeToValue((TreeNode)dagNode, EnvDesc.class);
    }

    public AutoTaskDesc deserializeYamlTask(String content, String path) {
        String refsSubPath = "task";
        JsonNode jsonNode = this.validateConfigFile(refsSubPath, content, path, (List<YamlMigratorInterface>)new .colon.colon((Object)YamlMigrator$V1$TaskConfig$.MODULE$, (List)Nil$.MODULE$), this.validateConfigFile$default$5()).path("task");
        if (!(jsonNode instanceof ObjectNode)) {
            throw new RuntimeException("Should never happen since it has been validated");
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        ObjectNode taskNode = objectNode;
        return (AutoTaskDesc)this.mapper().treeToValue((TreeNode)taskNode, AutoTaskDesc.class);
    }

    public Try<AutoJobDesc> deserializeYamlTransform(String content, String path) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String transformSubPath = "transform";
            JsonNode transformNode = MODULE$.validateConfigFile(transformSubPath, content, path, (List<YamlMigratorInterface>)new .colon.colon((Object)YamlMigrator$V1$TransformConfig$.MODULE$, (List)Nil$.MODULE$), MODULE$.validateConfigFile$default$5());
            return ((TransformDesc)MODULE$.mapper().treeToValue((TreeNode)transformNode, TransformDesc.class)).transform();
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AutoJobDesc value = (AutoJobDesc)success.value();
            return new Success((Object)value);
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            String string = content.trim();
            String string2 = "transform:";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Empty transform file: {}", new Object[]{path});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return new Success((Object)new AutoJobDesc("", (List<AutoTaskDesc>)Nil$.MODULE$, AutoJobDesc$.MODULE$.apply$default$3(), AutoJobDesc$.MODULE$.apply$default$4()));
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Invalid transform file: {}({})", new Object[]{path, exception.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new Failure(exception);
        }
        throw new MatchError((Object)try_);
    }

    private final Tuple2 adaptIt$1(String currentNodeName, JsonNode node) {
        boolean bl = false;
        TextNode textNode = null;
        JsonNode jsonNode = node;
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            ObjectNode newObjectNode = this.mapper().createObjectNode();
            String objectType = (String)Option$.MODULE$.apply((Object)objectNode.get("type")).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                JsonNode jsonNode = x0$1;
                if (jsonNode instanceof TextNode) {
                    TextNode textNode = (TextNode)jsonNode;
                    return new Some((Object)textNode.asText());
                }
                return None$.MODULE$;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            Object object = "object".equalsIgnoreCase(objectType) && !objectNode.has("additionalProperties") && !currentNodeName.endsWith("Base") ? newObjectNode.set("unevaluatedProperties", (JsonNode)BooleanNode.FALSE) : BoxedUnit.UNIT;
            ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(node.fields()).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> {
                Tuple2 tuple2 = this.adaptIt$1((String)kv.getKey(), (JsonNode)kv.getValue());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String newKey = (String)tuple2._1();
                JsonNode newValue = (JsonNode)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)newKey, (Object)newValue);
                String newKey2 = (String)tuple22._1();
                JsonNode newValue2 = (JsonNode)tuple22._2();
                return newObjectNode.set(newKey2, newValue2);
            });
            String string = currentNodeName;
            String string2 = "definitions";
            String newNodeName = !(string != null ? !string.equals(string2) : string2 != null) ? "$defs" : currentNodeName;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newNodeName), (Object)newObjectNode);
        }
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            ArrayNode newArrayNode = this.mapper().createArrayNode();
            newArrayNode.addAll((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)arrayNode).asScala()).map((Function1 & Serializable & scala.Serializable)currentNode -> {
                Tuple2 tuple2 = this.adaptIt$1(currentNodeName, (JsonNode)currentNode);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                JsonNode newValue = (JsonNode)tuple2._2();
                JsonNode newValue2 = newValue;
                return newValue2;
            }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)currentNodeName), (Object)newArrayNode);
        }
        if (jsonNode instanceof TextNode) {
            bl = true;
            textNode = (TextNode)jsonNode;
            String string = currentNodeName;
            String string3 = "$schema";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)currentNodeName), (Object)new TextNode(SpecVersion.VersionFlag.V201909.getId()));
            }
        }
        if (bl) {
            String string = currentNodeName;
            String string4 = "$ref";
            if (!(string != null ? !string.equals(string4) : string4 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)currentNodeName), (Object)new TextNode(textNode.asText().replaceFirst("^#/definitions/", "#/\\$defs/")));
            }
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)currentNodeName), (Object)node);
    }

    private YamlSerde$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        YamlUtils.$init$(this);
        this.mapper = Utils$.MODULE$.newYamlMapper();
    }
}

