/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils.conversion;

import java.io.Serializable;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.VarcharType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DuckDbUtils$ {
    public static DuckDbUtils$ MODULE$;

    static {
        new DuckDbUtils$();
    }

    public String[] bqSchema(DataType schema) {
        return this.sparkToDuckDbFields((StructType)schema, 0);
    }

    private String[] sparkToDuckDbFields(StructType struct, int level) {
        String[] fields = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])struct.fields())).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.createDuckDbColumn((StructField)field, level), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return fields;
    }

    private String createDuckDbColumn(StructField field, int level) {
        String column;
        String string;
        Tuple2 tuple2;
        Tuple2 tuple22;
        DataType dataType = field.dataType();
        String name = field.name();
        String nullable = !field.nullable() ? "NOT NULL" : "";
        String description = (String)this.getDescription(field).map((Function1 & Serializable & scala.Serializable)d -> new StringBuilder(10).append("COMMENT '").append((String)d).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        DataType dataType2 = dataType;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            tuple22 = new Tuple2((Object)arrayType.elementType(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple22 = tuple2 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DataType elementType = (DataType)tuple2._1();
        boolean repeated = tuple2._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)repeated));
        DataType elementType2 = (DataType)tuple23._1();
        boolean repeated2 = tuple23._2$mcZ$sp();
        DataType dataType3 = elementType2;
        if (dataType3 instanceof StructType) {
            StructType structType = (StructType)dataType3;
            String[] fields = this.sparkToDuckDbFields(structType, level + 1);
            string = repeated2 ? new StringBuilder(11).append(name).append(" STRUCT(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString("", ", ", "")).append(")[]").toString() : new StringBuilder(9).append(name).append(" STRUCT(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString("", ", ", "")).append(")").toString();
        } else if (dataType3 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType3;
            string = repeated2 ? new StringBuilder(13).append(name).append(" DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")[]").toString() : new StringBuilder(11).append(name).append(" DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString();
        } else {
            string = column = repeated2 ? new StringBuilder(3).append(name).append(" ").append(this.toDuckDbType(elementType2, field.metadata())).append("[]").toString() : new StringBuilder(1).append(name).append(" ").append(this.toDuckDbType(elementType2, field.metadata())).toString();
        }
        if (level > 0) {
            return column.trim();
        }
        return new StringBuilder(2).append(column).append(" ").append(nullable).append(" ").append(description).toString().trim();
    }

    private Option<String> getDescription(StructField field) {
        Option comment = !field.getComment().isEmpty() ? field.getComment() : (field.metadata().contains("description") ? Option$.MODULE$.apply((Object)field.metadata().getString("description")) : None$.MODULE$);
        return comment;
    }

    public boolean isJson(Metadata metadata) {
        return metadata.contains("sqlType") && "JSON".equals(metadata.getString("sqlType"));
    }

    public String toDuckDbType(DataType dataType, Metadata metadata) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof BinaryType) {
            return "BINARY";
        }
        if (dataType2 instanceof ByteType) {
            return "TINYINT";
        }
        if (dataType2 instanceof ShortType) {
            return "SMALLINT";
        }
        if (dataType2 instanceof IntegerType) {
            return "INTEGER";
        }
        if (dataType2 instanceof LongType) {
            return "BIGINT";
        }
        if (dataType2 instanceof BooleanType) {
            return "BOOLEAN";
        }
        if (dataType2 instanceof FloatType) {
            return "FLOAT";
        }
        if (dataType2 instanceof DoubleType) {
            return "DOUBLE";
        }
        if (dataType2 instanceof StringType) {
            if (this.isJson(metadata)) {
                return "JSON";
            }
            return "VARCHAR";
        }
        if (dataType2 instanceof VarcharType) {
            if (this.isJson(metadata)) {
                return "JSON";
            }
            return "VARCHAR";
        }
        if (dataType2 instanceof TimestampType) {
            return "TIMESTAMP";
        }
        if (dataType2 instanceof DateType) {
            return "DATE";
        }
        throw new IllegalArgumentException(new StringBuilder(24).append("Data type not expected: ").append(dataType.simpleString()).toString());
    }

    private DuckDbUtils$() {
        MODULE$ = this;
    }
}

