/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils.repackaged;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.SupportedCustomDataType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.unsafe.types.UTF8String;

public class BigQuerySchemaConverters {
    static final DecimalType NUMERIC_SPARK_TYPE = DataTypes.createDecimalType((int)38, (int)9);
    static final int MAX_BIGQUERY_NESTED_DEPTH = 15;
    private static final int NUMERIC_MAX_LEFT_OF_DOT_DIGITS = 29;

    public static StructType toSpark(Schema schema) {
        List<StructField> list = schema.getFields().stream().map(BigQuerySchemaConverters::convert).collect(Collectors.toList());
        StructType structType = new StructType(list.toArray(new StructField[0]));
        return structType;
    }

    public static Schema getSchemaWithPseudoColumns(TableInfo tableInfo) {
        TimePartitioning timePartitioning = null;
        TableDefinition tableDefinition = tableInfo.getDefinition();
        if (tableDefinition instanceof StandardTableDefinition) {
            timePartitioning = ((StandardTableDefinition)tableDefinition).getTimePartitioning();
        }
        boolean bl = timePartitioning != null && timePartitioning.getField() == null && timePartitioning.getType() != null;
        Schema schema = tableDefinition.getSchema();
        if (bl) {
            ArrayList<Field> arrayList = new ArrayList<Field>((Collection<Field>)schema.getFields());
            arrayList.add(BigQuerySchemaConverters.createBigQueryFieldBuilder("_PARTITIONTIME", LegacySQLTypeName.TIMESTAMP, Field.Mode.NULLABLE, null).build());
            if (timePartitioning.getType().equals((Object)TimePartitioning.Type.DAY)) {
                arrayList.add(BigQuerySchemaConverters.createBigQueryFieldBuilder("_PARTITIONDATE", LegacySQLTypeName.DATE, Field.Mode.NULLABLE, null).build());
            }
            schema = Schema.of(arrayList);
        }
        return schema;
    }

    public static InternalRow convertToInternalRow(Schema schema, List<String> list, GenericRecord genericRecord, Optional<StructType> optional) {
        List<StructField> list2 = Arrays.stream(optional.orElse(new StructType()).fields()).collect(Collectors.toList());
        return BigQuerySchemaConverters.convertAll(schema.getFields(), genericRecord, list, list2);
    }

    static Object convert(Field field, Object object2, StructField structField) {
        if (object2 == null) {
            return null;
        }
        if (field.getMode() == Field.Mode.REPEATED) {
            LegacySQLTypeName legacySQLTypeName = LegacySQLTypeName.valueOfStrict((String)field.getType().name());
            Field field2 = Field.newBuilder((String)field.getName(), (LegacySQLTypeName)legacySQLTypeName, (FieldList)field.getSubFields()).setMode(Field.Mode.REQUIRED).build();
            List list = (List)object2;
            return new GenericArrayData(list.stream().map(object -> BigQuerySchemaConverters.convert(field2, object, BigQuerySchemaConverters.getStructFieldForRepeatedMode(structField))).collect(Collectors.toList()));
        }
        return BigQuerySchemaConverters.convertByBigQueryType(field, object2, structField);
    }

    private static StructField getStructFieldForRepeatedMode(StructField structField) {
        StructField structField2 = null;
        if (structField != null) {
            ArrayType arrayType = (ArrayType)structField.dataType();
            structField2 = new StructField(structField.name(), arrayType.elementType(), arrayType.containsNull(), Metadata.empty());
        }
        return structField2;
    }

    static Object convertByBigQueryType(Field field, Object object, StructField structField) {
        if (LegacySQLTypeName.INTEGER.equals((Object)field.getType())) {
            if (structField != null) {
                DataType dataType = structField.dataType();
                if (dataType.equals(DataTypes.IntegerType)) {
                    return ((Number)object).intValue();
                }
                if (dataType.equals(DataTypes.ShortType)) {
                    return ((Number)object).shortValue();
                }
                if (dataType.equals(DataTypes.ByteType)) {
                    return ((Number)object).byteValue();
                }
            }
            return object;
        }
        if (LegacySQLTypeName.FLOAT.equals((Object)field.getType()) || LegacySQLTypeName.BOOLEAN.equals((Object)field.getType()) || LegacySQLTypeName.DATE.equals((Object)field.getType()) || LegacySQLTypeName.TIME.equals((Object)field.getType()) || LegacySQLTypeName.TIMESTAMP.equals((Object)field.getType())) {
            return object;
        }
        if (LegacySQLTypeName.STRING.equals((Object)field.getType()) || LegacySQLTypeName.DATETIME.equals((Object)field.getType()) || LegacySQLTypeName.GEOGRAPHY.equals((Object)field.getType()) || LegacySQLTypeName.JSON.equals((Object)field.getType())) {
            return UTF8String.fromBytes((byte[])((Utf8)object).getBytes());
        }
        if (LegacySQLTypeName.BYTES.equals((Object)field.getType())) {
            return BigQuerySchemaConverters.getBytes((ByteBuffer)object);
        }
        if (LegacySQLTypeName.NUMERIC.equals((Object)field.getType()) || LegacySQLTypeName.BIGNUMERIC.equals((Object)field.getType())) {
            byte[] byArray = BigQuerySchemaConverters.getBytes((ByteBuffer)object);
            int n = Optional.ofNullable(field.getScale()).map(Long::intValue).orElse(9);
            BigDecimal bigDecimal = new BigDecimal(new BigInteger(byArray), n);
            int n2 = Optional.ofNullable(field.getPrecision()).map(Long::intValue).orElse(38);
            Decimal decimal = Decimal.apply((BigDecimal)bigDecimal, (int)n2, (int)n);
            return decimal;
        }
        if (LegacySQLTypeName.RECORD.equals((Object)field.getType())) {
            List<String> list = null;
            List<StructField> list2 = null;
            if (structField != null) {
                StructType structType = (StructType)SupportedCustomDataType.toSqlType((DataType)structField.dataType());
                list2 = Arrays.stream(structType.fields()).collect(Collectors.toList());
                list = list2.stream().map(StructField::name).collect(Collectors.toList());
            } else {
                list = field.getSubFields().stream().map(Field::getName).collect(Collectors.toList());
            }
            return BigQuerySchemaConverters.convertAll(field.getSubFields(), (GenericRecord)object, list, list2);
        }
        throw new IllegalStateException("Unexpected type: " + field.getType());
    }

    private static byte[] getBytes(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    static GenericInternalRow convertAll(FieldList fieldList, GenericRecord genericRecord, List<String> list, List<StructField> list2) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = list2 == null ? new HashMap() : list2.stream().collect(Collectors.toMap(StructField::name, Function.identity()));
        fieldList.stream().forEach(field -> hashMap.put(field.getName(), BigQuerySchemaConverters.convert(field, genericRecord.get(field.getName()), (StructField)hashMap2.get(field.getName()))));
        Object[] objectArray = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = hashMap.get(list.get(i));
        }
        return new GenericInternalRow(objectArray);
    }

    private static StructField convert(Field field) {
        DataType dataType = BigQuerySchemaConverters.getDataType(field);
        boolean bl = true;
        if (field.getMode() == Field.Mode.REQUIRED) {
            bl = false;
        } else if (field.getMode() == Field.Mode.REPEATED) {
            dataType = new ArrayType(dataType, true);
        }
        MetadataBuilder metadataBuilder = new MetadataBuilder();
        if (field.getDescription() != null) {
            metadataBuilder.putString("description", field.getDescription());
            metadataBuilder.putString("comment", field.getDescription());
        }
        if (LegacySQLTypeName.JSON.equals((Object)field.getType())) {
            metadataBuilder.putString("sqlType", "JSON");
        }
        Metadata metadata = metadataBuilder.build();
        return BigQuerySchemaConverters.convertMap(field, metadata).orElse(new StructField(field.getName(), dataType, bl, metadata));
    }

    static Optional<StructField> convertMap(Field field, Metadata metadata) {
        if (field.getMode() != Field.Mode.REPEATED) {
            return Optional.empty();
        }
        if (field.getType() != LegacySQLTypeName.RECORD) {
            return Optional.empty();
        }
        FieldList fieldList = field.getSubFields();
        if (fieldList.size() != 2) {
            return Optional.empty();
        }
        Set set = fieldList.stream().map(Field::getName).collect(Collectors.toSet());
        if (!set.contains("key") || !set.contains("value")) {
            return Optional.empty();
        }
        Field field2 = fieldList.get("key");
        Field field3 = fieldList.get("value");
        MapType mapType = DataTypes.createMapType((DataType)BigQuerySchemaConverters.convert(field2).dataType(), (DataType)BigQuerySchemaConverters.convert(field3).dataType());
        return Optional.of(new StructField(field.getName(), (DataType)mapType, false, metadata));
    }

    private static DataType getDataType(Field field) {
        return BigQuerySchemaConverters.getCustomDataType(field).map(dataType -> dataType).orElseGet(() -> BigQuerySchemaConverters.getStandardDataType(field));
    }

    @VisibleForTesting
    static Optional<DataType> getCustomDataType(Field field) {
        String string = field.getDescription();
        if (string != null && LegacySQLTypeName.RECORD.equals((Object)field.getType())) {
            return SupportedCustomDataType.forDescription((String)string).map(SupportedCustomDataType::getSparkDataType);
        }
        return Optional.empty();
    }

    private static DataType getStandardDataType(Field field) {
        if (LegacySQLTypeName.INTEGER.equals((Object)field.getType())) {
            return DataTypes.LongType;
        }
        if (LegacySQLTypeName.FLOAT.equals((Object)field.getType())) {
            return DataTypes.DoubleType;
        }
        if (LegacySQLTypeName.NUMERIC.equals((Object)field.getType())) {
            return BigQuerySchemaConverters.createDecimalTypeFromNumericField(field, LegacySQLTypeName.NUMERIC, 38, 9);
        }
        if (LegacySQLTypeName.BIGNUMERIC.equals((Object)field.getType())) {
            int n = Optional.ofNullable(field.getPrecision()).map(Long::intValue).orElse(76);
            if (n > DecimalType.MAX_PRECISION()) {
                throw new IllegalArgumentException(String.format("BigNumeric precision is too wide (%d), Spark can only handle decimal types with max precision of %d", n, DecimalType.MAX_PRECISION()));
            }
            return BigQuerySchemaConverters.createDecimalTypeFromNumericField(field, LegacySQLTypeName.BIGNUMERIC, 76, 38);
        }
        if (LegacySQLTypeName.STRING.equals((Object)field.getType())) {
            return DataTypes.StringType;
        }
        if (LegacySQLTypeName.BOOLEAN.equals((Object)field.getType())) {
            return DataTypes.BooleanType;
        }
        if (LegacySQLTypeName.BYTES.equals((Object)field.getType())) {
            return DataTypes.BinaryType;
        }
        if (LegacySQLTypeName.DATE.equals((Object)field.getType())) {
            return DataTypes.DateType;
        }
        if (LegacySQLTypeName.TIMESTAMP.equals((Object)field.getType())) {
            return DataTypes.TimestampType;
        }
        if (LegacySQLTypeName.TIME.equals((Object)field.getType())) {
            return DataTypes.LongType;
        }
        if (LegacySQLTypeName.DATETIME.equals((Object)field.getType())) {
            return DataTypes.StringType;
        }
        if (LegacySQLTypeName.RECORD.equals((Object)field.getType())) {
            List<StructField> list = field.getSubFields().stream().map(BigQuerySchemaConverters::convert).collect(Collectors.toList());
            return new StructType(list.toArray(new StructField[0]));
        }
        if (LegacySQLTypeName.GEOGRAPHY.equals((Object)field.getType())) {
            return DataTypes.StringType;
        }
        if (LegacySQLTypeName.JSON.equals((Object)field.getType())) {
            return DataTypes.StringType;
        }
        throw new IllegalStateException("Unexpected type: " + field.getType());
    }

    @VisibleForTesting
    static DecimalType createDecimalTypeFromNumericField(Field field, LegacySQLTypeName legacySQLTypeName, int n, int n2) {
        Preconditions.checkArgument((boolean)field.getType().equals((Object)legacySQLTypeName), (String)"Field %s must be of type NUMERIC, instead it is of type %s", (Object)field.getName(), (Object)field.getType());
        Optional<Integer> optional = Optional.ofNullable(field.getPrecision()).map(Long::intValue);
        Optional<Integer> optional2 = Optional.ofNullable(field.getScale()).map(Long::intValue);
        if (optional.isPresent() && optional2.isPresent()) {
            return DataTypes.createDecimalType((int)optional.get(), (int)optional2.get());
        }
        if (!optional.isPresent() && !optional2.isPresent()) {
            return DataTypes.createDecimalType((int)n, (int)n2);
        }
        int n3 = n - n2;
        if (optional.isPresent()) {
            Integer n4 = (int)optional.get();
            return DataTypes.createDecimalType((int)n4, (int)Math.max(0, n4 - n3));
        }
        Integer n5 = optional2.get();
        return DataTypes.createDecimalType((int)(n5 + n3), (int)n5);
    }

    public static Schema toBigQuerySchema(StructType structType) {
        FieldList fieldList = BigQuerySchemaConverters.sparkToBigQueryFields(structType, 0);
        return Schema.of((Iterable)fieldList);
    }

    private static FieldList sparkToBigQueryFields(StructType structType, int n) {
        Preconditions.checkArgument((n < 15 ? 1 : 0) != 0, (Object)"Spark Schema exceeds BigQuery maximum nesting depth.");
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (StructField structField : structType.fields()) {
            arrayList.add(BigQuerySchemaConverters.createBigQueryColumn(structField, n));
        }
        return FieldList.of(arrayList);
    }

    @VisibleForTesting
    protected static Field createBigQueryColumn(StructField structField, int n) {
        LegacySQLTypeName legacySQLTypeName;
        SupportedCustomDataType supportedCustomDataType;
        Object object;
        DataType dataType = structField.dataType();
        String string = structField.name();
        Field.Mode mode = structField.nullable() ? Field.Mode.NULLABLE : Field.Mode.REQUIRED;
        FieldList fieldList = null;
        OptionalLong optionalLong = OptionalLong.empty();
        long l = 0L;
        if (dataType instanceof ArrayType) {
            object = (ArrayType)dataType;
            mode = Field.Mode.REPEATED;
            dataType = object.elementType();
        }
        if (((Optional)(object = SupportedCustomDataType.of((DataType)dataType))).isPresent()) {
            supportedCustomDataType = (SupportedCustomDataType)((Optional)object).get();
            dataType = supportedCustomDataType.getSqlType();
        }
        if (dataType instanceof StructType) {
            fieldList = BigQuerySchemaConverters.sparkToBigQueryFields((StructType)dataType, n + 1);
            legacySQLTypeName = LegacySQLTypeName.RECORD;
        } else if (dataType instanceof MapType) {
            supportedCustomDataType = (MapType)dataType;
            mode = Field.Mode.REPEATED;
            legacySQLTypeName = LegacySQLTypeName.RECORD;
            fieldList = FieldList.of((Field[])new Field[]{Field.newBuilder((String)"key", (LegacySQLTypeName)BigQuerySchemaConverters.toBigQueryType(supportedCustomDataType.keyType(), structField.metadata()), (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"value", (LegacySQLTypeName)BigQuerySchemaConverters.toBigQueryType(supportedCustomDataType.valueType(), structField.metadata()), (Field[])new Field[0]).setMode(supportedCustomDataType.valueContainsNull() ? Field.Mode.NULLABLE : Field.Mode.REQUIRED).build()});
        } else if (dataType instanceof DecimalType) {
            supportedCustomDataType = (DecimalType)dataType;
            int n2 = supportedCustomDataType.precision() - supportedCustomDataType.scale();
            legacySQLTypeName = supportedCustomDataType.scale() > 9 || n2 > 29 ? LegacySQLTypeName.BIGNUMERIC : LegacySQLTypeName.NUMERIC;
            optionalLong = OptionalLong.of(supportedCustomDataType.scale());
            l = supportedCustomDataType.precision();
        } else {
            legacySQLTypeName = BigQuerySchemaConverters.toBigQueryType(dataType, structField.metadata());
        }
        supportedCustomDataType = BigQuerySchemaConverters.createBigQueryFieldBuilder(string, legacySQLTypeName, mode, fieldList);
        Optional<String> optional = BigQuerySchemaConverters.getDescriptionOrCommentOfField(structField, (Optional<SupportedCustomDataType>)object);
        if (optional.isPresent()) {
            supportedCustomDataType.setDescription(optional.get());
        }
        if (optionalLong.isPresent()) {
            supportedCustomDataType.setPrecision(Long.valueOf(l));
            supportedCustomDataType.setScale(Long.valueOf(optionalLong.getAsLong()));
        }
        return supportedCustomDataType.build();
    }

    public static Optional<String> getDescriptionOrCommentOfField(StructField structField, Optional<SupportedCustomDataType> optional) {
        Optional<Object> optional2 = Optional.empty();
        if (!structField.getComment().isEmpty()) {
            optional2 = Optional.of((String)structField.getComment().get());
        } else if (structField.metadata().contains("description") && structField.metadata().getString("description") != null) {
            optional2 = Optional.of(structField.metadata().getString("description"));
        }
        Optional<String> optional3 = optional.map(SupportedCustomDataType::getTypeMarker);
        if (optional2.isPresent()) {
            String string = (String)optional2.get();
            return Optional.of(optional3.map(string2 -> string + " " + string2).orElse(string));
        }
        return optional3;
    }

    @VisibleForTesting
    protected static LegacySQLTypeName toBigQueryType(DataType dataType, Metadata metadata) {
        if (dataType instanceof BinaryType) {
            return LegacySQLTypeName.BYTES;
        }
        if (dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType) {
            return LegacySQLTypeName.INTEGER;
        }
        if (dataType instanceof BooleanType) {
            return LegacySQLTypeName.BOOLEAN;
        }
        if (dataType instanceof FloatType || dataType instanceof DoubleType) {
            return LegacySQLTypeName.FLOAT;
        }
        if (dataType instanceof StringType || dataType instanceof VarcharType) {
            if (SparkBigQueryUtil.isJson((Metadata)metadata)) {
                return LegacySQLTypeName.JSON;
            }
            return LegacySQLTypeName.STRING;
        }
        if (dataType instanceof TimestampType) {
            return LegacySQLTypeName.TIMESTAMP;
        }
        if (dataType instanceof DateType) {
            return LegacySQLTypeName.DATE;
        }
        throw new IllegalArgumentException("Data type not expected: " + dataType.simpleString());
    }

    private static Field.Builder createBigQueryFieldBuilder(String string, LegacySQLTypeName legacySQLTypeName, Field.Mode mode, FieldList fieldList) {
        return Field.newBuilder((String)string, (LegacySQLTypeName)legacySQLTypeName, (FieldList)fieldList).setMode(mode);
    }
}

