/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import ai.starlake.utils.Utils$;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JsonIngestionUtil$ {
    public static JsonIngestionUtil$ MODULE$;
    private final IndexedSeq<NumericType> numericPrecedence;
    private final Comparator<StructField> structFieldComparator;
    private final Function2<DataType, DataType, Option<DataType>> findTightestCommonTypeOfTwo;
    private final JsonFactory factory;

    static {
        new JsonIngestionUtil$();
    }

    public IndexedSeq<NumericType> numericPrecedence() {
        return this.numericPrecedence;
    }

    private Comparator<StructField> structFieldComparator() {
        return this.structFieldComparator;
    }

    public List<String> compareTypes(DataType schemaType, DataType datasetType) {
        return this.compareTypes((List<String>)Nil$.MODULE$, (Tuple3<String, DataType, Object>)new Tuple3((Object)"root", (Object)schemaType, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (Tuple3<String, DataType, Object>)new Tuple3((Object)"root", (Object)datasetType, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public List<String> compareTypes(List<String> context, Tuple3<String, DataType, Object> schemaType, Tuple3<String, DataType, Object> datasetType) {
        Tuple2 tuple2;
        boolean datasetAttrNullable;
        DataType datasetAttrType;
        String datasetAttrName;
        boolean schemaAttrNullable;
        DataType schemaAttrType;
        String schemaAttrName;
        while (true) {
            DataType dataType;
            Tuple3 tuple3;
            if ((tuple3 = schemaType) == null) {
                throw new MatchError(tuple3);
            }
            String schemaAttrName2 = (String)tuple3._1();
            DataType schemaAttrType2 = (DataType)tuple3._2();
            boolean schemaAttrNullable2 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)schemaAttrName2, (Object)schemaAttrType2, (Object)BoxesRunTime.boxToBoolean((boolean)schemaAttrNullable2));
            schemaAttrName = (String)tuple32._1();
            schemaAttrType = (DataType)tuple32._2();
            schemaAttrNullable = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
            Tuple3 tuple33 = datasetType;
            if (tuple33 == null) {
                throw new MatchError(tuple33);
            }
            String datasetAttrName2 = (String)tuple33._1();
            DataType datasetAttrType2 = (DataType)tuple33._2();
            boolean datasetAttrNullable2 = BoxesRunTime.unboxToBoolean((Object)tuple33._3());
            Tuple3 tuple34 = new Tuple3((Object)datasetAttrName2, (Object)datasetAttrType2, (Object)BoxesRunTime.boxToBoolean((boolean)datasetAttrNullable2));
            datasetAttrName = (String)tuple34._1();
            datasetAttrType = (DataType)tuple34._2();
            datasetAttrNullable = BoxesRunTime.unboxToBoolean((Object)tuple34._3());
            boolean schemaTypeNullable = schemaAttrNullable;
            tuple2 = new Tuple2((Object)schemaAttrType, (Object)datasetAttrType);
            if (tuple2 != null) {
                DataType t1 = (DataType)tuple2._1();
                DataType t2 = (DataType)tuple2._2();
                DataType dataType2 = t1;
                DataType dataType3 = t2;
                if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
                    return Nil$.MODULE$;
                }
            }
            if (tuple2 != null && NullType$.MODULE$.equals(dataType = (DataType)tuple2._2()) && schemaTypeNullable) {
                return Nil$.MODULE$;
            }
            if (tuple2 != null && tuple2._1() instanceof IntegralType && tuple2._2() instanceof IntegralType) {
                return Nil$.MODULE$;
            }
            if (tuple2 != null && tuple2._1() instanceof FractionalType && tuple2._2() instanceof IntegralType) {
                return Nil$.MODULE$;
            }
            if (tuple2 != null && tuple2._1() instanceof FractionalType && tuple2._2() instanceof FractionalType) {
                return Nil$.MODULE$;
            }
            if (tuple2 != null && tuple2._1() instanceof TimestampType && tuple2._2() instanceof DateType ? true : tuple2 != null && tuple2._1() instanceof DateType && tuple2._2() instanceof TimestampType) {
                return Nil$.MODULE$;
            }
            if (tuple2 != null && tuple2._1() instanceof TimestampType ? true : tuple2 != null && tuple2._1() instanceof DateType) {
                return Nil$.MODULE$;
            }
            if (tuple2 != null && tuple2._1() instanceof StringType && tuple2._2() instanceof StringType) {
                return Nil$.MODULE$;
            }
            if (tuple2 != null) {
                DataType dataType4 = (DataType)tuple2._1();
                DataType dataType5 = (DataType)tuple2._2();
                if (dataType4 instanceof StructType) {
                    StructType structType = (StructType)dataType4;
                    StructField[] unsortedSchemaFields = structType.fields();
                    if (dataType5 instanceof StructType) {
                        StructType structType2 = (StructType)dataType5;
                        StructField[] unsortedDatasetFields = structType2.fields();
                        List structContext = (List)context.$colon$plus((Object)schemaAttrName, List$.MODULE$.canBuildFrom());
                        StructField[] schemaFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unsortedSchemaFields)).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), (Ordering)Ordering.String$.MODULE$);
                        StructField[] datasetFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unsortedDatasetFields)).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), (Ordering)Ordering.String$.MODULE$);
                        ListBuffer errorList = (ListBuffer)ListBuffer$.MODULE$.empty();
                        int schemaFieldsIdx = 0;
                        int datasetFieldsIdx = 0;
                        while (schemaFieldsIdx < schemaFields.length && datasetFieldsIdx < datasetFields.length) {
                            StructField schemaField = schemaFields[schemaFieldsIdx];
                            StructField datasetField = datasetFields[datasetFieldsIdx];
                            int nameComp = schemaField.name().compareTo(datasetField.name());
                            if (nameComp != 0 && schemaField.nullable()) {
                                if (nameComp > 0) {
                                    ++datasetFieldsIdx;
                                    this.addError((List<String>)structContext, (ListBuffer<String>)errorList, (Option<StructField>)None$.MODULE$, datasetField);
                                    continue;
                                }
                                ++schemaFieldsIdx;
                                continue;
                            }
                            if (nameComp == 0) {
                                DataType f1Type = schemaField.dataType();
                                DataType f2Type = datasetField.dataType();
                                errorList.$plus$plus$eq(this.compareTypes((List<String>)structContext, (Tuple3<String, DataType, Object>)new Tuple3((Object)schemaField.name(), (Object)f1Type, (Object)BoxesRunTime.boxToBoolean((boolean)schemaField.nullable())), (Tuple3<String, DataType, Object>)new Tuple3((Object)datasetField.name(), (Object)f2Type, (Object)BoxesRunTime.boxToBoolean((boolean)datasetField.nullable()))));
                                ++schemaFieldsIdx;
                                ++datasetFieldsIdx;
                                continue;
                            }
                            if (nameComp > 0) {
                                ++datasetFieldsIdx;
                                continue;
                            }
                            this.addError((List<String>)structContext, (ListBuffer<String>)errorList, (Option<StructField>)new Some((Object)schemaField), datasetField);
                            ++schemaFieldsIdx;
                        }
                        if (schemaFieldsIdx == schemaFields.length) {
                            while (datasetFieldsIdx < datasetFields.length) {
                                StructField f2 = datasetFields[datasetFieldsIdx];
                                this.addError((List<String>)structContext, (ListBuffer<String>)errorList, (Option<StructField>)None$.MODULE$, f2);
                                ++datasetFieldsIdx;
                            }
                        }
                        return errorList.toList();
                    }
                }
            }
            if (tuple2 == null) break;
            DataType dataType6 = (DataType)tuple2._1();
            DataType dataType7 = (DataType)tuple2._2();
            if (!(dataType6 instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType6;
            DataType elementType1 = arrayType.elementType();
            boolean containsNull1 = arrayType.containsNull();
            if (!(dataType7 instanceof ArrayType)) break;
            ArrayType arrayType2 = (ArrayType)dataType7;
            DataType elementType2 = arrayType2.elementType();
            datasetType = new Tuple3((Object)schemaAttrName, (Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull1));
            schemaType = new Tuple3((Object)schemaAttrName, (Object)elementType1, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull1));
            context = (List)context.$colon$plus((Object)schemaAttrName, List$.MODULE$.canBuildFrom());
        }
        if (tuple2 != null) {
            return new .colon.colon((Object)new StringBuilder(73).append("Validation error in context: ").append(context.mkString(".")).append(", ").append(datasetAttrName).append(":").append(datasetAttrType).append(" isnullable:").append(datasetAttrNullable).append(" against ").append("schema ").append(schemaAttrName).append(":").append(schemaAttrType).append(" isnullable:").append(schemaAttrNullable).toString(), (List)Nil$.MODULE$);
        }
        throw new MatchError((Object)tuple2);
    }

    private void addError(List<String> context, ListBuffer<String> errorList, Option<StructField> expected, StructField incoming) {
        Option<StructField> option = expected;
        if (option instanceof Some) {
            Some some = (Some)option;
            StructField expected2 = (StructField)some.value();
            errorList.$plus$eq((Object)new StringBuilder(47).append(incoming.name()).append(": ").append(incoming.dataType().typeName()).append(", expected required attribute ").append(expected2.name()).append(" : ").append(expected2.dataType().typeName()).append(" in context ").append(context.mkString(".")).toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            errorList.$plus$eq((Object)new StringBuilder(35).append(incoming.name()).append(", ").append(incoming.dataType().typeName()).append(", ").append(context.mkString(".")).append(", unknown field ").append(incoming.name()).append(" : ").append(incoming.dataType().typeName()).append(" in context ").append(context.mkString(".")).toString());
            return;
        }
        throw new MatchError(option);
    }

    public Function2<DataType, DataType, Option<DataType>> findTightestCommonTypeOfTwo() {
        return this.findTightestCommonTypeOfTwo;
    }

    public DataType compatibleType(DataType t1, DataType t2) {
        return (DataType)((Option)this.findTightestCommonTypeOfTwo().apply((Object)t1, (Object)t2)).getOrElse(() -> JsonIngestionUtil$.$anonfun$compatibleType$1(t1, t2));
    }

    private Option<DataType> canonicalizeType(DataType tpe) {
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            return this.canonicalizeType(elementType).map((Function1 & Serializable & scala.Serializable)canonicalType -> arrayType.copy(canonicalType, arrayType.copy$default$2()));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            StructField[] canonicalFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).withFilter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)JsonIngestionUtil$.$anonfun$canonicalizeType$2(field))).flatMap((Function1 & Serializable & scala.Serializable)field -> Option$.MODULE$.option2Iterable(MODULE$.canonicalizeType(field.dataType()).map((Function1 & Serializable & scala.Serializable)canonicalType -> {
                DataType x$1 = canonicalType;
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, x$1, x$3, x$4);
            })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            if (canonicalFields.length > 0) {
                return new Some((Object)new StructType(canonicalFields));
            }
            return None$.MODULE$;
        }
        if (NullType$.MODULE$.equals(dataType)) {
            return new Some((Object)StringType$.MODULE$);
        }
        return new Some((Object)dataType);
    }

    public DataType inferSchema(JsonParser parser) {
        JsonToken jsonToken;
        while (true) {
            if ((jsonToken = parser.getCurrentToken()) == null ? true : JsonToken.VALUE_NULL.equals(jsonToken)) {
                return NullType$.MODULE$;
            }
            if (!JsonToken.FIELD_NAME.equals(jsonToken)) break;
            parser.nextToken();
        }
        if (JsonToken.START_ARRAY.equals(jsonToken)) {
            NullType$ elementType = NullType$.MODULE$;
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                elementType = this.compatibleType((DataType)elementType, this.inferSchema(parser));
            }
            return ArrayType$.MODULE$.apply((DataType)elementType);
        }
        if (JsonToken.START_OBJECT.equals(jsonToken)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                builder.$plus$eq((Object)new StructField(parser.getCurrentName(), this.inferSchema(parser), true, StructField$.MODULE$.apply$default$4()));
            }
            StructField[] fields = (StructField[])builder.result();
            return new StructType(fields);
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken)) {
            return StringType$.MODULE$;
        }
        if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken)) {
            JsonParser.NumberType numberType = parser.getNumberType();
            if (JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType)) {
                return LongType$.MODULE$;
            }
            if (JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType)) {
                BigDecimal v = parser.getDecimalValue();
                if (Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION()) {
                    return new DecimalType(Math.max(v.precision(), v.scale()), v.scale());
                }
                return DoubleType$.MODULE$;
            }
            if (JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType)) {
                return DoubleType$.MODULE$;
            }
            throw new MatchError((Object)numberType);
        }
        if (JsonToken.VALUE_TRUE.equals(jsonToken) ? true : JsonToken.VALUE_FALSE.equals(jsonToken)) {
            return BooleanType$.MODULE$;
        }
        throw new Exception("Should never happen");
    }

    public Try<DataType> parseString(String content) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (DataType)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> MODULE$.factory().createParser(content), (Function1 & Serializable & scala.Serializable)parser -> {
            parser.nextToken();
            return MODULE$.inferSchema((JsonParser)parser);
        }));
    }

    public String[] validateRecord(String record, DataType schema) {
        Try<DataType> try_ = this.parseString(record);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DataType datasetType = (DataType)success.value();
            return (String[])this.compareTypes(schema, datasetType).toArray(ClassTag$.MODULE$.apply(String.class));
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return (String[])((Object[])new String[]{exception.toString()});
        }
        throw new MatchError(try_);
    }

    public JsonFactory factory() {
        return this.factory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findTightestCommonTypeOfTwo$2(NumericType x14$1, NumericType x15$1, NumericType t) {
        NumericType numericType = t;
        NumericType numericType2 = x14$1;
        if (numericType == null) {
            if (numericType2 == null) return true;
        } else if (numericType.equals(numericType2)) return true;
        NumericType numericType3 = t;
        NumericType numericType4 = x15$1;
        if (numericType3 != null) {
            if (!numericType3.equals(numericType4)) return false;
            return true;
        }
        if (numericType4 == null) return true;
        return false;
    }

    public static final /* synthetic */ String $anonfun$compatibleType$2(StructField x$5) {
        return x$5.name();
    }

    public static final /* synthetic */ String $anonfun$compatibleType$3(StructField x$6) {
        return x$6.name();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ DataType $anonfun$compatibleType$1(DataType t1$1, DataType t2$1) {
        block26: {
            block25: {
                var4_2 = new Tuple2((Object)t1$1, (Object)t2$1);
                if (var4_2 == null || !DoubleType$.MODULE$.equals(var5_3 = (DataType)var4_2._1()) || !(var4_2._2() instanceof DecimalType)) break block25;
                v0 = true;
                break block26;
            }
            if (var4_2 == null) ** GOTO lbl-1000
            var6_4 = (DataType)var4_2._2();
            if (var4_2._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var6_4)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            return DoubleType$.MODULE$;
        }
        if (var4_2 != null) {
            t1 = (DataType)var4_2._1();
            t2 = (DataType)var4_2._2();
            if (t1 instanceof DecimalType) {
                var9_7 = (DecimalType)t1;
                if (t2 instanceof DecimalType) {
                    var10_8 = (DecimalType)t2;
                    scale = scala.math.package$.MODULE$.max(var9_7.scale(), var10_8.scale());
                    range = scala.math.package$.MODULE$.max(var9_7.precision() - var9_7.scale(), var10_8.precision() - var10_8.scale());
                    if (range + scale > 38) {
                        return DoubleType$.MODULE$;
                    }
                    return new DecimalType(range + scale, scale);
                }
            }
        }
        if (var4_2 != null) {
            var13_11 = (DataType)var4_2._1();
            var14_12 = (DataType)var4_2._2();
            if (var13_11 instanceof StructType) {
                var15_13 = (StructType)var13_11;
                unsortedFields1 = var15_13.fields();
                if (var14_12 instanceof StructType) {
                    var17_15 = (StructType)var14_12;
                    unsortedFields2 = var17_15.fields();
                    fields1 = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unsortedFields1)).sortBy((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$compatibleType$2(org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/String;)(), (Ordering)Ordering.String$.MODULE$);
                    fields2 = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unsortedFields2)).sortBy((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$compatibleType$3(org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/String;)(), (Ordering)Ordering.String$.MODULE$);
                    newFields = new ArrayList<StructField>();
                    f1Idx = 0;
                    f2Idx = 0;
                    while (f1Idx < fields1.length && f2Idx < fields2.length) {
                        f1Name = fields1[f1Idx].name();
                        comp = f1Name.compareTo(f2Name = fields2[f2Idx].name());
                        if (comp == 0) {
                            dataType = JsonIngestionUtil$.MODULE$.compatibleType(fields1[f1Idx].dataType(), fields2[f2Idx].dataType());
                            newFields.add(new StructField(f1Name, dataType, true, StructField$.MODULE$.apply$default$4()));
                            ++f1Idx;
                            ++f2Idx;
                            continue;
                        }
                        if (comp < 0) {
                            newFields.add(fields1[f1Idx]);
                            ++f1Idx;
                            continue;
                        }
                        newFields.add(fields2[f2Idx]);
                        ++f2Idx;
                    }
                    while (f1Idx < fields1.length) {
                        newFields.add(fields1[f1Idx]);
                        ++f1Idx;
                    }
                    while (f2Idx < fields2.length) {
                        newFields.add(fields2[f2Idx]);
                        ++f2Idx;
                    }
                    return new StructType((StructField[])newFields.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StructField.class))));
                }
            }
        }
        if (var4_2 != null) {
            var28_26 = (DataType)var4_2._1();
            var29_27 = (DataType)var4_2._2();
            if (var28_26 instanceof ArrayType) {
                var30_28 = (ArrayType)var28_26;
                elementType1 = var30_28.elementType();
                containsNull1 = var30_28.containsNull();
                if (var29_27 instanceof ArrayType) {
                    var33_31 = (ArrayType)var29_27;
                    elementType2 = var33_31.elementType();
                    containsNull2 = var33_31.containsNull();
                    return new ArrayType(JsonIngestionUtil$.MODULE$.compatibleType(elementType1, elementType2), containsNull1 != false || containsNull2 != false);
                }
            }
        }
        if (var4_2 != null) {
            t1 = (DataType)var4_2._1();
            t2 = (DataType)var4_2._2();
            if (t1 instanceof IntegralType) {
                var38_36 = (IntegralType)t1;
                if (t2 instanceof DecimalType) {
                    var39_37 = (DecimalType)t2;
                    return JsonIngestionUtil$.MODULE$.compatibleType((DataType)DecimalType$.MODULE$.forType((DataType)var38_36), (DataType)var39_37);
                }
            }
        }
        if (var4_2 != null) {
            t1 = (DataType)var4_2._1();
            t2 = (DataType)var4_2._2();
            if (t1 instanceof DecimalType) {
                var42_40 = (DecimalType)t1;
                if (t2 instanceof IntegralType) {
                    var43_41 = (IntegralType)t2;
                    return JsonIngestionUtil$.MODULE$.compatibleType((DataType)var42_40, (DataType)DecimalType$.MODULE$.forType((DataType)var43_41));
                }
            }
        }
        if (var4_2 != null) {
            return StringType$.MODULE$;
        }
        throw new MatchError((Object)var4_2);
    }

    public static final /* synthetic */ boolean $anonfun$canonicalizeType$2(StructField field) {
        return new StringOps(Predef$.MODULE$.augmentString(field.name())).nonEmpty();
    }

    private JsonIngestionUtil$() {
        MODULE$ = this;
        this.numericPrecedence = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$}));
        this.structFieldComparator = new Comparator<StructField>(){

            public Comparator<StructField> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<StructField> thenComparing(Comparator<? super StructField> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<StructField> thenComparing(Function<? super StructField, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<StructField> thenComparing(Function<? super StructField, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<StructField> thenComparingInt(ToIntFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<StructField> thenComparingLong(ToLongFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<StructField> thenComparingDouble(ToDoubleFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(StructField o1, StructField o2) {
                return new StringOps(Predef$.MODULE$.augmentString(o1.name())).compare(o2.name());
            }
        };
        this.findTightestCommonTypeOfTwo = (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                DataType t1 = (DataType)tuple2._1();
                DataType t2 = (DataType)tuple2._2();
                DataType dataType = t1;
                DataType dataType2 = t2;
                if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                    return new Some((Object)t1);
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType t1 = (DataType)tuple2._2();
                if (NullType$.MODULE$.equals(dataType)) {
                    return new Some((Object)t1);
                }
            }
            if (tuple2 != null) {
                DataType t1 = (DataType)tuple2._1();
                DataType dataType = (DataType)tuple2._2();
                if (NullType$.MODULE$.equals(dataType)) {
                    return new Some((Object)t1);
                }
            }
            if (tuple2 != null) {
                DataType t1 = (DataType)tuple2._1();
                DataType t2 = (DataType)tuple2._2();
                if (t1 instanceof IntegralType) {
                    DecimalType decimalType;
                    IntegralType integralType = (IntegralType)t1;
                    if (t2 instanceof DecimalType && (decimalType = (DecimalType)t2).isWiderThan((DataType)integralType)) {
                        return new Some((Object)decimalType);
                    }
                }
            }
            if (tuple2 != null) {
                DataType t1 = (DataType)tuple2._1();
                DataType t2 = (DataType)tuple2._2();
                if (t1 instanceof DecimalType) {
                    IntegralType integralType;
                    DecimalType decimalType = (DecimalType)t1;
                    if (t2 instanceof IntegralType && decimalType.isWiderThan((DataType)(integralType = (IntegralType)t2))) {
                        return new Some((Object)decimalType);
                    }
                }
            }
            if (tuple2 != null) {
                DataType t1 = (DataType)tuple2._1();
                DataType t2 = (DataType)tuple2._2();
                if (t1 instanceof NumericType) {
                    NumericType numericType = (NumericType)t1;
                    if (t2 instanceof NumericType) {
                        NumericType numericType2 = (NumericType)t2;
                        if (!(numericType instanceof DecimalType) && !(numericType2 instanceof DecimalType)) {
                            int index = MODULE$.numericPrecedence().lastIndexWhere((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)JsonIngestionUtil$.$anonfun$findTightestCommonTypeOfTwo$2(numericType, numericType2, t)));
                            return new Some(MODULE$.numericPrecedence().apply(index));
                        }
                    }
                }
            }
            if (tuple2 != null && tuple2._1() instanceof TimestampType && tuple2._2() instanceof DateType ? true : tuple2 != null && tuple2._1() instanceof DateType && tuple2._2() instanceof TimestampType) {
                return new Some((Object)TimestampType$.MODULE$);
            }
            return None$.MODULE$;
        };
        this.factory = new JsonFactory().enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
    }
}

