/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.superstream;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;

public class SuperstreamCounters {
    @JsonProperty(value="total_read_bytes_reduced")
    public AtomicLong TotalReadBytesReduced = new AtomicLong(0L);
    @JsonProperty(value="total_write_bytes_reduced")
    public AtomicLong TotalWriteBytesReduced = new AtomicLong(0L);
    public AtomicLong TotalReadBytes = new AtomicLong(0L);
    public Metrics metrics;

    public void reset() {
        this.TotalReadBytesReduced.set(0L);
        this.TotalWriteBytesReduced.set(0L);
    }

    public void incrementTotalReadBytesReduced(long bytes) {
        this.TotalReadBytesReduced.addAndGet(bytes);
    }

    public void incrementTotalWriteBytesReduced(long bytes) {
        this.TotalWriteBytesReduced.addAndGet(bytes);
    }

    public void incrementTotalReadBytes(long bytes) {
        this.TotalReadBytes.addAndGet(bytes);
    }

    public long getTotalReadBytesReduced() {
        return this.TotalReadBytesReduced.get();
    }

    public long getTotalWriteBytesReduced() {
        return this.TotalWriteBytesReduced.get();
    }

    public long getTotalReadBytes() {
        return this.TotalReadBytes.get();
    }

    public Double getProducerCompressionRate() {
        Double rate = this.getProducerCompressionMetric();
        if (rate == null || rate.isNaN() || rate > 1.0 || rate == 1.0 || rate < 0.0) {
            return 0.0;
        }
        if (rate > 0.0 && rate < 1.0) {
            return 1.0 - rate;
        }
        return 0.0;
    }

    public Double getConsumerCompressionRate() {
        Double totalBytesCompressedConsumed = this.getConsumerBytesConsumedMetric();
        long totalRead = this.getTotalReadBytes();
        if (totalBytesCompressedConsumed == null || totalBytesCompressedConsumed.isNaN() || totalBytesCompressedConsumed <= 0.0 || totalRead <= 0L) {
            return 0.0;
        }
        if (totalBytesCompressedConsumed > (double)totalRead) {
            return 0.0;
        }
        return 1.0 - totalBytesCompressedConsumed / (double)totalRead;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public Double getProducerCompressionMetric() {
        if (this.metrics != null) {
            for (Map.Entry<MetricName, KafkaMetric> entry : this.metrics.metrics().entrySet()) {
                String name = entry.getKey().name();
                if (!name.equals("compression-rate-avg")) continue;
                return (Double)((Metric)entry.getValue()).metricValue();
            }
        }
        return 0.0;
    }

    public Double getConsumerBytesConsumedMetric() {
        if (this.metrics != null) {
            for (Map.Entry<MetricName, KafkaMetric> entry : this.metrics.metrics().entrySet()) {
                String name = entry.getKey().name();
                if (!name.equals("bytes-consumed-total")) continue;
                return (Double)((Metric)entry.getValue()).metricValue();
            }
        }
        return 0.0;
    }
}

