/*
 * Decompiled with CFR 0.152.
 */
package ai.superstream;

import ai.superstream.Superstream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.shaded.com.google.protobuf.Descriptors;

public class SuperstreamDeserializer<T>
implements Deserializer<T> {
    private Deserializer<T> originalDeserializer;
    private Superstream superstreamConnection;

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            Deserializer originalDeserializerT;
            String originalDeserializerClassName;
            System.out.println("Running Superstream Kafka Consumer");
            String string = originalDeserializerClassName = configs.get("original.deserializer") != null ? (String)configs.get("original.deserializer") : null;
            if (originalDeserializerClassName == null) {
                throw new Exception("original deserializer is required");
            }
            Class<?> originalDeserializerClass = Class.forName(originalDeserializerClassName);
            this.originalDeserializer = originalDeserializerT = (Deserializer)originalDeserializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.originalDeserializer.configure(configs, isKey);
            Superstream superstreamConn = (Superstream)configs.get("superstream.connection");
            if (superstreamConn == null) {
                System.out.println("Failed to connect to Superstream - Running Kafka Consumer");
            } else {
                this.superstreamConnection = superstreamConn;
            }
        }
        catch (Exception e) {
            String errMsg = String.format("superstream: error initializing superstream: %s", e.getMessage());
            if (this.superstreamConnection != null) {
                this.superstreamConnection.handleError(errMsg);
            }
            System.out.println(errMsg);
        }
    }

    @Override
    public T deserialize(String topic, byte[] data) {
        T deserializedData = this.originalDeserializer.deserialize(topic, data);
        return deserializedData;
    }

    @Override
    public T deserialize(String topic, Headers headers, byte[] data) {
        Header header;
        String schemaId = null;
        byte[] dataToDesrialize = data;
        if (this.superstreamConnection != null) {
            this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(data.length);
        }
        if ((header = headers.lastHeader("superstream_schema")) != null) {
            schemaId = new String(header.value(), StandardCharsets.UTF_8);
        }
        if (schemaId != null) {
            Descriptors.Descriptor desc = this.superstreamConnection.SchemaIDMap.get(schemaId);
            if (desc == null) {
                this.superstreamConnection.sendGetSchemaRequest(schemaId);
                desc = this.superstreamConnection.SchemaIDMap.get(schemaId);
                if (desc == null) {
                    this.superstreamConnection.handleError("error getting schema with id: " + schemaId);
                    System.out.println("superstream: shcema not found");
                    return null;
                }
            }
            try {
                byte[] supertstreamDeserialized = this.superstreamConnection.protoToJson(data, desc);
                dataToDesrialize = supertstreamDeserialized;
                this.superstreamConnection.clientCounters.incrementTotalBytesBeforeReduction(supertstreamDeserialized.length);
                this.superstreamConnection.clientCounters.incrementTotalMessagesSuccessfullyConsumed();
            }
            catch (Exception e) {
                this.superstreamConnection.handleError(String.format("error deserializing data: %s", e.getMessage()));
                return null;
            }
        } else if (this.superstreamConnection != null) {
            this.superstreamConnection.clientCounters.incrementTotalBytesBeforeReduction(data.length);
            this.superstreamConnection.clientCounters.incrementTotalMessagesFailedConsume();
        }
        T deserializedData = this.originalDeserializer.deserialize(topic, dataToDesrialize);
        return deserializedData;
    }

    @Override
    public void close() {
        this.originalDeserializer.close();
        if (this.superstreamConnection != null) {
            this.superstreamConnection.close();
        }
    }
}

