/*
 * Decompiled with CFR 0.152.
 */
package ai.superstream;

import ai.superstream.Superstream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.serialization.Serializer;

public class SuperstreamSerializer<T>
implements Serializer<T> {
    private Serializer<T> originalSerializer;
    private Superstream superstreamConnection;

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            Serializer originalSerializerT;
            System.out.println("Running Superstream Kafka Producer");
            String originalSerializerClassName = (String)configs.get("original.serializer");
            if (originalSerializerClassName == null) {
                throw new Exception("original serializer is required");
            }
            Class<?> originalSerializerClass = Class.forName(originalSerializerClassName);
            this.originalSerializer = originalSerializerT = (Serializer)originalSerializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.originalSerializer.configure(configs, isKey);
            Superstream superstreamConn = (Superstream)configs.get("superstream.connection");
            if (superstreamConn == null) {
                System.out.println("Failed to connect to Superstream - Running Kafka Producer");
            } else {
                this.superstreamConnection = superstreamConn;
            }
        }
        catch (Exception e) {
            String errMsg = String.format("superstream: error initializing superstream: %s", e.getMessage());
            if (this.superstreamConnection != null) {
                this.superstreamConnection.handleError(errMsg);
            }
            System.out.println(errMsg);
        }
    }

    @Override
    public byte[] serialize(String topic, T data) {
        byte[] serializedData = this.originalSerializer.serialize(topic, data);
        return serializedData;
    }

    @Override
    public byte[] serialize(String topic, Headers headers, T data) {
        byte[] serializedResult;
        byte[] serializedData = this.originalSerializer.serialize(topic, data);
        if (this.superstreamConnection != null) {
            if (this.superstreamConnection.reductionEnabled.booleanValue()) {
                if (this.superstreamConnection.descriptor != null) {
                    try {
                        RecordHeader header = new RecordHeader("superstream_schema", this.superstreamConnection.ProducerSchemaID.getBytes(StandardCharsets.UTF_8));
                        headers.add(header);
                        byte[] superstreamSerialized = this.superstreamConnection.jsonToProto(serializedData);
                        this.superstreamConnection.clientCounters.incrementTotalBytesBeforeReduction(serializedData.length);
                        this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(superstreamSerialized.length);
                        this.superstreamConnection.clientCounters.incrementTotalMessagesSuccessfullyProduce();
                        serializedResult = superstreamSerialized;
                    }
                    catch (Exception e) {
                        serializedResult = serializedData;
                        this.superstreamConnection.handleError(String.format("error serializing data: ", e.getMessage()));
                        this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(serializedData.length);
                        this.superstreamConnection.clientCounters.incrementTotalMessagesFailedProduce();
                    }
                } else {
                    serializedResult = serializedData;
                    this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(serializedData.length);
                    if (this.superstreamConnection.learningFactorCounter <= this.superstreamConnection.learningFactor) {
                        this.superstreamConnection.sendLearningMessage(serializedResult);
                        ++this.superstreamConnection.learningFactorCounter;
                    } else if (!this.superstreamConnection.learningRequestSent) {
                        this.superstreamConnection.sendRegisterSchemaReq();
                    }
                }
            } else {
                serializedResult = serializedData;
                this.superstreamConnection.clientCounters.incrementTotalBytesBeforeReduction(serializedData.length);
                this.superstreamConnection.clientCounters.incrementTotalMessagesFailedProduce();
            }
        } else {
            serializedResult = serializedData;
        }
        return serializedResult;
    }

    @Override
    public void close() {
        this.originalSerializer.close();
        if (this.superstreamConnection != null) {
            this.superstreamConnection.close();
        }
    }
}

