/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class DescribeGroupsResponseDataJsonConverter {
    public static DescribeGroupsResponseData read(JsonNode _node, short _version) {
        DescribeGroupsResponseData _object = new DescribeGroupsResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("DescribeGroupsResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
            }
            _object.throttleTimeMs = 0;
        } else {
            _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "DescribeGroupsResponseData");
        }
        JsonNode _groupsNode = _node.get("groups");
        if (_groupsNode == null) {
            throw new RuntimeException("DescribeGroupsResponseData: unable to locate field 'groups', which is mandatory in version " + _version);
        }
        if (!_groupsNode.isArray()) {
            throw new RuntimeException("DescribeGroupsResponseData expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        ArrayList<DescribeGroupsResponseData.DescribedGroup> _collection = new ArrayList<DescribeGroupsResponseData.DescribedGroup>(_groupsNode.size());
        _object.groups = _collection;
        for (JsonNode _element : _groupsNode) {
            _collection.add(DescribedGroupJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(DescribeGroupsResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_version >= 1) {
            _node.set("throttleTimeMs", new IntNode(_object.throttleTimeMs));
        }
        ArrayNode _groupsArray = new ArrayNode(JsonNodeFactory.instance);
        for (DescribeGroupsResponseData.DescribedGroup _element : _object.groups) {
            _groupsArray.add(DescribedGroupJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("groups", _groupsArray);
        return _node;
    }

    public static JsonNode write(DescribeGroupsResponseData _object, short _version) {
        return DescribeGroupsResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class DescribedGroupJsonConverter {
        public static DescribeGroupsResponseData.DescribedGroup read(JsonNode _node, short _version) {
            DescribeGroupsResponseData.DescribedGroup _object = new DescribeGroupsResponseData.DescribedGroup();
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "DescribedGroup");
            JsonNode _groupIdNode = _node.get("groupId");
            if (_groupIdNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'groupId', which is mandatory in version " + _version);
            }
            if (!_groupIdNode.isTextual()) {
                throw new RuntimeException("DescribedGroup expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.groupId = _groupIdNode.asText();
            JsonNode _groupStateNode = _node.get("groupState");
            if (_groupStateNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'groupState', which is mandatory in version " + _version);
            }
            if (!_groupStateNode.isTextual()) {
                throw new RuntimeException("DescribedGroup expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.groupState = _groupStateNode.asText();
            JsonNode _protocolTypeNode = _node.get("protocolType");
            if (_protocolTypeNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'protocolType', which is mandatory in version " + _version);
            }
            if (!_protocolTypeNode.isTextual()) {
                throw new RuntimeException("DescribedGroup expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.protocolType = _protocolTypeNode.asText();
            JsonNode _protocolDataNode = _node.get("protocolData");
            if (_protocolDataNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'protocolData', which is mandatory in version " + _version);
            }
            if (!_protocolDataNode.isTextual()) {
                throw new RuntimeException("DescribedGroup expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.protocolData = _protocolDataNode.asText();
            JsonNode _membersNode = _node.get("members");
            if (_membersNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'members', which is mandatory in version " + _version);
            }
            if (!_membersNode.isArray()) {
                throw new RuntimeException("DescribedGroup expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
            }
            ArrayList<DescribeGroupsResponseData.DescribedGroupMember> _collection = new ArrayList<DescribeGroupsResponseData.DescribedGroupMember>(_membersNode.size());
            _object.members = _collection;
            for (JsonNode _element : _membersNode) {
                _collection.add(DescribedGroupMemberJsonConverter.read(_element, _version));
            }
            JsonNode _authorizedOperationsNode = _node.get("authorizedOperations");
            if (_authorizedOperationsNode == null) {
                if (_version >= 3) {
                    throw new RuntimeException("DescribedGroup: unable to locate field 'authorizedOperations', which is mandatory in version " + _version);
                }
                _object.authorizedOperations = Integer.MIN_VALUE;
            } else {
                _object.authorizedOperations = MessageUtil.jsonNodeToInt(_authorizedOperationsNode, "DescribedGroup");
            }
            return _object;
        }

        public static JsonNode write(DescribeGroupsResponseData.DescribedGroup _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("errorCode", new ShortNode(_object.errorCode));
            _node.set("groupId", new TextNode(_object.groupId));
            _node.set("groupState", new TextNode(_object.groupState));
            _node.set("protocolType", new TextNode(_object.protocolType));
            _node.set("protocolData", new TextNode(_object.protocolData));
            ArrayNode _membersArray = new ArrayNode(JsonNodeFactory.instance);
            for (DescribeGroupsResponseData.DescribedGroupMember _element : _object.members) {
                _membersArray.add(DescribedGroupMemberJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("members", _membersArray);
            if (_version >= 3) {
                _node.set("authorizedOperations", new IntNode(_object.authorizedOperations));
            } else if (_object.authorizedOperations != Integer.MIN_VALUE) {
                throw new UnsupportedVersionException("Attempted to write a non-default authorizedOperations at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(DescribeGroupsResponseData.DescribedGroup _object, short _version) {
            return DescribedGroupJsonConverter.write(_object, _version, true);
        }
    }

    public static class DescribedGroupMemberJsonConverter {
        public static DescribeGroupsResponseData.DescribedGroupMember read(JsonNode _node, short _version) {
            DescribeGroupsResponseData.DescribedGroupMember _object = new DescribeGroupsResponseData.DescribedGroupMember();
            JsonNode _memberIdNode = _node.get("memberId");
            if (_memberIdNode == null) {
                throw new RuntimeException("DescribedGroupMember: unable to locate field 'memberId', which is mandatory in version " + _version);
            }
            if (!_memberIdNode.isTextual()) {
                throw new RuntimeException("DescribedGroupMember expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.memberId = _memberIdNode.asText();
            JsonNode _groupInstanceIdNode = _node.get("groupInstanceId");
            if (_groupInstanceIdNode == null) {
                if (_version >= 4) {
                    throw new RuntimeException("DescribedGroupMember: unable to locate field 'groupInstanceId', which is mandatory in version " + _version);
                }
                _object.groupInstanceId = null;
            } else if (_groupInstanceIdNode.isNull()) {
                _object.groupInstanceId = null;
            } else {
                if (!_groupInstanceIdNode.isTextual()) {
                    throw new RuntimeException("DescribedGroupMember expected a string type, but got " + (Object)((Object)_node.getNodeType()));
                }
                _object.groupInstanceId = _groupInstanceIdNode.asText();
            }
            JsonNode _clientIdNode = _node.get("clientId");
            if (_clientIdNode == null) {
                throw new RuntimeException("DescribedGroupMember: unable to locate field 'clientId', which is mandatory in version " + _version);
            }
            if (!_clientIdNode.isTextual()) {
                throw new RuntimeException("DescribedGroupMember expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.clientId = _clientIdNode.asText();
            JsonNode _clientHostNode = _node.get("clientHost");
            if (_clientHostNode == null) {
                throw new RuntimeException("DescribedGroupMember: unable to locate field 'clientHost', which is mandatory in version " + _version);
            }
            if (!_clientHostNode.isTextual()) {
                throw new RuntimeException("DescribedGroupMember expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.clientHost = _clientHostNode.asText();
            JsonNode _memberMetadataNode = _node.get("memberMetadata");
            if (_memberMetadataNode == null) {
                throw new RuntimeException("DescribedGroupMember: unable to locate field 'memberMetadata', which is mandatory in version " + _version);
            }
            _object.memberMetadata = MessageUtil.jsonNodeToBinary(_memberMetadataNode, "DescribedGroupMember");
            JsonNode _memberAssignmentNode = _node.get("memberAssignment");
            if (_memberAssignmentNode == null) {
                throw new RuntimeException("DescribedGroupMember: unable to locate field 'memberAssignment', which is mandatory in version " + _version);
            }
            _object.memberAssignment = MessageUtil.jsonNodeToBinary(_memberAssignmentNode, "DescribedGroupMember");
            return _object;
        }

        public static JsonNode write(DescribeGroupsResponseData.DescribedGroupMember _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("memberId", new TextNode(_object.memberId));
            if (_version >= 4) {
                if (_object.groupInstanceId == null) {
                    _node.set("groupInstanceId", NullNode.instance);
                } else {
                    _node.set("groupInstanceId", new TextNode(_object.groupInstanceId));
                }
            }
            _node.set("clientId", new TextNode(_object.clientId));
            _node.set("clientHost", new TextNode(_object.clientHost));
            _node.set("memberMetadata", new BinaryNode(Arrays.copyOf(_object.memberMetadata, _object.memberMetadata.length)));
            _node.set("memberAssignment", new BinaryNode(Arrays.copyOf(_object.memberAssignment, _object.memberAssignment.length)));
            return _node;
        }

        public static JsonNode write(DescribeGroupsResponseData.DescribedGroupMember _object, short _version) {
            return DescribedGroupMemberJsonConverter.write(_object, _version, true);
        }
    }
}

