/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.kafka.common.KafkaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommonNameLoggingTrustManagerFactoryWrapper {
    private static final Logger log = LoggerFactory.getLogger(CommonNameLoggingTrustManagerFactoryWrapper.class);
    private TrustManagerFactory origTmf;

    protected CommonNameLoggingTrustManagerFactoryWrapper(String kmfAlgorithm) throws NoSuchAlgorithmException {
        this.origTmf = TrustManagerFactory.getInstance(kmfAlgorithm);
    }

    public static CommonNameLoggingTrustManagerFactoryWrapper getInstance(String kmfAlgorithm) throws NoSuchAlgorithmException {
        return new CommonNameLoggingTrustManagerFactoryWrapper(kmfAlgorithm);
    }

    public TrustManagerFactory getOriginalTrustManagerFactory() {
        return this.origTmf;
    }

    public String getAlgorithm() {
        return this.origTmf.getAlgorithm();
    }

    public void init(KeyStore ts) throws KeyStoreException {
        this.origTmf.init(ts);
    }

    public TrustManager[] getTrustManagers() {
        TrustManager[] origTrustManagers = this.origTmf.getTrustManagers();
        TrustManager[] wrappedTrustManagers = new TrustManager[origTrustManagers.length];
        for (int i = 0; i < origTrustManagers.length; ++i) {
            TrustManager tm = origTrustManagers[i];
            wrappedTrustManagers[i] = tm instanceof X509TrustManager ? new CommonNameLoggingTrustManager((X509TrustManager)tm, 2000) : tm;
        }
        return wrappedTrustManagers;
    }

    static class CommonNameLoggingTrustManager
    implements X509TrustManager {
        private final X509TrustManager origTm;
        final int nrOfRememberedBadCerts;
        private final LinkedHashMap<ByteBuffer, String> previouslyRejectedClientCertChains;

        public CommonNameLoggingTrustManager(X509TrustManager originalTrustManager, final int nrOfRememberedBadCerts) {
            this.origTm = originalTrustManager;
            this.nrOfRememberedBadCerts = nrOfRememberedBadCerts;
            this.previouslyRejectedClientCertChains = new LinkedHashMap<ByteBuffer, String>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<ByteBuffer, String> eldest) {
                    return this.size() > nrOfRememberedBadCerts;
                }
            };
        }

        public X509TrustManager getOriginalTrustManager() {
            return this.origTm;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            String errorMessage;
            CertificateException origException = null;
            ByteBuffer chainDigest = CommonNameLoggingTrustManager.calcDigestForCertificateChain(chain);
            if (chainDigest != null && (errorMessage = this.previouslyRejectedClientCertChains.get(chainDigest)) != null) {
                this.addRejectedClientCertChains(chainDigest, errorMessage, true);
                throw new CertificateException(errorMessage);
            }
            try {
                this.origTm.checkClientTrusted(chain, authType);
            }
            catch (CertificateException e) {
                origException = e;
                try {
                    X509Certificate[] wrappedChain = CommonNameLoggingTrustManager.sortChainAnWrapEndCertificate(chain);
                    this.origTm.checkClientTrusted(wrappedChain, authType);
                    Date now = new Date();
                    if (wrappedChain[0].getNotBefore().before(now)) {
                        String commonName = wrappedChain[0].getSubjectX500Principal().toString();
                        String notValidAfter = wrappedChain[0].getNotAfter().toString();
                        log.info("Certificate with common name \"" + commonName + "\" expired on " + notValidAfter);
                        this.addRejectedClientCertChains(chainDigest, origException.getMessage(), false);
                    }
                }
                catch (CertificateException innerException) {
                    this.addRejectedClientCertChains(chainDigest, origException.getMessage(), false);
                }
            }
            if (origException != null) {
                throw origException;
            }
        }

        public static ByteBuffer calcDigestForCertificateChain(X509Certificate[] chain) throws CertificateEncodingException {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
            for (X509Certificate cert : chain) {
                md.update(cert.getEncoded());
            }
            return ByteBuffer.wrap(md.digest());
        }

        private void addRejectedClientCertChains(ByteBuffer chainDigest, String errorMessage, boolean removeIfExisting) {
            if (removeIfExisting) {
                this.previouslyRejectedClientCertChains.remove(chainDigest);
            }
            this.previouslyRejectedClientCertChains.put(chainDigest, errorMessage);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.origTm.checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.origTm.getAcceptedIssuers();
        }

        public static X509Certificate[] sortChainAnWrapEndCertificate(X509Certificate[] origChain) throws CertificateException {
            if (origChain == null || origChain.length < 1) {
                throw new CertificateException("Certificate chain is null or empty");
            }
            HashMap<X500Principal, X509Certificate> principalToCertMap = new HashMap<X500Principal, X509Certificate>();
            HashMap<X500Principal, X509Certificate> issuedbyPrincipalToCertificatesMap = new HashMap<X500Principal, X509Certificate>();
            for (X509Certificate cert : origChain) {
                X500Principal principal = cert.getSubjectX500Principal();
                X500Principal issuerPrincipal = cert.getIssuerX500Principal();
                if (issuerPrincipal.equals(principal)) {
                    boolean isCA;
                    boolean bl = isCA = cert.getBasicConstraints() >= 0;
                    if (!isCA) {
                        throw new CertificateException("Self-signed certificate in chain that is not a CA!");
                    }
                }
                issuedbyPrincipalToCertificatesMap.put(issuerPrincipal, cert);
                principalToCertMap.put(principal, cert);
            }
            HashSet<X509Certificate> endCertificates = new HashSet<X509Certificate>();
            for (X509Certificate cert : origChain) {
                X500Principal subjectPrincipal = cert.getSubjectX500Principal();
                if (issuedbyPrincipalToCertificatesMap.containsKey(subjectPrincipal)) continue;
                endCertificates.add(cert);
            }
            if (endCertificates.size() != 1) {
                throw new CertificateException("Multiple end certificates in chain");
            }
            X509Certificate endCertificate = (X509Certificate)endCertificates.iterator().next();
            X509Certificate[] wrappedChain = new X509Certificate[origChain.length];
            wrappedChain[0] = new NeverExpiringX509Certificate(endCertificate);
            for (int i = 1; i < origChain.length; ++i) {
                X500Principal siblingCertificateIssuer = wrappedChain[i - 1].getIssuerX500Principal();
                if (!principalToCertMap.containsKey(siblingCertificateIssuer)) {
                    throw new CertificateException("Certificate chain contains certificates not belonging to the chain");
                }
                wrappedChain[i] = (X509Certificate)principalToCertMap.get(siblingCertificateIssuer);
            }
            return wrappedChain;
        }
    }

    static class NeverExpiringX509Certificate
    extends X509Certificate {
        private X509Certificate origCertificate;

        public NeverExpiringX509Certificate(X509Certificate origCertificate) {
            this.origCertificate = origCertificate;
            if (this.origCertificate == null) {
                throw new KafkaException("No X509 certificate provided in constructor NeverExpiringX509Certificate");
            }
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return this.origCertificate.getCriticalExtensionOIDs();
        }

        @Override
        public byte[] getExtensionValue(String oid) {
            return this.origCertificate.getExtensionValue(oid);
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return this.origCertificate.getNonCriticalExtensionOIDs();
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return this.origCertificate.hasUnsupportedCriticalExtension();
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            Date now = new Date();
            if (this.origCertificate.getNotAfter().before(now)) {
                return;
            }
            this.origCertificate.checkValidity();
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        }

        @Override
        public int getBasicConstraints() {
            return this.origCertificate.getBasicConstraints();
        }

        @Override
        public Principal getIssuerDN() {
            return this.origCertificate.getIssuerDN();
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return this.origCertificate.getIssuerUniqueID();
        }

        @Override
        public boolean[] getKeyUsage() {
            return this.origCertificate.getKeyUsage();
        }

        @Override
        public Date getNotAfter() {
            return this.origCertificate.getNotAfter();
        }

        @Override
        public Date getNotBefore() {
            return this.origCertificate.getNotBefore();
        }

        @Override
        public BigInteger getSerialNumber() {
            return this.origCertificate.getSerialNumber();
        }

        @Override
        public String getSigAlgName() {
            return this.origCertificate.getSigAlgName();
        }

        @Override
        public String getSigAlgOID() {
            return this.origCertificate.getSigAlgOID();
        }

        @Override
        public byte[] getSigAlgParams() {
            return this.origCertificate.getSigAlgParams();
        }

        @Override
        public byte[] getSignature() {
            return this.origCertificate.getSignature();
        }

        @Override
        public Principal getSubjectDN() {
            return this.origCertificate.getSubjectDN();
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return this.origCertificate.getSubjectUniqueID();
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            return this.origCertificate.getTBSCertificate();
        }

        @Override
        public int getVersion() {
            return this.origCertificate.getVersion();
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return this.origCertificate.getEncoded();
        }

        @Override
        public PublicKey getPublicKey() {
            return this.origCertificate.getPublicKey();
        }

        @Override
        public String toString() {
            return this.origCertificate.toString();
        }

        @Override
        public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            this.origCertificate.verify(publicKey);
        }

        @Override
        public void verify(PublicKey publicKey, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            this.origCertificate.verify(publicKey, sigProvider);
        }
    }
}

