/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ConsumerContext;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamOptions;
import io.nats.client.OrderedConsumerContext;
import io.nats.client.PurgeOptions;
import io.nats.client.StreamContext;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.MessageInfo;
import io.nats.client.api.OrderedConsumerConfiguration;
import io.nats.client.api.PurgeResponse;
import io.nats.client.api.StreamInfo;
import io.nats.client.api.StreamInfoOptions;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsConsumerContext;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamManagement;
import io.nats.client.impl.NatsOrderedConsumerContext;
import java.io.IOException;
import java.util.List;

class NatsStreamContext
implements StreamContext {
    final String streamName;
    final NatsJetStream js;
    final NatsJetStreamManagement jsm;

    NatsStreamContext(String streamName, NatsJetStream js, NatsConnection connection, JetStreamOptions jsOptions) throws IOException, JetStreamApiException {
        this.streamName = streamName;
        this.js = js == null ? new NatsJetStream(connection, jsOptions) : js;
        this.jsm = new NatsJetStreamManagement(connection, jsOptions);
        this.jsm.getStreamInfo(streamName);
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public StreamInfo getStreamInfo() throws IOException, JetStreamApiException {
        return this.jsm.getStreamInfo(this.streamName);
    }

    @Override
    public StreamInfo getStreamInfo(StreamInfoOptions options) throws IOException, JetStreamApiException {
        return this.jsm.getStreamInfo(this.streamName, options);
    }

    @Override
    public PurgeResponse purge() throws IOException, JetStreamApiException {
        return this.jsm.purgeStream(this.streamName);
    }

    @Override
    public PurgeResponse purge(PurgeOptions options) throws IOException, JetStreamApiException {
        return this.jsm.purgeStream(this.streamName, options);
    }

    @Override
    public ConsumerContext getConsumerContext(String consumerName) throws IOException, JetStreamApiException {
        return new NatsConsumerContext(this, this.jsm.getConsumerInfo(this.streamName, consumerName));
    }

    @Override
    public ConsumerContext createOrUpdateConsumer(ConsumerConfiguration config) throws IOException, JetStreamApiException {
        return new NatsConsumerContext(this, this.jsm.addOrUpdateConsumer(this.streamName, config));
    }

    @Override
    public OrderedConsumerContext createOrderedConsumer(OrderedConsumerConfiguration config) throws IOException, JetStreamApiException {
        return new NatsOrderedConsumerContext(this, config);
    }

    @Override
    public boolean deleteConsumer(String consumerName) throws IOException, JetStreamApiException {
        return this.jsm.deleteConsumer(this.streamName, consumerName);
    }

    @Override
    public ConsumerInfo getConsumerInfo(String consumerName) throws IOException, JetStreamApiException {
        return this.jsm.getConsumerInfo(this.streamName, consumerName);
    }

    @Override
    public List<String> getConsumerNames() throws IOException, JetStreamApiException {
        return this.jsm.getConsumerNames(this.streamName);
    }

    @Override
    public List<ConsumerInfo> getConsumers() throws IOException, JetStreamApiException {
        return this.jsm.getConsumers(this.streamName);
    }

    @Override
    public MessageInfo getMessage(long seq) throws IOException, JetStreamApiException {
        return this.jsm.getMessage(this.streamName, seq);
    }

    @Override
    public MessageInfo getLastMessage(String subject) throws IOException, JetStreamApiException {
        return this.jsm.getLastMessage(this.streamName, subject);
    }

    @Override
    public MessageInfo getFirstMessage(String subject) throws IOException, JetStreamApiException {
        return this.jsm.getFirstMessage(this.streamName, subject);
    }

    @Override
    public MessageInfo getNextMessage(long seq, String subject) throws IOException, JetStreamApiException {
        return this.jsm.getNextMessage(this.streamName, seq, subject);
    }

    @Override
    public boolean deleteMessage(long seq) throws IOException, JetStreamApiException {
        return this.jsm.deleteMessage(this.streamName, seq);
    }

    @Override
    public boolean deleteMessage(long seq, boolean erase) throws IOException, JetStreamApiException {
        return this.jsm.deleteMessage(this.streamName, seq, erase);
    }
}

