/*
 * Decompiled with CFR 0.152.
 */
package ai.superstream;

import ai.superstream.Superstream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.serialization.Serializer;

public class SuperstreamSerializer<T>
implements Serializer<T> {
    private Serializer<T> originalSerializer;
    private Superstream superstreamConnection;

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            Serializer originalSerializerT;
            Class originalSerializerClass;
            Object originalSerializerObj = configs.get("original.serializer");
            if (originalSerializerObj == null) {
                throw new Exception("original serializer is required");
            }
            if (originalSerializerObj instanceof String) {
                originalSerializerClass = Class.forName((String)originalSerializerObj);
            } else if (originalSerializerObj instanceof Class) {
                originalSerializerClass = (Class)originalSerializerObj;
            } else {
                throw new Exception("Invalid type for original serializer");
            }
            this.originalSerializer = originalSerializerT = (Serializer)originalSerializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.originalSerializer.configure(configs, isKey);
            Superstream superstreamConn = (Superstream)configs.get("superstream.connection");
            if (superstreamConn == null) {
                System.out.println("Failed to connect to Superstream");
            } else {
                this.superstreamConnection = superstreamConn;
            }
        }
        catch (Exception e) {
            String errMsg = String.format("superstream: error initializing superstream: %s", e.getMessage());
            if (this.superstreamConnection != null) {
                this.superstreamConnection.handleError(errMsg);
            }
            System.out.println(errMsg);
        }
    }

    @Override
    public byte[] serialize(String topic, T data) {
        if (this.originalSerializer == null) {
            return null;
        }
        byte[] serializedData = this.originalSerializer.serialize(topic, data);
        return serializedData;
    }

    @Override
    public byte[] serialize(String topic, Headers headers, T data) {
        byte[] serializedResult;
        block14: {
            if (this.originalSerializer == null) {
                return null;
            }
            byte[] serializedData = this.originalSerializer.serialize(topic, headers, data);
            if (serializedData == null) {
                return null;
            }
            if (this.superstreamConnection != null && this.superstreamConnection.superstreamReady.booleanValue()) {
                if (this.superstreamConnection.reductionEnabled.booleanValue()) {
                    if (this.superstreamConnection.descriptor != null) {
                        try {
                            Superstream.JsonToProtoResult jsonToProtoResult = this.superstreamConnection.jsonToProto(serializedData);
                            if (jsonToProtoResult.isSuccess()) {
                                byte[] superstreamSerialized = jsonToProtoResult.getMessageBytes();
                                this.superstreamConnection.clientCounters.incrementTotalBytesBeforeReduction(serializedData.length);
                                this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(superstreamSerialized.length);
                                this.superstreamConnection.clientCounters.incrementTotalMessagesSuccessfullyProduce();
                                serializedResult = superstreamSerialized;
                                RecordHeader header = new RecordHeader("superstream_schema", this.superstreamConnection.ProducerSchemaID.getBytes(StandardCharsets.UTF_8));
                                headers.add(header);
                                break block14;
                            }
                            serializedResult = serializedData;
                            this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(serializedData.length);
                        }
                        catch (Exception e) {
                            serializedResult = serializedData;
                            this.superstreamConnection.handleError(String.format("error serializing data: ", e.getMessage()));
                            this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(serializedData.length);
                            this.superstreamConnection.clientCounters.incrementTotalMessagesFailedProduce();
                        }
                    } else {
                        serializedResult = serializedData;
                        this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(serializedData.length);
                        if (this.superstreamConnection.learningFactorCounter <= this.superstreamConnection.learningFactor) {
                            this.superstreamConnection.sendLearningMessage(serializedResult);
                            ++this.superstreamConnection.learningFactorCounter;
                        } else if (!this.superstreamConnection.learningRequestSent) {
                            this.superstreamConnection.sendRegisterSchemaReq();
                        }
                    }
                } else {
                    serializedResult = serializedData;
                    this.superstreamConnection.clientCounters.incrementTotalBytesBeforeReduction(serializedData.length);
                    this.superstreamConnection.clientCounters.incrementTotalMessagesFailedProduce();
                }
            } else {
                serializedResult = serializedData;
            }
        }
        return serializedResult;
    }

    @Override
    public void close() {
        if (this.originalSerializer != null) {
            this.originalSerializer.close();
        }
        if (this.superstreamConnection != null) {
            this.superstreamConnection.close();
        }
    }
}

