/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.LostStreamData;
import io.nats.client.api.Subject;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.ZonedDateTime;
import java.util.List;

public class StreamState {
    private final long msgs;
    private final long bytes;
    private final long firstSeq;
    private final long lastSeq;
    private final long consumerCount;
    private final long subjectCount;
    private final long deletedCount;
    private final ZonedDateTime firstTime;
    private final ZonedDateTime lastTime;
    private final List<Subject> subjects;
    private final List<Long> deletedStreamSequences;
    private final LostStreamData lostStreamData;

    StreamState(JsonValue vStreamState) {
        this.msgs = JsonValueUtils.readLong(vStreamState, "messages", 0L);
        this.bytes = JsonValueUtils.readLong(vStreamState, "bytes", 0L);
        this.firstSeq = JsonValueUtils.readLong(vStreamState, "first_seq", 0L);
        this.lastSeq = JsonValueUtils.readLong(vStreamState, "last_seq", 0L);
        this.consumerCount = JsonValueUtils.readLong(vStreamState, "consumer_count", 0L);
        this.firstTime = JsonValueUtils.readDate(vStreamState, "first_ts");
        this.lastTime = JsonValueUtils.readDate(vStreamState, "last_ts");
        this.subjectCount = JsonValueUtils.readLong(vStreamState, "num_subjects", 0L);
        this.deletedCount = JsonValueUtils.readLong(vStreamState, "num_deleted", 0L);
        this.subjects = Subject.listOf(JsonValueUtils.readValue(vStreamState, "subjects"));
        this.deletedStreamSequences = JsonValueUtils.readLongList(vStreamState, "deleted");
        this.lostStreamData = LostStreamData.optionalInstance(JsonValueUtils.readValue(vStreamState, "lost"));
    }

    public long getMsgCount() {
        return this.msgs;
    }

    public long getByteCount() {
        return this.bytes;
    }

    public long getFirstSequence() {
        return this.firstSeq;
    }

    public ZonedDateTime getFirstTime() {
        return this.firstTime;
    }

    public long getLastSequence() {
        return this.lastSeq;
    }

    public ZonedDateTime getLastTime() {
        return this.lastTime;
    }

    public long getConsumerCount() {
        return this.consumerCount;
    }

    public long getSubjectCount() {
        return this.subjectCount;
    }

    public List<Subject> getSubjects() {
        return this.subjects;
    }

    public long getDeletedCount() {
        return this.deletedCount;
    }

    public List<Long> getDeleted() {
        return this.deletedStreamSequences;
    }

    public LostStreamData getLostStreamData() {
        return this.lostStreamData;
    }

    public String toString() {
        return "StreamState{msgs=" + this.msgs + ", bytes=" + this.bytes + ", firstSeq=" + this.firstSeq + ", lastSeq=" + this.lastSeq + ", consumerCount=" + this.consumerCount + ", firstTime=" + this.firstTime + ", lastTime=" + this.lastTime + ", subjectCount=" + this.subjectCount + ", subjects=" + this.subjects + ", deletedCount=" + this.deletedCount + ", deleteds=" + this.deletedStreamSequences + ", lostStreamData=" + this.lostStreamData + '}';
    }
}

