/*
 * Decompiled with CFR 0.152.
 */
package ai.superstream;

import ai.superstream.Consts;
import ai.superstream.SuperstreamConsumerInterceptor;
import ai.superstream.SuperstreamCounters;
import ai.superstream.SuperstreamDeserializer;
import ai.superstream.SuperstreamProducerInterceptor;
import ai.superstream.SuperstreamSerializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import io.nats.client.Dispatcher;
import io.nats.client.JetStream;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.Subscription;
import io.nats.client.api.ServerInfo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.shaded.com.google.protobuf.DescriptorProtos;
import org.apache.kafka.shaded.com.google.protobuf.Descriptors;
import org.apache.kafka.shaded.com.google.protobuf.DynamicMessage;
import org.apache.kafka.shaded.com.google.protobuf.Message;
import org.apache.kafka.shaded.com.google.protobuf.util.JsonFormat;

public class Superstream {
    public Connection brokerConnection;
    public JetStream jetstream;
    public String superstreamJwt;
    public String superstreamNkey;
    public byte[] descriptorAsBytes;
    public Descriptors.Descriptor descriptor;
    public String natsConnectionID;
    public String clientHash;
    public String accountName;
    public int learningFactor = 20;
    public int learningFactorCounter = 0;
    public boolean learningRequestSent = false;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    public String ProducerSchemaID = "0";
    public String ConsumerSchemaID = "0";
    public Map<String, Descriptors.Descriptor> SchemaIDMap = new HashMap<String, Descriptors.Descriptor>();
    public Map<String, Object> configs;
    public SuperstreamCounters clientCounters = new SuperstreamCounters();
    private Subscription updatesSubscription;
    private String host;
    private String token;
    public String type;
    public Boolean reductionEnabled;
    public Map<String, Set<Integer>> topicPartitions = new ConcurrentHashMap<String, Set<Integer>>();
    public ExecutorService executorService = Executors.newFixedThreadPool(3);
    private Integer kafkaConnectionID = 0;
    public Boolean superstreamReady = false;
    private String tags = "";
    public Boolean canStart = false;

    public Superstream(String token, String host, Integer learningFactor, Map<String, Object> configs, Boolean enableReduction, String type, String tags) {
        this.learningFactor = learningFactor;
        this.token = token;
        this.host = host;
        this.configs = configs;
        this.reductionEnabled = enableReduction;
        this.type = type;
        this.tags = tags;
    }

    public Superstream(String token, String host, Integer learningFactor, Map<String, Object> configs, Boolean enableReduction, String type) {
        this(token, host, learningFactor, configs, enableReduction, type, "");
    }

    public void init() {
        this.executorService.submit(() -> {
            try {
                this.initializeNatsConnection(this.token, this.host);
                if (this.brokerConnection != null) {
                    this.registerClient(this.configs);
                    this.waitForStart();
                    if (!this.canStart.booleanValue()) {
                        throw new Exception("Could not start superstream");
                    }
                    this.subscribeToUpdates();
                    this.superstreamReady = true;
                    this.reportClientsUpdate();
                    this.sendClientTypeUpdateReq();
                }
            }
            catch (Exception e) {
                this.handleError(e.getMessage());
            }
        });
    }

    public void close() {
        try {
            if (this.brokerConnection != null) {
                this.brokerConnection.close();
            }
            this.executorService.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initializeNatsConnection(String token, String host) {
        try {
            Options options = new Options.Builder().server(host).userInfo("superstream_internal", token).maxReconnects(-1).connectionTimeout(Duration.ofSeconds(10L)).reconnectWait(Duration.ofSeconds(1L)).connectionListener(new ConnectionListener(){

                @Override
                public void connectionEvent(Connection conn, ConnectionListener.Events type) {
                    if (type == ConnectionListener.Events.DISCONNECTED) {
                        Superstream.this.brokerConnection = null;
                        Superstream.this.superstreamReady = false;
                        System.out.println("superstream: Disconnected");
                    } else if (type == ConnectionListener.Events.RECONNECTED) {
                        try {
                            Superstream.this.brokerConnection = conn;
                            if (Superstream.this.brokerConnection != null) {
                                Superstream.this.natsConnectionID = Superstream.this.generateNatsConnectionID();
                                HashMap<String, String> reqData = new HashMap<String, String>();
                                reqData.put("new_nats_connection_id", Superstream.this.natsConnectionID);
                                reqData.put("client_hash", Superstream.this.clientHash);
                                ObjectMapper mapper = new ObjectMapper();
                                byte[] reqBytes = mapper.writeValueAsBytes(reqData);
                                Superstream.this.brokerConnection.publish("internal_tasks.clientReconnectionUpdate", reqBytes);
                                Superstream.this.subscribeToUpdates();
                                Superstream.this.superstreamReady = true;
                                Superstream.this.reportClientsUpdate();
                            }
                        }
                        catch (Exception e) {
                            System.out.println("superstream: Failed to reconnect: " + e.getMessage());
                        }
                        System.out.println("superstream: Reconnected to superstream");
                    }
                }
            }).build();
            Connection nc = Nats.connect(options);
            if (nc == null) {
                throw new Exception(String.format("Failed to connect to host: %s", host));
            }
            JetStream js = nc.jetStream();
            if (js == null) {
                throw new Exception(String.format("Failed to connect to host: %s", host));
            }
            this.brokerConnection = nc;
            this.jetstream = js;
            this.natsConnectionID = this.generateNatsConnectionID();
        }
        catch (Exception e) {
            System.out.println(String.format("superstream: %s", e.getMessage()));
        }
    }

    private String generateNatsConnectionID() {
        ServerInfo serverInfo = this.brokerConnection.getServerInfo();
        String connectedServerName = serverInfo.getServerName();
        int serverClientID = serverInfo.getClientId();
        return connectedServerName + ":" + serverClientID;
    }

    public void registerClient(Map<String, ?> configs) {
        try {
            String kafkaConnID = this.consumeConnectionID();
            if (kafkaConnID != null) {
                try {
                    this.kafkaConnectionID = Integer.parseInt(kafkaConnID);
                }
                catch (Exception e) {
                    this.kafkaConnectionID = 0;
                }
            }
            HashMap<String, Object> reqData = new HashMap<String, Object>();
            reqData.put("nats_connection_id", this.natsConnectionID);
            reqData.put("language", "java");
            reqData.put("learning_factor", this.learningFactor);
            reqData.put("version", "1.0.11");
            reqData.put("config", Superstream.normalizeClientConfig(configs));
            reqData.put("reduction_enabled", this.reductionEnabled);
            reqData.put("connection_id", this.kafkaConnectionID);
            reqData.put("tags", this.tags);
            ObjectMapper mapper = new ObjectMapper();
            byte[] reqBytes = mapper.writeValueAsBytes(reqData);
            Message reply = this.brokerConnection.request("internal.registerClient", reqBytes, Duration.ofMinutes(5L));
            if (reply != null) {
                Map replyData = mapper.readValue(reply.getData(), Map.class);
                Object clientHashObject = replyData.get("client_hash");
                if (clientHashObject != null) {
                    this.clientHash = clientHashObject.toString();
                } else {
                    System.out.println("superstream: client_hash is not a valid string: " + clientHashObject);
                }
                Object accountNameObject = replyData.get("account_name");
                if (accountNameObject != null) {
                    this.accountName = accountNameObject.toString();
                } else {
                    System.out.println("superstream: account_name is not a valid string: " + accountNameObject);
                }
                Object learningFactorObject = replyData.get("learning_factor");
                if (learningFactorObject instanceof Integer) {
                    this.learningFactor = (Integer)learningFactorObject;
                } else if (learningFactorObject instanceof String) {
                    try {
                        this.learningFactor = Integer.parseInt((String)learningFactorObject);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("superstream: learning_factor is not a valid integer: " + learningFactorObject);
                    }
                } else {
                    System.out.println("superstream: learning_factor is not a valid integer: " + learningFactorObject);
                }
            } else {
                String errMsg = "superstream: registering client: No reply received within the timeout period.";
                System.out.println(errMsg);
                this.handleError(errMsg);
            }
        }
        catch (Exception e) {
            System.out.println(String.format("superstream: %s", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForStart() {
        Dispatcher dispatcher;
        block4: {
            CountDownLatch latch = new CountDownLatch(1);
            dispatcher = this.brokerConnection.createDispatcher(msg -> {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    Map messageData = mapper.readValue(msg.getData(), Map.class);
                    if (messageData.containsKey("start")) {
                        boolean start = (Boolean)messageData.get("start");
                        if (start) {
                            this.canStart = true;
                            latch.countDown();
                        } else {
                            String err = (String)messageData.get("error");
                            System.out.println("superstream: Could not start superstream: " + err);
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            dispatcher.subscribe(String.format("internal.startClient.%s", this.clientHash));
            try {
                if (latch.await(10L, TimeUnit.MINUTES)) break block4;
                System.out.println("superstream: Could not connect to superstream for 10 minutes.");
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                    System.out.println("superstream: Could not start superstream: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    dispatcher.unsubscribe(String.format("internal.startClient.%s", this.clientHash));
                    throw throwable;
                }
                dispatcher.unsubscribe(String.format("internal.startClient.%s", this.clientHash));
            }
        }
        dispatcher.unsubscribe(String.format("internal.startClient.%s", this.clientHash));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String consumeConnectionID() {
        Properties consumerProps = this.copyAuthConfig();
        consumerProps.put("key.deserializer", StringDeserializer.class.getName());
        consumerProps.put("value.deserializer", StringDeserializer.class.getName());
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("superstream.inner.consumer", "true");
        consumerProps.put("max.poll.records", (Object)1);
        String connectionId = null;
        try (KafkaConsumer consumer = null;){
            consumer = new KafkaConsumer(consumerProps);
            List<PartitionInfo> partitions = consumer.partitionsFor("superstream.metadata", Duration.ofMillis(10000L));
            if (partitions == null || partitions.isEmpty()) {
                if (consumer != null) {
                    consumer.close();
                }
                String string = "0";
                return string;
            }
            TopicPartition topicPartition = new TopicPartition("superstream.metadata", 0);
            consumer.assign(Collections.singletonList(topicPartition));
            ConsumerRecords records = consumer.poll(Duration.ofMillis(10000L));
            Iterator iterator = records.iterator();
            if (iterator.hasNext()) {
                ConsumerRecord record = iterator.next();
                connectionId = (String)record.value();
            }
        }
        if (connectionId == null) {
            connectionId = "0";
        }
        return connectionId;
    }

    private Properties copyAuthConfig() {
        String[] relevantKeys = new String[]{"security.protocol", "ssl.truststore.location", "ssl.truststore.password", "ssl.keystore.location", "ssl.keystore.password", "ssl.key.password", "ssl.endpoint.identification.algorithm", "sasl.mechanism", "sasl.jaas.config", "sasl.kerberos.service.name", "bootstrap.servers", "client.dns.lookup", "connections.max.idle.ms", "request.timeout.ms", "metadata.max.age.ms", "reconnect.backoff.ms", "reconnect.backoff.max.ms"};
        Properties relevantProps = new Properties();
        for (String key : relevantKeys) {
            if (!this.configs.containsKey(key)) continue;
            if (key == "bootstrap.servers") {
                Object value = this.configs.get(key);
                if (value instanceof String[]) {
                    relevantProps.put(key, Arrays.toString((String[])value));
                    continue;
                }
                if (value instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)value;
                    relevantProps.put(key, String.join((CharSequence)", ", arrayList));
                    continue;
                }
                relevantProps.put(key, value);
                continue;
            }
            relevantProps.put(key, String.valueOf(this.configs.get(key)));
        }
        return relevantProps;
    }

    public void sendClientTypeUpdateReq() {
        if (this.type == "" || this.type == null) {
            return;
        }
        if (this.type != "consumer" && this.type != "producer") {
            return;
        }
        try {
            HashMap<String, String> reqData = new HashMap<String, String>();
            reqData.put("client_hash", this.clientHash);
            reqData.put("type", this.type);
            ObjectMapper mapper = new ObjectMapper();
            byte[] reqBytes = mapper.writeValueAsBytes(reqData);
            this.brokerConnection.publish("internal.clientTypeUpdate", reqBytes);
        }
        catch (Exception e) {
            this.handleError(String.format("sendClientTypeUpdateReq: %s", e.getMessage()));
        }
    }

    public void subscribeToUpdates() {
        try {
            String subject = String.format("internal.updates.%s", this.clientHash);
            Dispatcher dispatcher = this.brokerConnection.createDispatcher(this.updatesHandler());
            this.updatesSubscription = dispatcher.subscribe(subject, this.updatesHandler());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reportClientsUpdate() {
        ScheduledExecutorService singleExecutorService = Executors.newSingleThreadScheduledExecutor();
        singleExecutorService.scheduleAtFixedRate(() -> {
            try {
                if (this.brokerConnection != null && this.superstreamReady.booleanValue()) {
                    byte[] byteCounters = objectMapper.writeValueAsBytes(this.clientCounters);
                    HashMap<String, Map<String, Object>> topicPartitionConfig = new HashMap<String, Map<String, Object>>();
                    if (!this.topicPartitions.isEmpty()) {
                        Map<String, Integer[]> topicPartitionsToSend = Superstream.convertMap(this.topicPartitions);
                        switch (this.type) {
                            case "producer": {
                                topicPartitionConfig.put("producer_topics_partitions", topicPartitionsToSend);
                                topicPartitionConfig.put("consumer_group_topics_partitions", new HashMap());
                                break;
                            }
                            case "consumer": {
                                topicPartitionConfig.put("producer_topics_partitions", new HashMap());
                                topicPartitionConfig.put("consumer_group_topics_partitions", topicPartitionsToSend);
                            }
                        }
                    }
                    byte[] byteConfig = objectMapper.writeValueAsBytes(topicPartitionConfig);
                    this.brokerConnection.publish(String.format("internal_tasks.clientsUpdate.%s.%s", "counters", this.clientHash), byteCounters);
                    this.brokerConnection.publish(String.format("internal_tasks.clientsUpdate.%s.%s", "config", this.clientHash), byteConfig);
                }
            }
            catch (Exception e) {
                this.handleError("reportClientsUpdate: " + e.getMessage());
            }
        }, 0L, 10L, TimeUnit.MINUTES);
    }

    public static Map<String, Integer[]> convertMap(Map<String, Set<Integer>> topicPartitions) {
        HashMap<String, Integer[]> result = new HashMap<String, Integer[]>();
        for (Map.Entry<String, Set<Integer>> entry : topicPartitions.entrySet()) {
            Integer[] array = entry.getValue().toArray(new Integer[0]);
            result.put(entry.getKey(), array);
        }
        return result;
    }

    public void sendLearningMessage(byte[] msg) {
        try {
            this.brokerConnection.publish(String.format("internal.schema.learnSchema.%s", this.clientHash), msg);
        }
        catch (Exception e) {
            this.handleError("sendLearningMessage: " + e.getMessage());
        }
    }

    public void sendRegisterSchemaReq() {
        try {
            this.brokerConnection.publish(String.format("internal_tasks.schema.registerSchema.%s", this.clientHash), new byte[0]);
            this.learningRequestSent = true;
        }
        catch (Exception e) {
            this.handleError("sendLearningMessage: " + e.getMessage());
        }
    }

    public JsonToProtoResult jsonToProto(byte[] msgBytes) throws Exception {
        try {
            String jsonString = new String(msgBytes);
            if (!this.isJsonObject(jsonString)) {
                jsonString = Superstream.convertEscapedJsonString(jsonString);
            }
            if (jsonString == null || jsonString.isEmpty()) {
                return new JsonToProtoResult(false, msgBytes);
            }
            if (jsonString != null && jsonString.length() > 2 && jsonString.startsWith("\"{") && jsonString.endsWith("}\"")) {
                jsonString = jsonString.substring(1, jsonString.length() - 1);
            }
            DynamicMessage.Builder newMessageBuilder = DynamicMessage.newBuilder(this.descriptor);
            JsonFormat.parser().merge(jsonString, (Message.Builder)newMessageBuilder);
            DynamicMessage message = newMessageBuilder.build();
            return new JsonToProtoResult(true, message.toByteArray());
        }
        catch (Exception e) {
            return new JsonToProtoResult(false, msgBytes);
        }
    }

    private boolean isJsonObject(String jsonString) {
        try {
            JsonParser.parseString(jsonString).getAsJsonObject();
            return true;
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            return false;
        }
    }

    private static String convertEscapedJsonString(String escapedJsonString) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(escapedJsonString);
        return mapper.writeValueAsString(jsonNode).replace("\\\"", "\"").replace("\\\\", "\\");
    }

    public byte[] protoToJson(byte[] msgBytes, Descriptors.Descriptor desc) throws Exception {
        try {
            DynamicMessage message = DynamicMessage.parseFrom(desc, msgBytes);
            String jsonString = JsonFormat.printer().omittingInsignificantWhitespace().print(message);
            return jsonString.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            if (e.getMessage().contains("the input ended unexpectedly")) {
                return msgBytes;
            }
            throw e;
        }
    }

    private MessageHandler updatesHandler() {
        return msg -> {
            try {
                Map update = objectMapper.readValue(msg.getData(), Map.class);
                this.processUpdate(update);
            }
            catch (IOException e) {
                this.handleError("updatesHandler at json.Unmarshal: " + e.getMessage());
            }
        };
    }

    private void processUpdate(Map<String, Object> update) {
        String type = (String)update.get("type");
        try {
            String payloadBytesString = (String)update.get("payload");
            byte[] payloadBytes = Base64.getDecoder().decode(payloadBytesString);
            Map payload = objectMapper.readValue(payloadBytes, Map.class);
            switch (type) {
                case "LearnedSchema": {
                    String schemaID;
                    String descriptorBytesString = (String)payload.get("desc");
                    String masterMsgName = (String)payload.get("master_msg_name");
                    String fileName = (String)payload.get("file_name");
                    this.descriptor = this.compileMsgDescriptor(descriptorBytesString, masterMsgName, fileName);
                    this.ProducerSchemaID = schemaID = (String)payload.get("schema_id");
                    break;
                }
                case "ToggleReduction": {
                    Boolean enableReduction = (Boolean)payload.get("enable_reduction");
                    this.reductionEnabled = enableReduction != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
            }
        }
        catch (Exception e) {
            this.handleError("processUpdate: " + e.getMessage());
        }
    }

    public void sendGetSchemaRequest(String schemaID) {
        try {
            Descriptors.Descriptor respDescriptor;
            HashMap<String, String> reqData = new HashMap<String, String>();
            reqData.put("schema_id", schemaID);
            ObjectMapper mapper = new ObjectMapper();
            byte[] reqBytes = mapper.writeValueAsBytes(reqData);
            Message msg = this.brokerConnection.request(String.format("internal.schema.getSchema.%s", this.clientHash), reqBytes, Duration.ofSeconds(5L));
            if (msg == null) {
                throw new Exception("Could not get descriptor");
            }
            Map respMap = objectMapper.readValue(new String(msg.getData(), StandardCharsets.UTF_8), Map.class);
            if (respMap.containsKey("desc") && respMap.get("desc") instanceof String) {
                String fileName;
                String masterMsgName;
                String descriptorBytesString = (String)respMap.get("desc");
                respDescriptor = this.compileMsgDescriptor(descriptorBytesString, masterMsgName = (String)respMap.get("master_msg_name"), fileName = (String)respMap.get("file_name"));
                if (respDescriptor == null) {
                    throw new Exception("Error compiling schema.");
                }
            } else {
                throw new Exception("Response map does not contain expected keys.");
            }
            this.SchemaIDMap.put((String)respMap.get("schema_id"), respDescriptor);
        }
        catch (Exception e) {
            this.handleError(String.format("sendGetSchemaRequest: %s", e.getMessage()));
        }
    }

    private Descriptors.Descriptor compileMsgDescriptor(String descriptorBytesString, String masterMsgName, String fileName) {
        try {
            byte[] descriptorAsBytes = Base64.getDecoder().decode(descriptorBytesString);
            if (descriptorAsBytes == null) {
                throw new Exception("error decoding descriptor bytes");
            }
            DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom(descriptorAsBytes);
            Descriptors.FileDescriptor fileDescriptor = null;
            for (DescriptorProtos.FileDescriptorProto fdp : descriptorSet.getFileList()) {
                if (!fdp.getName().equals(fileName)) continue;
                fileDescriptor = Descriptors.FileDescriptor.buildFrom(fdp, new Descriptors.FileDescriptor[0]);
                break;
            }
            if (fileDescriptor == null) {
                throw new Exception("file not found");
            }
            for (Descriptors.Descriptor md : fileDescriptor.getMessageTypes()) {
                if (!md.getName().equals(masterMsgName)) continue;
                return md;
            }
        }
        catch (Exception e) {
            this.handleError(String.format("compileMsgDescriptor: %s", e.getMessage()));
        }
        return null;
    }

    public void handleError(String msg) {
        if (this.brokerConnection != null && this.superstreamReady.booleanValue()) {
            Map<String, String> envVars = System.getenv();
            String tags = envVars.get("SUPERSTREAM_TAGS");
            if (tags == null) {
                tags = "";
            }
            if (this.clientHash == "") {
                String message = String.format("[sdk: java][version: %s][tags: %s] %s", "1.0.11", tags, msg);
                this.brokerConnection.publish("internal.clientErrors", message.getBytes(StandardCharsets.UTF_8));
            } else {
                String message = String.format("[clientHash: %s][sdk: java][version: %s][tags: %s] %s", this.clientHash, "1.0.11", tags, msg);
                this.brokerConnection.publish("internal.clientErrors", message.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static Map<String, Object> normalizeClientConfig(Map<String, ?> javaConfig) {
        HashMap<String, Object> superstreamConfig = new HashMap<String, Object>();
        Superstream.mapIfPresent(javaConfig, "max.request.size", superstreamConfig, "producer_max_messages_bytes");
        Superstream.mapIfPresent(javaConfig, "acks", superstreamConfig, "producer_required_acks");
        Superstream.mapIfPresent(javaConfig, "delivery.timeout.ms", superstreamConfig, "producer_timeout");
        Superstream.mapIfPresent(javaConfig, "retries", superstreamConfig, "producer_retry_max");
        Superstream.mapIfPresent(javaConfig, "retry.backoff.ms", superstreamConfig, "producer_retry_backoff");
        Superstream.mapIfPresent(javaConfig, "compression.type", superstreamConfig, "producer_compression_level");
        Superstream.mapIfPresent(javaConfig, "fetch.min.bytes", superstreamConfig, "consumer_fetch_min");
        Superstream.mapIfPresent(javaConfig, "fetch.max.bytes", superstreamConfig, "consumer_fetch_default");
        Superstream.mapIfPresent(javaConfig, "retry.backoff.ms", superstreamConfig, "consumer_retry_backoff");
        Superstream.mapIfPresent(javaConfig, "max.poll.interval.ms", superstreamConfig, "consumer_max_wait_time");
        Superstream.mapIfPresent(javaConfig, "max.poll.records", superstreamConfig, "consumer_max_processing_time");
        Superstream.mapIfPresent(javaConfig, "auto.commit.interval.ms", superstreamConfig, "consumer_offset_auto_commit_interval");
        Superstream.mapIfPresent(javaConfig, "session.timeout.ms", superstreamConfig, "consumer_group_session_timeout");
        Superstream.mapIfPresent(javaConfig, "heartbeat.interval.ms", superstreamConfig, "consumer_group_heart_beat_interval");
        Superstream.mapIfPresent(javaConfig, "retry.backoff.ms", superstreamConfig, "consumer_group_rebalance_retry_back_off");
        Superstream.mapIfPresent(javaConfig, "group.id", superstreamConfig, "consumer_group_id");
        Superstream.mapIfPresent(javaConfig, "bootstrap.servers", superstreamConfig, "servers");
        return superstreamConfig;
    }

    private static void mapIfPresent(Map<String, ?> javaConfig, String javaKey, Map<String, Object> superstreamConfig, String superstreamKey) {
        if (javaConfig.containsKey(javaKey)) {
            if (javaKey == "bootstrap.servers") {
                Object value = javaConfig.get(javaKey);
                if (value instanceof String[]) {
                    superstreamConfig.put(superstreamKey, Arrays.toString((String[])value));
                } else if (value instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)value;
                    superstreamConfig.put(superstreamKey, String.join((CharSequence)", ", arrayList));
                } else {
                    superstreamConfig.put(superstreamKey, value);
                }
            } else {
                superstreamConfig.put(superstreamKey, javaConfig.get(javaKey));
            }
        }
    }

    public static Map<String, Object> initSuperstreamConfig(Map<String, Object> configs, String type) {
        String isInnerConsumer = (String)configs.get("superstream.inner.consumer");
        if (isInnerConsumer != null && isInnerConsumer.equals("true")) {
            return configs;
        }
        String interceptorToAdd = "";
        switch (type) {
            case "producer": {
                interceptorToAdd = SuperstreamProducerInterceptor.class.getName();
                if (!configs.containsKey("value.serializer") || configs.containsKey("original.serializer")) break;
                configs.put("original.serializer", configs.get("value.serializer"));
                configs.put("value.serializer", SuperstreamSerializer.class.getName());
                break;
            }
            case "consumer": {
                interceptorToAdd = SuperstreamConsumerInterceptor.class.getName();
                if (!configs.containsKey("value.deserializer") || configs.containsKey("original.deserializer")) break;
                configs.put("original.deserializer", configs.get("value.deserializer"));
                configs.put("value.deserializer", SuperstreamDeserializer.class.getName());
            }
        }
        try {
            Map<String, String> envVars;
            String superstreamHost;
            ArrayList<String> interceptors = null;
            Object existingInterceptors = configs.get("interceptor.classes");
            if (interceptorToAdd != "") {
                if (existingInterceptors != null) {
                    if (existingInterceptors instanceof List) {
                        interceptors = new ArrayList((List)existingInterceptors);
                    } else if (existingInterceptors instanceof String) {
                        interceptors = new ArrayList();
                        interceptors.add((String)existingInterceptors);
                    } else {
                        interceptors = new ArrayList();
                    }
                } else {
                    interceptors = new ArrayList<String>();
                }
            }
            if (interceptorToAdd != "") {
                interceptors.add(interceptorToAdd);
                configs.put("interceptor.classes", interceptors);
            }
            if ((superstreamHost = (envVars = System.getenv()).get("SUPERSTREAM_HOST")) == null) {
                throw new Exception("host is required");
            }
            configs.put("superstream.host", superstreamHost);
            String token = envVars.get("SUPERSTREAM_TOKEN");
            if (token == null) {
                token = "no-auth";
            }
            configs.put("superstream.token", token);
            String learningFactorString = envVars.get("SUPERSTREAM_LEARNING_FACTOR");
            Integer learningFactor = Consts.superstreamDefaultLearningFactor;
            if (learningFactorString != null) {
                learningFactor = Integer.parseInt(learningFactorString);
            }
            configs.put("superstream.learning.factor", learningFactor);
            Boolean reductionEnabled = false;
            String reductionEnabledString = envVars.get("SUPERSTREAM_REDUCTION_ENABLED");
            if (reductionEnabledString != null) {
                reductionEnabled = Boolean.parseBoolean(reductionEnabledString);
            }
            configs.put("superstream.reduction.enabled", reductionEnabled);
            String tags = envVars.get("SUPERSTREAM_TAGS");
            if (tags == null) {
                tags = "";
            }
            Superstream superstreamConnection = new Superstream(token, superstreamHost, learningFactor, configs, reductionEnabled, type, tags);
            superstreamConnection.init();
            configs.put("superstream.connection", superstreamConnection);
        }
        catch (Exception e) {
            String errMsg = String.format("superstream: error initializing superstream: %s", e.getMessage());
            System.out.println(errMsg);
            switch (type) {
                case "producer": {
                    if (!configs.containsKey("original.serializer")) break;
                    configs.put("value.serializer", configs.get("original.serializer"));
                    configs.remove("original.serializer");
                    break;
                }
                case "consumer": {
                    if (!configs.containsKey("original.deserializer")) break;
                    configs.put("value.deserializer", configs.get("original.deserializer"));
                    configs.remove("original.deserializer");
                }
            }
        }
        return configs;
    }

    public static Properties initSuperstreamProps(Properties properties, String type) {
        String interceptors = (String)properties.get("interceptor.classes");
        switch (type) {
            case "producer": {
                interceptors = interceptors != null && !interceptors.isEmpty() ? interceptors + "," + SuperstreamProducerInterceptor.class.getName() : SuperstreamProducerInterceptor.class.getName();
                if (!properties.containsKey("value.serializer") || properties.containsKey("original.serializer")) break;
                properties.put("original.serializer", properties.get("value.serializer"));
                properties.put("value.serializer", SuperstreamSerializer.class.getName());
                break;
            }
            case "consumer": {
                interceptors = interceptors != null && !interceptors.isEmpty() ? interceptors + "," + SuperstreamConsumerInterceptor.class.getName() : SuperstreamConsumerInterceptor.class.getName();
                if (!properties.containsKey("value.deserializer") || properties.containsKey("original.deserializer")) break;
                properties.put("original.deserializer", properties.get("value.deserializer"));
                properties.put("value.deserializer", SuperstreamDeserializer.class.getName());
            }
        }
        if (interceptors != null) {
            properties.put("interceptor.classes", interceptors);
        }
        try {
            Map<String, String> envVars = System.getenv();
            String superstreamHost = envVars.get("SUPERSTREAM_HOST");
            if (superstreamHost == null) {
                throw new Exception("host is required");
            }
            properties.put("superstream.host", superstreamHost);
            String token = envVars.get("SUPERSTREAM_TOKEN");
            if (token == null) {
                token = "no-auth";
            }
            properties.put("superstream.token", token);
            String learningFactorString = envVars.get("SUPERSTREAM_LEARNING_FACTOR");
            Integer learningFactor = Consts.superstreamDefaultLearningFactor;
            if (learningFactorString != null) {
                learningFactor = Integer.parseInt(learningFactorString);
            }
            properties.put("superstream.learning.factor", learningFactor);
            Boolean reductionEnabled = false;
            String reductionEnabledString = envVars.get("SUPERSTREAM_REDUCTION_ENABLED");
            if (reductionEnabledString != null) {
                reductionEnabled = Boolean.parseBoolean(reductionEnabledString);
            }
            properties.put("superstream.reduction.enabled", reductionEnabled);
            String tags = envVars.get("SUPERSTREAM_TAGS");
            if (tags != null) {
                properties.put("superstream.tags", tags);
            }
            Map<String, Object> configs = Superstream.propertiesToMap(properties);
            Superstream superstreamConnection = new Superstream(token, superstreamHost, learningFactor, configs, reductionEnabled, type);
            superstreamConnection.init();
            properties.put("superstream.connection", superstreamConnection);
        }
        catch (Exception e) {
            String errMsg = String.format("superstream: error initializing superstream: %s", e.getMessage());
            System.out.println(errMsg);
        }
        return properties;
    }

    public static Map<String, Object> propertiesToMap(Properties properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> e.getValue()));
    }

    public void updateTopicPartitions(String topic, Integer partition) {
        Set partitions = this.topicPartitions.computeIfAbsent(topic, k -> new HashSet());
        if (!partitions.contains(partition)) {
            partitions.add(partition);
        }
    }

    public class JsonToProtoResult {
        private final boolean success;
        private final byte[] messageBytes;

        public JsonToProtoResult(boolean success, byte[] messageBytes) {
            this.success = success;
            this.messageBytes = messageBytes;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public byte[] getMessageBytes() {
            return this.messageBytes;
        }
    }
}

