/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.provider;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(FileConfigProvider.class);

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public ConfigData get(String path) {
        ConfigData configData;
        block10: {
            HashMap<String, String> data = new HashMap<String, String>();
            if (path == null || path.isEmpty()) {
                return new ConfigData(data);
            }
            Reader reader = this.reader(path);
            try {
                Properties properties = new Properties();
                properties.load(reader);
                Enumeration<Object> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement().toString();
                    String value = properties.getProperty(key);
                    if (value == null) continue;
                    data.put(key, value);
                }
                configData = new ConfigData(data);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Could not read properties from file {}", (Object)path, (Object)e);
                    throw new ConfigException("Could not read properties from file " + path);
                }
            }
            reader.close();
        }
        return configData;
    }

    @Override
    public ConfigData get(String path, Set<String> keys) {
        ConfigData configData;
        block10: {
            HashMap<String, String> data = new HashMap<String, String>();
            if (path == null || path.isEmpty()) {
                return new ConfigData(data);
            }
            Reader reader = this.reader(path);
            try {
                Properties properties = new Properties();
                properties.load(reader);
                for (String key : keys) {
                    String value = properties.getProperty(key);
                    if (value == null) continue;
                    data.put(key, value);
                }
                configData = new ConfigData(data);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Could not read properties from file {}", (Object)path, (Object)e);
                    throw new ConfigException("Could not read properties from file " + path);
                }
            }
            reader.close();
        }
        return configData;
    }

    protected Reader reader(String path) throws IOException {
        return Files.newBufferedReader(Paths.get(path, new String[0]), StandardCharsets.UTF_8);
    }

    @Override
    public void close() {
    }
}

