/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.PushTelemetryRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class PushTelemetryRequestDataJsonConverter {
    public static PushTelemetryRequestData read(JsonNode _node, short _version) {
        PushTelemetryRequestData _object = new PushTelemetryRequestData();
        JsonNode _clientInstanceIdNode = _node.get("clientInstanceId");
        if (_clientInstanceIdNode == null) {
            throw new RuntimeException("PushTelemetryRequestData: unable to locate field 'clientInstanceId', which is mandatory in version " + _version);
        }
        if (!_clientInstanceIdNode.isTextual()) {
            throw new RuntimeException("PushTelemetryRequestData expected a JSON string type, but got " + (Object)((Object)_node.getNodeType()));
        }
        _object.clientInstanceId = Uuid.fromString(_clientInstanceIdNode.asText());
        JsonNode _subscriptionIdNode = _node.get("subscriptionId");
        if (_subscriptionIdNode == null) {
            throw new RuntimeException("PushTelemetryRequestData: unable to locate field 'subscriptionId', which is mandatory in version " + _version);
        }
        _object.subscriptionId = MessageUtil.jsonNodeToInt(_subscriptionIdNode, "PushTelemetryRequestData");
        JsonNode _terminatingNode = _node.get("terminating");
        if (_terminatingNode == null) {
            throw new RuntimeException("PushTelemetryRequestData: unable to locate field 'terminating', which is mandatory in version " + _version);
        }
        if (!_terminatingNode.isBoolean()) {
            throw new RuntimeException("PushTelemetryRequestData expected Boolean type, but got " + (Object)((Object)_node.getNodeType()));
        }
        _object.terminating = _terminatingNode.asBoolean();
        JsonNode _compressionTypeNode = _node.get("compressionType");
        if (_compressionTypeNode == null) {
            throw new RuntimeException("PushTelemetryRequestData: unable to locate field 'compressionType', which is mandatory in version " + _version);
        }
        _object.compressionType = MessageUtil.jsonNodeToByte(_compressionTypeNode, "PushTelemetryRequestData");
        JsonNode _metricsNode = _node.get("metrics");
        if (_metricsNode == null) {
            throw new RuntimeException("PushTelemetryRequestData: unable to locate field 'metrics', which is mandatory in version " + _version);
        }
        _object.metrics = MessageUtil.jsonNodeToBinary(_metricsNode, "PushTelemetryRequestData");
        return _object;
    }

    public static JsonNode write(PushTelemetryRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("clientInstanceId", new TextNode(_object.clientInstanceId.toString()));
        _node.set("subscriptionId", new IntNode(_object.subscriptionId));
        _node.set("terminating", BooleanNode.valueOf(_object.terminating));
        _node.set("compressionType", new ShortNode(_object.compressionType));
        _node.set("metrics", new BinaryNode(Arrays.copyOf(_object.metrics, _object.metrics.length)));
        return _node;
    }

    public static JsonNode write(PushTelemetryRequestData _object, short _version) {
        return PushTelemetryRequestDataJsonConverter.write(_object, _version, true);
    }
}

