/*
 * Decompiled with CFR 0.152.
 */
package ai.superstream;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SuperstreamCounters {
    @JsonProperty(value="total_bytes_before_reduction")
    public AtomicLong TotalBytesBeforeReduction = new AtomicLong(0L);
    @JsonProperty(value="total_bytes_after_reduction")
    public AtomicLong TotalBytesAfterReduction = new AtomicLong(0L);
    @JsonProperty(value="total_messages_successfully_produce")
    public AtomicInteger TotalMessagesSuccessfullyProduce = new AtomicInteger(0);
    @JsonProperty(value="total_messages_successfully_consume")
    public AtomicInteger TotalMessagesSuccessfullyConsumed = new AtomicInteger(0);
    @JsonProperty(value="total_messages_failed_produce")
    public AtomicInteger TotalMessagesFailedProduce = new AtomicInteger(0);
    @JsonProperty(value="total_messages_failed_consume")
    public AtomicInteger TotalMessagesFailedConsume = new AtomicInteger(0);
    @JsonProperty(value="total_serialization_reduced")
    public AtomicLong TotalSSMPayloadReduced = new AtomicLong(0L);

    public void reset() {
        this.TotalBytesBeforeReduction = new AtomicLong(0L);
        this.TotalBytesAfterReduction = new AtomicLong(0L);
        this.TotalSSMPayloadReduced = new AtomicLong(0L);
        this.TotalMessagesSuccessfullyProduce = new AtomicInteger(0);
        this.TotalMessagesSuccessfullyConsumed = new AtomicInteger(0);
        this.TotalMessagesFailedProduce = new AtomicInteger(0);
        this.TotalMessagesFailedConsume = new AtomicInteger(0);
    }

    public void incrementTotalBytesBeforeReduction(long bytes) {
        this.TotalBytesBeforeReduction.addAndGet(bytes);
    }

    public void incrementTotalBytesAfterReduction(long bytes) {
        this.TotalBytesAfterReduction.addAndGet(bytes);
    }

    public void incrementTotalSSMPayloadReduced(long bytes) {
        this.TotalSSMPayloadReduced.addAndGet(bytes);
    }

    public void incrementTotalMessagesSuccessfullyProduce() {
        this.TotalMessagesSuccessfullyProduce.incrementAndGet();
    }

    public void sumTotalBeforeReductionTotalSSMPayloadReduced() {
        long valueToAdd = this.TotalSSMPayloadReduced.getAndSet(0L);
        this.TotalBytesBeforeReduction.addAndGet(valueToAdd);
    }

    public void incrementTotalMessagesSuccessfullyConsumed() {
        this.TotalMessagesSuccessfullyConsumed.incrementAndGet();
    }

    public void incrementTotalMessagesFailedProduce() {
        this.TotalMessagesFailedProduce.incrementAndGet();
    }

    public void incrementTotalMessagesFailedConsume() {
        this.TotalMessagesFailedConsume.incrementAndGet();
    }

    public long getTotalBytesBeforeReduction() {
        return this.TotalBytesBeforeReduction.get();
    }

    public long getTotalBytesAfterReduction() {
        return this.TotalBytesAfterReduction.get();
    }

    public int getTotalMessagesSuccessfullyProduce() {
        return this.TotalMessagesSuccessfullyProduce.get();
    }

    public int getTotalMessagesSuccessfullyConsumed() {
        return this.TotalMessagesSuccessfullyConsumed.get();
    }

    public int getTotalMessagesFailedProduce() {
        return this.TotalMessagesFailedProduce.get();
    }

    public int getTotalMessagesFailedConsume() {
        return this.TotalMessagesFailedConsume.get();
    }

    public void setTotalBytesBeforeReduction(long totalBytesBeforeReduction) {
        this.TotalBytesBeforeReduction = new AtomicLong(totalBytesBeforeReduction);
    }

    public void setTotalBytesAfterReduction(long totalBytesAfterReduction) {
        this.TotalBytesAfterReduction = new AtomicLong(totalBytesAfterReduction);
    }

    public void setTotalMessagesSuccessfullyProduce(int totalMessagesSuccessfullyProduce) {
        this.TotalMessagesSuccessfullyProduce.addAndGet(totalMessagesSuccessfullyProduce);
    }

    public void setTotalMessagesSuccessfullyConsumed(int totalMessagesSuccessfullyConsumed) {
        this.TotalMessagesSuccessfullyConsumed.addAndGet(totalMessagesSuccessfullyConsumed);
    }

    public void setTotalMessagesFailedProduce(int totalMessagesFailedProduce) {
        this.TotalMessagesFailedProduce.addAndGet(totalMessagesFailedProduce);
    }

    public void setTotalMessagesFailedConsume(int totalMessagesFailedConsume) {
        this.TotalMessagesFailedConsume.addAndGet(totalMessagesFailedConsume);
    }
}

