/*
 * Decompiled with CFR 0.152.
 */
package example;

import ai.superstream.Superstream;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class App {
    public static void main(String[] args) {
        try {
            Properties producerProperties = new Properties();
            producerProperties.put("key.serializer", StringSerializer.class.getName());
            producerProperties.put("value.serializer", StringSerializer.class.getName());
            producerProperties.put("security.protocol", "SASL_SSL");
            producerProperties.put("sasl.mechanism", "PLAIN");
            producerProperties.put("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required username='****' password='****';");
            producerProperties.put("client.dns.lookup", "use_all_dns_ips");
            producerProperties.put("bootstrap.servers", "****");
            producerProperties = Superstream.initSuperstreamProps(producerProperties, "producer");
            KafkaProducer<String, String> producer = new KafkaProducer<String, String>(producerProperties);
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("id", 23);
            jsonMap.put("age", 28);
            jsonMap.put("first", "John");
            jsonMap.put("last", "Bratslavsky");
            jsonMap.put("hello", "Bratslavsky");
            jsonMap.put("world", "Bratslavsky");
            String jsonString = mapper.writeValueAsString(jsonMap);
            for (int i = 0; i < 50000; ++i) {
                producer.send(new ProducerRecord<String, String>("sample_topic", Integer.toString(i), jsonString));
            }
            producer.close();
            Properties consumerProperties = new Properties();
            consumerProperties.put("key.deserializer", StringDeserializer.class.getName());
            consumerProperties.put("value.deserializer", StringDeserializer.class.getName());
            consumerProperties.put("group.id", "test-group23");
            consumerProperties.put("auto.offset.reset", "earliest");
            consumerProperties.put("security.protocol", "SASL_SSL");
            consumerProperties.put("sasl.mechanism", "PLAIN");
            consumerProperties.put("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required username='****' password='****';");
            consumerProperties.put("client.dns.lookup", "use_all_dns_ips");
            consumerProperties.put("bootstrap.servers", "****");
            consumerProperties = Superstream.initSuperstreamProps(consumerProperties, "consumer");
            KafkaConsumer consumer = new KafkaConsumer(consumerProperties);
            consumer.subscribe(Collections.singletonList("javajava4"));
            Integer counter = 0;
            try {
                block5: while (true) {
                    ConsumerRecords records = consumer.poll(Duration.ofMillis(1000L));
                    Iterator iterator = records.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block5;
                        ConsumerRecord record = iterator.next();
                        String val = (String)record.value();
                        System.out.println(val);
                        Integer n = counter;
                        counter = counter + 1;
                        System.out.println(counter);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                System.out.println(counter);
                consumer.close();
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

