/*
 * Decompiled with CFR 0.152.
 */
package swim.auth;

import swim.api.auth.Authenticator;
import swim.api.auth.AuthenticatorDef;
import swim.auth.GoogleIdAuthenticator;
import swim.auth.GoogleIdAuthenticatorDef;
import swim.auth.OpenIdAuthenticator;
import swim.auth.OpenIdAuthenticatorDef;
import swim.kernel.KernelProxy;
import swim.structure.Item;
import swim.structure.Value;

public class AuthenticatorKernel
extends KernelProxy {
    final double kernelPriority;
    private static final double KERNEL_PRIORITY = 0.9;

    public AuthenticatorKernel(double kernelPriority) {
        this.kernelPriority = kernelPriority;
    }

    public AuthenticatorKernel() {
        this(0.9);
    }

    public final double kernelPriority() {
        return this.kernelPriority;
    }

    public AuthenticatorDef defineAuthenticator(Item authenticatorConfig) {
        AuthenticatorDef authenticatorDef = (AuthenticatorDef)GoogleIdAuthenticatorDef.form().cast(authenticatorConfig);
        if (authenticatorDef == null) {
            authenticatorDef = (AuthenticatorDef)OpenIdAuthenticatorDef.form().cast(authenticatorConfig);
        }
        return authenticatorDef != null ? authenticatorDef : super.defineAuthenticator(authenticatorConfig);
    }

    public Authenticator createAuthenticator(AuthenticatorDef authenticatorDef, ClassLoader classLoader) {
        if (authenticatorDef instanceof GoogleIdAuthenticatorDef) {
            return new GoogleIdAuthenticator((GoogleIdAuthenticatorDef)authenticatorDef);
        }
        if (authenticatorDef instanceof OpenIdAuthenticatorDef) {
            return new OpenIdAuthenticator((OpenIdAuthenticatorDef)authenticatorDef);
        }
        return super.createAuthenticator(authenticatorDef, classLoader);
    }

    public static AuthenticatorKernel fromValue(Value moduleConfig) {
        Value header = moduleConfig.getAttr("kernel");
        String kernelClassName = header.get("class").stringValue(null);
        if (kernelClassName == null || AuthenticatorKernel.class.getName().equals(kernelClassName)) {
            double kernelPriority = header.get("priority").doubleValue(0.9);
            return new AuthenticatorKernel(kernelPriority);
        }
        return null;
    }
}

