/*
 * Decompiled with CFR 0.152.
 */
package swim.auth;

import swim.api.auth.AbstractAuthenticator;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.policy.PolicyDirective;
import swim.auth.Authenticated;
import swim.auth.GoogleIdAuthenticatorDef;
import swim.auth.GoogleIdAuthenticatorPublicKeyClient;
import swim.auth.GoogleIdAuthenticatorPublicKeyRefreshTimer;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieSet;
import swim.concurrent.TimerFunction;
import swim.concurrent.TimerRef;
import swim.io.http.HttpClient;
import swim.io.http.HttpInterface;
import swim.io.http.HttpSettings;
import swim.security.GoogleIdToken;
import swim.security.PublicKeyDef;
import swim.uri.Uri;
import swim.uri.UriAuthority;

public class GoogleIdAuthenticator
extends AbstractAuthenticator
implements HttpInterface {
    protected final FingerTrieSeq<String> audiences;
    protected HashTrieSet<String> emails;
    protected final Uri publicKeyUri;
    protected final HttpSettings httpSettings;
    FingerTrieSeq<PublicKeyDef> publicKeyDefs;
    TimerRef publicKeyRefreshTimer;
    static final long PUBLIC_KEY_REFRESH_INTERVAL;

    public GoogleIdAuthenticator(FingerTrieSeq<String> audiences, HashTrieSet<String> emails, Uri publicKeyUri, HttpSettings httpSettings) {
        this.audiences = audiences;
        this.emails = emails;
        this.publicKeyUri = publicKeyUri;
        this.httpSettings = httpSettings;
        this.publicKeyDefs = FingerTrieSeq.empty();
    }

    public GoogleIdAuthenticator(GoogleIdAuthenticatorDef authenticatorDef) {
        this(authenticatorDef.audiences, authenticatorDef.emails, authenticatorDef.publicKeyUri, authenticatorDef.httpSettings);
    }

    public final FingerTrieSeq<String> audiences() {
        return this.audiences;
    }

    public final HashTrieSet<String> emails() {
        return this.emails;
    }

    public void addEmail(String email) {
        this.emails = this.emails.added((Object)email);
    }

    public void removeEmail(String email) {
        this.emails = this.emails.removed((Object)email);
    }

    public final Uri publicKeyUri() {
        return this.publicKeyUri;
    }

    public final HttpSettings httpSettings() {
        return this.httpSettings;
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        GoogleIdToken idToken;
        String compactJws = credentials.claims().get("idToken").stringValue(null);
        if (compactJws == null) {
            compactJws = credentials.claims().get("googleIdToken").stringValue(null);
        }
        if (compactJws != null && (idToken = GoogleIdToken.verify((String)compactJws, this.publicKeyDefs)) != null && (this.emails.isEmpty() || this.emails.contains((Object)idToken.email()))) {
            return PolicyDirective.allow((Object)new Authenticated(credentials.requestUri(), credentials.fromUri(), idToken.toValue()));
        }
        return null;
    }

    public final FingerTrieSeq<PublicKeyDef> publicKeyDefs() {
        return this.publicKeyDefs;
    }

    public void setPublicKeyDefs(FingerTrieSeq<PublicKeyDef> publicKeyDefs) {
        this.publicKeyDefs = publicKeyDefs;
    }

    public void refreshPublicKeys() {
        UriAuthority authority = this.publicKeyUri.authority();
        String address = authority.hostAddress();
        int port = authority.portNumber();
        if (port == 0) {
            port = 443;
        }
        this.connectHttps(address, port, (HttpClient)new GoogleIdAuthenticatorPublicKeyClient(this), this.httpSettings);
    }

    public void didStart() {
        this.refreshPublicKeys();
        TimerRef publicKeyRefreshTimer = this.publicKeyRefreshTimer;
        if (publicKeyRefreshTimer != null) {
            publicKeyRefreshTimer.cancel();
        }
        this.publicKeyRefreshTimer = this.schedule().setTimer(PUBLIC_KEY_REFRESH_INTERVAL, (TimerFunction)new GoogleIdAuthenticatorPublicKeyRefreshTimer(this));
    }

    public void willStop() {
        TimerRef publicKeyRefreshTimer = this.publicKeyRefreshTimer;
        if (publicKeyRefreshTimer != null) {
            publicKeyRefreshTimer.cancel();
            this.publicKeyRefreshTimer = null;
        }
    }

    static {
        long publicKeyRefreshInterval;
        try {
            publicKeyRefreshInterval = Long.parseLong(System.getProperty("swim.auth.google.public.key.refresh.interval"));
        }
        catch (NumberFormatException error) {
            publicKeyRefreshInterval = 3600000L;
        }
        PUBLIC_KEY_REFRESH_INTERVAL = publicKeyRefreshInterval;
    }
}

