/*
 * Decompiled with CFR 0.152.
 */
package swim.auth;

import swim.api.auth.AuthenticatorDef;
import swim.auth.GoogleIdAuthenticatorForm;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.ParserException;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieSet;
import swim.io.http.HttpSettings;
import swim.structure.Form;
import swim.structure.Kind;
import swim.uri.Uri;
import swim.util.Murmur3;

public class GoogleIdAuthenticatorDef
implements AuthenticatorDef,
Debug {
    final String authenticatorName;
    final FingerTrieSeq<String> audiences;
    final HashTrieSet<String> emails;
    final Uri publicKeyUri;
    final HttpSettings httpSettings;
    static final Uri PUBLIC_KEY_URI;
    private static int hashSeed;
    private static Form<GoogleIdAuthenticatorDef> form;

    public GoogleIdAuthenticatorDef(String authenticatorName, FingerTrieSeq<String> audiences, HashTrieSet<String> emails, Uri publicKeyUri, HttpSettings httpSettings) {
        this.authenticatorName = authenticatorName;
        this.audiences = audiences;
        this.emails = emails;
        this.publicKeyUri = publicKeyUri;
        this.httpSettings = httpSettings;
    }

    public final String authenticatorName() {
        return this.authenticatorName;
    }

    public final FingerTrieSeq<String> audiences() {
        return this.audiences;
    }

    public final HashTrieSet<String> emails() {
        return this.emails;
    }

    public final Uri publicKeyUri() {
        return this.publicKeyUri;
    }

    public final HttpSettings httpSettings() {
        return this.httpSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof GoogleIdAuthenticatorDef) {
            GoogleIdAuthenticatorDef that = (GoogleIdAuthenticatorDef)other;
            return (this.authenticatorName == null ? that.authenticatorName == null : this.authenticatorName.equals(that.authenticatorName)) && this.audiences.equals(that.audiences) && this.emails.equals(that.emails) && this.publicKeyUri.equals((Object)that.publicKeyUri) && this.httpSettings.equals((Object)that.httpSettings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(GoogleIdAuthenticatorDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.authenticatorName)), (int)this.audiences.hashCode()), (int)this.emails.hashCode()), (int)this.publicKeyUri.hashCode()), (int)this.httpSettings.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("new").write(32).write("GoogleIdAuthenticatorDef").write(40).debug((Object)this.authenticatorName).write(", ").debug(this.audiences).write(", ").debug(this.emails).write(", ").debug((Object)this.publicKeyUri).write(", ").debug((Object)this.httpSettings).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    @Kind
    public static Form<GoogleIdAuthenticatorDef> form() {
        if (form == null) {
            form = new GoogleIdAuthenticatorForm();
        }
        return form;
    }

    static {
        Uri publicKeyUri;
        try {
            publicKeyUri = Uri.parse((String)System.getProperty("swim.auth.google.public.key.uri"));
        }
        catch (NullPointerException | ParserException error) {
            publicKeyUri = Uri.parse((String)"https://www.googleapis.com/oauth2/v3/certs");
        }
        PUBLIC_KEY_URI = publicKeyUri;
    }
}

