/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base64;

final class Base64Standard
extends Base64 {
    final boolean isPadded;

    Base64Standard(boolean isPadded) {
        this.isPadded = isPadded;
    }

    @Override
    public String alphabet() {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    }

    @Override
    public boolean isPadded() {
        return this.isPadded;
    }

    @Override
    public Base64 isPadded(boolean isPadded) {
        if (isPadded == this.isPadded) {
            return this;
        }
        return Base64.standard(isPadded);
    }

    @Override
    public boolean isDigit(int c) {
        return c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 43 || c == 47;
    }
}

