/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Encoder;
import swim.codec.OutputBuffer;

public abstract class DynamicEncoder<I, O>
extends Encoder<I, O> {
    protected Encoder<? super I, ? extends O> encoding;

    @Override
    public Encoder<I, O> feed(I input) {
        if (this.encoding != null) {
            this.encoding = this.encoding.feed(input);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public Encoder<I, O> pull(OutputBuffer<?> output) {
        Encoder<I, O> encoder = this.encoding;
        if (encoder == null) {
            if (output.isDone()) {
                return DynamicEncoder.done();
            }
            encoder = this.doEncode();
            this.encoding = encoder;
            if (encoder == null) {
                return DynamicEncoder.done();
            }
        }
        if (encoder != null) {
            if ((encoder = encoder.pull(output)).isDone()) {
                this.encoding = null;
                this.didEncode(encoder.bind());
            } else if (encoder.isError()) {
                return encoder.asError();
            }
        }
        if (output.isDone()) {
            return DynamicEncoder.done();
        }
        return this;
    }

    @Override
    public Encoder<I, O> fork(Object condition) {
        if (this.encoding != null) {
            this.encoding = this.encoding.fork(condition);
        }
        return this;
    }

    @Override
    public O bind() {
        if (this.encoding != null) {
            return this.encoding.bind();
        }
        throw new IllegalStateException();
    }

    @Override
    public Throwable trap() {
        if (this.encoding != null) {
            return this.encoding.trap();
        }
        throw new IllegalStateException();
    }

    protected abstract Encoder<? super I, ? extends O> doEncode();

    protected abstract void didEncode(O var1);
}

