/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.InputBuffer;
import swim.codec.InputException;
import swim.codec.InputSettings;
import swim.codec.Mark;

final class InputBufferEmpty
extends InputBuffer {
    final Object id;
    final Mark mark;
    final InputSettings settings;

    InputBufferEmpty(Object id, Mark mark, InputSettings settings) {
        this.id = id;
        this.mark = mark;
        this.settings = settings;
    }

    @Override
    public boolean isCont() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isPart() {
        return true;
    }

    @Override
    public InputBuffer isPart(boolean isPart) {
        if (isPart) {
            return this;
        }
        return InputBuffer.done(this.id, this.mark, this.settings);
    }

    @Override
    public int index() {
        return 0;
    }

    @Override
    public InputBuffer index(int index) {
        if (index == 0) {
            return this;
        }
        InputException error = new InputException("invalid index");
        return InputBuffer.error(error, this.id, this.mark, this.settings);
    }

    @Override
    public int limit() {
        return 0;
    }

    @Override
    public InputBuffer limit(int limit) {
        if (limit == 0) {
            return this;
        }
        InputException error = new InputException("invalid limit");
        return InputBuffer.error(error, this.id, this.mark, this.settings);
    }

    @Override
    public int capacity() {
        return 0;
    }

    @Override
    public int remaining() {
        return 0;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean has(int index) {
        return false;
    }

    @Override
    public int get(int index) {
        throw new InputException();
    }

    @Override
    public void set(int index, int token) {
        throw new InputException();
    }

    @Override
    public int head() {
        throw new InputException();
    }

    @Override
    public InputBuffer step() {
        InputException error = new InputException("empty step");
        return InputBuffer.error(error, this.id, this.mark, this.settings);
    }

    @Override
    public InputBuffer step(int offset) {
        InputException error = new InputException("empty step");
        return InputBuffer.error(error, this.id, this.mark, this.settings);
    }

    @Override
    public InputBuffer fork(Object condition) {
        if (condition instanceof InputBuffer) {
            return (InputBuffer)condition;
        }
        return this;
    }

    @Override
    public InputBuffer seek(Mark mark) {
        InputException error = new InputException("empty seek");
        return InputBuffer.error(error, this.id, this.mark, this.settings);
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public InputBuffer id(Object id) {
        return InputBuffer.empty(id, this.mark, this.settings);
    }

    @Override
    public Mark mark() {
        return this.mark;
    }

    @Override
    public InputBuffer mark(Mark mark) {
        return InputBuffer.empty(this.id, mark, this.settings);
    }

    @Override
    public InputSettings settings() {
        return this.settings;
    }

    @Override
    public InputBuffer settings(InputSettings settings) {
        return InputBuffer.empty(this.id, this.mark, settings);
    }

    @Override
    public InputBuffer clone() {
        return this;
    }
}

