/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Encoder;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.WriterAndThen;
import swim.codec.WriterDone;
import swim.codec.WriterError;

public abstract class Writer<I, O>
extends Encoder<I, O> {
    private static Writer<Object, Object> done;

    @Override
    public boolean isCont() {
        return true;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public Writer<I, O> feed(I input) {
        throw new IllegalArgumentException();
    }

    @Override
    public abstract Writer<I, O> pull(Output<?> var1);

    @Override
    public Writer<I, O> pull(OutputBuffer<?> output) {
        return this.pull((Output<?>)output);
    }

    @Override
    public Writer<I, O> fork(Object condition) {
        return this;
    }

    @Override
    public O bind() {
        throw new IllegalStateException();
    }

    @Override
    public Throwable trap() {
        throw new IllegalStateException();
    }

    @Override
    public <I2> Writer<I2, O> asDone() {
        throw new IllegalStateException();
    }

    @Override
    public <I2, O2> Writer<I2, O2> asError() {
        throw new IllegalStateException();
    }

    @Override
    public <O2> Writer<I, O2> andThen(Writer<I, O2> that) {
        return new WriterAndThen<I, O2>(this, that);
    }

    @Override
    public <O2> Writer<I, O2> andThen(Encoder<I, O2> that) {
        return this.andThen((Writer)that);
    }

    public static <I, O> Writer<I, O> done() {
        if (done == null) {
            done = new WriterDone<Object, Object>(null);
        }
        return done;
    }

    public static <I, O> Writer<I, O> done(O output) {
        if (output == null) {
            return Writer.done();
        }
        return new WriterDone(output);
    }

    public static <I, O> Writer<I, O> error(Throwable error) {
        return new WriterError(error);
    }
}

