/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Output;
import swim.codec.ParserException;
import swim.codec.Writer;

final class WriterError<I, O>
extends Writer<I, O> {
    private final Throwable error;

    WriterError(Throwable error) {
        this.error = error;
    }

    @Override
    public boolean isCont() {
        return false;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public Writer<I, O> pull(Output<?> output) {
        return this;
    }

    @Override
    public O bind() {
        if (this.error instanceof Error) {
            throw (Error)this.error;
        }
        if (this.error instanceof RuntimeException) {
            throw (RuntimeException)this.error;
        }
        throw new ParserException(this.error);
    }

    @Override
    public Throwable trap() {
        return this.error;
    }

    @Override
    public <I2, O2> Writer<I2, O2> asError() {
        return this;
    }

    @Override
    public <O2> Writer<I, O2> andThen(Writer<I, O2> that) {
        return this;
    }
}

