/*
 * Decompiled with CFR 0.152.
 */
package swim.decipher;

import swim.codec.Binary;
import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.codec.UtfErrorMode;
import swim.decipher.DecipherDecoder;

final class AnyDecoder<I, V>
extends Decoder<V> {
    final DecipherDecoder<I, V> decipher;
    final Parser<V> xmlParser;
    final Parser<V> jsonParser;
    final Parser<V> reconParser;
    final Decoder<V> protobufDecoder;
    final Decoder<V> textDecoder;
    final Decoder<V> dataDecoder;
    final int consumed;
    static final int DETECTION_WINDOW;
    static final Decoder<Object> DETECTION_FAILED;

    AnyDecoder(DecipherDecoder<I, V> decipher, Parser<V> xmlParser, Parser<V> jsonParser, Parser<V> reconParser, Decoder<V> protobufDecoder, Decoder<V> textDecoder, Decoder<V> dataDecoder, int consumed) {
        this.decipher = decipher;
        this.xmlParser = xmlParser;
        this.jsonParser = jsonParser;
        this.reconParser = reconParser;
        this.protobufDecoder = protobufDecoder;
        this.textDecoder = textDecoder;
        this.dataDecoder = dataDecoder;
        this.consumed = consumed;
    }

    AnyDecoder(DecipherDecoder<I, V> decipher) {
        this(decipher, null, null, null, null, null, null, 0);
    }

    public Decoder<V> feed(InputBuffer input) {
        return AnyDecoder.decode(input, this.decipher, this.xmlParser, this.jsonParser, this.reconParser, this.protobufDecoder, this.textDecoder, this.dataDecoder, this.consumed);
    }

    static <I, V> Decoder<V> decode(InputBuffer input, DecipherDecoder<I, V> decipher, Parser<V> xmlParser, Parser<V> jsonParser, Parser<V> reconParser, Decoder<V> protobufDecoder, Decoder<V> textDecoder, Decoder<V> dataDecoder, int consumed) {
        int inputStart = input.index();
        int inputLimit = input.limit();
        int inputRemaining = inputLimit - inputStart;
        int inputConsumed = 0;
        if (xmlParser == null || xmlParser.isCont()) {
            xmlParser = xmlParser == null ? Utf8.parseDecoded(decipher.xmlParser(), (Input)input, (UtfErrorMode)UtfErrorMode.fatalNonZero()) : xmlParser.feed(input);
            if (input.isDone() && xmlParser.isDone()) {
                return AnyDecoder.done((Object)xmlParser.bind());
            }
            inputConsumed = Math.max(inputConsumed, input.index() - inputStart);
        }
        if (jsonParser == null || jsonParser.isCont()) {
            input = input.index(inputStart).limit(inputLimit);
            jsonParser = jsonParser == null ? Utf8.parseDecoded(decipher.jsonParser(), (Input)input, (UtfErrorMode)UtfErrorMode.fatalNonZero()) : jsonParser.feed(input);
            if (input.isDone() && jsonParser.isDone()) {
                return AnyDecoder.done((Object)jsonParser.bind());
            }
            inputConsumed = Math.max(inputConsumed, input.index() - inputStart);
        }
        if (reconParser == null || reconParser.isCont()) {
            input = input.index(inputStart).limit(inputLimit);
            reconParser = reconParser == null ? Utf8.parseDecoded(decipher.reconParser(), (Input)input, (UtfErrorMode)UtfErrorMode.fatalNonZero()) : reconParser.feed(input);
            if (input.isDone() && reconParser.isDone()) {
                return AnyDecoder.done((Object)reconParser.bind());
            }
            inputConsumed = Math.max(inputConsumed, input.index() - inputStart);
        }
        if (protobufDecoder == null || protobufDecoder.isCont()) {
            input = input.index(inputStart).limit(inputLimit);
            protobufDecoder = protobufDecoder == null ? decipher.decodeProtobuf(input) : protobufDecoder.feed(input);
            if (input.isDone() && protobufDecoder.isDone()) {
                return protobufDecoder;
            }
            inputConsumed = Math.max(inputConsumed, input.index() - inputStart);
        } else {
            protobufDecoder = DETECTION_FAILED.asError();
        }
        if (consumed + inputConsumed < DETECTION_WINDOW) {
            input = input.index(inputStart).limit(inputLimit);
            textDecoder = textDecoder == null ? Utf8.decodeOutput(decipher.textOutput(), (InputBuffer)input, (UtfErrorMode)UtfErrorMode.fatalNonZero()) : textDecoder.feed(input);
            if (input.isDone() && textDecoder.isDone()) {
                return textDecoder;
            }
            inputConsumed = Math.max(inputConsumed, input.index() - inputStart);
        } else {
            textDecoder = DETECTION_FAILED.asError();
        }
        if (consumed + inputConsumed < DETECTION_WINDOW) {
            input = input.index(inputStart).limit(inputLimit);
            dataDecoder = dataDecoder == null ? Binary.parseOutput(decipher.dataOutput(), (Input)input) : dataDecoder.feed(input);
            if (input.isDone() && dataDecoder.isDone()) {
                return dataDecoder;
            }
            inputConsumed = Math.max(inputConsumed, input.index() - inputStart);
        } else {
            dataDecoder = DETECTION_FAILED.asError();
        }
        if (jsonParser.isError() && reconParser.isError() && protobufDecoder.isError() && textDecoder.isError() && dataDecoder.isError()) {
            return xmlParser;
        }
        if (xmlParser.isError() && reconParser.isError() && protobufDecoder.isError() && textDecoder.isError() && dataDecoder.isError()) {
            return jsonParser;
        }
        if (xmlParser.isError() && jsonParser.isError() && protobufDecoder.isError() && textDecoder.isError() && dataDecoder.isError()) {
            return reconParser;
        }
        if (xmlParser.isError() && jsonParser.isError() && reconParser.isError() && textDecoder.isError() && dataDecoder.isError()) {
            return protobufDecoder;
        }
        if (xmlParser.isError() && jsonParser.isError() && reconParser.isError() && protobufDecoder.isError() && dataDecoder.isError()) {
            return textDecoder;
        }
        if (xmlParser.isError() && jsonParser.isError() && reconParser.isError() && protobufDecoder.isError() && textDecoder.isError()) {
            return dataDecoder;
        }
        if (input.isDone()) {
            return AnyDecoder.error((Throwable)new DecoderException("unexpected end of input"));
        }
        if (input.isError()) {
            return AnyDecoder.error((Throwable)input.trap());
        }
        return new AnyDecoder<I, V>(decipher, xmlParser, jsonParser, reconParser, protobufDecoder, textDecoder, dataDecoder, consumed += inputConsumed);
    }

    static <I, V> Decoder<V> decode(InputBuffer input, DecipherDecoder<I, V> decipher) {
        return AnyDecoder.decode(input, decipher, null, null, null, null, null, null, 0);
    }

    static {
        int detectionWindow;
        try {
            detectionWindow = Integer.parseInt(System.getProperty("swim.any.decoder.detection.window"));
        }
        catch (NumberFormatException e) {
            detectionWindow = 128;
        }
        DETECTION_WINDOW = detectionWindow;
        DETECTION_FAILED = AnyDecoder.error((Throwable)new DecoderException("detection failed"));
    }
}

