/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.http.HttpParser;
import swim.http.HttpWriter;

public final class Http {
    private static HttpParser standardParser;
    private static HttpWriter standardWriter;

    private Http() {
    }

    public static HttpParser standardParser() {
        if (standardParser == null) {
            standardParser = new HttpParser();
        }
        return standardParser;
    }

    public static HttpWriter standardWriter() {
        if (standardWriter == null) {
            standardWriter = new HttpWriter();
        }
        return standardWriter;
    }

    public static boolean isSpace(int c) {
        return c == 32 || c == 9;
    }

    public static boolean isAlpha(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    public static boolean isVisibleChar(int c) {
        return c >= 33 && c <= 126;
    }

    public static boolean isFieldChar(int c) {
        return c >= 33 && c <= 255;
    }

    public static boolean isPhraseChar(int c) {
        return Http.isSpace(c) || Http.isVisibleChar(c);
    }

    public static boolean isTokenChar(int c) {
        return c == 33 || c == 35 || c == 36 || c == 37 || c == 38 || c == 39 || c == 42 || c == 43 || c == 45 || c == 46 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c == 94 || c == 95 || c == 96 || c >= 97 && c <= 122 || c == 124 || c == 126;
    }

    public static boolean isCommentChar(int c) {
        return c == 9 || c == 32 || c >= 33 && c <= 39 || c >= 42 && c <= 91 || c >= 93 && c <= 126 || c >= 128 && c <= 255;
    }

    public static boolean isQuotedChar(int c) {
        return c == 9 || c == 32 || c == 33 || c >= 35 && c <= 91 || c >= 93 && c <= 126 || c >= 128 && c <= 255;
    }

    public static boolean isEscapeChar(int c) {
        return c == 9 || c == 32 || c >= 33 && c <= 126 || c >= 128 && c <= 255;
    }

    public static boolean isToken(String token) {
        int n = token.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Http.isTokenChar(token.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

