/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Http;
import swim.http.HttpCharset;
import swim.http.HttpParser;

final class HttpCharsetParser
extends Parser<HttpCharset> {
    final HttpParser http;
    final StringBuilder name;
    final Parser<Float> weight;
    final int step;

    HttpCharsetParser(HttpParser http, StringBuilder name, Parser<Float> weight, int step) {
        this.http = http;
        this.name = name;
        this.weight = weight;
        this.step = step;
    }

    HttpCharsetParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<HttpCharset> feed(Input input) {
        return HttpCharsetParser.parse(input, this.http, this.name, this.weight, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<HttpCharset> parse(Input input, HttpParser http, StringBuilder name, Parser<Float> weight2222, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return HttpCharsetParser.error((Diagnostic)Diagnostic.expected((String)"charset", (Input)input));
                input = input.step();
                if (name == null) {
                    name = new StringBuilder();
                }
                name.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return HttpCharsetParser.error((Diagnostic)Diagnostic.expected((String)"charset", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                name.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                step = 3;
            }
        }
        if (step == 3) {
            void weight2222;
            if (weight2222 == null) {
                Parser<Float> weight2222 = http.parseQValue(input);
            } else {
                Object weight2222;
                Parser weight2222 = weight2222.feed(input);
            }
            if (weight2222.isDone()) {
                Float qvalue = (Float)weight2222.bind();
                float q = qvalue != null ? qvalue.floatValue() : 1.0f;
                return HttpCharsetParser.done((Object)http.charset(name.toString(), q));
            }
            if (weight2222.isError()) {
                return weight2222.asError();
            }
        }
        if (!input.isError()) void weight2222;
        return new HttpCharsetParser(http, name, (Parser<Float>)weight2222, step);
        return HttpCharsetParser.error((Throwable)input.trap());
    }

    static Parser<HttpCharset> parse(Input input, HttpParser http) {
        return HttpCharsetParser.parse(input, http, null, null, 1);
    }
}

