/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.Product;
import swim.util.Builder;

final class ProductParser
extends Parser<Product> {
    final HttpParser http;
    final StringBuilder name;
    final StringBuilder version;
    final Builder<String, FingerTrieSeq<String>> comments;
    final Parser<String> comment;
    final int step;

    ProductParser(HttpParser http, StringBuilder name, StringBuilder version, Builder<String, FingerTrieSeq<String>> comments, Parser<String> comment, int step) {
        this.http = http;
        this.name = name;
        this.version = version;
        this.comments = comments;
        this.comment = comment;
        this.step = step;
    }

    ProductParser(HttpParser http) {
        this(http, null, null, null, null, 1);
    }

    public Parser<Product> feed(Input input) {
        return ProductParser.parse(input, this.http, this.name, this.version, this.comments, this.comment, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static Parser<Product> parse(Input input, HttpParser http, StringBuilder name, StringBuilder version, Builder<String, FingerTrieSeq<String>> comments, Parser<String> comment3222, int step) {
        block35: {
            void comment3222;
            int c = 0;
            if (step == 1) {
                if (input.isCont()) {
                    c = input.head();
                    if (!Http.isTokenChar(c)) return ProductParser.error((Diagnostic)Diagnostic.expected((String)"product name", (Input)input));
                    input = input.step();
                    if (name == null) {
                        name = new StringBuilder();
                    }
                    name.appendCodePoint(c);
                    step = 2;
                } else if (input.isDone()) {
                    return ProductParser.error((Diagnostic)Diagnostic.expected((String)"product name", (Input)input));
                }
            }
            if (step == 2) {
                while (input.isCont() && Http.isTokenChar(c = input.head())) {
                    input = input.step();
                    name.appendCodePoint(c);
                }
                if (input.isCont() && c == 47) {
                    input = input.step();
                    step = 3;
                } else if (!input.isEmpty()) {
                    step = 5;
                }
            }
            if (step == 3) {
                if (input.isCont()) {
                    c = input.head();
                    if (!Http.isTokenChar(c)) return ProductParser.error((Diagnostic)Diagnostic.expected((String)"product version", (Input)input));
                    input = input.step();
                    if (version == null) {
                        version = new StringBuilder();
                    }
                    version.appendCodePoint(c);
                    step = 4;
                } else if (input.isDone()) {
                    return ProductParser.error((Diagnostic)Diagnostic.expected((String)"product version", (Input)input));
                }
            }
            if (step == 4) {
                while (input.isCont() && Http.isTokenChar(c = input.head())) {
                    input = input.step();
                    version.appendCodePoint(c);
                }
                if (!input.isEmpty()) {
                    step = 5;
                }
            }
            while (true) {
                block34: {
                    if (step == 5) {
                        if (input.isCont() && Http.isSpace(input.head())) {
                            input = input.step();
                            step = 6;
                        } else if (!input.isEmpty()) {
                            FingerTrieSeq fingerTrieSeq;
                            String string = name.toString();
                            String string2 = version != null ? version.toString() : null;
                            if (comments != null) {
                                fingerTrieSeq = (FingerTrieSeq)comments.bind();
                                return ProductParser.done((Object)http.product(string, string2, (FingerTrieSeq<String>)fingerTrieSeq));
                            }
                            fingerTrieSeq = FingerTrieSeq.empty();
                            return ProductParser.done((Object)http.product(string, string2, (FingerTrieSeq<String>)fingerTrieSeq));
                        }
                    }
                    if (step == 6) {
                        while (input.isCont() && Http.isSpace(c = input.head())) {
                            input = input.step();
                        }
                        if (input.isCont()) {
                            if (c == 40) {
                                step = 7;
                                break block34;
                            } else {
                                step = 5;
                                continue;
                            }
                        }
                        if (input.isDone()) {
                            step = 5;
                            continue;
                        }
                    }
                }
                if (step != 7) break block35;
                if (comment3222 == null) {
                    Parser<String> comment3222 = http.parseComment(input);
                } else {
                    void comment3222;
                    Parser comment3222 = comment3222.feed(input);
                }
                if (!comment3222.isDone()) break;
                if (comments == null) {
                    comments = FingerTrieSeq.builder();
                }
                comments.add((Object)((String)comment3222.bind()));
                Object comment3222 = null;
                step = 5;
            }
            if (comment3222.isError()) {
                return comment3222.asError();
            }
        }
        if (!input.isError()) void comment3222;
        return new ProductParser(http, name, version, (Builder<String, FingerTrieSeq<String>>)comments, (Parser<String>)comment3222, step);
        return ProductParser.error((Throwable)input.trap());
    }

    static Parser<Product> parse(Input input, HttpParser http) {
        return ProductParser.parse(input, http, null, null, null, null, 1);
    }
}

