/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import swim.concurrent.Stage;
import swim.io.IpSettings;
import swim.io.IpStation;
import swim.io.Station;
import swim.io.http.HttpInterface;
import swim.io.http.HttpSettings;

public class HttpEndpoint
implements IpStation,
HttpInterface {
    protected final Station station;
    protected HttpSettings httpSettings;

    public HttpEndpoint(Station station, HttpSettings httpSettings) {
        this.station = station;
        this.httpSettings = httpSettings;
    }

    public HttpEndpoint(Station station) {
        this(station, HttpSettings.standard());
    }

    public HttpEndpoint(Stage stage, HttpSettings httpSettings) {
        this(new Station(stage), httpSettings);
    }

    public HttpEndpoint(Stage stage) {
        this(new Station(stage), HttpSettings.standard());
    }

    public final Stage stage() {
        return this.station.stage();
    }

    public final Station station() {
        return this.station;
    }

    public final IpSettings ipSettings() {
        return this.httpSettings.ipSettings();
    }

    @Override
    public final HttpSettings httpSettings() {
        return this.httpSettings;
    }

    public void start() {
        this.station.start();
    }

    public void stop() {
        this.station.stop();
    }
}

