/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import java.net.InetSocketAddress;
import swim.io.IpInterface;
import swim.io.IpModem;
import swim.io.IpServiceRef;
import swim.io.IpSocket;
import swim.io.IpSocketModem;
import swim.io.IpSocketRef;
import swim.io.http.HttpClient;
import swim.io.http.HttpClientModem;
import swim.io.http.HttpService;
import swim.io.http.HttpSettings;
import swim.io.http.HttpSocketService;

public interface HttpInterface
extends IpInterface {
    public HttpSettings httpSettings();

    default public IpServiceRef bindHttp(InetSocketAddress localAddress, HttpService service, HttpSettings httpSettings) {
        HttpSocketService tcpService = new HttpSocketService(service, httpSettings);
        return this.bindTcp(localAddress, tcpService, httpSettings.ipSettings());
    }

    default public IpServiceRef bindHttp(InetSocketAddress localAddress, HttpService service) {
        return this.bindHttp(localAddress, service, this.httpSettings());
    }

    default public IpServiceRef bindHttp(String address, int port, HttpService service, HttpSettings httpSettings) {
        return this.bindHttp(new InetSocketAddress(address, port), service, httpSettings);
    }

    default public IpServiceRef bindHttp(String address, int port, HttpService service) {
        return this.bindHttp(new InetSocketAddress(address, port), service, this.httpSettings());
    }

    default public IpServiceRef bindHttps(InetSocketAddress localAddress, HttpService service, HttpSettings httpSettings) {
        HttpSocketService tlsService = new HttpSocketService(service, httpSettings);
        return this.bindTls(localAddress, tlsService, httpSettings.ipSettings());
    }

    default public IpServiceRef bindHttps(InetSocketAddress localAddress, HttpService service) {
        return this.bindHttps(localAddress, service, this.httpSettings());
    }

    default public IpServiceRef bindHttps(String address, int port, HttpService service, HttpSettings httpSettings) {
        return this.bindHttps(new InetSocketAddress(address, port), service, httpSettings);
    }

    default public IpServiceRef bindHttps(String address, int port, HttpService service) {
        return this.bindHttps(new InetSocketAddress(address, port), service, this.httpSettings());
    }

    default public IpSocketRef connectHttp(InetSocketAddress remoteAddress, HttpClient client, HttpSettings httpSettings) {
        HttpClientModem modem = new HttpClientModem(client, httpSettings);
        IpSocketModem socket = new IpSocketModem((IpModem)modem);
        return this.connectTcp(remoteAddress, (IpSocket)socket, httpSettings.ipSettings());
    }

    default public IpSocketRef connectHttp(InetSocketAddress remoteAddress, HttpClient client) {
        return this.connectHttp(remoteAddress, client, this.httpSettings());
    }

    default public IpSocketRef connectHttp(String address, int port, HttpClient client, HttpSettings httpSettings) {
        return this.connectHttp(new InetSocketAddress(address, port), client, httpSettings);
    }

    default public IpSocketRef connectHttp(String address, int port, HttpClient client) {
        return this.connectHttp(new InetSocketAddress(address, port), client, this.httpSettings());
    }

    default public IpSocketRef connectHttps(InetSocketAddress remoteAddress, HttpClient client, HttpSettings httpSettings) {
        HttpClientModem modem = new HttpClientModem(client, httpSettings);
        IpSocketModem socket = new IpSocketModem((IpModem)modem);
        return this.connectTls(remoteAddress, (IpSocket)socket, httpSettings.ipSettings());
    }

    default public IpSocketRef connectHttps(InetSocketAddress remoteAddress, HttpClient client) {
        return this.connectHttps(remoteAddress, client, this.httpSettings());
    }

    default public IpSocketRef connectHttps(String address, int port, HttpClient client, HttpSettings httpSettings) {
        return this.connectHttps(new InetSocketAddress(address, port), client, httpSettings);
    }

    default public IpSocketRef connectHttps(String address, int port, HttpClient client) {
        return this.connectHttps(new InetSocketAddress(address, port), client, this.httpSettings());
    }
}

