/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import java.net.InetSocketAddress;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpModem;
import swim.io.IpService;
import swim.io.IpServiceContext;
import swim.io.IpSocket;
import swim.io.IpSocketModem;
import swim.io.http.HttpServer;
import swim.io.http.HttpServerModem;
import swim.io.http.HttpService;
import swim.io.http.HttpServiceContext;
import swim.io.http.HttpSettings;

public class HttpSocketService
implements IpService,
HttpServiceContext {
    protected final HttpService service;
    protected final HttpSettings httpSettings;
    protected IpServiceContext context;

    public HttpSocketService(HttpService service, HttpSettings httpSettings) {
        this.service = service;
        this.httpSettings = httpSettings;
    }

    public IpServiceContext ipServiceContext() {
        return this.context;
    }

    public void setIpServiceContext(IpServiceContext context) {
        this.context = context;
        this.service.setHttpServiceContext(this);
    }

    public IpSocket createSocket() {
        HttpServer server = this.service.createServer();
        HttpServerModem modem = new HttpServerModem(server, this.httpSettings);
        return new IpSocketModem((IpModem)modem);
    }

    public void didBind() {
        this.service.didBind();
    }

    public void didAccept(IpSocket socket) {
        if (socket instanceof HttpServerModem) {
            this.service.didAccept(((HttpServerModem)socket).server);
        }
    }

    public void didUnbind() {
        this.service.didUnbind();
    }

    public void didFail(Throwable error) {
        this.service.didFail(error);
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    @Override
    public HttpSettings httpSettings() {
        return this.httpSettings;
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    @Override
    public void unbind() {
        this.context.unbind();
    }
}

