/*
 * Decompiled with CFR 0.152.
 */
package swim.io.mqtt;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import swim.codec.Decoder;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.Modem;
import swim.io.ModemContext;
import swim.io.Socket;
import swim.io.mqtt.MqttSettings;
import swim.io.mqtt.MqttSocket;
import swim.io.mqtt.MqttSocketContext;
import swim.mqtt.Mqtt;
import swim.mqtt.MqttPacket;

public class MqttSocketModem<I, O>
implements Modem<Object, Object>,
MqttSocketContext<I, O> {
    protected final MqttSocket<I, O> socket;
    protected final MqttSettings mqttSettings;
    protected ModemContext<Object, Object> context;

    public MqttSocketModem(MqttSocket<I, O> socket, MqttSettings mqttSettings) {
        this.socket = socket;
        this.mqttSettings = mqttSettings;
    }

    public ModemContext<Object, Object> modemContext() {
        return this.context;
    }

    public void setModemContext(ModemContext<Object, Object> context) {
        this.context = context;
        this.socket.setMqttSocketContext(this);
    }

    public long idleTimeout() {
        return this.socket.idleTimeout();
    }

    public void doRead() {
        this.socket.doRead();
    }

    public void didRead(Object input) {
        this.socket.didRead((MqttPacket)input);
    }

    public void doWrite() {
        this.socket.doWrite();
    }

    public void didWrite(Object output) {
        this.socket.didWrite((MqttPacket)output);
    }

    public void willConnect() {
        this.socket.willConnect();
    }

    public void didConnect() {
        this.socket.didConnect();
    }

    public void willSecure() {
        this.socket.willSecure();
    }

    public void didSecure() {
        this.socket.didSecure();
    }

    public void willBecome(Socket socket) {
        this.socket.willBecome(socket);
    }

    public void didBecome(Socket socket) {
        this.socket.didBecome(socket);
    }

    public void didTimeout() {
        this.socket.didTimeout();
    }

    public void didDisconnect() {
        this.socket.didDisconnect();
    }

    public void didFail(Throwable error) {
        this.socket.didFail(error);
        this.close();
    }

    public boolean isConnected() {
        ModemContext<Object, Object> context = this.context;
        return context != null && context.isConnected();
    }

    public boolean isClient() {
        ModemContext<Object, Object> context = this.context;
        return context != null && context.isClient();
    }

    public boolean isServer() {
        ModemContext<Object, Object> context = this.context;
        return context != null && context.isServer();
    }

    public boolean isSecure() {
        ModemContext<Object, Object> context = this.context;
        return context != null && context.isSecure();
    }

    public String securityProtocol() {
        return this.context.securityProtocol();
    }

    public String cipherSuite() {
        return this.context.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    public Principal localPrincipal() {
        return this.context.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.context.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.context.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.context.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.context.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    @Override
    public MqttSettings mqttSettings() {
        return this.mqttSettings;
    }

    @Override
    public <I2 extends I> void read(Decoder<I2> content) {
        this.context.read(Mqtt.standardDecoder().packetDecoder(content));
    }

    @Override
    public <O2 extends O> void write(MqttPacket<O2> packet) {
        this.context.write(packet.mqttEncoder(Mqtt.standardEncoder()));
    }

    @Override
    public void become(Socket socket) {
        this.context.become(socket);
    }

    @Override
    public void close() {
        this.context.close();
    }
}

