/*
 * Decompiled with CFR 0.152.
 */
package swim.js;

import swim.api.agent.AgentDef;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.structure.Value;
import swim.uri.UriPath;
import swim.util.Murmur3;

public class JsAgentDef
implements AgentDef,
Debug {
    final String agentName;
    final UriPath modulePath;
    final Value props;
    private static int hashSeed;

    public JsAgentDef(String agentName, UriPath modulePath, Value props) {
        this.agentName = agentName;
        this.modulePath = modulePath;
        this.props = props;
    }

    public final String agentName() {
        return this.agentName;
    }

    public JsAgentDef agentName(String agentName) {
        return this.copy(agentName, this.modulePath, this.props);
    }

    public final UriPath modulePath() {
        return this.modulePath;
    }

    public JsAgentDef modulePath(UriPath modulePath) {
        return this.copy(this.agentName, modulePath, this.props);
    }

    public final Value props() {
        return this.props;
    }

    public JsAgentDef props(Value props) {
        return this.copy(this.agentName, this.modulePath, props);
    }

    protected JsAgentDef copy(String agentName, UriPath modulePath, Value props) {
        return new JsAgentDef(agentName, modulePath, props);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof JsAgentDef) {
            JsAgentDef that = (JsAgentDef)other;
            return (this.agentName == null ? that.agentName == null : this.agentName.equals(that.agentName)) && (this.modulePath == null ? that.modulePath == null : this.modulePath.equals((Object)that.modulePath)) && this.props.equals((Object)that.props);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(JsAgentDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.agentName)), (int)Murmur3.hash((Object)this.modulePath)), (int)this.props.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("JsAgentDef").write(46).write("from").write(40).debug((Object)this.agentName).write(", ").debug((Object)this.modulePath).write(41);
        if (this.props.isDefined()) {
            output = output.write(46).write("props").write(40).debug((Object)this.props).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static JsAgentDef from(String agentName, UriPath modulePath) {
        return new JsAgentDef(agentName, modulePath, Value.absent());
    }

    public static JsAgentDef from(String agentName, String modulePath) {
        return new JsAgentDef(agentName, UriPath.parse((String)modulePath), Value.absent());
    }

    public static JsAgentDef fromModulePath(UriPath modulePath) {
        return new JsAgentDef(modulePath.toString(), modulePath, Value.absent());
    }

    public static JsAgentDef fromModulePath(String modulePath) {
        return new JsAgentDef(modulePath, UriPath.parse((String)modulePath), Value.absent());
    }
}

