/*
 * Decompiled with CFR 0.152.
 */
package swim.js;

import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import swim.api.agent.AbstractAgentRoute;
import swim.api.agent.AgentContext;
import swim.js.JsAgent;
import swim.js.JsAgentDef;
import swim.js.JsKernel;
import swim.uri.UriPath;
import swim.vm.js.JsBridge;
import swim.vm.js.JsModule;
import swim.vm.js.JsModuleLoader;
import swim.vm.js.JsModuleSystem;

public class JsAgentFactory
extends AbstractAgentRoute<JsAgent> {
    protected final JsKernel jsKernel;
    protected final UriPath basePath;
    protected final JsAgentDef agentDef;

    public JsAgentFactory(JsKernel jsKernel, UriPath basePath, JsAgentDef agentDef) {
        this.jsKernel = jsKernel;
        this.basePath = basePath;
        this.agentDef = agentDef;
    }

    public final JsKernel jsKernel() {
        return this.jsKernel;
    }

    public final UriPath basePath() {
        return this.basePath;
    }

    public final JsAgentDef agentDef() {
        return this.agentDef;
    }

    protected Context createAgentJsContext(AgentContext agentContext) {
        return Context.newBuilder((String[])new String[]{"js"}).engine(this.jsKernel.jsEngine()).build();
    }

    protected JsBridge createAgentJsBridge(AgentContext agentContext, Context jsContext) {
        return new JsBridge(this.jsKernel.jsRuntime(), jsContext);
    }

    protected JsModuleSystem createAgentModuleSystem(AgentContext agentContext, Context jsContext, JsBridge jsBridge) {
        return new JsModuleSystem(jsContext, (JsModuleLoader)jsBridge);
    }

    protected JsModule requireAgentModule(AgentContext agentContext, JsModuleSystem moduleSystem) {
        return moduleSystem.requireModule(this.basePath(), this.agentDef.modulePath());
    }

    protected Value createGuestAgent(AgentContext agentContext, JsBridge jsBridge, JsModule agentModule) {
        Value guestAgent;
        Object guestAgentContext = jsBridge.hostToGuest((Object)agentContext);
        Value agentExports = agentModule.moduleExports();
        if (agentExports.canInstantiate()) {
            guestAgent = agentExports.newInstance(new Object[]{guestAgentContext});
        } else {
            guestAgent = agentExports;
            if (guestAgent.hasMembers()) {
                guestAgent.putMember("context", guestAgentContext);
            }
        }
        return guestAgent;
    }

    public JsAgent createAgent(AgentContext agentContext) {
        Context jsContext = this.createAgentJsContext(agentContext);
        JsBridge jsBridge = this.createAgentJsBridge(agentContext, jsContext);
        JsModuleSystem moduleSystem = this.createAgentModuleSystem(agentContext, jsContext, jsBridge);
        JsModule module = this.requireAgentModule(agentContext, moduleSystem);
        Value guest = this.createGuestAgent(agentContext, jsBridge, module);
        return new JsAgent(agentContext, jsBridge, module, guest);
    }
}

